!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


MODULE MOD_MBM_MATERIALPARAMS
! Material constants (used in MBM equations)

IMPLICIT NONE

                                    ! lmdc14: radioactive decay constant for C14 [yr^-1]
DOUBLE PRECISION, PARAMETER ::  lmdc14 =   1.D+00/8267.D+00
                                    ! c13rk: delta-13C of carbonate rock [1/1000]
DOUBLE PRECISION, PARAMETER ::  c13rk  =   1.60D+00
                                    ! c14rk: Delta-14C of carbonate rock [1/1000]
DOUBLE PRECISION, PARAMETER ::  c14rk  = -1000.D+00
                                    ! c13ff: delta-13C of fossil fuel [1/1000]
DOUBLE PRECISION, PARAMETER ::  c13ff  = 24.D+00


END MODULE MOD_MBM_MATERIALPARAMS

