!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


MODULE MOD_MBM_CONTIWEATHERING

IMPLICIT NONE


! Variables to allow weathering scenarii to be prescribed from a file:
!
! weaflx_biccc:  river HCO3 flux from carbonates dissolved by CO2 [10^18 mol/yr]
! weaflx_bicsc:  river HCO3 flux from silicates dissolved by CO2 [10^18 mol/yr]
! weaflx_biccs:  river HCO3 flux from carbonates dissolved by H4SO4 [10^18 mol/yr]
! weaflx_co2cs:  CO2 flux, part of biccs, taken up from the atmosphere during
!                reequilibration of biccs-water with the atmosphere [10^18 mol/yr]
! weaflx_co2oo:  CO2 flux from organic (kerogen) oxidation [10^18 mol/yr]
! weaflx_po4rw:  PO4 flux from rock weathering [10^18 mol/yr]
! weaflx_bicccm, 
! weaflx_bicscm,
! weaflx_biccsm,
! weaflx_co2csm,
! weaflx_co2oom,
! weaflx_po4rwm: respective average values of the previous [10^18 mol/yr]


INTEGER, SAVE                :: n_weathering = 0

DOUBLE PRECISION, DIMENSION(:), POINTER, SAVE &
                             :: weaflx_time

DOUBLE PRECISION, DIMENSION(:), POINTER, SAVE &
                             :: weaflx_biccc => NULL(), weaflx_bicsc => NULL(), &
                                weaflx_biccs => NULL(), weaflx_co2cs => NULL(), &
                                weaflx_co2oo => NULL(), weaflx_po4rw => NULL()

DOUBLE PRECISION, SAVE       :: weaflx_bicccm, weaflx_bicscm, &
                                weaflx_biccsm, weaflx_co2csm, &
                                weaflx_co2oom, weaflx_po4rwm

DOUBLE PRECISION, PARAMETER  :: weaflx_period_dflt = 120D3

DOUBLE PRECISION, SAVE       :: weaflx_period = weaflx_period_dflt

DOUBLE PRECISION, PARAMETER  :: weaflx_biccc_dflt = 24.6D-6, &
                                weaflx_bicsc_dflt = 11.7D-6, &
                                weaflx_biccs_dflt =  0.0D-6, &
                                weaflx_co2cs_dflt =  0.0D-6, &
                                weaflx_co2oo_dflt =  1.5D-6, &
                                weaflx_po4rw_dflt =  0.014150943D-6


INTEGER, PARAMETER :: n_weaflx       =  6
 CHARACTER(LEN=31), DIMENSION(n_weaflx), PARAMETER &
                             :: weaflx_names = (/ 'biccc', 'bicsc', 'biccs', 'co2cs', 'co2oo', 'po4rw' /)
INTEGER, PARAMETER           :: i_weaflx_biccc = 1, &
                                i_weaflx_bicsc = 2, &
                                i_weaflx_biccs = 3, &
                                i_weaflx_co2cs = 4, &
                                i_weaflx_co2oo = 5, &
                                i_weaflx_po4rw = 6

INTEGER, SAVE                :: n_weaflx_biccc = 1, &
                                n_weaflx_bicsc = 1, &
                                n_weaflx_biccs = 1, &
                                n_weaflx_co2cs = 1, &
                                n_weaflx_co2oo = 1, &
                                n_weaflx_po4rw = 1

INTEGER, SAVE                :: i_weathering   = -1

END MODULE MOD_MBM_CONTIWEATHERING
