!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


MODULE MOD_MBM_CONBIO

USE MOD_MBM_GEOMETRY, ONLY: ro1, nro1, ro3, nro3

IMPLICIT NONE

! Continental biospheric forcings
! Experimental only
! tcbio : time evolution (1st in file = -120000 yr, ie, 120kyr BP
!                         last in file = 0 yr
! frcbio: evolution of fractionation for C13, leading to
!         (dC13 biosphere = dC13 atmosphere + frcbio)
!         Units in file: permil, to be converted!
! stcbio: stock of carbon in the continental biosphere
!         Units in file: Gt (10^15 g) of C,
!                        to be converted into 10^18molC
! stpbio: stock of phosphorus in the continental biosphere
!         Units in file: 10^12 g of P,
!                        to be converted into 10^18molP
! dcbio : variation of carbon stock, to be calculated
!         Units: 10^18 molC/yr
! dpbio : variation of phosphorus stock, to be calculated
!         Units: 10^18 molP/yr
! cindex: current index for interpolation


INTEGER, PARAMETER                                        :: ncbio = 1201


DOUBLE PRECISION, DIMENSION(ncbio)                        :: tcbio, stcbio, frcbio, stpbio, dcbio, dpbio
INTEGER                                                   :: cindex

DOUBLE PRECISION, DIMENSION(0:ncbio-1, ro3+1:ro3+nro3)    :: aalyso, cclyso
DOUBLE PRECISION, DIMENSION(0:ncbio-1, ro1+1:ro1+nro1, 3) :: sscini, sscino, sscori, sscoro, &
                                                             ssalki, ssalko, ssoxyi, ssoxyo
DOUBLE PRECISION, DIMENSION(0:ncbio-1, ro1+1:ro1+nro1)    :: ccorli, ccorlo, sshbko


END MODULE MOD_MBM_CONBIO
