!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!     ******************************************************************
      MODULE MOD_MBM_BIOCTS
!     ******************************************************************

      USE MOD_MBM_GEOMETRY, ONLY: ro1, nro1, i_hypspr_1, i_hypspr_n

      IMPLICIT NONE


! C, N, P and Remin O2 Redfield parameters
      DOUBLE PRECISION, SAVE
     &                  :: orgm_c, orgm_n, orgm_p, orgm_ro2

! P:C and N:C Redfield parameters
      DOUBLE PRECISION, SAVE
     &                  :: rhopc, rhonc

! PO4 utilisation ratios (fraction of influx)
      DOUBLE PRECISION, SAVE, DIMENSION(ro1+1:ro1+nro1)
     &                  :: po4uti

! Organic matter remineralisation ratios
! - layer 2: 100-1000m
      DOUBLE PRECISION, SAVE, DIMENSION(i_hypspr_1:i_hypspr_n)
     &                  :: corem2
! - layer 3: 1000+m
      DOUBLE PRECISION, SAVE
     &                  :: corem3

      END MODULE MOD_MBM_BIOCTS
