!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


      MODULE MOD_MBM_XSETUP

      USE mod_mbm_geometry, ONLY: nro3, nroc,
     >                           n_hypspr, n_sflelt

      IMPLICIT NONE

! Variable vector setups

! Oceanic variable vector setup

      INTEGER, PARAMETER :: n_pco2a  = 1
      INTEGER, PARAMETER :: n_c13a   = 1
      INTEGER, PARAMETER :: n_c14a   = 1
      INTEGER, PARAMETER :: n_vpo4   = nroc
      INTEGER, PARAMETER :: n_vcit   = nroc
      INTEGER, PARAMETER :: n_cc14   = nroc
      INTEGER, PARAMETER :: n_valk   = nroc
      INTEGER, PARAMETER :: n_cc13   = nroc
      INTEGER, PARAMETER :: n_voxy   = nroc

      INTEGER, PARAMETER :: ioca_pco2a_1  = 1                      !  1
      INTEGER, PARAMETER :: ioca_c13a_1   = ioca_pco2a_1 + n_pco2a !  2
      INTEGER, PARAMETER :: ioca_c14a_1   = ioca_c13a_1  + n_c13a  !  3
      INTEGER, PARAMETER :: ioca_vpo4_1   = ioca_c14a_1  + n_c14a  !  4
      INTEGER, PARAMETER :: ioca_vcit_1   = ioca_vpo4_1  + n_vpo4  ! 14
      INTEGER, PARAMETER :: ioca_cc14_1   = ioca_vcit_1  + n_vcit  ! 24
      INTEGER, PARAMETER :: ioca_valk_1   = ioca_cc14_1  + n_cc14  ! 34
      INTEGER, PARAMETER :: ioca_cc13_1   = ioca_valk_1  + n_valk  ! 44
      INTEGER, PARAMETER :: ioca_voxy_1   = ioca_cc13_1  + n_cc13  ! 54
      
      INTEGER, PARAMETER :: n_xoca        = ioca_voxy_1  + n_voxy -1!63


! Sedimentary variable vector setup

      INTEGER, PARAMETER :: n_arag2s = n_hypspr*n_sflelt
      INTEGER, PARAMETER :: n_calc2s = n_hypspr*n_sflelt
      INTEGER, PARAMETER :: n_orgm2s = n_hypspr*n_sflelt
      INTEGER, PARAMETER :: n_othr2s = n_hypspr*n_sflelt
      INTEGER, PARAMETER :: n_s2cit  = nro3
      INTEGER, PARAMETER :: n_s2alk  = nro3
      

      INTEGER, PARAMETER :: ised_arag2s_1 = 1
      INTEGER, PARAMETER :: ised_calc2s_1 = ised_arag2s_1 + n_arag2s
      INTEGER, PARAMETER :: ised_orgm2s_1 = ised_calc2s_1 + n_calc2s
      INTEGER, PARAMETER :: ised_othr2s_1 = ised_orgm2s_1 + n_orgm2s
      INTEGER, PARAMETER :: ised_s2cit_1  = ised_othr2s_1 + n_othr2s
      INTEGER, PARAMETER :: ised_s2alk_1  = ised_s2cit_1  + n_s2cit

      INTEGER, PARAMETER :: n_xsed        = ised_s2alk_1  + n_s2alk -1


      INTEGER, PARAMETER :: le = n_xoca 
      INTEGER, PARAMETER :: ne = n_xoca+n_xsed

      
      END MODULE MOD_MBM_XSETUP

