!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


      MODULE MOD_LOGUNITS

      IMPLICIT NONE

      INTEGER, PARAMETER :: min_valid =  50

      INTEGER, SAVE, PRIVATE :: min_free = min_valid

      CONTAINS
      INTEGER FUNCTION RESERVE_LOGUNIT(iunit)
      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: iunit
      INTEGER :: mf_unit
      INTEGER :: number
      LOGICAL :: exists, opened

      iunit = -1

!/* #ifdef DEBUG
!      INQUIRE(UNIT = iunit,
!     &        EXIST = exists, OPENED = opened, NUMBER = number)
!      PRINT*, 'Assigning unit', iunit
!      PRINT*, 'Unit', iunit, ' exists: ', exists
!      PRINT*, 'Unit', iunit, ' opened: ', opened
!      PRINT*, 'Unit', iunit, ' number: ', number
!#endif */
      IF(min_free == -1) THEN ! There no valid units left
        reserve_logunit = 1
        RETURN
      ELSE ! check whether min_free still available
        INQUIRE(UNIT = min_free, OPENED = opened)
        IF (.NOT. opened) THEN ! if so, reserve it
          iunit = min_free
        ELSE
          DO
          min_free = min_free+1
          INQUIRE(UNIT = min_free,
     &            EXIST = exists, OPENED = opened, NUMBER = number)
          IF(.NOT. exists) THEN
            min_free = -1
            reserve_logunit = 1
            RETURN
          ELSEIF(.NOT. opened) THEN
            iunit = min_free
            EXIT
          ELSE
            CYCLE
          ENDIF
          ENDDO
        ENDIF

        DO ! Now search for the next free one 
          min_free = min_free+1
          INQUIRE(UNIT = min_free,
     &            EXIST = exists, OPENED = opened, NUMBER = number)
          IF(.NOT. exists) THEN ! there is none left: min_free -> -1
            min_free = -1
            EXIT
          ELSEIF(.NOT. opened) THEN ! this one is fine
            EXIT
          ELSE ! try the next one
            CYCLE
          ENDIF
        ENDDO
      ENDIF
      reserve_logunit = 0
      RETURN
      END FUNCTION RESERVE_LOGUNIT


      INTEGER FUNCTION FREE_LOGUNIT(iunit)
      IMPLICIT NONE
      INTEGER :: iunit
      INTENT(INOUT) :: iunit
      INTEGER :: number
      LOGICAL :: exists, opened

!/* #ifdef DEBUG
!      INQUIRE(UNIT = iunit,
!     &        EXIST = exists, OPENED = opened, NUMBER = number)
!      PRINT*, 'Closing unit', iunit
!      PRINT*, 'Unit', iunit, ' exists: ', exists
!      PRINT*, 'Unit', iunit, ' opened: ', opened
!      PRINT*, 'Unit', iunit, ' number: ', number
!#endif */

      IF(iunit < min_valid) THEN
        free_logunit = 2    ! Existing, but not managed here
      ELSE
        INQUIRE(UNIT = iunit,
     &          EXIST = exists, OPENED = opened, NUMBER = number)
        IF(exists) THEN
          IF(opened) CLOSE(iunit)
          IF(min_free > iunit) min_free = iunit
          iunit = -1
          free_logunit = 0
        ELSE
          free_logunit = 1  ! Non existing unit
        ENDIF
      ENDIF
      RETURN
      END FUNCTION FREE_LOGUNIT

      END MODULE MOD_LOGUNITS
