!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


      SUBROUTINE MBMCFG(cfg_filename)

      USE mod_logunits
      USE mod_mbm_files
      USE mod_mbm_info

      IMPLICIT NONE

      CHARACTER(len=*), INTENT(IN) :: cfg_filename

      INTEGER :: status, cfguni
      CHARACTER(len=256) :: oneline, analine
      CHARACTER(len=32) :: token1
      INTEGER :: len_analine
      INTEGER :: line_count, pos, pos1, pos2
      CHARACTER(len = 41), PARAMETER ::
     & syntaxerr_form = '("Syntax error in CFG file at line ", i3)'


      status = RESERVE_LOGUNIT(cfguni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "cfguni" unit number ', cfguni
      ELSE
        STOP 'Error assigning "cfguni" a unit number'
      ENDIF
      
      OPEN(UNIT=cfguni,FILE=cfg_filename)

      line_count = 0
      read_header: DO
      READ(cfguni,'(A256)') oneline
      line_count = line_count+1
      IF(oneline(1:2)/='##') THEN
!        WRITE(erruni,*) TRIM(oneline)
        CYCLE
      ELSE
        EXIT
      ENDIF
      ENDDO read_header

      parse_cfg: DO
        READ(cfguni,'(A256)') oneline
        line_count = line_count+1
        analine = TRIM(ADJUSTL(oneline))
        len_analine = len_trim(analine)
        IF(len_analine == 0) CYCLE parse_cfg
        IF(analine(1:1) == '!') CYCLE parse_cfg


        pos = INDEX(analine, '## MODEL_ID')
        IF(pos == 1) THEN
          WRITE(erruni,'("Processing MODEL_ID from line ",i3)')
     &                                                        line_count
          model_idstr = ' '
          model_id: DO
            READ(cfguni,'(A256)') oneline
            line_count = line_count+1
            analine = TRIM(ADJUSTL(oneline))
            len_analine = len_trim(analine)
            IF(len_analine == 0) CYCLE model_id
            IF(analine(1:1) == '!') CYCLE model_id
            pos1 = INDEX(analine, "'")
            pos2 = INDEX(analine, "'",.TRUE.)
            IF(pos1 < pos2-1) THEN
              model_idstr = analine(pos1+1:pos2-1)
            ELSE
              pos = INDEX(analine, '## END MODEL_ID')
              IF(pos == 1) THEN
                WRITE(erruni,'("End of MODEL_ID at line ",i3)')
     &                                                        line_count
                EXIT model_id
              ELSE
                WRITE(erruni,syntaxerr_form) line_count
                STOP
              ENDIF
            ENDIF
          ENDDO model_id
        ENDIF


        pos = INDEX(analine, '## EXPERIMENT_ID')
        IF(pos == 1) THEN
          WRITE(erruni,'("Processing experiment_id from line ",i3)')
     &                                                        line_count
          experiment_idstr = ' '
          experiment_id: DO
            READ(cfguni,'(A256)') oneline
            line_count = line_count+1
            analine = TRIM(ADJUSTL(oneline))
            len_analine = len_trim(analine)
            IF(len_analine == 0) CYCLE experiment_id
            IF(analine(1:1) == '!') CYCLE experiment_id
            pos1 = INDEX(analine, "'")
            pos2 = INDEX(analine, "'",.TRUE.)
            IF(pos1 < pos2-1) THEN
              experiment_idstr = analine(pos1+1:pos2-1)
            ELSE
              pos = INDEX(analine, '## END EXPERIMENT_ID')
              IF(pos == 1) THEN
                WRITE(erruni,'("End of EXPERIMENT_ID at line ",i3)')
     &                                                        line_count
                EXIT experiment_id
              ELSE
                WRITE(erruni,syntaxerr_form) line_count
                STOP
              ENDIF
            ENDIF
          ENDDO experiment_id
        ENDIF


        pos = INDEX(analine, '## FILES')
        IF(pos == 1) THEN
          WRITE(erruni,'("Processing FILES list from line ",i3)')
     &                                                        line_count
          filelist: DO
            READ(cfguni,'(A256)') oneline
            line_count = line_count+1
            analine = TRIM(ADJUSTL(oneline))
            len_analine = len_trim(analine)
            IF(len_analine == 0) CYCLE filelist
            IF(analine(1:1) == '!') CYCLE filelist
            pos = INDEX(analine, ' = ')
            IF(pos <= 1) THEN
              pos = INDEX(analine, '## END FILES')
              IF(pos == 1) THEN
                WRITE(erruni,'("End of FILES list at line ",i3)')
     &                                                        line_count
                EXIT filelist
              ELSE
                WRITE(erruni,syntaxerr_form) line_count
                STOP
              ENDIF
            ELSE
              token1 = TRIM(analine(1:pos-1))
              SELECT CASE (token1)
              CASE('DAT')
                datusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  datfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'dat file = ',TRIM(datfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('INI')
                iniusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  inifil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'ini file = ',TRIM(inifil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('RES')
                resusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  resfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'res file = ',TRIM(resfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('CSL')
                cslusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
#ifdef MBM_WITH_NETCDF
                  cslfil = analine(pos+pos1+3:pos+pos2+1)//'.nc'
#else
                  cslfil = analine(pos+pos1+3:pos+pos2+1)
#endif
                  WRITE(erruni,*) 'csl file = ',TRIM(cslfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('CMS')
                cmsusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
#ifdef MBM_WITH_NETCDF
                  cmsfil = analine(pos+pos1+3:pos+pos2+1)//'.nc'
#else
                  cmsfil = '/dev/null'
                  WRITE(erruni,*) 'cms file requires MBM' //
                                  '_WITH_NETCDF'
#endif
                  WRITE(erruni,*) 'cms file = ',TRIM(cmsfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('ELV')
                elvusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  elvfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'elv file = ',TRIM(elvfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('SLV')
                slvusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  slvfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'slv file = ',TRIM(slvfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('FLX')
                flxusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  flxfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'flx file = ',TRIM(flxfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('FF1')
                ff1usd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  ff1fil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'ff1 file = ',TRIM(ff1fil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('PUR')
                purusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  purfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'pur file = ',TRIM(purfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('CRR')
                crrusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  crrfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'crr file = ',TRIM(crrfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('AFC')
                afcusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  afcfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'afc file = ',TRIM(afcfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('SHF')
                shfusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  shffil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'shf file = ',TRIM(shffil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('WEA')
                weausd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  weafil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'wea file = ',TRIM(weafil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('SDO')
                sdousd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  sdofil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'sdo file = ',TRIM(sdofil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('SDI')
                sdiusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  sdifil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'sdi file = ',TRIM(sdifil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('CON')
                conusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  confil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'con file = ',TRIM(confil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('CBF')
                cbfusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  cbffil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'cbf file = ',TRIM(cbffil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE('TPR') ! Temperatures in NetCDF
                tprusd = 1
                pos1 = INDEX(analine(pos+3:), "'")
                pos2 = INDEX(analine(pos+3:), "'",.TRUE.)
                IF(pos1 < pos2) THEN
                  tprfil = analine(pos+pos1+3:pos+pos2+1)
                  WRITE(erruni,*) 'tpr file = ',TRIM(tprfil)
                ELSE
                  WRITE(erruni,syntaxerr_form) line_count
                ENDIF
              CASE DEFAULT
                WRITE(erruni,*) token1, ' not yet supported'
              END SELECT
            ENDIF
          ENDDO filelist
        ENDIF
        pos = INDEX(analine, '## END CFG')
        IF(pos == 1) THEN
          WRITE(erruni,'("End of CFG at line ",i3)') line_count
          EXIT parse_cfg
        ENDIF

      ENDDO parse_cfg

      
!      end_cfg: DO
!        READ(cfguni,'(A256)') oneline
!        line_count = line_count+1
!        analine = TRIM(ADJUSTL(oneline))
!        len_analine = len_trim(analine)
!        IF(len_analine == 0) CYCLE end_cfg
!        IF(analine(1:1) == '!') CYCLE end_cfg
!        pos = INDEX(analine, '## END CFG')
!        IF(pos == 1) THEN
!          WRITE(erruni,'("End of CFG at line ",i3)') line_count
!          EXIT end_cfg
!        ELSE
!          WRITE(erruni,
!     &          '("Syntax error in *.cfg file at line ", i3)')
!     &          line_count
!          STOP
!        ENDIF
!      ENDDO end_cfg

      CLOSE(UNIT=cfguni)
      WRITE(erruni,*) 'Freeing "cfguni" unit number ', cfguni
      status = FREE_LOGUNIT(cfguni)
      IF (status /= 0) THEN
        WRITE(erruni,*) 'Error ', status,
     &             ' when freeing "cfguni" unit number; Ignoring.'
      ENDIF


      WRITE(erruni,*) 'Message (model_id)'
      WRITE(erruni,*) model_idstr

      IF (datusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(datuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "datuni" unit number ', datuni
      ELSE
        STOP 'Error assigning "datuni" a unit number'
      ENDIF
      ELSE
        STOP 'dat-file mandatory'
      ENDIF

      IF (iniusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(iniuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "iniuni" unit number ', iniuni
      ELSE
        STOP 'Error assigning "iniuni" a unit number'
      ENDIF
      ELSE
        STOP 'ini-file mandatory'
      ENDIF

      IF (elvusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(elvuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "elvuni" unit number ', elvuni
      ELSE
        STOP 'Error assigning "elvuni" a unit number'
      ENDIF
      ELSE
        STOP 'elv-file mandatory'
      ENDIF

      IF (weausd .NE. 0) THEN
      status = RESERVE_LOGUNIT(weauni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "weauni" unit number ', weauni
      ELSE
        STOP 'Error assigning "weauni" a unit number'
      ENDIF
      ENDIF

      IF (cslusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(csluni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "csluni" unit number ', csluni
      ELSE
        STOP 'Error assigning "csluni" a unit number'
      ENDIF
      ENDIF

      IF (resusd .NE. 0) THEN
        IF (loguni /= -1) THEN       ! If loguni has been re-set (exists), use it
          resuni = loguni
        ELSE
          status = RESERVE_LOGUNIT(resuni)
          IF (status == 0) THEN
            WRITE(erruni,*) 'Assigning "resuni" unit number ', resuni
          ELSE
            STOP 'Error assigning "resuni" a unit number'
          ENDIF
        ENDIF
      ENDIF

      status = RESERVE_LOGUNIT(tmpuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "tmpuni" unit number ', tmpuni
      ELSE
        STOP 'Error assigning "tmpuni" a unit number'
      ENDIF

      IF (sdousd .NE. 0) THEN
      status = RESERVE_LOGUNIT(sdouni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "sdouni" unit number ', sdouni
      ELSE
        STOP 'Error assigning "sdouni" a unit number'
      ENDIF
      ENDIF

      IF (conusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(conuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "conuni" unit number ', conuni
      ELSE
        STOP 'Error assigning "conuni" a unit number'
      ENDIF
      ENDIF

      IF (sdiusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(sdiuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "sdiuni" unit number ', sdiuni
      ELSE
        STOP 'Error assigning "sdiuni" a unit number'
      ENDIF
      ENDIF

      IF (flxusd .NE. 0) THEN
      status = RESERVE_LOGUNIT(flxuni)
      IF (status == 0) THEN
        WRITE(erruni,*) 'Assigning "flxuni" unit number ', flxuni
      ELSE
        STOP 'Error assigning "flxuni" a unit number'
      ENDIF
      ENDIF

      END SUBROUTINE MBMCFG


