!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef FN_THISFILE
#undef FN_THISFILE
#endif
#define FN_THISFILE "mbm_medusa.F"
#ifndef __LINE__
#define __LINE__ 0
#endif
#ifndef SAVE_COLUMN_BYCALLER
#define SAVE_COLUMN_BYCALLER
#endif
      PROGRAM medmbm
C
C     (C) Guy Munhoven
c     If you break your machine with this program ...
c     ... you are alone owner and responsible of the pieces!
C
C     Disclaimer:
C     This software is distributed "as is", with no
C     liability included whatsoever.
c
c     Calls: INITIA, SECMEM, DORPRI, SETGEO
c
      USE mod_generalparams
      USE mod_mbm_geometry
      USE mod_mbm_options
      USE mod_mbm_tempo, ONLY: temps
      USE mod_mbm_xsetup
      USE mod_mbm_biocts
      USE mod_mbm_paleod
      USE mod_mbm_conbio
      USE mod_mbm_files
      USE mod_mbm_info

      USE mod_mbm_other, ONLY:
      USE mod_mbm_chimiq, ONLY:
      USE mod_mbm_wfluxes, ONLY:
      USE mod_mbm_contiweathering, ONLY:
      USE mod_mbm_shelffluxes, ONLY:



      USE mod_indexparam, ONLY: ncompo, nsolid, nsolut
      USE mod_gridparam, ONLY: idnt, idnb
      USE mod_materialcharas
      USE mod_logunits

      USE mod_defines_medusa
      USE mod_execontrol_medusa, ONLY: ABORT_MEDUSA
      USE mod_files_medusa
      USE mod_mbm_medusa_setup, ONLY: SETUP_MEDUSA_FOR_MBM
      USE mod_mbm_medusa_o2s
      USE mod_mbm_medusa_s2o

      USE mod_seafloor_central
      USE mod_seafloor_temp
      USE mod_seafloor_init
      USE mod_sedcore  ! for REACLAY_X_CORELAY, SEDFIL_NOFILE, SEDFIL_OPEN

#ifdef MBM_WITH_NETCDF
      USE mod_store_ncfiles, ONLY: STORE_NC_3D, STORE_NC_3DR,
     &                             STORE_NC_FLX, STORE_NC_BDRYCOND
#endif

      USE mod_equilibdata
      USE mod_equilibcontrol

      USE mod_processdata
      USE mod_processcontrol

      IMPLICIT NONE


#include "netcdf.inc"
      INTEGER :: istatus

      INTEGER savsup

      DOUBLE PRECISION, DIMENSION(ne) :: x, dtx
#include "secmem.equivalence"

      DOUBLE PRECISION :: r76

      DOUBLE PRECISION tinf,tmax,pas,tol,tmin,tsup
      DOUBLE PRECISION x_tinf(1:ne)
      CHARACTER(len = 80) ::
     &  messag = 'This is medmbm10.0 - '
     &           // TIMESTAMP
      INTEGER i, j, k, nepoch, rqflag, iiflag, idummy
      INTEGER :: i_column, n_trouble

! Action request flag variables
      LOGICAL updtts, iasd01, svsd01, biof01
      INTEGER :: prguni

      DOUBLE PRECISION, DIMENSION(1:nro1,3) ::
     &  save_dic_tf, save_alk_tf, save_oxyg_tf
! Medusa-related variables
      INTEGER :: n_columns
      INTEGER :: i_request
      DOUBLE PRECISION, DIMENSION(idnt:idnb, ncompo) ::
     &  xcn, dx_xcn
      DOUBLE PRECISION, DIMENSION(nsolid) :: ysolidn


      CHARACTER(LEN=*), PARAMETER ::
     &  fn_thisfile     = FN_THISFILE
      CHARACTER(LEN=*), PARAMETER ::
     &  fmt_info_a      = '("['//fn_thisfile//']: ", A)' ,
     &  fmt_info_ai     = '("['//fn_thisfile//']: ", A, I0)',
     &  fmt_infolin_ia  = '("['//fn_thisfile//':", I0, "]: ", A)'


! Except for the medusa system log/error-file, filenames are
! specified in the .cfg file 'mbm.cfg'
! Current exceptions: NETCDF files are opened directly
! here, with hard-wired names (to be changed)

      loguni = jp_stdlog             ! from mod_defines_medusa
      erruni = jp_stderr             ! from mod_defines_medusa
      OPEN(erruni, FILE='medmbm.log')

      IF (jp_stddbg  /= -1) THEN
        dbguni = jp_stddbg           ! from mod_defines_medusa
      ELSE
        istatus = RESERVE_LOGUNIT(dbguni)
        IF (istatus == 0) THEN
          WRITE(erruni,*) 'Assigning "dbguni" unit number ', dbguni
        ELSE
          STOP 'Error assigning "dbguni" a unit number'
        ENDIF
      ENDIF

      OPEN(dbguni, FILE='medmbm.dbg')

      prguni = erruni
      resuni = jp_stdlog           ! from mod_defines_medusa

      CALL MBMCFG('mbm.cfg')


C     --- OPTIONS ------------------------------------------------------
! These options were previously possible with the .cfg file
! but have now been phased out. Other possibilities exist
! to perform the same, with better control and check options.
! Currently, the variables still remain, in order
! to avoid side-effects as long as the code has not been completely
! cleared

!     READ(cfguni,*) cbcinp
!     cbcinp = .FALSE. : Continental CO2 input forcing ignored, set to 0
!              .TRUE.  : Continental CO2 input forcing used
!                        from prescribed scenario
      cbcinp = .TRUE.

!     READ(cfguni,*) supvis
!     supvis = 0 : secmem works in silence; no outputs to csluni (6)
!              1 : secmem prints out the residence times of the
!                  different constituents and other info 
!                  into file unit 7 (resfil)
!              2 : secmem prints out results to file unit 6 (default)
!              4 : the program only prints out various info (weathering
!                  scenario evolution and does not perform any
!                  calculations
      supvis = 2


!     ------------------------------------------------------------------ 
      IF (cslusd /= 0) OPEN(UNIT=csluni, FILE=cslfil)
      IF (flxusd /= 0) OPEN(UNIT=flxuni, FILE=flxfil)

      IF (resusd /= 0) THEN
        OPEN(UNIT=resuni, FILE=resfil)
        WRITE(resuni,*) messag
      ENDIF

! Initialise ocean related variables and forcings.
      OPEN(UNIT=datuni, FILE=datfil)
      OPEN(UNIT=iniuni, FILE=inifil)
      OPEN(UNIT=elvuni, FILE=elvfil, FORM='UNFORMATTED')
      CALL INITIA(tmin,tmax,pas,tol, 
     <            pco2a, c13a, c14a,
     <            vpo4, vcit, cc14, valk, cc13, voxy, r76)
      CLOSE(UNIT=datuni)
      CLOSE(UNIT=iniuni)
      CLOSE(UNIT=elvuni)
C
! Preparing Medusa:
! The driver should then in turn
! * CALL SEAFLOOR_STARTUP(n_columns, ...)
!     which calls SEAFLOOR_SETUP and prepares all the index
!     initialisation for SEAFLOOR_MODULE
! * CALL SEAFLOOR_INIT, which loads the initial state of
!     the sediment (corelay*, reaclay*, ...) into SEAFLOOR_MODULE
! * For each time step t -> t + dt
!   + CALL OCEAN-TO_SEDIMENT(...) to load boundary conditions
!     at time = t+dt into SEAFLOOR_MODULE
!   + CALL SOLVSED_ONESTEP(atime(=t), datime(=dt), n_columns,
!    &                     iflag, n_trouble)
!     which, retrieves all the information required from
!     SEAFLOOR_MODULE, performs the integration of the DAE,
!     and restores the new state into SEAFLOOR_MODULE
!   + CALL SEDIMENT_TO_OCEAN(...) to return the top boundary
!     fluxes to a possibly coupled model of the ocean carbon cycle.
!   + and, once the results for t + dt are acceptable
!     CALL REACLAY_X_CORELAY(atime(=t+dt))
!     to normalise the ysolid/corelay_solids distributions

! Stages:
!  1. Setup and Initialisation of sediment
!  2. Determine initial estimate for sediment-to-ocean flux
!  3. Print out required information to res-file
!  4. For each [t, t+epoch] interval, determine ocean
!     values for t+epoch, use those with Medusa to get
!     revised sediment output fluxes and cycle until
!     OK. Store new sediment state into SEAFLOOR_MODULE,
!     possibly save results to file, and do next epoch-interval


! Stage 1: Initialise sediment:

! 1.0 Read in the list of input and output files for MEDUSA
      CALL INIT_FILELIST_MEDUSA(experiment_idstr)   ! from MOD_FILES_MEDUSA

! 1.1
! Set up the interface data in mod_mbm_setup

! 1.2
! 1.2.1 Set up sediment model

      CALL SETUP_MEDUSA_FOR_MBM(n_columns)


                                    ! Must be done here as
                                    ! this also calls CORELAY_SETUP
      CALL SETUP_SEDCORE_SYSTEM(cfn_ncin_sedcore, cfn_ncout_sedcore)

! 1.2.2 Read in reaction rate parameters from file 'medusa.rrp'
!       and log rate law infos and rate constant values to erruni
      IF(resusd /= 0) WRITE(resuni,*)

      CALL InitEquilibParameters    ! From mod_equilibcontrol.F
      CALL InitProcessParameters    ! From mod_processcontrol.F


! 1.2.3 Set up mod_seafloor_temp (allocate array space)
      CALL SEAFLOOR_TEMP_SETUP(n_columns)


! 1.3 Define seafloor initial condition in SEAFLOOR_MODULE
                                    ! Initialize the sediment state
                                    ! (subr. from MOD_SEAFLOOR_INIT)
      IF (cfn_ncin_init /= "/dev/null") THEN

        CALL InitSeafloorFromNetCDFFiles(cfn_reaclay = cfn_ncin_init,
     &                                   cfn_flx     = cfn_ncin_flx)

                                    ! Override zero sediment-to-ocean
                                    ! fluxes if flux data have been
                                    ! read into SEAFLOOR_CENTRAL by
                                    ! InitSeafloorFromNetCDFFiles
        IF (cfn_ncin_flx /= "/dev/null") THEN
           CALL SEDIMENT_TO_OCEAN(iiflag)
           ! IF(iiflag /= 0) THEN
           ! ...
           ! ENDIF
        ENDIF

      ELSEIF (cfn_nmlin_init /= "/dev/null") THEN

        CALL InitSeafloorFromNamelistFile(cfn_nmlin_init)

      ELSE

        WRITE(jp_stderr,'()')
        WRITE(jp_stderr,
     &                 '("Error: no valid initialisation file given:")')
        WRITE(jp_stderr,'(" - cfn_nmlin_init = """, A, """")')
     &                              TRIM(cfn_nmlin_init)
        WRITE(jp_stderr,'(" - cfn_ncin_init = """, A, """")')
     &                              TRIM(cfn_ncin_init)
        WRITE(jp_stderr,'("Aborting!")')
        CALL ABORT_MEDUSA()

      ENDIF

! Stage 2. Determine initial estimate for sediment-to-ocean flux:
!          Load an initial set of boundary conditions into MOD_MBM_O2S
!          (Top conc and Fluxes, DBSL, temp, salin, surf)

! 2.1 Set MBM control flags
      CALL SETUPD(temps, updtts, iasd01, svsd01, biof01)

! 2.2 Call SECMEM with supvis=8 to get MOD_MBM_O2S loaded

      rest_dic_tf(:,:)  = 0D0
      rest_alk_tf(:,:)  = 0D0
      rest_oxyg_tf(:,:) = 0D0

      savsup=supvis
      supvis=8
      CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
      supvis=savsup
      !STOP
! 2.3 Load the first set of boundary conditions into SEAFLOOR_MODULE:
!     - CALL OCEAN_TO_SEDIMENT, which will retrieve the required
!       stuff from MOD_MBM_O2S, convert units, shape etc,
!       and upload it into SEAFLOOR_MODULE
      i_request = 0 ! mandatorily get data here
      CALL OCEAN_TO_SEDIMENT(i_request, iiflag)
      ! IF(iiflag /= 0) THEN
      ! ...
      ! ENDIF

! 2.4 Carry out one trial step to get initial estimates for the
!     sediment-to-ocean fluxes to run MBM-Ocean; these
!     get saved into SEAFLOOR_MODULE

! 2.4.1 Make initial estimates for xc(t+epoch) values available
!     to SOLVSED_ONESTEP via MOD_SEAFLOOR_TEMP:
!     'SAVE_COLUMN_BYCALLER' is #defined, so we have to
!     provide these values manually here
      DO i_column=1, n_columns
        CALL GET_COLUMN(i_column=i_column, iflag=iiflag,
     &           xc=xcn, ysolid=ysolidn)
        solvsed_xc(:,:,i_column)    = xcn
        solvsed_dx_xc(:,:,i_column) = dx_xcn
        solvsed_ysolid(:,i_column)  = ysolidn
      ENDDO
      
! 2.4.2 Do actual calculation; SOLVSED_ONESTEP still stores
!     the resulting boundary exchange fluxes in SEAFLOOR_MODULE
!     The calculated xcn, dx_xcn and ysolidn are not needed at
!     this stage, and can stay in MOD_SEAFLOOR_TEMP
      CALL SOLVSED_ONESTEP(temps, epoch, n_columns,
     &                     iiflag, n_trouble)


! 2.5 Load boundary fluxes from SEAFLOOR_MODULE into MOD_MBM_S2O
!     where EQNSED can retrieve them
      CALL SEDIMENT_TO_OCEAN(iiflag)
      ! IF(iiflag /= 0) THEN
      ! ...
      ! ENDIF
! Run one epoch step to get DIC(t+dt)  etc
! Redo the sediment step 
! Compare previously adopted sediment fluxes
! the newly calculated ones
! Adapt, reload saved sediment state
! reload saved ocean state state
! and redo the same epoch step again.
! repeat until the sediment-to-ocean flux
! adapted for the epoch step with the ocean
! module matches the one calculated with the
! sediment model a posteriori.
! possibly adapt solvsed_onestep to avoid the
! storage of the sediment state ???

! 3. Now that all is initialised, report to file
      savsup=supvis
      supvis=1 ! Print out stuff into resfil
      CALL SETUPD(temps, updtts, iasd01, svsd01, biof01)
      IF (resusd /= 0) THEN
        WRITE(resuni,*)' '
        WRITE(resuni,*)' '
        WRITE(resuni,*)'Time: ', temps
      ENDIF

      CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
      supvis=savsup

      IF (supvis .NE. 4) THEN

! 4 Do actual time interval calculations
! (26MAY1992)
! Update geometry every <epoch> years.
! To do this, subdivide the interval [tmin,tmax] in
! subintervals of <epoch> years, plus a remainder and call
! the ODE integrator ***dorpri*** for each subinterval.

      CALL OPEN_NCFILES_MEDUSA(temps)       ! from MOD_FILES_MEDUSA


! 4.0 Preparation
! 4.0.1 Preparation
      nepoch=INT((tmax-tmin)/epoch)
      tinf=tmin
      temps=tinf

#ifdef DEBUG_MBM_MEDUSA
      WRITE(dbguni,*)
      WRITE(dbguni,*)
      WRITE(dbguni,'("[MBM-MEDUSA step 4.0.1]:")')
      WRITE(dbguni,*) "(tmax-tmin)/epoch = ", (tmax-tmin)/epoch
      WRITE(dbguni,'(" nepoch = ", I0)') nepoch

      CALL FLUSH(dbguni)
#endif

! 4.0.2 Initialise Flux and deep-sea DIC and ALK integrals
      st_arag2s(:,:) = 0D0
      st_calc2s(:,:) = 0D0
      st_orgm2s(:,:) = 0D0
      st_othr2s(:,:) = 0D0
      st_cit(:)      = 0D0
      st_alk(:)      = 0D0

! 4.0.2a Initialise possible Loopback Fluxes to zero
#ifdef LOOP_ORGMATTER
      mbm_orgm_lb = 0D0
#endif
#ifdef LOOP_CALCITE
      mbm_calc_lb = 0D0
#endif
#ifdef LOOP_ARAGONITE
      mbm_arag_lb = 0D0
#endif

! 4.0.3 Save to current state to csl-file
      supvis=2
      CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
      supvis=0

! 4.1 Do calculations 
      time_intervals: DO i=1, nepoch
! 4.1.0 Save current state
         x_tinf = x
! 4.1.1 Update geometry etc.
         CALL SETUPD(temps, updtts, iasd01, svsd01, biof01)
         CALL SETGEO(updtts)

         InteractiveSediment: IF (iasd01) THEN
#ifdef DEBUG_MBM_MEDUSA
         WRITE(dbguni,'("[mbm-medusa.F]: Starting iasd01 step ",I0)') i
         WRITE(dbguni, *) " from ", tinf, " to ", tinf+epoch
#endif
         seditry: DO j=1,5
#ifdef DEBUG_MBM_MEDUSA
           WRITE(dbguni,'("[mbm-medusa.F]: Starting seditry ",I0)') j
#endif
! 4.1.2 Integrate the ocean part with dorpri-[800+]-medusa
! 4.1.2.1 Prepare initial x, boundaries of time interval
           x = x_tinf
           temps = tinf
           IF(i < nepoch) THEN
             tsup = tinf+epoch
           ELSE
             tsup = tmax            ! For the last time interval, <tsup> set
             epoch = tmax - tinf    ! equal to end of simulation run, <tmax>,
                                    ! and the value of <epoch> is adjusted.
           ENDIF
! 4.1.2.2 Initialise flux integral values
           st_arag2s(:,:) = 0D0
           st_calc2s(:,:) = 0D0
           st_orgm2s(:,:) = 0D0
           st_othr2s(:,:) = 0D0
           st_cit(:)      = 0D0
           st_alk(:)      = 0D0
! 4.1.2.3 Save current top sediment-to-ocean fluxes for comparison
!          below
           save_dic_tf = mbm_dic_tf
           save_alk_tf = mbm_alk_tf
           save_oxyg_tf = mbm_oxyg_tf

c~            write(dbguni,*)'before dorpri: ', x(1:le)
           CALL DORPRI(tinf,tsup,pas,x,tol, iasd01, svsd01, biof01)
c~            write(dbguni,*)'after dorpri:  ', x(1:le)
c~            write(dbguni,*)'weaitp:', weaflx_biccc_itp, weaflx_bicsc_itp,
c~      &     weaflx_biccs_itp, weaflx_co2cs_itp,
c~      &     weaflx_co2oo_itp, weaflx_po4rw_itp
! 4.1.3 Check against updated sediment-to-ocean fluxes
! 4.1.3.1 Load MOD_MBM_O2S
           savsup=supvis
           supvis=16  ! upload integrated flux instead of current one
           CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
           supvis=savsup

! 4.1.3.2 Load SEAFLOOR_MODULE:
           i_request = 0
           CALL OCEAN_TO_SEDIMENT(i_request, iiflag)
           ! IF(iiflag /= 0) THEN
           ! ...
           ! ENDIF

! 4.1.3.3 Carry out a trial step to get new estimates for the
!          sediment-to-ocean fluxes to run MBM-Ocean; varn
!          values are still available in MOD_SEAFLOOR_
           CALL SOLVSED_ONESTEP(tinf, epoch, n_columns,
     &                        iiflag, n_trouble)


! 4.1.3.4 Load boundary fluxes from SEAFLOOR_MODULE into MOD_MBM_S2O
!          where EQNSED can retrieve them
           CALL SEDIMENT_TO_OCEAN(iiflag)
           ! IF(iiflag /= 0) THEN
           ! ...
           ! ENDIF

c~            WRITE(dbguni,*) 'dic_tf: ', mbm_dic_tf
c~            WRITE(dbguni,*) 'alk_tf: ', mbm_alk_tf

           IF(ALL(ABS(mbm_dic_tf(:,:) - save_dic_tf(:,:))
     &            - 1D-2*ABS(save_dic_tf(:,:)) < 1D-30
     &           ) .AND.
     &        ALL(ABS(mbm_alk_tf(:,:) - save_alk_tf(:,:))
     &            - 1D-2*ABS(save_alk_tf(:,:)) < 1D-30
     &           ) .AND. (j>1)) THEN
              WRITE(prguni,'("At i =",i4,"/",i4,": ",i1," tries")')
     &         i, nepoch, j
#ifdef DEBUG_MBM_MEDUSA
              WRITE(dbguni,'("[mbm-medusa.F]: Exiting at seditry ",I0)')
     &         j
#endif
              EXIT seditry
           ENDIF
         ENDDO seditry

! 4.2 Book-keeping
! 4.2.1 rest fluxes
! * <save_xxx_tf> is the amount that was taken into account
!   to do the latest tinf->tsup integration;
! * <mbm_xxx_tf> is the amount that the sediment module
!   would have returned on the basis of the integrated
!   yyyy2s fluxes from secmem-medusa.
! The difference of <mbm_xxx_tf-save_xxx_tf> is thus not
! yet accounted for
         rest_dic_tf(:,:) = mbm_dic_tf(:,:) - save_dic_tf(:,:)
         rest_alk_tf(:,:) = mbm_alk_tf(:,:) - save_alk_tf(:,:)
         rest_oxyg_tf(:,:) = mbm_oxyg_tf(:,:) - save_oxyg_tf(:,:)

! We should actually do the same for the top fluxes !!

! 4.2.2a Save possible Loopback Fluxes
#ifdef LOOP_ORGMATTER
         mbm_orgm_lb = mbm_orgm_bf
#endif
#ifdef LOOP_CALCITE
         mbm_calc_lb = mbm_arag_bf
#endif
#ifdef LOOP_ARAGONITE
         mbm_arag_lb = mbm_arag_bf
#endif

! 4.2.2 SAVE accepted state to SEAFLOOR_MODULE
         DO i_column=1, n_columns
           xcn     = solvsed_xc(:,:,i_column)
           dx_xcn  = solvsed_dx_xc(:,:,i_column)
           ysolidn = solvsed_ysolid(:,i_column)
           CALL SAVE_COLUMN(i_column=i_column, iflag=iiflag,
     &              xc=xcn, ysolid=ysolidn)
         ENDDO

! 4.2.3 Normalize SEAFLOOR_MODULE
         CALL REACLAY_X_CORELAY(temps)

! 4.2.4 Check and adjust CORELAY and ERODLAY levels
         CALL SEDFIL_PRUNE

! 4.3 Save to file
! 4.3.1 Save sediment state to file (every tenth interval)
         IF (MOD(i,10) .EQ. 0) THEN
            savsup=supvis
            supvis=1
            IF(resusd /= 0) THEN
               WRITE(resuni,*)' '
               WRITE(resuni,*)' '
               WRITE(resuni,*)'Time: ',temps
            ENDIF
            CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
            supvis=savsup

            CALL WRITERES_NCFILES_MEDUSA(temps)

         ENDIF

         ELSE ! if not interactive sediment
#ifdef DEBUG_MBM_MEDUSA
         WRITE(dbguni,'("[mbm-medusa.F]: Starting non-iasd01 step ",' //
     &                ' I0)') i
         WRITE(dbguni, *) " from ", tinf, " to ", tinf+epoch
#endif
         x = x_tinf
         temps=tinf
         tsup=tinf+epoch
! 4.1.2.2 Initialise flux integral values
         st_arag2s(:,:) = 0D0
         st_calc2s(:,:) = 0D0
         st_orgm2s(:,:) = 0D0
         st_othr2s(:,:) = 0D0
         st_cit(:)      = 0D0
         st_alk(:)      = 0D0
! 4.1.2.3 Save current top sediment-to-ocean fluxes for comparison
!         below

         CALL DORPRI(tinf,tsup,pas,x,tol, iasd01, svsd01, biof01)
!           
         ENDIF InteractiveSediment


! 4.3.1 Store intermediate results to csl-file if used
         supvis=2
#ifdef DEBUG_MBM_MEDUSA
         WRITE(dbguni,'("[mbm-medusa.F]: CSL write at step ",I0)') i
#endif
         CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
         supvis=0

! 4.3.2 Prepare next time interval

         tinf=tsup

      ENDDO time_intervals
      
!!!      STOP
!!!      tsup=tmax
!!!      IF (tsup-tinf.GT.1.d0) THEN
!!!         CALL SETUPD(temps, updtts, iasd01, svsd01, biof01)
!!!         CALL SETGEO(updtts)
!!!         CALL DORPRI(tinf,tsup,pas,x,tol, iasd01, svsd01, biof01)
!!!         savsup=supvis
!!!         supvis=1
!!!         IF(resusd /= 0) THEN
!!!           WRITE(resuni,*)' '
!!!           WRITE(resuni,*)' '
!!!           WRITE(resuni,*)'Time: ',temps
!!!         ENDIF
!!!         CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
!!!         supvis=savsup
!!!      ENDIF


C     If conusd=1, creation of a new initialisation file, roughly
C     corresponding to a file with the results just obtained
C     Reconvert concentrations into total amounts:
C
      IF (conusd .EQ. 1) THEN
         DO i = ro1+1, ro3+nro3
            vpo4(i)=vpo4(i)/volum(i)
            vcit(i)=vcit(i)/volum(i)
            valk(i)=valk(i)/volum(i)
            voxy(i)=voxy(i)/volum(i)
         ENDDO

         OPEN(UNIT=conuni, FILE=confil)
         WRITE(conuni, '( 3(i2,/),i2)') nra1, nro1, nro2, nro3
         WRITE(conuni, '( 3(e15.9,/),e15.9)') tinf, tmax, pas, tol
         WRITE(conuni, '(62(e15.9,/),e15.9)') (x(i), i=1, 63)
         WRITE(conuni, '(   e15.9 )') x(ne)
         WRITE(conuni, '( 2(e15.9,/),e15.9)') 0.0D+00, 0.0D+00, 0.0D+00
         CLOSE(UNIT=conuni)
      ENDIF


      ELSE
C     If <supvis>=4, do not iterate, but only call
C     setgeo and secmem at epoch intervals:
      nepoch=INT((tmax-tmin)/epoch)
      DO i = 0, nepoch
         temps = tmin+i*epoch
         CALL SETUPD(temps, updtts, iasd01, svsd01, biof01)
         IF(i<nepoch) CALL SETGEO(updtts)  ! may currently fail if temps == tmax
         CALL SECMEM(x,dtx,iiflag, iasd01, svsd01, biof01)
      ENDDO
      ENDIF
c
C
#ifndef MBM_WITH_NETCDF
      IF (cslusd /= 0) CLOSE(UNIT=csluni)
#else
      IF (cslusd /= 0) THEN
         istatus = NF_CLOSE(nc_cslfilid)
         IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF
      IF (cmsusd /= 0) THEN
         istatus = NF_CLOSE(nc_cmsfilid)
         IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF
#endif
      IF (resusd /= 0) CLOSE(UNIT=resuni)
      IF (flxusd /= 0) CLOSE(UNIT=flxuni)

      CALL CLOSE_RESFILES_MEDUSA()

      STOP
      END
!---+----|----+----|----+----|----+----|----+----|----+----|----+----|--


