!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


! This code has been automatically generated by CREATE_SOLVSED_CODES
! from the MEDUSA configuration utility MedusaCoCoGen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--

! PLEASE NOTICE:
! =============

! 1. This subroutine possibly needs to be adapted for your special needs.

! 2. If you modify the code in this file, it is recommended to change
!    the name of the file (but not the name of the subroutine!)
!    to avoid having it overwritten at the next code re-generation.

!=======================================================================
      SUBROUTINE solvsedLossConversions(bfflx, ysolid)
!=======================================================================

      USE mod_indexparam
      USE mod_materialcharas

      IMPLICIT NONE


      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN)    :: bfflx
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(INOUT) :: ysolid

      INTEGER :: jf_lost


#ifdef LOST_CALCITE_VOL
                                    ! Replace the volume of Calcite
                                    ! by an equivalent volume of some other
                                    ! material (default: Mud)
                                    ! bfflx(if_calc) is left unchanged
                                    ! so that the loss can be evaluated.
      jf_lost = jf_mud
      IF (bfflx(if_calc) > 0.0D+00) THEN
        ysolid(jf_lost) = ysolid(jf_lost)
     &    + (ysolid(if_calc)*apsv(if_calc))/apsv(jf_lost)
        ysolid(if_calc)   = 0.0D+00
      ENDIF
#endif

#ifdef LOST_CALCITE_MASS
                                    ! Replace the mass of Calcite
                                    ! by an equivalent mass of some other
                                    ! material (default: Mud)
                                    ! bfflx(if_calc) is left unchanged
                                    ! so that the loss can be evaluated.
      jf_lost = jf_mud
      IF (bfflx(if_calc) > 0.0D+00) THEN
        ysolid(jf_lost) = ysolid(jf_lost) + ysolid(if_calc)
        ysolid(if_calc)   = 0.0D+00
      ENDIF
#endif


#ifdef LOST_ARAGONITE_VOL
                                    ! Replace the volume of Aragonite
                                    ! by an equivalent volume of some other
                                    ! material (default: Mud)
                                    ! bfflx(if_arag) is left unchanged
                                    ! so that the loss can be evaluated.
      jf_lost = jf_mud
      IF (bfflx(if_arag) > 0.0D+00) THEN
        ysolid(jf_lost) = ysolid(jf_lost)
     &    + (ysolid(if_arag)*apsv(if_arag))/apsv(jf_lost)
        ysolid(if_arag)   = 0.0D+00
      ENDIF
#endif

#ifdef LOST_ARAGONITE_MASS
                                    ! Replace the mass of Aragonite
                                    ! by an equivalent mass of some other
                                    ! material (default: Mud)
                                    ! bfflx(if_arag) is left unchanged
                                    ! so that the loss can be evaluated.
      jf_lost = jf_mud
      IF (bfflx(if_arag) > 0.0D+00) THEN
        ysolid(jf_lost) = ysolid(jf_lost) + ysolid(if_arag)
        ysolid(if_arag)   = 0.0D+00
      ENDIF
#endif


#ifdef LOST_ORGMATTER_VOL
                                    ! Replace the volume of OrgMatter
                                    ! by an equivalent volume of some other
                                    ! material (default: Mud)
                                    ! bfflx(if_om) is left unchanged
                                    ! so that the loss can be evaluated.
      jf_lost = jf_mud
      IF (bfflx(if_om) > 0.0D+00) THEN
        ysolid(jf_lost) = ysolid(jf_lost)
     &    + (ysolid(if_om)*apsv(if_om))/apsv(jf_lost)
        ysolid(if_om)   = 0.0D+00
      ENDIF
#endif

#ifdef LOST_ORGMATTER_MASS
                                    ! Replace the mass of OrgMatter
                                    ! by an equivalent mass of some other
                                    ! material (default: Mud)
                                    ! bfflx(if_om) is left unchanged
                                    ! so that the loss can be evaluated.
      jf_lost = jf_mud
      IF (bfflx(if_om) > 0.0D+00) THEN
        ysolid(jf_lost) = ysolid(jf_lost) + ysolid(if_om)
        ysolid(if_om)   = 0.0D+00
      ENDIF
#endif


      CONTINUE


      RETURN


!=======================================================================
      END SUBROUTINE solvsedLossConversions
!=======================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
