!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


C     ******************************************************************
      SUBROUTINE EQNSED(yoca, ysed, dtysed,
     >            cit, alk, calc2s, arag2s, othr2s, orgm2s, eroth,
     <            sxcini, sxcino, sxcori, sxcoro,
     <            sxalki, sxalko, sxoxyi, sxoxyo,
     <            clyso, alyso, iflag)
C     ******************************************************************

      USE mod_mbm_geometry
      USE mod_mbm_tempo, ONLY: temps
      USE mod_mbm_xsetup
      USE mod_mbm_medusa_s2o
      USE mod_mbm_biocts
      USE mod_mbm_other
      USE mod_mbm_materialparams, ONLY: c13rk, c14rk

      IMPLICIT NONE
      

      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1) ::
     &   coralo, corali, shbnko, shbnki

      DOUBLE PRECISION, DIMENSION(n_xoca) :: yoca
      DOUBLE PRECISION, DIMENSION(n_xsed) :: ysed, dtysed

      DOUBLE PRECISION, DIMENSION(ro1+1:ro3+nro3) :: cit, alk

      DOUBLE PRECISION, DIMENSION(1:bottom,ro1+1:ro1+nro1,3) ::
     &   calc2s, arag2s, orgm2s
      DOUBLE PRECISION, DIMENSION(1:bottom,ro1+1:ro1+nro1  ) ::
     &   othr2s

C Is the following really necessary ?
      DOUBLE PRECISION eroth(0:bottom-1,ro1+1:ro1+nro1)

      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1,3,3) ::
     &   sxcini, sxcino, sxcori, sxcoro
      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1,3)   ::
     &   sxalki, sxalko, sxoxyi, sxoxyo

      DOUBLE PRECISION, DIMENSION(ro3+1:ro3+nro3) :: alyso, clyso

      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1,3) :: scini, scino

      INTEGER :: i, j, iflag


      DOUBLE PRECISION xsed(n_xsed)
#include "eqnsed_x.equivalence"

      DOUBLE PRECISION dtxsed(n_xsed)
#include "eqnsed_dtx.equivalence"

      DOUBLE PRECISION xoca(n_xoca)
#include "eqnoce_x.equivalence"

      DOUBLE PRECISION volcsi, volcca, volctt
      DOUBLE PRECISION iwcitt
      DOUBLE PRECISION swcitc, swcits, swcitt

      COMMON /FORCINGS/ volcsi, volcca, volctt,
     &                  iwcitt, swcitc, swcits, swcitt,
     &                  coralo, corali, shbnko, shbnki
      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1) :: factor
      DOUBLE PRECISION :: eff_flux

      xoca = yoca
      xsed = ysed

! Equations for having the fluxes integrated by dorpri.

      dtst_arag2s(:,:) = arag2s(:,:,1)
      dtst_calc2s(:,:) = calc2s(:,:,1)
      dtst_orgm2s(:,:) = orgm2s(:,:,1)
      dtst_othr2s(:,:) = othr2s(:,:  )
      dtst_cit(:)      = cit(ro3+1:ro3+nro3)
      dtst_alk(:)      = alk(ro3+1:ro3+nro3)

      DO j = 1, 3     ! loop over the three major depth intervals
      DO i = 1, nro1  ! loop over the (5) profiles
        eff_flux = mbm_dic_tf(i,j) + rest_dic_tf(i,j)
        IF(eff_flux < 0D0) THEN
          scino(ro1+i,j) = 0D0
          scini(ro1+i,j) = -eff_flux
        ELSE
          scino(ro1+i,j) = eff_flux
          scini(ro1+i,j) = 0D0
        ENDIF
         
        eff_flux = mbm_alk_tf(i,j) + rest_alk_tf(i,j)
        IF(eff_flux < 0D0) THEN
          sxalko(ro1+i,j) = 0D0
          sxalki(ro1+i,j) = -eff_flux
        ELSE
          sxalko(ro1+i,j) = eff_flux
          sxalki(ro1+i,j) = 0D0
        ENDIF
         
        eff_flux = mbm_oxyg_tf(i,j) + rest_oxyg_tf(i,j)
        IF(eff_flux < 0D0) THEN
          sxoxyo(ro1+i,j) = 0D0
          sxoxyi(ro1+i,j) = -eff_flux
        ELSE
          sxoxyo(ro1+i,j) = eff_flux
          sxoxyi(ro1+i,j) = 0D0
        ENDIF
      ENDDO
      ENDDO

! sxcori: C transfer Sediment-to-Ocean, as DIC, resulting from
!         diffusion of C into the ocean that was
!         stored as OrgC in the sediment.
!         NB: isotopic fluxes are estimates only!
      sxcori(:,:,1) = (sxoxyo(:,:)/orgm_ro2)*orgm_c
      sxcori(:,:,2) = sxcori(:,:,1)*(c13rk-frc13b)
      ! dC-14 of -162 permil (500 yr after formation with -110 permil)
      sxcori(:,:,3) = sxcori(:,:,1)*(c14rk*0.162D+00)

! sxcoro: this would be the C transfer Ocean-to-Sediment, as DIC,
!         resulting from Organic C in the deep oceanic reservoirs
!         There is currently no such thing
      sxcoro(:,:,:) = 0D0

! sxcini: C transfer Sediment-to-Ocean, as DIC, resulting from
!         diffusion of C into the ocean that was
!         stored as carbonate in the sediment.
!         NB: isotopic fluxes are estimates only!
      
      sxcini(:,:,1) = scini(:,:)-sxcori(:,:,1)
      sxcini(:,:,2) = sxcini(:,:,1)*c13rk
      sxcini(:,:,3) = sxcini(:,:,1)*(c14rk*0.421D+00)

! sxcino: C transfer Ocean-to-Sediment, as DIC, resulting from
!         diffusion of C into the sediment that was stored
!         as DIC in the deep oceanic reservoirs.
!         NB: isotopic fluxes are exact!

      sxcino(:,:,1) = scino(:,:)

      sxcino(ro1+1:ro1+nro1, 1,2) = scino(ro1+1:ro1+nro1, 1)
     &                              *cc13(ro1+1:ro1+nro1)

      sxcino(ro1+1, 2,2) = scino(ro1+1, 2)*cc13(ro1+1)
      sxcino(ro1+2, 2,2) = scino(ro1+2, 2)*cc13(ro2+1)
      sxcino(ro1+3, 2,2) = scino(ro1+3, 2)*cc13(ro1+3)
      sxcino(ro1+4, 2,2) = scino(ro1+4, 2)*cc13(ro2+2)
      sxcino(ro1+5, 2,2) = scino(ro1+5, 2)*cc13(ro1+5)

      sxcino(ro1+1, 3,2) = scino(ro1+1, 3)*cc13(ro3+1)
      sxcino(ro1+2, 3,2) = scino(ro1+2, 3)*cc13(ro3+1)
      sxcino(ro1+3, 3,2) = scino(ro1+3, 3)*cc13(ro3+2)
      sxcino(ro1+4, 3,2) = scino(ro1+4, 3)*cc13(ro3+3)
      sxcino(ro1+5, 3,2) = scino(ro1+5, 3)*cc13(ro3+3)

      sxcino(ro1+1:ro1+nro1, 1,3) = scino(ro1+1:ro1+nro1, 1)
     &                              *cc14(ro1+1:ro1+nro1)

      sxcino(ro1+1, 2,3) = scino(ro1+1, 2)*cc14(ro1+1)
      sxcino(ro1+2, 2,3) = scino(ro1+2, 2)*cc14(ro2+1)
      sxcino(ro1+3, 2,3) = scino(ro1+3, 2)*cc14(ro1+3)
      sxcino(ro1+4, 2,3) = scino(ro1+4, 2)*cc14(ro2+2)
      sxcino(ro1+5, 2,3) = scino(ro1+5, 2)*cc14(ro1+5)

      sxcino(ro1+2, 3,3) = scino(ro1+1, 3)*cc14(ro3+1)
      sxcino(ro1+2, 3,3) = scino(ro1+2, 3)*cc14(ro3+1)
      sxcino(ro1+3, 3,3) = scino(ro1+3, 3)*cc14(ro3+2)
      sxcino(ro1+4, 3,3) = scino(ro1+4, 3)*cc14(ro3+3)
      sxcino(ro1+5, 3,3) = scino(ro1+5, 3)*cc14(ro3+3)

      dtysed = dtxsed

! Finally, set alyso and clyso to controlled values (0D0)
! These values are not used when MBM is coupled to MEDUSA.
! They are only used to keep the res-file complete
      alyso(:) = 0D0
      clyso(:) = 0D0

      END SUBROUTINE EQNSED
C     ******************************************************************

