!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!     ******************************************************************
      SUBROUTINE EQNOCE_XPRT_STRAIGHTTOSEAFLOOR
     >           (xprt_x_nodcum, n_isotopes,
     <            xprt_r, xprt2s)
!     ******************************************************************


      USE mod_mbm_geometry

      IMPLICIT NONE


! Input variables
! ===============

      DOUBLE PRECISION, DIMENSION(i_sflnod_top:i_sflnod_bot,
     &                            i_hypspr_1  :i_hypspr_n,
     &                            n_isotopes)
     &                  :: xprt_x_nodcum

! NOTE ON FORTRAN 95 STANDARD CONFORMANCE
! The previous is not entirely standard conformant (according to gfortran
! this is an illegal explicit-shape array declaration, although I do not
! see why, the more since the similar xprt_r declaration below is OK)
! and may have to be replaced by the following (completely implicit shape)
! but then requires an interface to be used
!      DOUBLE PRECISION, DIMENSION(i_sflnod_top:, i_hypspr_1:, :),
!     &               :: xprt_x_nodcum

      INTEGER           :: n_isotopes

      INTENT(IN)        :: xprt_x_nodcum, n_isotopes



! Output variables
! ================


      DOUBLE PRECISION, DIMENSION(ro1+1:ro3+nro3, n_isotopes)
     &               :: xprt_r
!DEL      DOUBLE PRECISION, DIMENSION(ro1+1:ro3+nro3, n_isotopes)
!DEL     &               :: xprt_r

      DOUBLE PRECISION, DIMENSION(1:bottom, ro1+1: ro1+nro1, n_isotopes)
     &               :: xprt2s
!DEL      DOUBLE PRECISION, DIMENSION(ro1+1: ro1+nro1, n_isotopes)
!DEL     &               :: xprt2s

      INTENT(OUT) :: xprt_r, xprt2s


! Local variables
! ===============


      INTEGER :: j, ip

! Calculations
! ============

      xprt2s(:,:,:) = 0D0


      DO ip = i_hypspr_1, i_hypspr_n

        DO j = i_sflelt_1, maxdep(ip)
          xprt2s(j,ip,:) = xprt_x_nodcum(j,ip,:)-xprt_x_nodcum(j-1,ip,:)
        ENDDO

        xprt2s(maxdep(ip)+1:bottom,ip,:) = 0D0
!DEL        xprt2s(ip,:) = xprt_x_nodcum(i_sflnod_bot,ip,:)

      ENDDO

      xprt_r(:,:) = 0D0

      RETURN
      END SUBROUTINE EQNOCE_XPRT_STRAIGHTTOSEAFLOOR
