!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


/* Select one option among the four available below.
   Only the first one defined will actually be considered! */
#define MBMRHOCAC_HOMOGENEOUS /* Default */
#undef MBMRHOCAC_SHALLOW_HAT
#undef MBMRHOCAC_MIDDLE_HAT
#undef MBMRHOCAC_DEEP_HAT
/* End of selectable options */
/* Option validity check below */
#define MBMRHOCAC_DEFAULT
#ifdef MBMRHOCAC_HOMOGENEOUS
#undef MBMRHOCAC_SHALLOW_HAT
#undef MBMRHOCAC_MIDDLE_HAT
#undef MBMRHOCAC_DEEP_HAT
#undef MBMRHOCAC_HALFHATS
#undef MBMRHOCAC_DEFAULT
#endif
#ifdef MBMRHOCAC_SHALLOW_HAT
#define MBMRHOCAC_HALFHATS
#undef MBMRHOCAC_HOMOGENEOUS
#undef MBMRHOCAC_MIDDLE_HAT
#undef MBMRHOCAC_DEEP_HAT
#undef MBMRHOCAC_DEFAULT
#endif
#ifdef MBMRHOCAC_MIDDLE_HAT
#define MBMRHOCAC_HALFHATS
#undef MBMRHOCAC_HOMOGENEOUS
#undef MBMRHOCAC_SHALLOW_HAT
#undef MBMRHOCAC_DEEP_HAT
#undef MBMRHOCAC_DEFAULT
#endif
#ifdef MBMRHOCAC_DEEP_HAT
#define MBMRHOCAC_HALFHATS
#undef MBMRHOCAC_HOMOGENEOUS
#undef MBMRHOCAC_SHALLOW_HAT
#undef MBMRHOCAC_MIDDLE_HAT
#undef MBMRHOCAC_DEFAULT
#endif
#ifdef MBMRHOCAC_DEFAULT
#define MBMRHOCAC_HOMOGENEOUS
#undef MBMRHOCAC_HALFHATS
#endif
!     ******************************************************************
      SUBROUTINE EQNOCE_CARB_DISTRIBUTION
     >           (time, orgm_x_nodcum, orgm_xs_oocelt,
     >            i_oocelt, frac_oocelt,
     <            carb_x_nodcum, carb_xs_oocelt)
!     ******************************************************************
!     ******************************************************************
      
#ifdef MBMRHOCAC_HOMOGENEOUS
      USE mod_mbm_geometry, ONLY : i_sflnod_top, i_sflnod_bot,
     &                             i_hypspr_1,   i_hypspr_n
#endif
#ifdef MBMRHOCAC_HALFHATS
      USE mod_mbm_geometry, ONLY : i_sflnod_top, i_sflnod_bot,
     &                             i_sflelt_1,   i_sflelt_n,
     &                             i_hypspr_1,   i_hypspr_n,
     &                             maxdep
#endif
      USE mod_mbm_biocarbonates, ONLY :
     &   CARB_RAINRATIO => CARB_RAINRATIO_FROMFILE,
     &   CARB_RAINRATIO_MINMAX_GET
      
      IMPLICIT NONE


! Argument Variables
! ==================

! Input Variables
! ---------------

      DOUBLE PRECISION, INTENT(IN)
     &  :: time

      DOUBLE PRECISION, INTENT(IN),
     &  DIMENSION(i_sflnod_top:i_sflnod_bot, i_hypspr_1:i_hypspr_n, 3)
     &  :: orgm_x_nodcum

      DOUBLE PRECISION, INTENT(IN),
     &  DIMENSION(i_hypspr_1:i_hypspr_n, 3)
     &  :: orgm_xs_oocelt

      INTEGER, INTENT(IN)
     &  :: i_oocelt

      DOUBLE PRECISION, INTENT(IN)
     &  :: frac_oocelt


! Output Variables
! ----------------

      DOUBLE PRECISION, INTENT(OUT),
     &  DIMENSION(i_sflnod_top:i_sflnod_bot, i_hypspr_1:i_hypspr_n,3)
     &  :: carb_x_nodcum

      DOUBLE PRECISION, INTENT(OUT),
     &  DIMENSION(i_hypspr_1:i_hypspr_n,3)
     &  :: carb_xs_oocelt


! Local Variables
! ===============

#ifdef MBMRHOCAC_HOMOGENEOUS
! Export rain ratio
      DOUBLE PRECISION, DIMENSION(i_hypspr_1:i_hypspr_n)
     &                  :: rhocac_x

! Dummy loop indices
      INTEGER           :: ip
#endif
#ifdef MBMRHOCAC_HALFHATS
! Base rain ratio value
      DOUBLE PRECISION,
     &  DIMENSION(i_hypspr_1:i_hypspr_n), SAVE
     &  :: rhocac_bas = 0D0
      LOGICAL
     &  :: f_rhocac_bas_tbinit = .TRUE.

! Distributed rain ratio
      DOUBLE PRECISION,
     &  DIMENSION(i_sflelt_1:i_sflelt_n,   i_hypspr_1:i_hypspr_n)
     &  :: rhocac_i

! Number of total production fractions considered
      INTEGER, PARAMETER
     &  :: n_frac=3
     
! Dummy loop indices
      INTEGER
     &  :: i, ip

      INTEGER, SAVE,
     &  DIMENSION(i_hypspr_1:i_hypspr_n, n_frac)
     &  :: i_n=-1

      DOUBLE PRECISION,
     &  DIMENSION(i_hypspr_1:i_hypspr_n, n_frac)
     &  :: f_n, orgmx_n

      DOUBLE PRECISION,
     &  DIMENSION(i_hypspr_1:i_hypspr_n)
     &  :: rhocac_x, rhocac_min, rhocac_max

      DOUBLE PRECISION
     &  :: orgm_xj, rhocac_0, rhocac_1
#endif


! Calculations
! ============

! First the actual rain ratios are determined as a function of time
! (by CARB_RAINRATIO)
! Then, the actual changes are distributed over depth, where depth is
! parameterised as a function of the cumulated organic matter production

#ifdef MBMRHOCAC_HOMOGENEOUS

                                   ! Calculate the global average rain
      CALL CARB_RAINRATIO(time, rhocac_x)  ! ratios for each profile
                                   ! CARB_RAINRATIO returns the actual
                                   ! rain ratios, as a function of time
                                   ! in <rhocac_x>.


      DO ip = i_hypspr_1, i_hypspr_n
        carb_x_nodcum(:,ip,1) = rhocac_x(ip)*orgm_x_nodcum(:,ip,1)
      ENDDO

      carb_x_nodcum(:,:,2:3) = 0D0 ! Set C13 and C14 fluxes to zero.
                                   ! They are calculated in the
                                   ! calling EQNOCE routine.

      carb_xs_oocelt(:,1) = rhocac_x(:)*orgm_xs_oocelt(:,1)
      carb_xs_oocelt(:,2:3) = 0D0
#endif  /* MBMRHOCAC_HOMOGENEOUS */

#ifdef MBMRHOCAC_HALFHATS

      IF (f_rhocac_bas_tbinit) THEN

                                   ! Initialisation of <rhocac_bas>.
                                   ! <rhocac_bas> provides the BASic value
                                   ! for peak interglacial (present-day) times.
                                   ! We currently simply set it to the maximum
                                   ! value of rhocac.

         CALL CARB_RAINRATIO_MINMAX_GET(rhocac_min, rhocac_max)
         rhocac_bas(:) = rhocac_max(:)
         f_rhocac_bas_tbinit = .FALSE.  ! No need to repeat this initialisation.

      ENDIF


      CALL CARB_RAINRATIO(time, rhocac_x)
                                   ! Calculate the global average
                                   ! rain ratios for each profile
                                   ! CARB_RAINRATIO returns the
                                   ! actual rain ratios, as a function
                                   ! of time in <rhocac_x>.


      orgmx_n(:,1) = orgm_x_nodcum(i_sflnod_bot,:,1)/4D0
      orgmx_n(:,2) = orgm_x_nodcum(i_sflnod_bot,:,1)/2D0
      orgmx_n(:,3) = orgm_x_nodcum(i_sflnod_bot,:,1)-orgmx_n(:,1)
                                   ! Typical values for the boundaries:
                                   ! 1/4, 1/2 and 3/4 of the total
                                   ! accumulated organic production in
                                   ! each profile.

      IF(i_n(1,1) == -1) THEN      ! Calculate first approximation of
        i_n(:,1) =  MAXDEP(:)/4    ! the localisation of the nodes where
        i_n(:,2) =  MAXDEP(:)/2    ! these are reached.
        i_n(:,3) = (MAXDEP(:)*3)/4
      ENDIF

      DO i = 1, n_frac
        DO ip = i_hypspr_1, i_hypspr_n
        search_node: DO            ! Now search, in each profile, for
                                   ! the exact interval where the three
                                   ! values are reached
        IF    (orgm_x_nodcum(i_n(ip,i)+1, ip, 1)
     &                       .LT. orgmx_n(ip, i)) THEN      
          i_n(ip,i) = i_n(ip,i)+1  ! At least one index too low.
          CYCLE search_node
        ELSEIF(orgm_x_nodcum(i_n(ip,i)-1, ip, 1)
     &                       .GE. orgmx_n(ip, i)) THEN
          i_n(ip,i) = i_n(ip,i)-1  ! At least one index too high.
          CYCLE search_node
        ELSE
                                   ! We got it. Determine the remainder
                                   ! fraction on partial interval
          orgm_xj =   orgm_x_nodcum(i_n(ip,i)+1, ip, 1)
     &              - orgm_x_nodcum(i_n(ip,i)  , ip, 1)

          IF(orgm_xj .EQ. 0D0) THEN
            f_n(ip,i) = 0D0        ! We look for the minimum depth,
                                   ! which, in this case, is
                                   ! exactly at the node
          ELSE
            f_n(ip,i) = (orgmx_n(ip, i)-orgm_x_nodcum(i_n(ip,i), ip, 1))
     &                  / orgm_xj
          ENDIF
          EXIT search_node
        ENDIF
        ENDDO search_node
        ENDDO
      ENDDO

      DO ip = i_hypspr_1, i_hypspr_n

        rhocac_0 = rhocac_bas(ip)
        rhocac_1 = rhocac_bas(ip)+2D0*(rhocac_x(ip)-rhocac_0)

#ifdef MBMRHOCAC_SHALLOW_HAT
        rhocac_i(i_sflelt_1:i_oocelt-1,  ip) =                  0D0
        rhocac_i(i_oocelt:i_n(ip,2),     ip) =                  rhocac_1
        rhocac_i(i_n(ip,2)+1,            ip) =       f_n(ip,2) *rhocac_1
     &                                         +(1D0-f_n(ip,2))*rhocac_0
        rhocac_i(i_n(ip,2)+2:i_sflelt_n, ip) =                  rhocac_0
#endif

#ifdef MBMRHOCAC_MIDDLE_HAT
        rhocac_i(i_sflelt_1:i_oocelt-1,  ip) =                  0D0
        rhocac_i(i_oocelt:i_n(ip,1),     ip) =                  rhocac_0
        rhocac_i(i_n(ip,1)+1,            ip) =       f_n(ip,1) *rhocac_0
     &                                         +(1D0-f_n(ip,1))*rhocac_1
        rhocac_i(i_n(ip,1)+2:i_n(ip,3),  ip) =                  rhocac_1
        rhocac_i(i_n(ip,3)+1,            ip) =       f_n(ip,3) *rhocac_1
     &                                         +(1D0-f_n(ip,3))*rhocac_0
        rhocac_i(i_n(ip,3)+2:i_sflelt_n, ip) =                  rhocac_0
#endif

#ifdef MBMRHOCAC_DEEP_HAT
        rhocac_i(i_sflelt_1:i_oocelt-1,  ip) =                  0D0
        rhocac_i(i_oocelt:i_n(ip,2),     ip) =                  rhocac_0
        rhocac_i(i_n(ip,2)+1,            ip) =       f_n(ip,2) *rhocac_0
     &                                         +(1D0-f_n(ip,2))*rhocac_1
        rhocac_i(i_n(ip,2)+2:i_sflelt_n, ip) =                  rhocac_1
#endif
      ENDDO


! Now determine the cumulated carbonate flux

      carb_xs_oocelt(:, 1) =   orgm_xs_oocelt(:, 1)
     &                       * rhocac_i(i_oocelt, :)
      carb_xs_oocelt(:, 2:3) = 0D0


      carb_x_nodcum(:, :, :) = 0D0

      DO i = i_sflnod_top+1, i_sflnod_bot
        carb_x_nodcum(i, :, 1) =
     &    carb_x_nodcum(i-1, :, 1)
     &    + (orgm_x_nodcum(i, :, 1) - orgm_x_nodcum(i-1, :, 1))
     &     * rhocac_i(i,:)
          
      ENDDO
#endif  /* MBMRHOCAC_HALFHATS */

      RETURN

      END SUBROUTINE EQNOCE_CARB_DISTRIBUTION
