!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      MODULE MOD_MBM_DORPRI
!=======================================================================

      IMPLICIT NONE

      DOUBLE PRECISION,SAVE :: taumin_oca=1D+6 ! years
      CHARACTER(LEN=4), SAVE :: taumin_oca_var ! name
      INTEGER, SAVE :: taumin_oca_ires ! reservoir

!=======================================================================
      END MODULE MOD_MBM_DORPRI
!=======================================================================
      

!=======================================================================
      SUBROUTINE DORPRI(TINF,TMAX,PAS,X,TOL, iasd01, svsd01, biof01)
!=======================================================================

!     Appels: SECMEM, SEDIM

      USE mod_mbm_files, ONLY: erruni
      USE mod_mbm_tempo, ONLY: temps
      USE mod_mbm_xsetup, ONLY: n_xsed, le, ne
      USE mod_mbm_dorpri
      USE mod_logunits

      IMPLICIT NONE


! If flux and dic/alk integration required, uncomment the next line
      INTEGER, PARAMETER :: ne_mm = le + n_xsed
! If flux and dic/alk integration not required, uncomment the next on
!     INTEGER, PARAMETER :: ne_mm = le


! Input variables
      LOGICAL iasd01, svsd01, biof01

! MATRICES DEFINING THE METHOD:
      REAL A(7,7),B1(7),B2(7)

      DOUBLE PRECISION x(ne)
      DOUBLE PRECISION x1(ne),x2(ne)
      DOUBLE PRECISION ak(ne_mm,7)
      DOUBLE PRECISION appro1(ne_mm),appro2(ne_mm),delta(ne_mm)
      DOUBLE PRECISION tmax,tinf,pas,tol,h,erreur,errk

      INTEGER I,J,K,FLAG,rqflag,iiflag

      INTEGER  :: istatus
      INTEGER, SAVE :: logunit=-1

      IF(logunit == (-1)) THEN
        istatus = RESERVE_LOGUNIT(logunit)
        IF(istatus /= 0) THEN
          WRITE(erruni,*) '[DORPRI]: No LOGUNIT could be'
          WRITE(erruni,*) '  Not logging step evolution'
          logunit=-2
        ELSE
          WRITE(erruni,*) '[DORPRI]: Starting logging of step info '
          WRITE(erruni,*) '  to unit ',logunit, ' at time ', temps
          OPEN(logunit, FILE='mbm-dorpri.log')
        ENDIF
      ENDIF


      A = 0D0
      A(2,1)= 1.d+00/5.d+00
      A(3,1)= 3.d+00/40.d+00
      A(3,2)= 9.d+00/40.d+00
      A(4,1)= 44.d+00/45.d+00
      A(4,2)=-56.d+00/15.d+00
      A(4,3)= 32.d+00/9.d+00
      A(5,1)= 19372.d+00/6561.d+00
      A(5,2)=-25360.d+00/2187.d+00
      A(5,3)= 64448.d+00/6561.d+00
      A(5,4)=-212./729.d+00
      A(6,1)= 9017.d+00/3168.d+00
      A(6,2)=-355.d+00/33.d+00
      A(6,3)= 46732./5247.d+00
      A(6,4)= 49./176.d+00
      A(6,5)=-5103./18656.d+00
      A(7,1)= 35./384.d+00
      A(7,2)= 0.d+00
      A(7,3)= 500.d+00/1113.d+00
      A(7,4)= 125.d+00/192.d+00
      A(7,5)=-2187.d+00/6784.d+00
      A(7,6)= 11.d+00/84.d+00

      B1(1)= 35.d+00/384.d+00
      B1(2)= 0.d+00
      B1(3)= 500.d+00/1113.d+00
      B1(4)= 125.d+00/192.d+00
      B1(5)=-2187.d+00/6784.d+00
      B1(6)= 11.d+00/84.d+00
      B1(7)= 0.d+00

      B2(1)= 5179.d+00/57600.d+00
      B2(2)= 0.d+00
      B2(3)= 7571.d+00/16695.d+00
      B2(4)= 393.d+00/640.d+00
      B2(5)=-92097.d+00/339200.d+00
      B2(6)= 187.d+00/2100.d+00
      B2(7)= 1.d+00/40.d+00

      FLAG=0
      TEMPS=TINF
      H=PAS

    1 IF (TEMPS.LT.TMAX) THEN

   10    IF ((TEMPS+H).GT.TMAX) THEN
            H=TMAX-TEMPS
         ENDIF


         DO 1000 I=1,7
            DELTA(:)=0D0

            J=1
  115       IF (J.LT.I) THEN
!              MATRIX A IS STRICTLY LOWER TRIANGULAR
               DELTA(:) = DELTA(:) + A(I,J)*AK(:,J)
               J=J+1
               GOTO 115
!           --- EXIT OUT OF 'WHILE-WEND'-STYLE LOOP
            ENDIF

            IF (I.EQ.7)  THEN
!           --- PECULARITY OF DORMAND-PRINCE METHOD: A(7,J)=B1(J)
                  APPRO1(:)=DELTA(:)
            ENDIF

!     |     --- x1 has to be initialised for each k.
!               For those that are not considered, delta(k)=0.
               X1(      1:ne_mm) = X(      1:ne_mm) + H*DELTA(:)
               X1(ne_mm+1:ne   ) = X(ne_mm+1:   ne)

            CALL SECMEM(X1,X2,iiflag, iasd01, svsd01, biof01)
!           If activy has made trouble (iiflag=1), then restart
!           the whole iteration with a smaller stepsize
            IF (iiflag.eq.1) THEN
               IF(logunit /= (-2)) THEN
                 WRITE(logunit,*) temps, H, ' failure (SECMEM trouble)'
               ENDIF
               h=h*0.7d+00
               GOTO 10
            ENDIF
            IF (taumin_oca < 10D0*h) THEN
               IF(logunit /= (-2)) THEN
                 WRITE(logunit,*) temps, H, 
     &                  ' Warning: small taumin_oca ',taumin_oca,
     &                  ' for ', taumin_oca_var, ' in res. ',
     &                  taumin_oca_ires
               ENDIF
               !h=taumin_oca/11D0
               !GOTO 10
            ENDIF

                AK(:,I)=X2(1:ne_mm)
!     |
 1000    CONTINUE


            APPRO2(:)=0.D+00

         DO I=1,7
            APPRO2(:)=APPRO2(:)+B2(I)*AK(:,I)
         ENDDO


!     --- Estimation of the error only for variables, not for the
!         fluxes integrated
         ERREUR=0.d+00
         DO 1300 K=1,le
               ERRK=ABS(APPRO1(K)-APPRO2(K))
               IF (ABS(X1(K)) .GT. 1.D-8) ERRK=ERRK/X1(K)
               IF (ERRK.GT.ERREUR) ERREUR=ERRK
 1300    CONTINUE

!     --- stepsize control: reduce stepsize faster than increasing it
!                          (4th root if tol/err < 1.
!                           5th root if tol/err > 1.)
         IF (ERREUR.GT.TOL) THEN
            IF(logunit /= (-2)) THEN
              WRITE(logunit,*) temps, H,
     &                         ' failure (DORPRI error estimate)'
            ENDIF
            H=.8D0*H*(TOL/ERREUR)**(0.25D0)
            GOTO 10
!           RESTART EVALUATION IF ERROR IS TO LARGE
         ELSE
!        --- update X, ...
               X(1:ne_mm)=X1(1:ne_mm)
!        ... advance clock, ...
            IF(logunit /= (-2)) WRITE(logunit,*) temps, H, ' success'
            TEMPS=TEMPS+H
!        ... adjust integration step size ...
            IF (ERREUR.NE.0.) H=.8D0*H*(TOL/ERREUR)**(0.20D0)
!        ... without exaggerating too much, ...
            H=MIN(2D0,H)
!        ... increment iteration counter ...
            FLAG=FLAG+1

!        ... and go to the next iteration.
            GOTO 1
         ENDIF
      ENDIF
      RETURN
      END
