!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


C     ******************************************************************
      SUBROUTINE CORALS(nivmer,dnimer,sflelt_sfcarea,cit, alk,
     <                  sfcero,sfccrl,coralo,corali,shbnko,shbnki,iflag)
C     ******************************************************************
C
C     Appels: aucun
C
C     Calcule les surfaces sujettes a l'erosion (SFCERO) et
C     au depot de recifs de corail (SFCCRL), ainsi que les
C     quantites de CaCO3 depose dans les recifs de corail (CORALO)
C     et reinjecte par erosion (CORALI)

      USE mod_mbm_files, ONLY: erruni, dbguni
      USE mod_mbm_geometry, ONLY: nro1, ro1, ro3, nro3, bottom, resol
      USE mod_mbm_chimiq

      IMPLICIT NONE


      DOUBLE PRECISION cit(ro1+1:ro3+nro3), alk(ro1+1:ro3+nro3),
     &                 sflelt_sfcarea(1:bottom,ro1+1:ro1+nro1),
     &                 omega(ro1+1:ro1+nro1),nivmer,dnimer,
     &                 sfccrl(ro1+1:ro1+nro1),sfcero(ro1+1:ro1+nro1),
     &                 coralo(ro1+1:ro1+nro1),corali(ro1+1:ro1+nro1),
     &                 shbnko(ro1+1:ro1+nro1),shbnki(ro1+1:ro1+nro1)
      DOUBLE PRECISION d0,d100,p200,limit
      DOUBLE PRECISION rho2,rho4, ca2, ca4, kspar2, kspar4
      DOUBLE PRECISION TOTCA, AKARAG, RHOSW
      INTEGER i, id0, ilimit
      DOUBLE PRECISION produc
C
      DOUBLE PRECISION co3(2), hco3(1), pco2(1), ph(1)
      INTEGER iflag
C     -----------------------------------------------------------------
      i = ro1+2
      CALL ACTIVY(borate(i),k0(i),k1(i),k2(i),kb(i),kw(i),
     &                  cit(i),alk(i),ph(1),pco2(1),co3(1),1,iflag)
      IF(iflag /= 0) THEN
        WRITE(erruni,*) '[CORALS]: ACTIVY failed for ro1+2.'
        WRITE(erruni,*) '   Returning to caller'
        RETURN
      ENDIF
      i = ro1+4
      CALL ACTIVY(borate(i),k0(i),k1(i),k2(i),kb(i),kw(i),
     &                  cit(i),alk(i),ph(1),pco2(1),co3(2),1,iflag)
      IF(iflag /= 0) THEN
        WRITE(erruni,*) '[CORALS]: ACTIVY failed for ro1+4.'
        WRITE(erruni,*) '   Returning to caller'
        RETURN
      ENDIF
C
C     omega:  facteur de sursaturation de CO3 par rapport a CaCO3
C             AKARAG rend le produit de solubilite en (mol/kg-SW)^2!
C             TOTCA rend la teneur en Calcium en mol/kg-SW.
C             CO3() en mol/m3-SW
C
C     Atlantique (ro1+2) et Indo-Pacifique (ro1+4):
      rho2 = RHOSW(temp(ro1+2),salin(ro1+2),0.0d+00)
      ca2 = TOTCA(temp(ro1+2),salin(ro1+2),0.0d+00)
      kspar2 = AKARAG(temp(ro1+2),salin(ro1+2),0.0D+00)

      rho4 = RHOSW(temp(ro1+4),salin(ro1+4),0.0d+00)
      ca4 = TOTCA(temp(ro1+4),salin(ro1+4),0.0d+00)
      kspar4 = AKARAG(temp(ro1+4),salin(ro1+4),0.0D+00)
      omega(ro1+2) = (ca2*co3(1))/(kspar2*rho2)
      omega(ro1+4) = (ca4*co3(2))/(kspar4*rho4)
C
C     -----------------------------------------------------------------
C
C
C                 sfccrl=surface propice aux corails
C                 sfcero=surface exposee a l'erosion
C
C      d0: profondeur dans le profil ou se trouve la surface de la mer
C     id0: indice de la couche qui comprend la surface
C      d100: profondeur dans le profil ou se trouve le plan a -100m
C      p200: profondeur dans le profil ou se trouve la marge
C            (a 200m en-desous du 0 actuel. Invariable)
C     ip200: indice de cette couche
         d0 = (0.D+00-nivmer)/resol
        id0 = int(d0)
       d100 = (100.D+00-nivmer)/resol
       p200 = 200.0D+00/resol
C      limit: limite inferieure ou poussent encore des coraux
C     jusqu'a 100 m de profondeur d'eau, mais sur la marge.
C     ilimit: indice de cette couche
      limit = min(d100,p200)
      ilimit=INT(limit)
C
      sfccrl(ro1+2)=0.0D+00
      sfccrl(ro1+4)=0.0D+00
      sfcero(ro1+2)=0.0D+00
      sfcero(ro1+4)=0.0D+00
      DO 100 i=0,id0-1
         sfcero(ro1+2)=sfcero(ro1+2)+sflelt_sfcarea(i+1,ro1+2)
         sfcero(ro1+4)=sfcero(ro1+4)+sflelt_sfcarea(i+1,ro1+4)
 100  CONTINUE
      sfcero(ro1+2)=sfcero(ro1+2)+sflelt_sfcarea(id0+1,ro1+2)*(d0-id0)
      sfcero(ro1+4)=sfcero(ro1+4)+sflelt_sfcarea(id0+1,ro1+4)*(d0-id0)
      IF (ilimit.GT.id0) THEN
         sfccrl(ro1+2)=sflelt_sfcarea(id0+1,ro1+2)*(id0+1-d0)
         sfccrl(ro1+4)=sflelt_sfcarea(id0+1,ro1+4)*(id0+1-d0)
         DO 101 i=id0+1,ilimit-1
            sfccrl(ro1+2)=sfccrl(ro1+2)+sflelt_sfcarea(i+1,ro1+2)
            sfccrl(ro1+4)=sfccrl(ro1+4)+sflelt_sfcarea(i+1,ro1+4)
 101     CONTINUE
         sfccrl(ro1+2)=sfccrl(ro1+2) + sflelt_sfcarea(ilimit+1,ro1+2)
     &                                *(limit-ilimit)
         sfccrl(ro1+4)=sfccrl(ro1+4) + sflelt_sfcarea(ilimit+1,ro1+4)
     &                                *(limit-ilimit)
      ELSE
         sfccrl(ro1+2)=sflelt_sfcarea(id0+1,ro1+2)*(limit-d0)
         sfccrl(ro1+4)=sflelt_sfcarea(id0+1,ro1+4)*(limit-d0)
      ENDIF
c
c###  Decommenter pour les tests SEPM/IAS Carbonates and Global Change.
c     sfccrl(ro1+2)=0.0D+00
c     sfccrl(ro1+4)=0.0D+00
C
C     -----------------------------------------------------------------
C
C     Introduction d'une dependance envers la vitesse de
C     remontee des mers dnimer (en m/annee):
C
C                 produc = facteur d'efficacite
C
      IF (dnimer.LE.-2.5D-3) THEN
         produc=0.D+00
      ELSEIF (dnimer.LE.2.5D-3) THEN
         produc=(dnimer+2.5D-03)*0.2D+03
      ELSEIF (dnimer.LE.10.0D-03) THEN
         produc=1.0D+00
      ELSEIF (dnimer.LE.15D-03) THEN
         produc=1.0D+00-(dnimer-10.0D-3)*0.2D+03
      ELSE
         produc=0.0D+00
      ENDIF
C
C     -----------------------------------------------------------------
C
C     Ce qui suit est valable si integre a partir de t0=1980, avec
C     EPOCH=1000. Sinon, recalculer.
C     On obtient alors une moyenne de 7x10^12 mol/CaCO3 par an, 
C     preconisee par Milliman (1993), sur les 5000 dernieres annees.
C
C     For stability, and physical reasons, limit Omega to the
C     range of [1, 6] before using it. The upper limit of 6 is
C     arbitrarily chosen. The meaning of 1 is clear: below,
C     sea water would be undersaturated.
      omega(ro1+2) = MAX(1.0D+00, MIN(omega(ro1+2), 6.D+00))
      omega(ro1+4) = MAX(1.0D+00, MIN(omega(ro1+2), 6.D+00))
      coralo(ro1+1)=0.0D+00
      coralo(ro1+2)=sfccrl(ro1+2)*(omega(ro1+2)-1.D+00)**1.7D+00*
     >               produc*2.0D-19*0.860D+00
      coralo(ro1+3)=0.0D+00
      coralo(ro1+4)=sfccrl(ro1+4)*(omega(ro1+4)-1.D+00)**1.7D+00*
     >               produc*2.0D-19*0.860D+00
      coralo(ro1+5)=0.0D+00
C
C     Valeurs d'origine. Donnent 7.7 Tmol HCO3/yr.
      corali(ro1+2)=sfcero(ro1+2)*4.674D-19
      corali(ro1+4)=sfcero(ro1+4)*4.674D-19
C
C     Valeurs en accord avec Bluth et Kump, pour 1000 mm/yr de runoff,
C     on trouve 2.147 mol HCO3/m2/yr
C     Donc: Dissolution = 1.074(-18) x 1(18) mol CaCO3/m2/yr
C     
      corali(ro1+1)=0.0D+00
      corali(ro1+2)=sfcero(ro1+2)*1.074D-18
      corali(ro1+3)=0.0D+00
      corali(ro1+4)=sfcero(ro1+4)*1.074D-18
      corali(ro1+5)=0.0D+00
C
      shbnko(ro1+1)=0D0
      shbnko(ro1+2)=sfccrl(ro1+2)*0.92e-18
      shbnko(ro1+3)=0D0
      shbnko(ro1+4)=sfccrl(ro1+4)*0.92e-18
      shbnko(ro1+5)=0D0
C
      shbnki(:)=0D0

C     Decommenter les lignes suivantes pour avoir une erosion
C     constante dans le temps des plateformes continentales.
C     corali(ro1+2)=1.20D-06
C     corali(ro1+4)=1.20D-06
C
C     augmenter quote-part des recifs a cause des borates et pression.
C     coralo(ro1+2)=coralo(ro1+2)*1.0d+00
C     coralo(ro1+4)=coralo(ro1+4)*1.0d+00
C
C     -----------------------------------------------------------------
C
      RETURN
      END
      
