!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef FN_THISFILE
#undef FN_THISFILE
#endif
#define FN_THISFILE "contiw.F"
#ifndef __LINE__
#define __LINE__ 0
#endif
!     ******************************************************************
      SUBROUTINE CONTIW(temps, coralo, corali,
     <                  volcsi, volcca, iwcitt, swcitc, swcits,
     <                  owco2t, rwpo4t)
!     ******************************************************************

      USE mod_mbm_geometry, ONLY: nra1, nro1, ro1
      USE mod_mbm_files, ONLY: erruni, dbguni, weausd, weafil,
     &                               resusd, resuni,
     &                               HANDLE_ERRORS
      USE mod_mbm_tempo, ONLY: simul_tinf, simul_tmax, simul_t_set
      USE mod_mbm_contiweathering


      IMPLICIT NONE


#include "netcdf.inc"


      DOUBLE PRECISION, INTENT(IN)
     &  :: temps

      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1)
     &  :: coralo, corali

      DOUBLE PRECISION, INTENT(OUT)
     &  :: volcsi, volcca, iwcitt, swcitc, swcits, owco2t, rwpo4t

      DOUBLE PRECISION :: weaflx_tinf, weaflx_tmax
      DOUBLE PRECISION :: weaflx_factor

      INTEGER :: n_current
      INTEGER :: status
      INTEGER :: nc_id, dating_dimid, dating_dimlen, dating_varid
      INTEGER :: anyflx_varid

      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE
     &  :: weaflx_dates_orig
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE
     &  :: weaflx_anyflx_orig
      DOUBLE PRECISION, DIMENSION(:), POINTER
     &  :: weaflx_anyflx => NULL()
      DOUBLE PRECISION
     &  :: weaflx_anyflxm, weaflx_dflt
      CHARACTER(LEN=80) :: c_title
      CHARACTER(LEN=31) :: c_varname

      INTEGER :: i, j, ll
      INTEGER :: n_flx_in_file
      LOGICAL :: use_dflt, use_some_dflt
      DOUBLE PRECISION :: swco2s

      DOUBLE PRECISION, SAVE
     &  :: weaflx_biccc_itp, weaflx_bicsc_itp,
     &     weaflx_biccs_itp, weaflx_co2cs_itp,
     &     weaflx_co2oo_itp, weaflx_po4rw_itp

      INTEGER :: i1, i2, is, i_first, i_last
      INTEGER :: n_replicbfr, n_replicaft
      LOGICAL  :: failed_replication_check = .FALSE.


      CHARACTER(LEN=*), PARAMETER ::
     &  fn_thisfile     = FN_THISFILE
      CHARACTER(LEN=*), PARAMETER ::
     &  fmt_info_a      = '("['//fn_thisfile//']: ", A)' ,
     &  fmt_info_ai     = '("['//fn_thisfile//']: ", A, I0)',
     &  fmt_infolin_ia  = '("['//fn_thisfile//':", I0, "]: ", A)',
     &  fmt_infolin_iai = '("['//fn_thisfile//':", I0, "]: ", A, I0)'
 

      contiwsetup_tbd: IF (n_weathering == 0) THEN

        IF(.NOT.simul_t_set) THEN
          WRITE(erruni,fmt_infolin_ia) (__LINE__), 
     &      'Simulation time interval not yet set. Aborting!'
          CALL ABORT()
        ENDIF

        WRITE(dbguni,*) 
        WRITE(dbguni,*) '[CONTIW]:'
        WRITE(dbguni,*) ' Weathering fluxes'

        IF(n_weathering /= 0) THEN
          IF(ASSOCIATED(weaflx_time))  DEALLOCATE(weaflx_time)
          IF(ASSOCIATED(weaflx_biccc)) DEALLOCATE(weaflx_biccc)
          IF(ASSOCIATED(weaflx_bicsc)) DEALLOCATE(weaflx_bicsc)
          IF(ASSOCIATED(weaflx_biccs)) DEALLOCATE(weaflx_biccs)
          IF(ASSOCIATED(weaflx_co2cs)) DEALLOCATE(weaflx_co2cs)
          IF(ASSOCIATED(weaflx_co2oo)) DEALLOCATE(weaflx_co2oo)
          IF(ASSOCIATED(weaflx_po4rw)) DEALLOCATE(weaflx_po4rw)
        ENDIF

        ifweaused: IF (weausd == 1) THEN
                                    ! If we use weathering scenarios
                                    ! from a file then read them in now

          use_some_dflt = .FALSE.   ! We anticipate not to use any default values
          use_dflt = .TRUE.

          IF(resusd /= 0) THEN
            WRITE(resuni,*)
            WRITE(resuni,*)
            WRITE(resuni,'("[Weathering scenario info]:")')

            WRITE(resuni,'(A)') ' Reading in weathering scenario data'
     &                       // ' from file "' // TRIM(weafil) // '"'
          ENDIF
         
                                    ! Open NetCDF File
          status = NF_OPEN(weafil, NF_NOWRITE, nc_id)
          IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)


          IF(resusd /= 0) THEN

            status = NF_GET_ATT_TEXT(nc_id, NF_GLOBAL, 'title', c_title)
            IF (status /= NF_NOERR) THEN
              IF (status /= NF_ENOTATT) THEN
                CALL HANDLE_ERRORS(status)
              ELSE
                WRITE(resuni,'(" No title attribute found in file.")')
              ENDIF

            ELSE

              status = NF_INQ_ATTLEN(nc_id, NF_GLOBAL, 'title', ll)
              IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

              WRITE(resuni,'(" Title from file: ",A)') c_title(1:ll)
            ENDIF
          ENDIF


                                    ! Dimension inquiries:
                                    ! -- of dimension 'age' (dating)
                                    !    This could be changed to allow for
                                    !    arbitrary dating (test for a set
                                    !    of names and units). Currently, we
                                    !    assume that dates are given by ages
                                    !    before 1950.
          status = NF_INQ_DIMID(nc_id, 'age', dating_dimid)
          IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

                                    ! Inquire length for dimension 'age'
          status = NF_INQ_DIMLEN(nc_id, dating_dimid, dating_dimlen)
          IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)


                                    ! Variables' inquiries
                                    ! -- for variable 'age'
          status = NF_INQ_VARID(nc_id, 'age', dating_varid)
          IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)



                                    ! Allocate space for one flux "column" from file
          ALLOCATE(weaflx_anyflx_orig(dating_dimlen))
          ALLOCATE(weaflx_dates_orig(dating_dimlen))

          IF(dating_dimlen == 1) THEN
            n_weathering = 1        ! If there are only weathering flux
                                    ! data for one single instant in time,
                                    ! then, we use that value throughout
                                    ! the whole simulation without changes.
                                    ! No time information required then,
                                    ! no replication will be needed.
          ELSE
                                    ! Allocate for the age "column" from file

                                    ! Read in the original date information
            status = NF_GET_VAR_DOUBLE(nc_id, dating_varid,
     &                                weaflx_dates_orig(:))
            IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

           ! get age:replicate_period information into weaflx_period
            status = NF_GET_ATT_DOUBLE(nc_id, dating_varid,
     &                                 'replicate_period',
     &                                 weaflx_period)

            IF (status /= NF_NOERR) THEN
              IF (status == NF_ENOTATT) THEN
                weaflx_period = weaflx_period_dflt

                IF(resusd /= 0) THEN
                  WRITE(resuni,'(" age:replicate_period not found.")')
                  WRITE(resuni,'(" Using default period of ", F16.4, '
     &                       //'" years" )') weaflx_period
                ENDIF
              ELSE
                CALL HANDLE_ERRORS(status)
              ENDIF
            ENDIF

            IF(weaflx_period > 0D0) THEN
                                    ! If replication is allowed, check
                                    ! whether it is required

                                    ! Check age extent:
            IF(weaflx_dates_orig(dating_dimlen) > weaflx_dates_orig(1))
     &      THEN
                                    !  -- if ages are in increasing order
              weaflx_tinf = 1950D0 - weaflx_dates_orig(dating_dimlen)
              weaflx_tmax = 1950D0 - weaflx_dates_orig(1)
              i1          = dating_dimlen
              i2          = 1
              is          = -1
            ELSE
                                    !  -- if ages are in decreasing order.
              weaflx_tinf = 1950D0 - weaflx_dates_orig(1)
              weaflx_tmax = 1950D0 - weaflx_dates_orig(dating_dimlen)
              i1          = 1
              i2          = dating_dimlen
              is          = 1
            ENDIF                                

                                    ! How many replicates do we need:
                                    !  -- before temp_tinf ?
            IF(weaflx_tinf > simul_tinf) THEN
              n_replicbfr = INT((weaflx_tinf - simul_tinf)
     &                          /weaflx_period)
              IF((weaflx_tinf - simul_tinf)
     &            > DBLE(n_replicbfr)*weaflx_period) THEN
                n_replicbfr = n_replicbfr + 1
              ENDIF
            ELSE
              n_replicbfr = 0
            ENDIF
            
                                    !  -- after temp_tmax ?
            IF(simul_tmax > weaflx_tmax) THEN
              n_replicaft = INT((simul_tmax - weaflx_tmax)
     &                          /weaflx_period)
              IF((simul_tmax - weaflx_tmax)
     &           > DBLE(n_replicaft)*weaflx_period) THEN
                n_replicaft = n_replicaft + 1
              ENDIF
            ELSE
              n_replicaft = 0
            ENDIF

            IF(resusd /= 0) THEN
              IF((n_replicbfr > 0) .OR. (n_replicaft > 0)) THEN
              WRITE(resuni,'(" Weathering flux data extend only from")')
              WRITE(resuni,'(F16.4," to ",F16.4)')
     &          weaflx_tinf, weaflx_tmax
              WRITE(resuni,'(" Extending the temporal range by",' //
     &                     ' " assuming a periodic evolution.")')
              WRITE(resuni,'(" Adopting a period of ",F16.4," years.")')
     &          weaflx_period
              ENDIF
            ENDIF

                                    ! Total space required for time dimension
            n_weathering = (n_replicbfr+n_replicaft+1) * dating_dimlen

            ELSE
              IF((weaflx_tinf > simul_tinf)
     &           .OR.(simul_tmax > weaflx_tmax)) THEN
                WRITE(erruni,'(A)')
     &            'The data in the file ' // TRIM(weafil)
                WRITE(erruni,'(A)')
     &            'must not be extended by periodic replication!'
                WRITE(erruni,'(A)')
     &            'It might be necessary to provide a file that ' //
     &            'covers the complete simulation time interval.'
                WRITE(erruni,'(A)')
     &            'Need to recheck at later on. '
                failed_replication_check = .TRUE.
                n_weathering = dating_dimlen
              ELSE
                failed_replication_check = .FALSE.
                n_replicbfr = 0
                n_replicaft = 0
                n_weathering = dating_dimlen
              ENDIF
            ENDIF

          ENDIF

          WRITE(dbguni,*) ' n_weathering set to ', n_weathering 

          n_flx_in_file = 0         ! number of fluxes that require time
                                    ! interval duplication

          WRITE(dbguni,*)
          WRITE(dbguni,*) ' Starting to initialize weathering fluxes'
          do4weaflx: DO j = 1, n_weaflx+1

            use_dflt = .FALSE.      ! We expect to find a variable for each flux

            SELECT CASE(j)
            CASE(1) ! weaflx_biccc
              c_varname = 'biccc'
              weaflx_dflt = weaflx_biccc_dflt
            CASE(2) ! weaflx_bicsc
              c_varname = 'bicsc'
              weaflx_dflt = weaflx_bicsc_dflt
            CASE(3) ! weaflx_biccs
              c_varname = 'biccs'
              weaflx_dflt = weaflx_biccs_dflt
            CASE(4) ! weaflx_co2cs
              c_varname = 'co2cs'
              weaflx_dflt = weaflx_co2cs_dflt
            CASE(5) ! weaflx_co2oo
              c_varname = 'co2oo'
              weaflx_dflt = weaflx_co2oo_dflt
            CASE(6) ! weaflx_po4rw
              c_varname = 'po4rw'
              weaflx_dflt = weaflx_po4rw_dflt
            CASE(n_weaflx+1) ! weaflx_time
              CONTINUE
            END SELECT


            IF (j <= n_weaflx) THEN ! If we are dealing with fluxes and not time
                                    ! then we are getting the informations from
                                    ! the file, else we have the raw data already
                                    ! and only the replications needs to be done.

              WRITE(dbguni,*)
              WRITE(dbguni,*) ' Setting up ', TRIM(c_varname)

              status = NF_INQ_VARID(nc_id, c_varname, anyflx_varid)
              IF (status /= NF_NOERR) THEN
                IF (status == NF_ENOTVAR) THEN  ! no variable called c_varname
                  IF(resusd /= 0) THEN
                   WRITE(resuni,'(A)') ' File does not include "'
     >                                 // TRIM(c_varname)
     >                                 // '" variable'
                   WRITE(resuni,'(A,E12.4)') ' Using default value ',
     >                                 weaflx_dflt
                  ENDIF

                  WRITE(dbguni,*) ' '// TRIM(c_varname) //
     >              ' not found in file, using default value ',
     >              weaflx_dflt
                  use_dflt = .TRUE.
                  use_some_dflt = .TRUE.
                  ALLOCATE(weaflx_anyflx(1))
                  weaflx_anyflx(1) = weaflx_dflt
                  weaflx_anyflxm   = weaflx_dflt
                  n_current = 1      ! only one datum for variable <c_varname>
                ELSE
                  CALL HANDLE_ERRORS(status) ! other error while searching for <c_varname>
                ENDIF
              ELSE                   ! there is a variable called <c_varname>
                n_current = n_weathering
              ENDIF

              WRITE(dbguni,*) ' set number of values to ', n_current
              WRITE(dbguni,*) ' set use_dflt ', use_dflt

              IF(.NOT. use_dflt) THEN
                                    ! If the variable exists in the file,
                                    ! (i.e., we do not use the default value)
                                    ! then read in the values from the file.

                WRITE(dbguni,*) ' not using default values for ' //
     &                          TRIM(c_varname)
                IF(n_weathering == 1) THEN
                                    ! if only one datum exists in the file, this
                                    ! will be the final forcing data, no replication
                                    ! needs to be done and we can read in the
                                    ! data into the final array directly.

                  WRITE(dbguni,*) ' Allocating weaflx_anyflx(1)'
                  ALLOCATE(weaflx_anyflx(1))

                  status = NF_GET_VAR_DOUBLE(nc_id, anyflx_varid,
     &                                       weaflx_anyflx(:))
                  IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

                                   ! Convert Tmol/yr -> 10^18 mol/yr
                  weaflx_anyflx(1) = weaflx_anyflx(1)*1D-6
                  weaflx_anyflxm   = weaflx_anyflx(1)

                  WRITE(dbguni,'("  Reading 1 value from file.")')

                ELSE


                  WRITE(dbguni, 
     &              '("  Reading ",I0," values from file.")')
     &              dating_dimlen

                  status = NF_GET_VAR_DOUBLE(nc_id, anyflx_varid,
     &                                      weaflx_anyflx_orig(:))
                  IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

                  status = NF_GET_ATT_DOUBLE(nc_id, anyflx_varid,
     &                                      'average', weaflx_anyflxm)
                  IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

                                   ! Convert Tmol/yr -> 10^18 mol/yr
                  weaflx_anyflx_orig(:) = weaflx_anyflx_orig(:)*1D-6

                  weaflx_anyflxm = weaflx_anyflxm*1D-6

                                   ! increment number of vars requiring
                                   ! replication of time intervals.
                  n_flx_in_file = n_flx_in_file+1

                ENDIF

              ENDIF

            ELSE ! i.e., if i == n_weaflx + 1
              IF (n_flx_in_file == 0) THEN
                                   ! If there is no flux variable in the file
                                   ! (useless file actually), there is no need
                                   ! to replicate anything!
                                   ! Reset n_weathering to 1.
                n_weathering = 1
                ALLOCATE(weaflx_time(1))
                weaflx_time(1) = 0D0
              ENDIF

              IF(n_weathering /= 1) THEN
                                   ! Copy replicates into weaflx_time
                                   ! if allowed
                IF(failed_replication_check) THEN
                  WRITE(erruni,'(A)')
     &              'Impossible to recover from failed ' //
     &              'replication check. Aborting.'
                  WRITE(erruni,'(A)')
     &              'Please provide a file that covers the complete ' //
     &              'simulation time interval.'
                  CALL ABORT()
                ENDIF

                ALLOCATE(weaflx_time(n_weathering))

                i_first = 1
                i_last  = dating_dimlen

                DO i = n_replicbfr, 1, -1
                  weaflx_time(i_first:i_last)
     &              = 1950D0 - weaflx_dates_orig(i1:i2:is)
     &                       - DBLE(i)*weaflx_period
                  i_first = i_last + 1
                  i_last  = i_last + dating_dimlen
                ENDDO

                weaflx_time(i_first:i_last)
     &            = 1950D0 - weaflx_dates_orig(i1:i2:is)

                DO i = 1, n_replicaft
                  i_first = i_last + 1
                  i_last  = i_last + dating_dimlen
                  weaflx_time(i_first:i_last)
     &              = 1950D0 - weaflx_dates_orig(i1:i2:is)
     &                       + DBLE(i)*weaflx_period
                ENDDO

                CYCLE do4weaflx     ! And cycle (i.e., EXIT)

              ENDIF
            ENDIF



            IF(n_current /= 1) THEN ! Replication of the flux values if
                                    ! if n_current > 1, i.e., only if
                                    ! the current flux is not constant
                                    ! in time.
           
              IF(failed_replication_check) THEN
                WRITE(erruni,'(A)')
     &            'Impossible to recover from failed ' //
     &            'replication check. Aborting.'
                WRITE(erruni,'(A)')
     &            'Please provide a file that covers the complete ' //
     &            'simulation time interval.'
                CALL ABORT()
              ENDIF

              WRITE(dbguni,'("  Allocating '//
     &                     'weaflx_anyflx(n_weathering)")')
              ALLOCATE(weaflx_anyflx(n_weathering))

              i_first = 1           ! Copy replicates into weaflx_anyflx
              i_last  = dating_dimlen

              DO i = n_replicbfr, 1, -1
                weaflx_anyflx(i_first:i_last)
     &            = weaflx_anyflx_orig(i1:i2:is)
                i_first = i_last + 1
                i_last  = i_last + dating_dimlen
              ENDDO

              weaflx_anyflx(i_first:i_last)
     &          = weaflx_anyflx_orig(i1:i2:is)

              DO i = 1, n_replicaft
                i_first = i_last + 1
                i_last  = i_last + dating_dimlen
                weaflx_anyflx(i_first:i_last)
     &            = weaflx_anyflx_orig(i1:i2:is)
              ENDDO
            ENDIF




            SELECT CASE(j)
            CASE(1) ! weaflx_biccc
              weaflx_biccc => weaflx_anyflx
              weaflx_bicccm = weaflx_anyflxm
              n_weaflx_biccc = n_current
            CASE(2) ! weaflx_bicsc
              weaflx_bicsc => weaflx_anyflx
              weaflx_bicscm = weaflx_anyflxm
              n_weaflx_bicsc = n_current
            CASE(3) ! weaflx_biccs
              weaflx_biccs => weaflx_anyflx
              weaflx_biccsm = weaflx_anyflxm
              n_weaflx_biccs = n_current
            CASE(4) ! weaflx_co2cs
              weaflx_co2cs => weaflx_anyflx
              weaflx_co2csm = weaflx_anyflxm
              n_weaflx_co2cs = n_current
            CASE(5) ! weaflx_co2oo
              weaflx_co2oo => weaflx_anyflx
              weaflx_co2oom = weaflx_anyflxm
              n_weaflx_co2oo = n_current
            CASE(6) ! weaflx_po4rw
              weaflx_po4rw => weaflx_anyflx
              weaflx_po4rwm = weaflx_anyflxm
              n_weaflx_po4rw = n_current
            CASE DEFAULT
         
            END SELECT


            NULLIFY(weaflx_anyflx)  ! Now that the correct pointer points
                                    ! to the relevant information, nullify
                                    ! weaflx_anyflx for the next round


          ENDDO do4weaflx


          WRITE(dbguni,
     &      '(" dating_dimlen, n_weathering: ", I0, 1X, I0)')
     &      dating_dimlen, n_weathering
!           WRITE(dbguni,*) weaflx_dates
!           WRITE(dbguni,*) weaflx_time
          WRITE(dbguni,'(" weaflx_tinf, weaflx_tmax:", 2F16.4)')
     &      weaflx_tinf, weaflx_tmax
          IF(n_weathering>1)WRITE(dbguni,'(3(" ", i0))') i1, i2, is
          CALL FLUSH(dbguni)
 
                                    ! Deallocate space, as it is not
                                    ! required anymore
          IF(ALLOCATED(weaflx_dates_orig)) 
     &      DEALLOCATE(weaflx_dates_orig)
          IF(ALLOCATED(weaflx_anyflx_orig))
     &      DEALLOCATE(weaflx_anyflx_orig)

        ELSE ifweaused

                                    ! No scenario file given:
                                    ! use default values

          ALLOCATE(weaflx_biccc(1))
          ALLOCATE(weaflx_bicsc(1))
          ALLOCATE(weaflx_biccs(1))
          ALLOCATE(weaflx_co2cs(1))
          ALLOCATE(weaflx_co2oo(1))
          ALLOCATE(weaflx_po4rw(1))
 
          weaflx_biccc(1) = weaflx_biccc_dflt
          weaflx_bicsc(1) = weaflx_bicsc_dflt
          weaflx_biccs(1) = weaflx_biccs_dflt
          weaflx_co2cs(1) = weaflx_co2cs_dflt
          weaflx_co2oo(1) = weaflx_co2oo_dflt
          weaflx_po4rw(1) = weaflx_po4rw_dflt

          weaflx_bicccm   = weaflx_biccc_dflt
          weaflx_bicscm   = weaflx_bicsc_dflt
          weaflx_biccsm   = weaflx_biccs_dflt
          weaflx_co2csm   = weaflx_co2cs_dflt
          weaflx_co2oom   = weaflx_co2oo_dflt
          weaflx_po4rwm   = weaflx_po4rw_dflt

          n_weaflx_biccc = 1
          n_weaflx_bicsc = 1
          n_weaflx_biccs = 1
          n_weaflx_co2cs = 1
          n_weaflx_co2oo = 1
          n_weaflx_po4rw = 1

          n_weathering   = 1

        ENDIF ifweaused

                                    ! Pre-set all interpolates for
                                    ! fluxes that have only one datum.

        IF(n_weaflx_biccc == 1) weaflx_biccc_itp = weaflx_biccc(1)
        IF(n_weaflx_bicsc == 1) weaflx_bicsc_itp = weaflx_bicsc(1)
        IF(n_weaflx_biccs == 1) weaflx_biccs_itp = weaflx_biccs(1)
        IF(n_weaflx_co2cs == 1) weaflx_co2cs_itp = weaflx_co2cs(1)
        IF(n_weaflx_co2oo == 1) weaflx_co2oo_itp = weaflx_co2oo(1)
        IF(n_weaflx_po4rw == 1) weaflx_po4rw_itp = weaflx_po4rw(1)

        WRITE(dbguni, *)
        WRITE(dbguni, '(" n_weaflx_biccc = ",I0," (size: ",I0,")")')
     &    n_weaflx_biccc, SIZE(weaflx_biccc)
        WRITE(dbguni, '(" n_weaflx_bicsc = ",I0," (size: ",I0,")")')
     &    n_weaflx_bicsc, SIZE(weaflx_bicsc)
        WRITE(dbguni, '(" n_weaflx_biccs = ",I0," (size: ",I0,")")')
     &    n_weaflx_biccs, SIZE(weaflx_biccs)
        WRITE(dbguni, '(" n_weaflx_co2cs = ",I0," (size: ",I0,")")')
     &    n_weaflx_co2cs, SIZE(weaflx_co2cs)
        WRITE(dbguni, '(" n_weaflx_co2oo = ",I0," (size: ",I0,")")')
     &    n_weaflx_co2oo, SIZE(weaflx_co2oo)
        WRITE(dbguni, '(" n_weaflx_po4rw = ",I0," (size: ",I0,")")')
     &    n_weaflx_po4rw, SIZE(weaflx_po4rw)


        IF(use_some_dflt) THEN
          IF(resusd /= 0) THEN
            WRITE(resuni,'(A)') ' Warning: one or more default values'//
     &        ' have been adopted. Consistency needs to be checked!'
          ENDIF

          WRITE(dbguni, *)
          WRITE(dbguni, *) 'One or more default flux values adopted.'
        ENDIF

      ENDIF contiwsetup_tbd


      IF(n_weathering /= 1) THEN    ! We need to recalculate at least
                                    ! some interpolations


        IF(i_weathering == -1) i_weathering = 1


        IF(temps > weaflx_time(n_weathering)) THEN
          WRITE(erruni,fmt_infolin_ia) (__LINE__),
     &                    'temps > weaflx_time(n_weathering)'
          WRITE(erruni,*) 'temps = ', temps
          WRITE(erruni,*) 'weaflx_time(n_weathering) = ', 
     &                       weaflx_time(n_weathering)
          WRITE(erruni,fmt_infolin_ia) (__LINE__), 'Aborting!'
          CALL ABORT()
        ELSEIF(temps < weaflx_time(1)) THEN
          WRITE(erruni,*) 'temps < weaflx_time(1)'
          WRITE(erruni,*) 'temps = ', temps
          WRITE(erruni,*) 'weaflx_time(1) = ', 
     &                     weaflx_time(1)
          WRITE(erruni,fmt_infolin_ia) (__LINE__), 'Aborting!'
          CALL ABORT()
        ELSE                        ! OK temps is acceptable
!          WRITE(dbguni,*) 'i_wea, n_wea: ', i_weathering, n_weathering
                                    ! Search for i_weathering such that
                                    ! weaflx_time(i_weathering)
                                    !   <= temps < weaflx_time(i_weathering+1)
          DO WHILE(temps < weaflx_time(i_weathering))
!            WRITE(dbguni,*) i_weathering,
!     &                        weaflx_time(i_weathering,1), temps,
!     &                        i_weathering-1
            i_weathering = i_weathering-1
          ENDDO

          IF (i_weathering < n_weathering) THEN
            DO WHILE(temps >= weaflx_time(i_weathering+1))
!              WRITE(dbguni,*) i_weathering,
!      &                       weaflx_time(i_weathering+1,1), temps,
!      &                       i_weathering+1
              IF (i_weathering == (n_weathering-1)) THEN
                EXIT
              ELSE
                i_weathering = i_weathering+1
              ENDIF
            ENDDO
          ENDIF

          i1=i_weathering
          i2=i_weathering+1


!         WRITE(dbguni,*) 'si-', sealevel(i1), temps,
!     &                          sealevel(i2)

          weaflx_factor = (          temps - weaflx_time(i1))
     &                   /(weaflx_time(i2) - weaflx_time(i1))

          IF(n_weaflx_biccc /= 1) 
     &      weaflx_biccc_itp = weaflx_biccc(i1)
     &      + (weaflx_biccc(i2) - weaflx_biccc(i1))*weaflx_factor

          IF(n_weaflx_bicsc /= 1) 
     &      weaflx_bicsc_itp = weaflx_bicsc(i1)
     &      + (weaflx_bicsc(i2) - weaflx_bicsc(i1))*weaflx_factor

          IF(n_weaflx_biccs /= 1) 
     &      weaflx_biccs_itp = weaflx_biccs(i1)
     &      + (weaflx_biccs(i2) - weaflx_biccs(i1))*weaflx_factor

          IF(n_weaflx_co2cs /= 1) 
     &      weaflx_co2cs_itp = weaflx_co2cs(i1)
     &      + (weaflx_co2cs(i2) - weaflx_co2cs(i1))*weaflx_factor

          IF(n_weaflx_co2oo /= 1) 
     &      weaflx_co2oo_itp = weaflx_co2oo(i1)
     &      + (weaflx_co2oo(i2) - weaflx_co2oo(i1))*weaflx_factor

          IF(n_weaflx_po4rw /= 1) 
     &      weaflx_po4rw_itp = weaflx_po4rw(i1)
     &      + (weaflx_po4rw(i2) - weaflx_po4rw(i1))*weaflx_factor

        ENDIF
      ENDIF

      owco2t = weaflx_co2oo_itp
      rwpo4t = weaflx_po4rw_itp
      swcits = weaflx_biccs_itp
      swco2s = weaflx_co2cs_itp
      swcits = swcits - 2.D+00*swco2s
      swcitc = weaflx_biccc_itp + 2.D+00*swco2s
      iwcitt = weaflx_bicsc_itp
      volcsi = weaflx_bicscm/2.D+00
!Uncomment following for DEGLAVOLC simulation experiments
!Begin DEGLAVOLC simulation experiments
!        volcsi = volcsi*1D0 !(1D0-(0.055/(120000D0*bicscm/2.D+00)))
!     >           + 0.055D0/(1.3D3*SQRT(3.14159265358979323846D+00))
!     >             *EXP(-((temps+  8020D0)/1.3D3)**2)
!     >           + 0.055D0/(1.3D3*SQRT(3.14159265358979323846D+00))
!     >             *EXP(-((temps+128020D0)/1.3D3)**2)
!End DEGLAVOLC simulation experiments
!     volcca = (weaflx_biccsm-2.D+00*weaflx_co2csm)/2.D+00
      volcca = weaflx_biccsm/2.D+00-weaflx_co2csm

                                     
      corali(ro1+2)=0.0D+0      ! Annuler Corali, l'apport
      corali(ro1+4)=0.0D+0      ! en provenance des marges.

!      STOP ! for debugging purposes

      RETURN
      END SUBROUTINE CONTIW

