!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!     ******************************************************************
      SUBROUTINE ADVECT(cargo,transi,transo)
!     ******************************************************************

      USE mod_mbm_geometry, ONLY: nro1, nro3, ro1, ro2, ro3
      USE mod_mbm_wfluxes, ONLY: wflux, wfluxo

      IMPLICIT NONE
      

      DOUBLE PRECISION  cargo(ro1+1:ro3+nro3)
      DOUBLE PRECISION transi(ro1+1:ro3+nro3)
      DOUBLE PRECISION transo(ro1+1:ro3+nro3)
      INTEGER i

      transi(ro1+1) =   wflux(ro1+2,ro1+1)*cargo(ro1+2)
     &                + wflux(ro1+5,ro1+1)*cargo(ro1+5)
     &                + wflux(ro2+1,ro1+1)*cargo(ro2+1)
     &                + wflux(ro3+1,ro1+1)*cargo(ro3+1)
      transi(ro1+2) =   wflux(ro1+1,ro1+2)*cargo(ro1+1)
     &                + wflux(ro1+3,ro1+2)*cargo(ro1+3)
     &                + wflux(ro1+4,ro1+2)*cargo(ro1+4)
     &                + wflux(ro2+1,ro1+2)*cargo(ro2+1)
      transi(ro1+3) =   wflux(ro1+2,ro1+3)*cargo(ro1+2)
     &                + wflux(ro1+4,ro1+3)*cargo(ro1+4)
     &                + wflux(ro2+1,ro1+3)*cargo(ro2+1)
     &                + wflux(ro2+2,ro1+3)*cargo(ro2+2)
     &                + wflux(ro3+2,ro1+3)*cargo(ro3+2)
      transi(ro1+4) =   wflux(ro1+2,ro1+4)*cargo(ro1+2)
     &                + wflux(ro1+3,ro1+4)*cargo(ro1+3)
     &                + wflux(ro1+5,ro1+4)*cargo(ro1+5)
     &                + wflux(ro2+2,ro1+4)*cargo(ro2+2)
      transi(ro1+5) =   wflux(ro1+4,ro1+5)*cargo(ro1+4)
     &                + wflux(ro1+1,ro1+5)*cargo(ro1+1)
     &                + wflux(ro2+2,ro1+5)*cargo(ro2+2)
     &                + wflux(ro3+3,ro1+5)*cargo(ro3+3)
      transi(ro2+1) =   wflux(ro1+1,ro2+1)*cargo(ro1+1)
     &                + wflux(ro1+2,ro2+1)*cargo(ro1+2)
     &                + wflux(ro1+3,ro2+1)*cargo(ro1+3)
     &                + wflux(ro2+2,ro2+1)*cargo(ro2+2)
     &                + wflux(ro3+1,ro2+1)*cargo(ro3+1)
     &                + wflux(ro3+2,ro2+1)*cargo(ro3+2)
      transi(ro2+2) =   wflux(ro1+3,ro2+2)*cargo(ro1+3)
     &                + wflux(ro1+4,ro2+2)*cargo(ro1+4)
     &                + wflux(ro1+5,ro2+2)*cargo(ro1+5)
     &                + wflux(ro2+1,ro2+2)*cargo(ro2+1)
     &                + wflux(ro3+2,ro2+2)*cargo(ro3+2)
     &                + wflux(ro3+3,ro2+2)*cargo(ro3+3)
      transi(ro3+1) =   wflux(ro1+1,ro3+1)*cargo(ro1+1)
     &                + wflux(ro2+1,ro3+1)*cargo(ro2+1)
     &                + wflux(ro3+2,ro3+1)*cargo(ro3+2)
     &                + wflux(ro3+3,ro3+1)*cargo(ro3+3)
      transi(ro3+2) =   wflux(ro1+3,ro3+2)*cargo(ro1+3)
     &                + wflux(ro2+1,ro3+2)*cargo(ro2+1)
     &                + wflux(ro2+2,ro3+2)*cargo(ro2+2)
     &                + wflux(ro3+1,ro3+2)*cargo(ro3+1)
     &                + wflux(ro3+3,ro3+2)*cargo(ro3+3)
      transi(ro3+3) =   wflux(ro1+5,ro3+3)*cargo(ro1+5)
     &                + wflux(ro2+2,ro3+3)*cargo(ro2+2)
     &                + wflux(ro3+1,ro3+3)*cargo(ro3+1)
     &                + wflux(ro3+2,ro3+3)*cargo(ro3+2)

      DO 10 i = ro1+1, ro3+nro3
         transo(i) = wfluxo(i)*cargo(i)
   10 CONTINUE
      RETURN
      END
