!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


************************************************************************
      SUBROUTINE ACTIVY(borate,k0,k1,k2,kb,kw,
     &                  cit,alk,ph,pco2,co3,nres,iflag)
************************************************************************
C
C
C     Calculates the speciation of the carbonate system.
C     Concentration units do not really matter,
C     as only concentration ratios are actually used.
C     The system only has to be coherent.
C
C
      IMPLICIT NONE
      INTEGER nres,iflag
      DOUBLE PRECISION cit(nres),alk(nres),ph(nres),pco2(nres),co3(nres)
      DOUBLE PRECISION borate(nres),k0(nres),k1(nres),k2(nres),kb(nres),
     >                 kw(nres)
C
C
C     Local variables
C
      INTEGER i
      DOUBLE PRECISION ba,sa,a,b,c,ah,ah0,fah,dfah,residu
C
      DO 100 i=1,nres
         ba=borate(i)/alk(i)
         sa=cit(i)/alk(i)
         a=(kb(i)*(1.-ba)+k1(i)*(1.-sa))*1.0d+08
         b=(kb(i)*(1.-ba-sa)+k2(i)*(1.-sa-sa))*k1(i)*1.0d+16
         c=(1.-ba-sa-sa)*k1(i)*k2(i)*kb(i)*1.0d+24
c
         ah0 = MAX(ABS(c),1.D+00+ABS(b),1.D+00+ABS(a))
         ah = ah0
C
C     NEWTON-RAPHSON METHOD
C
    2 CONTINUE
         fah = c+ah*(b+ah*(a+ah))
        dfah = b+ah*(a+a+3.D+00*ah)
c
      residu = -fah/dfah
          ah = ah+residu
      IF (ABS(residu).GT.1.D-05) GOTO 2
C
      ah = ah*1.0D-08
      IF ((ah.LT.1.0D-7).OR.(ah.GT.1.0D-01)) THEN 
          WRITE(0,*)'[ACTIVY]: Final <ah> out of range'
          WRITE(0,*)'  Reservoir:',i,' of ',nres
          WRITE(0,*)'  DIC:', cit(i)
          WRITE(0,*)'  ALK:', alk(i)
          WRITE(0,*)'  ahi:', ah0*1.0D-08
          WRITE(0,*)'  ahf:', ah
          WRITE(0,*)'  abc:', a,b,c
          WRITE(0,*)'  Returning to caller.'
          iflag=1
          RETURN
      ENDIF
        ph(i) = -DLOG10(ah*1D-3)
      pco2(i) = ah*ah*cit(i)/(k1(i)*k2(i)+ah*(k1(i)+ah))/k0(i)
       co3(i) = k1(i)*k2(i)*cit(i)/(k1(i)*k2(i)+ah*(k1(i)+ah))
  100 CONTINUE
      iflag=0
      RETURN
      END
