!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      SUBROUTINE STORE_CSV_SUMMARY(cfn_csvout_summary)
!=======================================================================


      USE mod_defines_medusa
      USE mod_logunits
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_seafloor_wdata
      USE mod_indexparam
      USE mod_seafloor_central
      USE mod_netcdfparam
      USE mod_chemicalconsts
      USE mod_zone_mass_totals,     ONLY: ZONE_MASS_TOTALS


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN) :: cfn_csvout_summary


      LOGICAL :: l_csvfile_is_mine = .TRUE. ! for later MPI extension
      INTEGER :: iu_csv, istatus
      INTEGER :: isedcol, nsedcol_central, nsedcol_csvfile
      INTEGER :: i

      TYPE(WDATA_CONTAINER) :: wdata

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: total_xm
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: total_rea_xm

      DOUBLE PRECISION, DIMENSION(nsolut) :: wconc
      DOUBLE PRECISION, DIMENSION(nsolid) :: wfflx
      DOUBLE PRECISION, DIMENSION(nsolid) :: bfflx

      DOUBLE PRECISION :: total_solids

      CHARACTER(LEN=*), PARAMETER :: cfmt_info_a
     &  = '("[STORE_CSV_SUMMARY] info: ", A)'

      CHARACTER(LEN=*), PARAMETER :: cfmt_err_a
     &  = '("[STORE_CSV_SUMMARY] error: ", A)'

#ifdef DEBUG
      CHARACTER(LEN=*), PARAMETER :: cfmt_dbg_a
     &  = '("[STORE_CSV_SUMMARY] debug: ", A)'
#endif



      IF (l_csvfile_is_mine) THEN

        istatus = RESERVE_LOGUNIT(iu_csv)
        IF (istatus /= 0) THEN
          WRITE(jp_stderr, cfmt_err_a)
     &      'unable to reserve a logical unit for "iu_csv" -- aborting'
          CALL ABORT_MEDUSA()
#ifdef DEBUG
        ELSE
          WRITE(jp_stddbg, cfmt_dbg_a, ADVANCE='NO')
     &      'assigning logical unit number '
          WRITE(jp_stddbg, '(I0,A)') iu_csv, ' to "iu_csv".'
#endif
        ENDIF


        OPEN(UNIT=iu_csv, FILE=cfn_csvout_summary)


                                    ! Print out header
                                    ! ================
        WRITE(iu_csv, '( "''", A, "''")', ADVANCE='NO') 'Column'
        WRITE(iu_csv, '(",''", A, "''")', ADVANCE='NO') 'DBSL'
c~         WRITE(iu_csv, '(",''", A, "''")', ADVANCE='NO') 'Delta_CO3'

        DO i = 1, ncat1solid
          WRITE(iu_csv, '(",''", A, "''")', ADVANCE='NO')
     &      '%' // TRIM(vnn(j1f_to_io(i)))
        ENDDO

        DO i = 1, ncat1solid
          WRITE(iu_csv, '(",''", A, "''")', ADVANCE='NO')
     &      'wf_' // TRIM(vnn(j1f_to_io(i)))
        ENDDO

        DO i = 1, ncat1solut
          WRITE(iu_csv, '(",''", A, "''")', ADVANCE='NO')
     &      'wc_' // TRIM(vnn(j1c_to_io(i)))
        ENDDO

        DO i = 1, ncat1solid
          WRITE(iu_csv, '(",''", A, "''")', ADVANCE='NO')
     &      'bf_' // TRIM(vnn(j1f_to_io(i)))
        ENDDO

        WRITE(iu_csv, '()')         ! and linefeed.


        CALL N_COLUMNS_USED(nsedcol_central)

        ALLOCATE(total_xm(ncompo, nsedcol_central))
        ALLOCATE(total_rea_xm(ncompo, nsedcol_central))


        CALL ZONE_MASS_TOTALS(total_xm = total_xm,
     &                              total_rea_xm = total_rea_xm)


        DO isedcol = 1, nsedcol_central

          CALL GET_BOUNDARY_CONDS(i_column = isedcol,
     &                              gbcflag = istatus,
     &                              wdata = wdata,
     &                              wconc = wconc(:),
     &                              wfflx = wfflx(:))

          CALL GET_BOUNDARY_FLUXES(i_column = isedcol,
     &                              gbfflag = istatus,
     &                              bfflx = bfflx(:))

          WRITE(iu_csv, '(       I0)', ADVANCE='NO') isedcol
          WRITE(iu_csv, '(",", F0.2)', ADVANCE='NO') wdata%wdbsl

#ifdef SOLIDS_VOLUMELESS
          total_solids = total_xm(jo_mud, isedcol)
#else
          total_solids = SUM(total_xm(j1f_to_io(:), isedcol))
#endif

          CALL SETCCT(wdata, wconc(:))

c~           WRITE(iu_csv, '(",", F0.14)', ADVANCE='NO')
c~      &      (wconc(ic_co3) - cct_ksp_calc/cct_ttcc_ca) * 1.0D+03

          DO i = 1, ncat1solid
            WRITE(iu_csv, '(",", F0.17)', ADVANCE='NO')
     &        total_xm(j1f_to_io(i), isedcol)/total_solids
          ENDDO

          DO i = 1, ncat1solid
            WRITE(iu_csv, '(",", E22.17)', ADVANCE='NO')
     &        wfflx(j1f_to_if(i))
          ENDDO

          DO i = 1, ncat1solut
            WRITE(iu_csv, '(",", E22.17)', ADVANCE='NO')
     &        wconc(j1c_to_ic(i))
          ENDDO

          DO i = 1, ncat1solid
            WRITE(iu_csv, '(",", E22.17)', ADVANCE='NO')
     &        bfflx(j1f_to_if(i))
          ENDDO

          WRITE(iu_csv, '()')         ! and linefeed.


        ENDDO


        CLOSE(UNIT=iu_csv)


#ifdef DEBUG
        WRITE(jp_stddbg, cfmt_dbg_a, ADVANCE='NO')
     &      'Freeing logical unit '
        WRITE(jp_stddbg, '(I0,A)')
     &    iu_csv, ' (attached to "iu_csv")'
#endif
        istatus = FREE_LOGUNIT(iu_csv)
        IF (istatus /= 0) THEN
          WRITE(jp_stderr, cfmt_err_a, ADVANCE='NO') 'error '
          WRITE(jp_stderr, '(I0,A)')
     &      istatus, ' while freeing logical unit from "iu_csv" ' //
     &      '-- ignored.'
        ENDIF

        CALL FLUSH(jp_stderr)

        DEALLOCATE(total_xm)
        DEALLOCATE(total_rea_xm)


      ENDIF


!=======================================================================
      END SUBROUTINE STORE_CSV_SUMMARY
!=======================================================================
