!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      MODULE MOD_TIMECONT_MEDUSA_TSI
!=======================================================================

      IMPLICIT NONE

      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE GET_TIMESTEP_INFO(irequest, mark,
     &                              atime, datime, nsteps)
!-----------------------------------------------------------------------

      USE mod_defines_medusa
      USE mod_execontrol_medusa, ONLY: ABORT_MEDUSA
      USE mod_logunits

      IMPLICIT NONE

      INTEGER,          INTENT(IN)            :: irequest
      INTEGER,          INTENT(OUT)           :: mark
      DOUBLE PRECISION, INTENT(OUT), OPTIONAL :: atime, datime
      INTEGER,          INTENT(OUT), OPTIONAL :: nsteps


      LOGICAL, SAVE :: medusa_tsi_isopen = .FALSE.
      INTEGER, SAVE :: medusa_tsi_unit   = -1


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: cfmt_modprocname_a =
     &  '("[MOD_TIMECONT_MEDUSA_TSI/GET_TIMESTEP_INFO]: ", A)'

      CHARACTER(LEN=*), PARAMETER :: cfmt_a     = '(" - ", A)'
      CHARACTER(LEN=*), PARAMETER :: cfmt_a_ind = '(" - ", A)'


#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'Start'
#endif


      IF (medusa_tsi_unit == -1) THEN

        mark = RESERVE_LOGUNIT(medusa_tsi_unit)

        IF (mark /= 0) THEN
          WRITE(jp_stderr, cfmt_modprocname_a) 'Fatal error'
          WRITE(jp_stderr, cfmt_a)
     &      'Unable to reserve a logical unit number ' //
     &      'for the MEDUSA_TSI unit -- aborting!'
          CALL ABORT_MEDUSA()
#ifdef DEBUG

        ELSE

          WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")
     &      'Assigning logical unit number '
          WRITE(jp_stddbg, '(I0, A)') medusa_tsi_unit,
     &      ' to the MEDUSA_TSI unit.'
#endif

        ENDIF

      ENDIF


      SELECT CASE(irequest)

      CASE(0)

        INQUIRE(FILE='medusa.tsi', OPENED=medusa_tsi_isopen)
        IF ( .NOT.(medusa_tsi_isopen)) THEN

          OPEN(medusa_tsi_unit, FILE='medusa.tsi', STATUS="OLD")

        ELSE

          CLOSE(medusa_tsi_unit)
          OPEN(medusa_tsi_unit, FILE='medusa.tsi')

        ENDIF

        READ(medusa_tsi_unit,*) atime
        READ(medusa_tsi_unit,*) datime
        READ(medusa_tsi_unit,*) nsteps

        IF (datime < 0.0D+00) THEN
          WRITE(jp_stderr, cfmt_modprocname_a) 'Fatal error'
          WRITE(jp_stderr, cfmt_a)
     &      'time step length (datime) must not be negative -- '
     &      // 'aborting!'
          CALL ABORT_MEDUSA()
        ENDIF

        IF (nsteps <= 0.0D+00) THEN
          WRITE(jp_stderr, cfmt_modprocname_a) 'Fatal error'
          WRITE(jp_stderr, cfmt_a)
     &      'number of steps (nsteps) must not be negative or zero -- '
     &      // 'aborting!'
          CALL ABORT_MEDUSA()
        ENDIF


      CASE(1)

        CLOSE(medusa_tsi_unit)
        medusa_tsi_isopen = .FALSE.

#ifdef DEBUG
        WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")
     &      'Releasing logical unit number '
          WRITE(jp_stddbg, '(I0, A)', ADVANCE="NO")
     &      medusa_tsi_unit, ' (attached to the MEDUSA_TSI unit)'
        WRITE(jp_stddbg, '(I0)', ADVANCE="NO") 
#endif
        mark = FREE_LOGUNIT(medusa_tsi_unit)
        IF (mark /= 0) THEN
          WRITE(jp_stderr, cfmt_modprocname_a) 'Warning'
          WRITE(jp_stderr, cfmt_a, ADVANCE="NO")
     &      'FREE_LOGUNIT returned error code '
          WRITE(jp_stderr, '(I0, A)') mark,
     &      ' when trying to release the logical unit number'
     &      //  ' attached to the MEDUSA_TSI unit -- ignoring.'
#ifdef DEBUG
          WRITE(jp_stddbg, '()')
          WRITE(jp_stddbg, cfmt_a_ind, ADVANCE="NO")
          WRITE(jp_stddbg, '(A, I0, A)')
     &      'FREE_LOGUNIT returned error code ', mark,
     &      ' when trying to release the logical unit number'
     &      //  ' attached to the MEDUSA_TSI unit -- ignoring.'
        ELSE
          WRITE(jp_stddbg, '(" - done.")')
#endif
        ENDIF

        CALL FLUSH(jp_stderr)
#ifdef DEBUG
        CALL FLUSH(jp_stddbg)
#endif

        mark = 0


      CASE DEFAULT

        mark = 1

      END SELECT

#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'End'
      WRITE(jp_stddbg,'()')
#endif


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE GET_TIMESTEP_INFO
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MOD_TIMECONT_MEDUSA_TSI
!=======================================================================
