!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      MODULE MOD_JEASIM_MEDUSA_SETUP
!=======================================================================


      IMPLICIT NONE

      LOGICAL, PRIVATE, SAVE :: l_setup_done = .FALSE.


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE SETUP_MEDUSA_FOR_JEASIM(n_columns)
!-----------------------------------------------------------------------

      USE mod_defines_medusa
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_seafloor_central,     ONLY: SEAFLOOR_SETUP

      USE mod_materialcharas
      USE mod_logunits


      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: n_columns


      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE
     &  :: jeasim_ocngrid_surf


      ! Standard I/O related data
      ! -------------------------

      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_JEASIM_MEDUSA_SETUP/SETUP_MEDUSA_FOR_JEASIM]' //
     &    ' error: ", A)'

#ifdef DEBUG
      CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a
     &  = '("[MOD_JEASIM_MEDUSA_SETUP/SETUP_MEDUSA_FOR_JEASIM]' //
     &    ' debug: ", A)'
#endif


      IF (l_setup_done) THEN
        WRITE(jp_stderr,c_fmterr_a) 'Setup already done -- aborting.'
        CALL ABORT_MEDUSA()
      ENDIF


      n_columns = 1 ! one after another

                                    ! Set surface areas to 1.0
      ALLOCATE(jeasim_ocngrid_surf(n_columns))
      jeasim_ocngrid_surf(:) = 1.0D+00


      CALL SEAFLOOR_SETUP(n_columns, jeasim_ocngrid_surf)


#ifdef DEBUG
      WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE='NO')
     &  'Number of seafloor grid elements '
      WRITE(jp_stddbg, '(I0)') n_columns
#endif

      DEALLOCATE(jeasim_ocngrid_surf)


      l_setup_done = .TRUE.

      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE SETUP_MEDUSA_FOR_JEASIM
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MOD_JEASIM_MEDUSA_SETUP
!=======================================================================
