!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION TOTCA(tk,s,d)
!     ******************************************************************
      IMPLICIT NONE

!     Function calculates calcium concentration in (mol/kg-SW)
!     Checked Wed  3 Apr 11:22:40 CEST 2019

!     Input variables:
!     s      : salinity
!     tk     : temperature in K
!     d      : depth in m
!
      DOUBLE PRECISION tk,s,d

      CHARACTER(LEN=*), PARAMETER :: whatid
     &  = '"@(#)- Total Ca: after Handbook (2007), [mol/kg-SW]"'

      totca=0.010282D+00*(s/35.0D+00)

      RETURN

!     ******************************************************************
      END
!     ******************************************************************
