!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


************************************************************************
      SUBROUTINE SPECIA_CB(tk,s,d, alk,
     &                     cit, co3,hco3,co2,  bt, boh4,boh3,
     &                     oh,h3o,
     &                     iflag)
************************************************************************
C
C
C     Calculates the speciation of the carbonate system.
C     Concentration units do not really matter,
C     as only concentration ratios are actually used.
C     The system only has to be coherent.
C
C
      IMPLICIT NONE
      INTEGER, INTENT(OUT) :: iflag
      DOUBLE PRECISION, INTENT(IN) :: tk,s,d
      DOUBLE PRECISION, INTENT(IN) :: alk, cit, bt
      DOUBLE PRECISION, INTENT(OUT):: hco3,co2,co3, boh4,boh3, h3o,oh
C
C
C     Local variables
C
      DOUBLE PRECISION ::  ba,sa,a,b,c,ah,ah2,fah,dfah,residu,sdelta
      DOUBLE PRECISION ::  k0,k1,k2,kb, kw, rho
      DOUBLE PRECISION ::  ak0, ak1, ak2, akb, akw, rhosw
C
         rho = rhosw(tk,s,d)
          k0 = AK0(tk,s,d)*rho
          k1 = AK1(tk,s,d)*rho
          k2 = AK2(tk,s,d)*rho
          kb = AKB(tk,s,d)*rho
          kw = AKW(tk,s,d)*(rho*2)

         ba=bt/alk
         sa=cit/alk
         a=(kb*(1.-ba)+k1*(1.-sa))*1.0d+08
         b=(kb*(1.-ba-sa)+k2*(1.-sa-sa))*k1*1.0d+16
         c=(1.-ba-sa-sa)*k1*k2*kb*1.0d+24
c
          ah = MAX(ABS(c),1.D+00+ABS(b),1.D+00+ABS(a))
      sdelta = DSQRT(a*a-3.D+00*b)
         ah2 = (-a+sdelta)/3.D+00
          ah = MIN(ah,ah2+DSQRT(-(c+ah2*(b+ah2*(a+ah2)))/sdelta))
C
C     NEWTON-RAPHSON METHOD
C
    2 CONTINUE
         fah = c+ah*(b+ah*(a+ah))
        dfah = b+ah*(a+a+3.D+00*ah)
c
      residu = -fah/dfah
          ah = ah+residu
      IF (ABS(residu).GT.1.D-05) GOTO 2
C
      ah = ah*1.0D-08
C Approximations are valid for 4 <     pH      < 10,
C                   i.e. 10^(-4) >  ah/(mol/l) > 10^(-10),
C                   i.e. 10^(-1) > ah/(mol/m3) > 10^(-7)
      IF ((ah.LT.1.0D-7).OR.(ah.GT.1.0D-01)) THEN 
          iflag=1
          return
      ENDIF

      co2 = ah*ah*cit/(k1*k2+ah*(k1+ah))
      co3 = k1*k2*cit/(k1*k2+ah*(k1+ah))
      hco3 = cit - co3 - co2
      boh4 = kb*bt/(kb+ah)
      boh3 = bt-boh4
      h3o = ah
      oh = kw/ah
      iflag=0
      RETURN
      END

