!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION RHOSW(tk,s,d)
!     ******************************************************************
      IMPLICIT NONE
!
!     Function returns \rho in (kg-SW)/(m^3-SW)
!     Input variables:
!     s      : salinity
!     tk     : temperature in K
!     d      : depth in m
      DOUBLE PRECISION tk,s,d
!
!     Local variables:
!     p      : pressure in bar
!     s0     : 35.5
!     tk0    : 285.16 K
!     p0     : 300 bar
!     rhosw1 : first degree expression
!     rhosw2 : second degree expression
      DOUBLE PRECISION p,s0,tk0,p0
      PARAMETER(s0=35.5D+00, tk0=285.16D+00, p0=300.0D+00)
!     DOUBLE PRECISION rhosw1
      DOUBLE PRECISION rhosw2
!
      CHARACTER (len = 62) , DIMENSION(2) :: whatid
      DATA whatid(1) /'"@(#)- Rho_SW: Munhoven (1997) [kg-SW/m3-SW];"'/
      DATA whatid(2) /'"@(#)       after EOS80 (UNESCO, 1981, 1983)"'/
!
       p = d/10.0D+00
!
!
!     rhosw1 = 1039.9044D+00 + 0.77629393D+00*(s-s0)
!    >                       - 0.19692738D+00*(tk-tk0)
!    >                       + 0.044038615D+00*(p-p0)
      rhosw2 = 1040.0145D+00 + 0.77629393D+00*(s-s0)
     >                       - 0.25013591D+00*(tk-tk0)
     >                       + 4.2026266D-02*(p-p0)
     >                       - 4.7473116D-03*(tk-tk0)*(tk-tk0)
     >                       - 4.7974224D-06*(p-p0)*(p-p0)
     >                       - 2.1404592D-04*(tk-tk0)*(p-p0)
      rhosw = rhosw2
      RETURN
      END
