!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION BHSO4(tk, salin)
!     ******************************************************************
      IMPLICIT NONE
!
!     Returns \beta_{HSO4} in (mol/kg-SW)^{-1}, where
!     \beta_{HSO4} = \frac{ [HSO_{4}^{-}] }{ [H^{+}] [SO_{4}^{2-}] }
!
!     Input variables:
!     salin  : salinity in psu
!     tk     : temperature in K
      DOUBLE PRECISION tk, salin
!
!     Local variables:
!     ionstr: Ionic Strength in mol/kg-H2O
      DOUBLE PRECISION ionstr, lkhso4
!
      CHARACTER (len = 62) :: whatid
      DATA whatid /'"@(#)- b_HSO4: Dickson (1990) [mol/kg-H2O]"'/
!
!
      ionstr= 0.019920D+00*salin/(1.0D+00 - 0.0010049D+00*salin) 
      lkhso4=   -4276.1D+00/tk + 141.328D+00 -  23.093D+00*DLOG(tk)
     >        + (-13856D+00/tk +  324.57D+00 -  47.986D+00*DLOG(tk))
     >                                           *DSQRT(ionstr)
     >        + ( 35474D+00/tk -  771.54D+00 + 114.723D+00*DLOG(tk))
     >                                           *ionstr
     >        - (2698D+00/tk)*ionstr*DSQRT(ionstr)
     >        + (1776D+00/tk)*ionstr*ionstr
      bhso4=(DEXP(-lkhso4))/(1.0D+00 - 0.0010049D+00*salin)
      RETURN
      END
