!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION BHF(tk, salin)
!     ******************************************************************
      IMPLICIT NONE
!
!     Returns \beta_{HF} in (mol/kg-SW)^{-1}, where
!     \beta_{HF} = \frac{ [HF] }{ [H^{+}] [F^{-}] }
!
!     Input variables:
!     salin  : salinity in psu
!     tk     : temperature in K
      DOUBLE PRECISION tk, salin
!
!     Local variables:
!     ionstr: Ionic Strength in mol/kg-H2O
      DOUBLE PRECISION ionstr, lnbhf
!
      CHARACTER (len = 62) :: whatid
      DATA whatid /'"@(#)- b_HF: Dickson & Riley (1979) [mol/kg-H2O]"'/
!
!
      ionstr= 0.019920D+00*salin/(1.0D+00-0.0010049D+00*salin) 
      lnbhf = -1590.2D+00/tk + 12.641D+00 - 1.525D+00*DSQRT(ionstr)
      bhf=DEXP(lnbhf)/(1.0D+00-0.0010049D+00*salin)
      RETURN
      END
