!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION AKW(tk,s,d)
!     ******************************************************************
      IMPLICIT NONE
!
!     Funct. calculates water dissociation constant Kw in (mol/kg-SW)^2
!     Checked Sat Jun 21 11:42:38 MET DST 1997 
!
!     Input variables:
!     s      : salinity
!     tk     : temperature in K
!     d      : depth in m
!     
      DOUBLE PRECISION tk,s,d
!     Local variables:
!     p      : pressure in bar
!     rt     : R*TEMP
!     tc     : temperature in degrees Celsius
!     dvi    : volume change for ionization
!     dki    : compressibility change for ionization
!     sqrts  : square root of salinity
!     ds     : salinity-34.8

      DOUBLE PRECISION p,rt,tc,dvi,dki,ds,sqrts
!
      CHARACTER (len = 62) , DIMENSION(2) :: whatid
      DATA whatid(1)
     &/'"@(#)- K_w: after Millero (1995), pH-SWS, [(mol/kg-SW)^2];"'/
      DATA whatid(2)
     &/'"@(#)       pressure correction after Millero (1982)"'/
!
       p = d/10.0D+00
      tc = tk - 273.16D+00
      ds = s - 34.8D+00
      sqrts = DSQRT(s)
      rt = 83.14510D+00*tk
!
!
      dvi = -( 20.02D+00 - 0.1119D+00*tc + 0.1409D-02*tc*tc)
      dki = -(  5.13D+00 - 0.0794D+00*tc)*1.0D-03
      akw = DEXP(148.9802D+00 - 13847.26D+00/tk - 23.6521D+00*DLOG(tk)
     >           + ( -5.977D+00 + 118.67D+00/tk
     >              + 1.0495D+00*DLOG(tk))*sqrts - 0.01615D+00*s
     >           - (dvi - dki*p/2.D+00)*p/rt )
      RETURN
      END
