!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION AKB(tk,s,d)
!     ******************************************************************
      IMPLICIT NONE
!
!     Function calculates boric acid dissociation constant KB
!     in mol/kg-SW on SWS pH-scale.
!     Checked Sat Jun 21 11:42:38 MET DST 1997 
!
!     Input variables:
!     s      : salinity
!     tk     : temperature in K
!     d      : depth in m
!     
      DOUBLE PRECISION tk,s,d
!     Local variables:
!     p      : applied pressure in bar
!     rt     : R*TEMP, R in bar*cm3/(mol*K)
!     tc     : temperature in degrees Celsius
!     dvi    : volume change for ionization
!     dki    : compressibility change for ionization
!     sqrts  : square root of salinity
!     ds     : salinity-34.8
!     is     : molal ionic strength (mol/kg-H2O)
!     hswsht : [H]SWS / [H]T
!     so4t   : total sulphate (mol/kg-SW)
!     ft     : total fluoride (mol/kg-SW)
!
      DOUBLE PRECISION p,rt,tc,dvi,dki,ds,sqrts
      DOUBLE PRECISION is,so4t,ft,hswsht,bhso4,bhf
!
      CHARACTER (len = 62) , DIMENSION(2) :: whatid
      DATA whatid(1)
     &/'"@(#)- K_b: after Dickson (1990), pH-SWS, [mol/kg-SW];"'/
      DATA whatid(2)
     &/'"@(#)       pressure correction after Millero (1982)"'/
!
       p = d/10.0D+00
      tc = tk - 273.16D+00
      ds = s - 34.8D+00
      sqrts = DSQRT(s)
      rt = 83.14510D+00*tk
!
      is   = (0.019920D+00*s)/(1.D+00 - 0.0010049D+00*s)
      so4t = 0.028234D+00*(s/35.D+00)
      ft   = 0.000068D+00*(s/35.D+00)
!
      hswsht = 1.D+00 + bhf(tk,is)*ft/(1.D+00 + bhso4(tk,is)*so4t)
!
!
      dvi = -(   29.48D+00 - 0.295D+00*ds - 0.1622D+00*tc
     >        + 0.2608D-02*tc*tc)
      dki = -( 2.84D+00 - 0.354D+00*ds)*1.0D-03
      akb = DEXP( ( -8966.9D+00 + sqrts*( -2890.51D+00
     >             + sqrts*(-77.942D+00 + sqrts*( 1.726D+00
     >             - 0.0993*sqrts))))/tk   +   148.0248D+00
     >             + sqrts*(137.194D+00 + sqrts*1.62247D+00)
     >            + (-24.4344D+00 + sqrts*(-25.085D+00
     >               -0.2474*sqrts))*DLOG(tk) + 0.53105D-01*sqrts*tk
     >         - (dvi - dki*p/2.0D+00)*p/rt )
     >      * hswsht * (1.D+00 - 0.0010049D+00*s)
      RETURN
      END
