!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION AK1(tk,s,d)
!     ******************************************************************
      IMPLICIT NONE
!
!     Function calculates first dissociation constant K1 in mol/kg-SW
!     on SWS pH-scale.
!     Checked Sat Jun 21 11:42:38 MET DST 1997 
!
!     Input variables:
!     s      : salinity
!     tk     : temperature in K
!     d      : depth in m
!     
      DOUBLE PRECISION tk,s,d
!     Local variables:
!     p      : applied pressure in bar
!     rt     : R*TEMP, R in bar*cm3/(mol*K)
!     tc     : temperature in degrees Celsius
!     dvi    : volume change for ionization
!     dki    : compressibility change for ionization
!     sqrts  : square root of salinity
!     ds     : salinity-34.8

      DOUBLE PRECISION p,rt,tc,dvi,dki,ds,sqrts
!
      CHARACTER (len = 62) , DIMENSION(2) :: whatid
      DATA whatid(1)
     &/'"@(#)- K_1: after Millero (1995), pH-SWS, [mol/kg-SW];"'/
      DATA whatid(2)
     &/'"@(#)       pressure correction after Millero (1982)"'/
!
       p = d/10.0D+00
      tc = tk - 273.16D+00
      ds = s - 34.8D+00
      sqrts = DSQRT(s)
      rt = 83.14510D+00*tk
!
!
      dvi = -(25.50D+00 + 0.151D+00*ds - 0.1271D+00*tc)
      dki = -( 3.08D+00 + 0.578D+00*ds - 0.0877D+00*tc)*1.0D-03
      ak1 = DEXP(  2.18867D+00 - 2275.0360D+00/tk
     >           - 1.468591D+00*DLOG(tk)
     >           + ( -0.138681D+00 - 9.33291D+00/tk)*sqrts
     >           + 0.726483D-01*s - 0.574938D-02*s*sqrts
     >           - ( dvi - dki*p/2.D+00)*p/rt)
      RETURN
      END
