!
!    Copyright 1997-2007, 2015, 2019, 2020 Guy Munhoven
!
!    This file is part of libthdyct.
!
!    Licensed under the Apache License, Version 2.0 (the "License");
!    you may not use this file except in compliance with the License.
!    You may obtain a copy of the License at
!
!        http://www.apache.org/licenses/LICENSE-2.0
!
!    Unless required by applicable law or agreed to in writing, software
!    distributed under the License is distributed on an "AS IS" BASIS,
!    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!    See the License for the specific language governing permissions and
!    limitations under the License.
!


!     ******************************************************************
      DOUBLE PRECISION FUNCTION AK0(tk,s,d)
!     ******************************************************************
      IMPLICIT NONE
!
!     Function calculates K0 in (mol/kg-SW)/atmosphere
!     Checked Sat Jun 21 11:42:38 MET DST 1997 
!
!     Input variables:
!     s      : salinity
!     tk     : temperature in K
!     d      : depth in m
      DOUBLE PRECISION tk, s, d
!
!     Local variables:
!     t100   : tk/100

      DOUBLE PRECISION t100
!
      CHARACTER (len = 65) :: whatid
      DATA whatid
     &/'"@(#)- K_0: after Weiss (1979) [(mol/kg-SW)/atm]"'/
!
      t100 = tk/100.0D+00
      ak0 = DEXP( -60.2409D+00 + 93.4517D+00/t100
     >          + 23.3585D+00*DLOG(t100)
     >          + (  0.23517D-01 - 0.23656D-01*t100
     >             + 0.47036D-02*t100*t100)*s )
      RETURN
      END
