      program G_C_4D_Var_driver


      DOUBLE PRECISION  f,rms,diff_norm,ref_norm
      DOUBLE PRECISION, ALLOCATABLE :: g(:)
      DOUBLE PRECISION, ALLOCATABLE :: x(:)
      REAL  D,relerr
      REAL, PARAMETER :: eps = 0.001
      
!-----------------LBFGS Parameters----------------

      INTEGER, PARAMETER :: nmax=321000, mmax=17
      character*60     task,csave
      logical          lsave(4)
      integer          n,m,iprint,nbd(nmax),iwa(3*nmax),isave(44)
      double precision factr,pgtol,l(nmax),u(nmax)
      double precision dsave(29)
      double precision wa(2*mmax*nmax+4*nmax+12*mmax*mmax+12*mmax)
      LOGICAL :: EXP_PRECOND = .FALSE. ! Do exponential preconditioning or not

! Allocate memories for dynamic arrays
      integer i,j,k
      integer aa
      INTEGER      ALLOCSTAT

!---------------------------------------------------------------------
      INTEGER    its,ite, jts,jte, kts,kte,levs,leve
      PARAMETER(its = 1,ite = 41, jts = 1,jte= 23, & 
                kts = 1,kte = 31, levs = 1,leve= 3)

      double precision sb(its:ite,jts:jte,levs:leve) 
      double precision s_new(its:ite,jts:jte,levs:leve) ! here sigma=ln(s/sb)
      double precision sigma(its:ite,jts:jte,levs:leve) ! here sigma=ln(s/sb)
      double precision emissionb(its:ite,jts:jte,levs:leve) ! here lgrid is the sensitivity from GRAPES-CUACE-ADJ
      
      double precision B(its:ite,jts:jte,levs:leve)
      double precision R(its:ite,jts:jte,levs:leve)

      DOUBLE PRECISION, ALLOCATABLE :: lgrid(:)
      DOUBLE PRECISION, ALLOCATABLE :: sb_trans(:)
      DOUBLE PRECISION, ALLOCATABLE :: xb(:)
      DOUBLE PRECISION, ALLOCATABLE :: B_trans(:)
      DOUBLE PRECISION, ALLOCATABLE :: R_trans(:)

      real gamma  ! here gamma is in the first term of cost function
      real B_element,R_element

      DOUBLE PRECISION J_prediction,J_parameter

      character*4 st_yyyy
      character*2 st_mm
      character*2 st_dd
      character*2 st_hh
   
      character*4 ed_yyyy
      character*2 ed_mm
      character*2 ed_dd
      character*2 ed_hh

      integer it_count
      character*2 it_counter

      INTEGER status
      character*500 :: command0
      character*500 :: command1
      character*500 :: command2
      character*500 :: command3
      character*500 :: command4
      character*500 :: command5
      character*500 :: command6
      character*500 :: command7

      character*200 :: PATH_GRAPES_CUACE='../grapes_cuace/grapes_cuace_OK/run/'
      character*200 :: PATH_GRAPES_CUACE_ADJ='../CAM_ADJ/'
      character*200 :: PATH_EMISS='../grapes_cuace/emis_2006/ITERATION/'
      character*200 :: PATH_OBS='../observation/'
      character*200 :: PATH_SIM='../grapes_cuace/simulation/'


      character*40 :: station(36)
      DATA station/'Datong','Hohhot','Ulanqab','Beijing','Baoding','Chengde',&
          &     'Tangshan','Tianjin','Zhangjiakou',&
          &     'Changzhi','Linfen','Handan','Shuozhou','Shijiazhuang',&
          &     'Taiyuan','Xingtai','Yangquan','Cangzhou','Dezhou','Dongying',&
          &     'Jinan','Jining','Laiwu','Liaocheng','Qingdao',&
          &     'Rizhao','Taian','Yantai','Zaozhuang','Zhangqiu','Hebi',&
          &     'Luoyang','Puyang','Xinxiang','Yuncheng','Zhengzhou'/

      INTEGER :: nstation,istation,itime
      PARAMETER(nstation=36,itime=24)
      real conc_obs(nstation,itime),conc_sim(nstation,itime)

      logical ALIVE


!-------------------------------------------------------------------
      st_yyyy='2016'
      st_mm='07'
      st_dd='03'
      st_hh='12'
      ed_yyyy='2016'
      ed_mm='07'
      ed_dd='04'
      ed_hh='12'

!-------------------------------------------------------------------
      gamma=0.0001
      B_element=0.76
      R_element=1.0
      
!-------------------------------------------------------------------
      aa=ite*jte*leve  !3 levels, 41*23 grids

      ALLOCATE ( g( aa ), STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'g memory allocation failed'
      END IF

      ALLOCATE ( x( aa ), STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'x memory allocation failed'
      END IF

      ALLOCATE ( lgrid( aa ), STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'lgrid memory allocation failed'
      END IF

      ALLOCATE ( sb_trans( aa ), STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'sb_trans memory allocation failed'
      END IF

      ALLOCATE ( xb( aa ), STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'xb memory allocation failed'
      END IF

!--------------------------------------------------------------------------------------------------
! read sb and obs    
      open(10,file=trim(adjustl(PATH_EMISS))//'sb/low_'//trim(adjustl(st_yyyy))&
                 //trim(adjustl(st_mm))//trim(adjustl(st_dd))//trim(adjustl(ed_dd))//'_daily.txt')
          read(10,101)((sb(i,j,1),i=its,ite),j=jts,jte)
      close(10)

      open(10,file=trim(adjustl(PATH_EMISS))//'sb/poi_'//trim(adjustl(st_yyyy))&
                 //trim(adjustl(st_mm))//trim(adjustl(st_dd))//trim(adjustl(ed_dd))//'_daily.txt')
          read(10,101)((sb(i,j,2),i=its,ite),j=jts,jte)
      close(10)

      open(10,file=trim(adjustl(PATH_EMISS))//'sb/pow_'//trim(adjustl(st_yyyy))&
                 //trim(adjustl(st_mm))//trim(adjustl(st_dd))//trim(adjustl(ed_dd))//'_daily.txt')
          read(10,101)((sb(i,j,3),i=its,ite),j=jts,jte)
      close(10)

      DO k=levs,leve
        DO i=its,ite
          DO j=jts,jte
             sb_trans((j-jts)+(i-its)*jte+(k-levs)*jte*ite+1)=sb(i,j,k)
          ENDDO
        ENDDO
      ENDDO

      DO istation=1,nstation
        open(200+istation,file=trim(adjustl(PATH_OBS))//trim(adjustl(station(istation)))&
                             //'_BC_'//trim(adjustl(st_yyyy))//trim(adjustl(st_mm))//trim(adjustl(st_dd))&
                             //trim(adjustl(ed_yyyy))//trim(adjustl(ed_mm))//trim(adjustl(ed_dd))//trim(adjustl(ed_hh))//'_hourly.txt')
        read(200+istation,*) conc_obs(istation,:)
        close(200+istation)
      ENDDO

!-------------------------------------------------------------------

!     cccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

!     LBFGS Optimization Steps
!     We wish to have output at every iteration.

      iprint = 1

!------------------------------------------------------------------

!     We specify the tolerances in the stopping criteria.

!      factr=1.0d+7
      factr=1.0d+13
      pgtol=1.0d-7

!     We specify the dimension n of the sample problem and the number
!        m of limited memory corrections stored.  (n and m should not
!        exceed the limits nmax and mmax respectively.)
 
      n = ite*jte*leve

      m = 5 ! in L-BFGS 

!     We now provide nbd which defines the bounds on the variables:
!                    l   specifies the lower bounds,
!                    u   specifies the upper bounds. 
 
!     First set bounds on variables.

      IF (EXP_PRECOND) THEN
        do i=1,n
           nbd(i)=0   
        end do
      ELSE
        do i=1,n
           nbd(i)=2   ! =1, x(i) has only a lower bound; =2,both lower and upper
                      ! =3 only upper bound; =0, unbounded
           l(i)=log(0.4)  ! lower bound
           u(i)=log(1.6)       ! upper bound
        end do
      END IF 

!     We now define the starting point.

      it_count=0 
      write(it_counter,'(i2)')it_count  ! iteration times   

      open(10,file='./it_count.txt')
          write(10,*) it_count
      close(10)  
      
      sigma=0.0    ! sigma=ln(sb/sb)=0.0, sigma(:,:,:)

      xb=0.0   ! xb=ln(sb/sb)=0.0, xb(:)


!!**********************************************************************************************

      DO k=levs,leve
        DO i=its,ite
          DO j=jts,jte
             x((j-jts)+(i-its)*jte+(k-levs)*jte*ite+1)=sigma(i,j,k)
          ENDDO
        ENDDO
      ENDDO

      task = 'START'

!        ------- the beginning of the loop ----------
 
 111  continue
      
!     This is the call to the L-BFGS-B code.      
      call setulb(n,m,x,l,u,nbd,f,g,factr,pgtol,wa,iwa,task,iprint,&
     &     csave,lsave,isave,dsave)

      print*,'after call setulb, task=',task

      if (task(1:2) .eq. 'FG') then

        DO k=levs,leve
           DO i=its,ite
             DO j=jts,jte
                sigma(i,j,k)=x((j-jts)+(i-its)*jte+(k-levs)*jte*ite+1)
             ENDDO
           ENDDO
        ENDDO

!---------------------------------------------------------------------------------------
! EMISS processes

        open(10,file=trim(adjustl(PATH_EMISS))//'x/low_x_BC_'//trim(adjustl(it_counter))//'.txt')
             write(10,101)((sigma(i,j,1),i=its,ite),j=jts,jte)
        close(10)  

        open(10,file=trim(adjustl(PATH_EMISS))//'x/poi_x_BC_'//trim(adjustl(it_counter))//'.txt')
             write(10,101)((sigma(i,j,2),i=its,ite),j=jts,jte)
        close(10)   

        open(10,file=trim(adjustl(PATH_EMISS))//'x/pow_x_BC_'//trim(adjustl(it_counter))//'.txt')
             write(10,101)((sigma(i,j,3),i=its,ite),j=jts,jte)
        close(10)   
         
        command0='. emiss_update.sh' 
        status=system(command0)
!        if ( status .ne. 0 ) then
!           print*,'ERROR update emiss.grd'
!           stop 
!        endif


! Before Run GRAPES-CUACE

       INQUIRE(file='./out/GRAPES_CUACE_ERROR.log',EXIST=ALIVE)
       if (ALIVE) then
          command1='rm -f ./out/GRAPES_CUACE_ERROR.log' 
          status=system(command1)
!          if ( status .ne. 0 ) then
!             print*,'ERROR rm -f ./out/GRAPES_CUACE_ERROR.log'
!             stop 
!          endif
       endif

! The same initial concentration field

       INQUIRE(file=trim(adjustl(PATH_GRAPES_CUACE))//'fort'//trim(adjustl(st_yyyy))&
                    //trim(adjustl(st_mm))//trim(adjustl(st_dd))//'.601',EXIST=ALIVE)         
       if (ALIVE) then

          command3='cp '//trim(adjustl(PATH_GRAPES_CUACE))//'fort'//trim(adjustl(st_yyyy))&
                        //trim(adjustl(st_mm))//trim(adjustl(st_dd))//'.601 '//&
                          trim(adjustl(PATH_GRAPES_CUACE))//'fort.601'
          status=system(command3)
!          if ( status .ne. 0 ) then
!            print*,'ERROR cp fort.601'
!         stop 
!         endif
!
       else
         print*,'No fort.601'
         stop
       endif 

! Run GRAPES-CUACE, conc_sim and state-basic values

       command4='. grapes_cuace_fnl_savedat.sh'
       status = system(command4)
       print*,'status=',status
!       if ( status .ne. 0 ) then
!        print*,'ERROR . grapes_cuace_fnl_savedat.sh'
!        stop 
!       endif

       INQUIRE(file='./out/GRAPES_CUACE_ERROR.log',EXIST=ALIVE)
       if (ALIVE) then
        print*,'ERROR in GRAPES-CUACE RUNNING PROCESS'
        stop
       endif

! Extract BC concentration
      call concentration_sim(st_yyyy,st_mm,st_dd,ed_yyyy,ed_mm,ed_dd,ed_hh)

      DO istation=1,nstation
        open(200+istation,file=trim(adjustl(PATH_SIM))//trim(adjustl(station(istation)))&
                             //'_BC_'//trim(adjustl(st_yyyy))//trim(adjustl(st_mm))//trim(adjustl(st_dd))&
                             //trim(adjustl(ed_yyyy))//trim(adjustl(ed_mm))//trim(adjustl(ed_dd))//trim(adjustl(ed_hh))//'_hourly.txt')
        read(200+istation,*) conc_sim(istation,:)
        close(200+istation)
      ENDDO

! Run GRAPES-CUACE-ADJ

      command6='. grapes_cuace_adj.sh'
      status = system(command6)
      print*,'status=',status
!       if ( status .ne. 0 ) then
!        print*,'ERROR . grapes_cuace_adj.sh'
!        print*,'status=',status
!        stop 
!       endif

! Extract emissionb
      INQUIRE(file=trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/low_sens_BC.txt',EXIST=ALIVE)
      if (ALIVE) then
        command7='rm '//trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/*txt'
        status=system(command7)
!        if ( status .ne. 0 ) then
!            print*,'ERROR rm low_sens_BC.txt'
!        stop 
!        endif        
      endif 

      call emissionb_sim()

      INQUIRE(file=trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/low_sens_BC.txt',EXIST=ALIVE)
      if (ALIVE) then
         open(10,file=trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/low_sens_BC.txt')
             read(10,101)((emissionb(i,j,1),i=its,ite),j=jts,jte)
         close(10)

         open(10,file=trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/poi_sens_BC.txt')
             read(10,101)((emissionb(i,j,2),i=its,ite),j=jts,jte)
         close(10)       

         open(10,file=trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/pow_sens_BC.txt')
             read(10,101)((emissionb(i,j,3),i=its,ite),j=jts,jte)
         close(10)      
      else
         print*,'ERROR No low_sens_BC'
      endif

!-----------------------------------------------------------------------
! Update lgrid, g, and calculate f

      DO k=levs,leve
        DO i=its,ite
          DO j=jts,jte
             lgrid((j-jts)+(i-its)*jte+(k-levs)*jte*ite+1)=emissionb(i,j,k)
          ENDDO
        ENDDO
      ENDDO

      DO i=1,aa
         g(i)=gamma*(x(i)-xb(i))*1.0/B_element+lgrid(i)*sb_trans(i)*exp(x(i))  
      ENDDO
      
      f=0.0
      J_parameter=0.0
      J_prediction=0.0
      DO i=1,n
        J_parameter=J_parameter+1.0/2*(x(i)-xb(i))*(x(i)-xb(i))*1.0/B_element
        f=f+1.0/2*gamma*(x(i)-xb(i))*(x(i)-xb(i))*1.0/B_element
      ENDDO
      
      DO j=1,itime
!      DO j=1,2
        DO i=1,nstation
           J_prediction=J_prediction+1.0/2*(conc_sim(i,j)-conc_obs(i,j))*(conc_sim(i,j)-conc_obs(i,j))*1.0/R_element 
           f=f+1.0/2*(conc_sim(i,j)-conc_obs(i,j))*(conc_sim(i,j)-conc_obs(i,j))*1.0/R_element 
        ENDDO
      ENDDO
      
      print*,'gamma=',gamma
      print*,'J_parameter=',J_parameter
      print*,'J_prediction=',J_prediction
      print*,'f=',f
!------------
! Save savedat

       INQUIRE(file=trim(adjustl(PATH_GRAPES_CUACE))//'savedat'&
                    //trim(adjustl(st_yyyy))//trim(adjustl(st_mm))//trim(adjustl(st_dd))&
                    //trim(adjustl(ed_yyyy))//trim(adjustl(ed_mm))//trim(adjustl(ed_dd))&
                    //trim(adjustl(ed_hh)),EXIST=ALIVE)
       if (ALIVE) then
         print*,'iteration=',it_count
         
         command2='mv  '//trim(adjustl(PATH_GRAPES_CUACE))//'savedat'//trim(adjustl(st_yyyy))//&
                       '* '//trim(adjustl(PATH_GRAPES_CUACE))//'savedat_'//trim(adjustl(it_counter))
         status=system(command2)
!         if ( status .ne. 0 ) then
!            print*,'ERROR mv savedat SAVEDAT/it_counter'
!         stop 
!         endif        
       endif 

!------------
! Before Run GRAPES-CUACE-ADJ, save last emissinb results

      INQUIRE(file=trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/emissionb_BC.grd',EXIST=ALIVE)
       if (ALIVE) then         
         command5='mv  '//trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/emissionb_BC.grd '&
                       //trim(adjustl(PATH_GRAPES_CUACE_ADJ))//'result_data/emissionb_BC_'//trim(adjustl(it_counter))//'.grd'
         status=system(command5)
!         if ( status .ne. 0 ) then
!            print*,'ERROR mv emissionb_BC.grd emissionb_BC.grd/it_counter'
!         stop 
!         endif        
       endif     

      it_count=it_count+1      
      write(it_counter,'(i2)')it_count  ! iteration times

      open(10,file='./it_count.txt')
          write(10,*) it_count
      close(10)
         
!     go back to the minimization routine.
         goto 111
      
      elseif (task(1:5) .eq. 'NEW_X')  then
!     the minimization routine has returned with a new iterate,
!     and we have opted to continue the iteration.

         DO k=levs,leve
           DO i=its,ite
             DO j=jts,jte
                sigma(i,j,k)=x((j-jts)+(i-its)*jte+(k-levs)*jte*ite+1)
             ENDDO
           ENDDO
        ENDDO

!     go back to the minimization routine.
         goto 111

      end if


      DEALLOCATE ( g, STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'g memory deallocation failed'
      END IF

      DEALLOCATE ( x, STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'x memory deallocation failed'
      END IF

      DEALLOCATE ( lgrid, STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'lgrid memory deallocation failed'
      END IF

      DEALLOCATE ( sb_trans, STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'sb_trans memory deallocation failed'
      END IF
      
      DEALLOCATE ( xb, STAT = ALLOCSTAT )
      IF ( ALLOCSTAT .NE. 0 ) THEN
         print*, 'xb memory deallocation failed'
      END IF

!-----------------------------------------------------------------------
101 FORMAT(23(41E20.10/))
      end
