;***********************************************************
; FUNCTIONS FOR MULTIVARIABLE EVALUATION TOOL
;***********************************************************
; To report bugs or make suggestions, please send emails at:
;  zhangmengzhuo1996@163.com , xuzhf@tea.ac.cn
;***********************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;***********************************************************
undef ("Get_Mvars")
; Get the number of scalar/vector variables for evaluation (M),
;  and their dimensions. Check var weighting.
;-----------------------------------------------------------
function Get_Mvars( Varname, Wgt_var) 
local Varname,Wgt_var,Var_names,Nvar,M,iVec,Nparen1,Nparen2,\
      i,ivar,iL,Mvar_D,iM,Wgt_var0,j,k,M_wgt,iD
;-----------------------------------------------------------
begin
   Var_names = str_split(Varname,",")
   Nvar      = dimsizes(Var_names)

   M = 0
   iVec = False

   Nparen1 = 0
   Nparen2 = 0

   do i = 0,(Nvar-1)
      ivar := str_split_by_length(Var_names(i),1)
      iL = dimsizes(ivar)

      if (ivar(0).eq."(") then
         Nparen1 = Nparen1 + 1
      end if
      if (ivar(iL-1).eq.")") then
         Nparen2 = Nparen2 + 1
      end if

      if (iVec) then
         if (ivar(iL-1).eq.")") then
            iVec = False
         end if
      else
         M = M + 1
         if (ivar(0).eq."(") then
            iVec = True
         end if
      end if
   end do 

   if (Nparen1.ne.Nparen2) then
      print("****Calculate_MVIE error: error of parentheses in Varname !") 
      exit
   end if

   Mvar_D = new(M,integer)
   Mvar_D = 0

   iM = 0 
   iVec = False

   do i = 0,(Nvar-1)
      ivar := str_split_by_length(Var_names(i),1)
      iL = dimsizes(ivar)

      if (iVec) then
         Mvar_D(iM) = Mvar_D(iM) + 1

         if (ivar(iL-1).eq.")") then
            iVec = False
            iM = iM + 1
            Var_names(i) = str_concat(ivar(0:(iL-2)))
         end if
      else
         if (ivar(0).eq."(") then
            Mvar_D(iM) = Mvar_D(iM) + 1
            iVec = True
            Var_names(i) = str_concat(ivar(1:(iL-1)))
         else
            Mvar_D(iM) = 1
            iM = iM + 1
         end if
      end if
   end do 

   VarWgt_str = new(M,string)

   if (dimsizes(Wgt_var).ne.1.) then
      if (M.eq.1) then
         print("****Calculate_MVIE warning: Wgt_var is invalid because "+ \
               "there is only one scalar or vector variable for evaluation !")
         M_wgt = 1.
      else
         if (dimsizes(Wgt_var).ne.Nvar) then
            print("****Calculate_MVIE error: the num of Wgt_var should "+ \
                  "match with the num of variables in Varname !")
            exit
         end if

         i = 0
         do j = 0,(M-1)
            VarWgt_str(j) = Var_names(i)
            if (Mvar_D(j).gt.1) then
               do k = 1,(Mvar_D(j)-1)
                  if (Wgt_var(i).ne.Wgt_var(i+k)) then
                     print("****Calculate_MVIE error: Weight of "+(i+k+1)+"-th variable "+ \
                           "should be the same with "+(i+1)+"-th variable in Wgt_var !")       
                     exit
                  end if
                  VarWgt_str(j) = VarWgt_str(j)+","+Var_names(i+k)
               end do 
               i = i + Mvar_D(j)
            else
               i = i + 1
            end if
            VarWgt_str(j) = VarWgt_str(j)+":"
         end do

         Wgt_var0 = Wgt_var/sum(Wgt_var) 

         M_wgt = new(M,typeof(Wgt_var))

         iD = 0
         do i = 0,(M-1)
            M_wgt(i) = Wgt_var0(iD)
            iD = iD + Mvar_D(i)
         end do  
      end if
   else
      M_wgt = 1
   end if

   return([/Var_names,Nvar,M,Mvar_D,M_wgt,VarWgt_str/]) 
end  
;***********************************************************
undef("ReadVars")
; Read variables with no coordinates to fixed format
;-----------------------------------------------------------
function ReadVars( filename, var_name, typ_d)
local filename,var_name,typ_d,Nvar,f,i,iVar,D,Nspacetime,data
;-----------------------------------------------------------
begin
   Nvar = dimsizes(var_name)

   if (ismissing(systemfunc("ls "+filename))) then
      print("****Calculate_MVIE error: cannot find "+filename+" !")
      exit
   end if

   f = addfile(filename, "r")

   if (any(.not.isfilevar(f,var_name))) then
      print("****Calculate_MVIE error: cannot find all variables evaluated in " \
            +filename+" !")
      exit
   end if

   do i = 0,(Nvar-1)
      if (isshort(f->$var_name(i)$)) then
         iVar := short2flt(f->$var_name(i)$)

         if (typ_d .eq. "double") then
            iVar := flt2dble(iVar)
         end if
      else       
         iVar := totype(f->$var_name(i)$, typ_d)
      end if

      if (i.eq.0) then
         D = dimsizes(iVar)
         Nspacetime = product(D)
         data = new((/Nvar,Nspacetime/),typ_d)
      else
         if ((dimsizes(dimsizes(iVar)).ne.dimsizes(D)).or. \
               any(dimsizes(iVar).ne.D)) then
            print("Claculate_MVIE error: dimsize of "+var_name(i)+ \
                  " does not match that of "+var_name(0)+" in "+filename+" !")
            exit
         end if
      end if

      data(i,:) = reshape(iVar, Nspacetime)      
   end do

   return(data)
end 
;***********************************************************
undef("ReadVars_Coord")
; Read variables with 1D/2D/3D coordinate to fixed format
;-----------------------------------------------------------
function ReadVars_Coord( filename, var_name, isC_time, \
                              isC_geo,isarea_wgt,haslev,typ_d)
local filename,var_name,isC_time,isC_geo,isarea_wgt,haslev,typ_d, \
      Nvar,f,C_name,nC,C_range,TIME_R,time,TIME0,iCrood,i, lev,\
      iVar,D,Nspacetime,data,ind_lat,lat,Wgt_lat,Area_wgt,var_lev
;-----------------------------------------------------------
begin
   Nvar = dimsizes(var_name)

   if (ismissing(systemfunc("ls "+filename))) then
      print("****Calculate_MVIE error: cannot find "+filename+" !")
      exit
   end if

   f = addfile(filename, "r")

   if (any(.not.isfilevar(f,var_name))) then
      print("****Calculate_MVIE error: cannot find all variables evaluated in file " \
            +filename+" !")
      exit
   end if

   if (isC_time) then
      C_name = isC_time@name
   end if
   if (isC_geo) then
      if (isC_time) then
         C_name := array_append_record(C_name,isC_geo@name,0)
      else
         C_name = isC_geo@name
      end if
   end if

   nC = dimsizes(C_name)
   C_range = new((/2,nC/),double)
   
   if (isC_time) then
      if (isstring(isC_time@range)) then
         TIME_R = isC_time@range
         if (.not.isfilevar(f,C_name(0))) then
            print("****Calculate_MVIE error: cannot find variable "+ \
                     C_name(0)+" in "+filename+" !")
            exit
         end if

         time  = f->$C_name(0)$
         
         if (strlen(TIME_R(0)).eq.6) then
            TIME0 = cd_calendar(time,1)
         end if
         if (strlen(TIME_R(0)).eq.8) then
            TIME0 = cd_calendar(time,2)
         end if
         if (strlen(TIME_R(0)).eq.10) then
            TIME0 = cd_calendar(time,3)
         end if

         if (.not.isvar("TIME0")) then
            print("****Calculate_MVIE error: when Range_time is string, it should "+ \
                  "have the format as 'YYYYMM', 'YYYYMMDD', or 'YYYYMMDDHH' !")
            exit
         end if

         if (ismissing(ind(TIME_R(0).eq.TIME0))) then
            print("****Calculate_MVIE error: cannot find "+TIME_R(0)+" in "+C_name(0)+ \
                  " coordinate in "+filename+" !")
            exit
         end if
         if (ismissing(ind(TIME_R(1).eq.TIME0))) then
            print("****Calculate_MVIE error: cannot find "+TIME_R(1)+" in "+C_name(0)+ \
                  " coordinate in "+filename+" !")
            exit
         end if
         
         C_range(0,0) = time(ind(TIME_R(0).eq.TIME0))
         C_range(1,0) = time(ind(TIME_R(1).eq.TIME0))
      else
         C_range(:,0) = isC_time@range
      end if

      if (isC_geo) then
         C_range(:,1:) = isC_geo@range
      end if   
   else
      C_range = isC_geo@range
   end if

   if (isstring(haslev)) then
      if (.not.isfilevar(f,haslev)) then
         print("****Calculate_MVIE error: cannot find "+haslev+" in file "+filename+" !")    
         exit
      end if

      var_lev = haslev@VarLev
      lev = f->$haslev$
   end if
 
   do i = 0,(Nvar-1)
      do iC = 0,(nC-1)
         if (.not.isfilevarcoord(f,var_name(i),C_name(iC))) then
            print("****Calculate_MVIE error: cannot find coordinate "+C_name(iC)+ \
                     " in "+var_name(i)+" of "+filename+" !")
            exit
         end if
      end do

      if (i.eq.0) then   
         iVar := f->$var_name(i)$

         do iC = 0,(nC-1)
            iCrood := iVar&$C_name(iC)$
            if ((max(C_range(:,iC)).lt.(min(iCrood))) .or. \
               (min(C_range(:,iC)).gt.(max(iCrood)))) then
               print("****Calculate_MVIE error: range of "+C_name(iC)+" are out of "+ \
                     "coordinate of vars in "+filename+" !")
               exit
            end if
         end do
      end if 

      if (islogical(haslev)) then
         if (dimsizes(getfilevardims(f,var_name(i))).ne.nC) then
            print("****Calculate_MVIE error: Num of dimensions in var:"+var_name(i)+" in file ("+\
               filename+" does not match input Var Dimension&Coordinate information !")
            exit
         end if
      else
         if ((dimsizes(getfilevardims(f,var_name(i))).ne.nC).and.\
            (dimsizes(getfilevardims(f,var_name(i))).ne.(nC+1))) then
            print("****Calculate_MVIE error: Num of dimensions in var:"+var_name(i)+" in file ("+\
               filename+" does not match input Var Dimension&Coordinate information !")
            exit
         end if
      end if     
   end do

   do i = 0,(Nvar-1)
      if (isstring(haslev).and.iscoord(f->$var_name(i)$, haslev)) then
         if (ismissing(ind(tointeger(var_lev(i)).eq.tointeger(lev)))) then
            print("****Calculate_MVIE error: cannot find '"+haslev+"="+var_lev(i)+"' in "\
                   +var_name(i)+" of "+filename+" !")
            exit
         else
            if (nC.eq.1) then
               iVar := f->$var_name(i)$({$haslev$|var_lev(i):var_lev(i)},{$C_name$|C_range(0,0):C_range(1,0)})
               iVar := iVar(0,:)
            end if
            if (nC.eq.2) then
               if (isC_time) then
                  iVar := f->$var_name(i)$({$C_name(0)$|C_range(0,0):C_range(1,0)},{$haslev$|var_lev(i):var_lev(i)},\
                                               {$C_name(1)$|C_range(0,1):C_range(1,1)})
                  iVar := iVar(:,0,:)
               else
                  iVar := f->$var_name(i)$({$haslev$|var_lev(i):var_lev(i)},{$C_name(0)$|C_range(0,0):C_range(1,0)},\
                                               {$C_name(1)$|C_range(0,1):C_range(1,1)})
                  iVar := iVar(0,:,:)
               end if
            end if
            if (nC.eq.3) then
               iVar := f->$var_name(i)$({$C_name(0)$|C_range(0,0):C_range(1,0)},{$haslev$|var_lev(i):var_lev(i)},\
                        {$C_name(1)$|C_range(0,1):C_range(1,1)},{$C_name(2)$|C_range(0,2):C_range(1,2)})
               iVar := iVar(:,0,:,:)
            end if
         end if
      else     
         if (nC.eq.1) then
            iVar := f->$var_name(i)$({$C_name$|C_range(0,0):C_range(1,0)})
         end if
         if (nC.eq.2) then
            iVar := f->$var_name(i)$({$C_name(0)$|C_range(0,0):C_range(1,0)},\
                                          {$C_name(1)$|C_range(0,1):C_range(1,1)})
         end if
         if (nC.eq.3) then
            iVar := f->$var_name(i)$({$C_name(0)$|C_range(0,0):C_range(1,0)},\
               {$C_name(1)$|C_range(0,1):C_range(1,1)},{$C_name(2)$|C_range(0,2):C_range(1,2)})
         end if
      end if

      if ((i.eq.0) .and. isstring(isarea_wgt)) then
         lat = iVar&$isarea_wgt$
      end if

      if (i.eq.0) then
         D = dimsizes(iVar)
         Nspacetime = product(D)
         data = new((/Nvar,Nspacetime/),typ_d)
      else
         if ((dimsizes(dimsizes(iVar)).ne.dimsizes(D)).or.\
               any(dimsizes(iVar).ne.D)) then
            print("****Calculate_MVIE error: dimsize of "+var_name(i)+ \
                  " does not match that of "+var_name(0)+" in "+filename+" !")
            exit
         end if
      end if

      if (isshort(iVar)) then
         iVar := short2flt(iVar)

         if (typ_d .eq. "double") then
            iVar := flt2dble(iVar)
         end if
      else       
         iVar := totype(iVar, typ_d)
      end if

      data(i,:) = totype(reshape(iVar,Nspacetime), typ_d)
   end do  

   if (isstring(isarea_wgt)) then 
      if (typeof(lat) .ne. typ_d) then
         lat := totype(lat, typ_d)
      end if
      lat!0 = "lat"

      Wgt_lat = latRegWgt(lat,typ_d,0)

      ind_lat   = ind(isarea_wgt.eq.C_name)
      Area_wgt  = conform_dims(D,Wgt_lat,ind_lat)
      Area_wgt := reshape(Area_wgt,Nspacetime)
   else
      Area_wgt = 1
   end if

   return([/data,Area_wgt/])
end 
;***********************************************************
undef("unif_missing_p")
; Uniform missing points of model data and Ref data
;-----------------------------------------------------------
function unif_missing_p( model, Ref, opt_Var )
local model,Ref,opt_Var,dim,mask0,i,model2,Ref2
;-----------------------------------------------------------
begin
   dim = dimsizes(model)
  
   if (dimsizes(dim).eq.1) then
      mask0 = new(dim,typeof(model))
      mask0 = 0
      mask0 = mask0 + model - model + Ref - Ref

      model2 = model + mask0
      Ref2   = Ref + mask0
   else
      if (opt_Var) then
         mask0 = new(dim(1), typeof(model))
         mask0 = 0
         
         do i = 0,(dim(0)-1)
            mask0 = mask0 + model(i,:) - model(i,:) + Ref(i,:) - Ref(i,:)
         end do

         model2 = model + conform_dims(dim, mask0, 1)
         Ref2   = Ref + conform_dims(dim, mask0, 1)
      else
         mask0 = new((/dim(0),dim(1)/), typeof(model))
         mask0 = 0
         mask0 = mask0 + model - model + Ref - Ref

         model2 = model + mask0
         Ref2   = Ref + mask0
      end if
   end if

   return([/model2,Ref2/])
end 
;***********************************************************
undef("VSCor")
; Centered(opt=0)/ uncentered(opt=1) vector similarity correlation
;-----------------------------------------------------------
function VSCor( model, Ref, opt[1]:integer, area_wgt )
local model,Ref,opt,area_wgt,model2,Ref2,dim,VSC
;-----------------------------------------------------------
begin
   if (opt.eq.0) then
      if (dimsizes(area_wgt).eq.1) then
         model2 = dim_rmvmean(model)
         Ref2   = dim_rmvmean(Ref)
      else
         dim = dimsizes(model)

         model2 = model - conform_dims(dim,dim_avg_wgt(model,area_wgt,1),0)
         Ref2   = Ref - conform_dims(dim,dim_avg_wgt(Ref,area_wgt,1),0)
      end if
   else
      model2 = model
	   Ref2   = Ref
   end if

   if (dimsizes(area_wgt).eq.1) then
      VSC = sum(dim_avg(model2*Ref2))/sqrt(sum(dim_avg(model2^2))*sum(dim_avg(Ref2^2)))
   else
      VSC = sum(dim_avg_wgt(model2*Ref2,area_wgt,1))/ \
            sqrt(sum(dim_avg_wgt(model2^2,area_wgt,1))*sum(dim_avg_wgt(Ref2^2,area_wgt,1)))
   end if
   
   return(VSC)
end
;***********************************************************
undef("RMSLength")
; Centered(opt=0) / uncentered(opt=1) root mean square length
;-----------------------------------------------------------
function RMSLength( model, opt[1]:integer, area_wgt )
local model,opt,area_wgt,model2,RMSL
;-----------------------------------------------------------
begin
   if (opt.eq.0) then
      if (dimsizes(area_wgt).eq.1) then
         model2 = dim_rmvmean(model)
      else
         model2 = model - conform_dims(dimsizes(model),dim_avg_wgt(model,area_wgt,1),0)
      end if
   else
      model2 = model
   end if
   
   if (dimsizes(area_wgt).eq.1) then
      RMSL = sqrt(sum(dim_avg(model2^2)))
   else
      RMSL = sqrt(sum(dim_avg_wgt(model2^2,area_wgt,1)))
   end if

   return(RMSL)
end
;***********************************************************
undef("RMSVDiff")
; Centered(opt=0) / uncentered(opt=1) root mean square vector difference
;-----------------------------------------------------------
function RMSVDiff( model, Ref, opt[1]:integer, area_wgt)
local model,Ref,opt,area_wgt,model2,Ref2,dim,RMSVD
;-----------------------------------------------------------
begin
   if (opt.eq.0) then
      if (dimsizes(area_wgt).eq.1) then
         model2 = dim_rmvmean(model)
         Ref2   = dim_rmvmean(Ref)
      else
         dim = dimsizes(model)

         model2 = model - conform_dims(dim,dim_avg_wgt(model,area_wgt,1),0)
         Ref2   = Ref - conform_dims(dim,dim_avg_wgt(Ref,area_wgt,1),0)
      end if
   else
      model2 = model
	   Ref2   = Ref
   end if

   if (dimsizes(area_wgt).eq.1) then
      RMSVD = sqrt(sum(dim_avg((model2-Ref2)^2)))
   else
      RMSVD = sqrt(sum(dim_avg_wgt((model2-Ref2)^2,area_wgt,1)))
   end if
     
   return(RMSVD)
end
;***********************************************************
undef("VecMError")
; Vector mean error(VME) or mean error of vector magnitude (MEVM)
;-----------------------------------------------------------
function VecMError( model, Ref, area_wgt, opt_VME)
local model,Ref,area_wgt,opt_VME,dim,ME,VME,MEVM
;-----------------------------------------------------------
begin
   dim = dimsizes(model)

   if (dim(0).eq.1) then
      if (dimsizes(area_wgt).eq.1) then
         ME = dim_avg(model)-dim_avg(Ref)
      else
         ME = dim_avg_wgt(model,area_wgt,1)-dim_avg_wgt(Ref,area_wgt,1)
      end if

      return(ME)
   else
      if (opt_VME.eq.1) then
         if (dimsizes(area_wgt).eq.1) then
            VME = sqrt(sum((dim_avg(model)-dim_avg(Ref))^2))
         else
            VME = sqrt(sum((dim_avg_wgt(model,area_wgt,1)- \
                        dim_avg_wgt(Ref,area_wgt,1))^2))
         end if

         return(VME)
      else
         if (dimsizes(area_wgt).eq.1) then
            MEVM = avg(sqrt(dim_avg_n(model^2,0))-sqrt(dim_avg_n(Ref^2,0)))
         else
            MEVM = dim_avg_wgt(sqrt(dim_avg_n(model^2,0))-sqrt(dim_avg_n(Ref^2,0)), \
                     area_wgt,1)
         end if
   
         return(MEVM)
      end if
   end if
end
;***********************************************************
undef("AzimuthM") 
; Azimuth for model referring to ref
;-----------------------------------------------------------
function AzimuthM(model, Ref)
local model,Ref,Ang_ref,dim,model_toref,Ang
;-----------------------------------------------------------
begin
   Ang_ref = atan2(Ref(1,:), Ref(0,:))

   dim = dimsizes(model)
   model_toref = new((/dim(0),dim(1)/),typeof(model))
   model_toref(0,:) = model(0,:)*cos(Ang_ref)+model(1,:)*sin(Ang_ref)
   model_toref(1,:) = model(1,:)*cos(Ang_ref)-model(0,:)*sin(Ang_ref)

   Ang = atan2(model_toref(1,:),model_toref(0,:))*180./get_pi(typeof(model))

   return Ang
end
;***********************************************************
undef("MEVecDir")
; Mean error of vector direction between model and ref
;-----------------------------------------------------------
function MEVecDir( model, Ref, area_wgt )
local model,Ref,area_wgt,dim,angle,i,MEVD
;-----------------------------------------------------------
begin
   angle = AzimuthM(model, Ref)

   if (dimsizes(area_wgt).eq.1) then
      MEVD = dim_avg(angle)
   else
      MEVD = dim_avg_wgt(angle,area_wgt,1)
   end if

   return(MEVD)
end  
;***********************************************************
undef("Skill_score2")
; Skill scores (S1&S2) for individual scalar/vector field
;-----------------------------------------------------------
function Skill_score2( SD, CORR )
local SD,CORR,dim,S1,S2,R0,i
;-----------------------------------------------------------
begin
   dim = dimsizes(CORR)
   S1 = new(dim,typeof(SD))
   S2 = new(dim,typeof(SD))

   R0 = max(CORR)

   do i = 0,(dim-1)
      S1(i) = 4.*(1+CORR(i))/((SD(i)+1./SD(i))^2*(1+R0))
      S2(i) = 4.*(1+CORR(i))^4/((SD(i)+1./SD(i))^2*(1+R0)^4)
   end do

   return([/S1,S2/])
end
;***********************************************************
undef("Nor_matrix")
; Matrix for normalization and adding variable weighting 
;  for multivariable field
;-----------------------------------------------------------
function Nor_matrix( ref, Var_D, M_wgt, area_wgt )
local ref,Var_D,M_wgt,area_wgt,dim,M,M_nor,iD,ivar
;-----------------------------------------------------------
begin
   dim   = dimsizes(ref)
   M     = dimsizes(Var_D)
   M_nor = new(dim(0),typeof(ref))

   iD = 0  

   if (dimsizes(M_wgt).eq.1) then
      do ivar = 0,(M-1)
         M_nor(iD:(iD+Var_D(ivar)-1)) = 1./ RMSLength(ref(iD:(iD+Var_D(ivar)-1),:),1,area_wgt) 

         iD = iD + Var_D(ivar)
      end do
   else
      do ivar = 0,(M-1)
         M_nor(iD:(iD+Var_D(ivar)-1)) = M_wgt(ivar) / RMSLength(ref(iD:(iD+Var_D(ivar)-1),:),1,area_wgt)
                                                                               
         iD = iD + Var_D(ivar)
      end do
   end if

   return(conform_dims(dim,M_nor,0))
end
;***********************************************************
undef("Std_varWgt")
; Calculate rms_std / SD_std with variable weighting
;-----------------------------------------------------------
function Std_varWgt( ratio, M_wgt)
local ratio,M_wgt,ratio_avg,ratio_std
;-----------------------------------------------------------
begin
   ratio_avg = dim_avg_wgt(ratio,M_wgt,1)
   ratio_std = sqrt(dim_avg_wgt((ratio-ratio_avg)^2,M_wgt,1))
   
   return(ratio_std)
end
;***********************************************************
undef("MIEIndex")
; Calculate Multivariable Intergrated Evaluation Index (MIEI)
; Model and Ref data should be normalized and added variable 
;  weighting if choosing
;-----------------------------------------------------------
function MIEIndex( rms, VSC, M_wgt, F)
local rms,VSC,M_wgt,F,M,R_rms,i,MIEI2,MIEI
;-----------------------------------------------------------
begin
   M = dimsizes(rms)
   R_rms = new(M,typeof(rms))

   do i = 0,(M-1)
      if (rms(i).gt.1) then
         R_rms(i) = 1./rms(i)
      else
         R_rms(i) = rms(i)
      end if
   end do
         
   if (dimsizes(M_wgt).eq.1) then
      MIEI2 = avg((R_rms-1.)^2)+F*(1.-VSC)
   else
      MIEI2 = dim_avg_wgt((R_rms-1.)^2,M_wgt,1)+F*(1.-VSC)
   end if

   MIEI = where(MIEI2.lt.0., 0., sqrt(MIEI2))

   return(MIEI)
end  
;***********************************************************
undef("MISScore")
; Calculate Multivariable Intergrated Skill Score (MISS)
;-----------------------------------------------------------
function MISScore( rms, VSC, M_wgt, F)
local rms,VSC,M_wgt,F,MIEI,MISS
;-----------------------------------------------------------
begin
   MIEI = MIEIndex(rms,VSC,M_wgt,F)
   MISS = (F+1.-MIEI^2)/(F+1.)

   return(MISS)
end
;***********************************************************
undef("Pri_stat_range1")
; Print range of stats for individual scalar/vector field
;-----------------------------------------------------------
procedure Pri_stat_range1( stats, s, stats_names)
local stats,s,stats_names,List1,List2,header,cutter
;-----------------------------------------------------------
begin     
   if (dimsizes(stats_names).eq.3) then
      List1 = [/stats_names, \
               (/min(stats(0,:)),min(stats(1,:)),min(stats(2,:))/), \
               (/max(stats(0,:)),max(stats(1,:)),max(stats(2,:))/)/]
   else
      List1 = [/stats_names, \
               (/min(stats(0,:)),min(stats(1,:)),min(stats(2,:)),min(stats(3,:))/), \
               (/max(stats(0,:)),max(stats(1,:)),max(stats(2,:)),max(stats(3,:))/)/]
   end if

   List2 = [/(/"S1_cen", "S2_cen", "S1_uncen", "S2_uncen"/),\
            (/min(s(0,:)),min(s(1,:)),min(s(2,:)),min(s(3,:))/), \
            (/max(s(0,:)),max(s(1,:)),max(s(2,:)),max(s(3,:))/)/]
  
   header = (/"*********************************","*        Ranges of Stats        *","*********************************"/)
   cutter =   "---------------------------------"

   print_table([/header/],"%s")

   print_table([/cutter/],"%s")
   print_table(List1,"%-8s:%6.3f,%6.3f")

   print_table([/cutter/],"%s")
   print_table(List2,"%-8s:%6.3f,%6.3f")

   print_table([/cutter/],"%s")
end
;***********************************************************
undef("Pri_stat_range2")
; Print range of stats for multivariable integrated field
;-----------------------------------------------------------
procedure Pri_stat_range2( stats1, stats2, MISS, opt)
local stats1,stats2,MISS,opt,dim2,List1,List2,List3,List4,header,cutter
;-----------------------------------------------------------
begin
   dim2 = dimsizes(stats2)
  
   if (dim2(0).eq.5) then    
      ;centered stats
      List1 = [/(/"CORR", "cVSC", "MISS_cen", "MISS_uncen"/), \
               (/min(stats1(0,:,:)),min(stats2(0,:)),min(MISS(0,:)),min(MISS(1,:))/), \
               (/max(stats1(0,:,:)),max(stats2(0,:)),max(MISS(0,:)),max(MISS(1,:))/)/]

      List2 = [/(/"SD", "cRMSL"/), \
               (/min(stats1(1,:,:)),min(stats2(1,:))/), \
               (/max(stats1(1,:,:)),max(stats2(1,:))/)/]

      List3 = [/(/"SD_std", "cRMSD", "cRMSVD"/), \
               (/min(stats2(2,:)),min(stats1(2,:,:)),min(stats2(3,:))/), \
	            (/max(stats2(2,:)),max(stats1(2,:,:)),max(stats2(3,:))/)/]

      List4 = [/(/"ME", where(opt.eq.1, "VME", "MEVM")/), \
               (/min(stats1(3,:,:)),min(stats2(4,:))/), \
	            (/max(stats1(3,:,:)),max(stats2(4,:))/)/]	               
   else                      
      ;uncentered stats
      List1 = [/(/"uCORR", "VSC", "MISS_cen", "MISS_uncen"/), \
               (/min(stats1(0,:,:)),min(stats2(0,:)),min(MISS(0,:)),min(MISS(1,:))/), \
               (/max(stats1(0,:,:)),max(stats2(0,:)),max(MISS(0,:)),max(MISS(1,:))/)/]

      List2 = [/(/"rms", "RMSL"/), \
               (/min(stats1(1,:,:)),min(stats2(1,:))/), \
               (/max(stats1(1,:,:)),max(stats2(1,:))/)/]

      List3 = [/(/"rms_std", "RMSD", "RMSVD"/), \
               (/min(stats2(2,:)),min(stats1(2,:,:)),min(stats2(3,:))/), \
	            (/max(stats2(2,:)),max(stats1(2,:,:)),max(stats2(3,:))/)/]
   end if

   header = (/"*********************************","*        Ranges of Stats        *","*********************************"/)
   cutter =   "---------------------------------"

   print_table([/header/],"%s")

   print_table([/cutter/],"%s")
   print_table(List1,"%-10s:%6.3f,%6.3f")

   print_table([/cutter/],"%s")
   print_table(List2,"%-10s:%6.3f,%6.3f")

   print_table([/cutter/],"%s")
   print_table(List3,"%-10s:%6.3f,%6.3f")

   print_table([/cutter/],"%s")

   if (dim2(0).eq.5) then 
      print_table(List4,"%-10s:%6.3f,%6.3f")
      print_table([/cutter/],"%s") 
   end if   
end
;***********************************************************
