;####################################################################
; PLOT SCRIPT FOR VFE DIAGRAM AND METRICS TABLE
;    BEFORE RUN THIS SCRIPT, CALCULATE SCRIPT HAS BEEN RUN.
;####################################################################
; Plot VFE diagram and/or metrics table            
;********************************************************************
; Statistics for VFE diagram:
; ----------------------------------------------------------------------
; |                             | Stats           | Dimsizes of input  |
; ----------------------------------------------------------------------
; | Individual scalar variables | uCORR, SD       | [Ncase] x [Nvar]   |
; |                             |-----------------|                    |
; |                             | CORR, rms       |                    |   
; ----------------------------------------------------------------------
; | Individual vector variable  | cVSC, cRMSL     | [Ncase]            |
; |                             |-----------------|                    |
; | / Multivariable field       | VSC, RMSL       |                    | 
; ----------------------------------------------------------------------
; Statistics that can be shown in metrics table:
; ----------------------------------------------------------------------------
; |                     | Stats                          | Dimsizes of input |
; ----------------------------------------------------------------------------
; | Individual variables| uCORR,rms,RMSD,SD,CORR,cRMSD,  | [Ncase] x [Nvar]  |
; |                     | ME(MEVD)                       |                   |
; ---------------------------------------------------------------------------
; | Multivariable field | VSC,RMSL,RMSVD,rms_std,cVSC,   | [Ncase]           |
; |                     | cRMSL,cRMSVD,SD_std,VME/MEVM   |                   |
; ----------------------------------------------------------------------------
; | Index for summary   | cMISS,uMISS                    | [Ncase]           |   
; ----------------------------------------------------------------------------
; [Ncase] - num of cases
;           - if num of obs is 1, cases are all models
;           - if num of obs is greater than 1, case are models and obs
; [Nvar]  - num of variables
;********************************************************************
; Users control the plotting by modifying codes for user at the 
;   beginning of this script.
;********************************************************************
; Please report bugs to: zhangmengzhuo1996@163.com or xuzhf@tea.ac.cn
;
;####################################################################
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "./function/VFE_diagram.ncl"
load "./function/metrics_table.ncl"
begin
;              **********************************
;              * namelist to be edited by users *
;              **********************************
;============== user's editing starts here ===========================================================
 Model_names          =            ;Names for models (array of str) 

 Obs_names            =            ;Names for observation / reanalysis datasets

 Plot_VFE_diagram     =         	  ;Plot Taylor/VFE diagram [True] or not [False] 
 
 Plot_metrics_table   =            ;Plot metrics table [True] or not [False]

;------ configuration for VFE diagram when 'Plot_VFE_diagram = True' ---------------------------------
 MVIE_filename1       =            ;Name of NetCDF file for plotting VFE diagram (str)

 stats_metrics1       =            ;Stat names in 'MVIE_filename1' used for VFE diagram (two str) [default: (/"RMSL","VSC"/)]

 ivar                 =            ;If stat in 'stats_metrics1' has dimsize as Ncase x Nvar, plot ivar-var for VFE diagram (int) [default: 0]

 filename_VFE         =            ;Filename of Taylor/VFE diagram (str) [default:"MVIE.diagram"]

 pltType_VFE          =            ;Image storage format:"ps"/"eps"/"pdf"/"png" (str) [default:"eps"]

 opt_VFE              =            ;Use VFE diagram attributes [True] or not [False: default]?  
                     ;Below arguments are valid under 'opt_VFE = True'

 opt_VFE@tiMainString         =            ;Diagram title (str) [default: not draw]

 opt_VFE@tiMainFontHeightF    =            ;Font height of diagram title (numeric value) [default: 0.0225]

 opt_VFE@xyMax                =            ;Max value of axis (numeric value) [have default]

 opt_VFE@xyFontHeightF        =            ;Font height for axis (numeric value) [default: 0.0175]

 opt_VFE@OneX                 =            ;X-axis label at one point (str) [default: "REF"]

 opt_VFE@tiYAxisString        =            ;Y-axis string (str) [default: "RMSL"]

 opt_VFE@CorLabel             =            ;Arc label (str) [default: "Similarity"]

 opt_VFE@stnRad               =            ;Standard radius for RMSL (array of numeric values) [default: not draw]

 opt_VFE@ccRays               =            ;Radial lines for VSC (array of numeric values) [default: not draw]

 opt_VFE@centerDiffRMS        =            ;Draw radii from REF [True] or not [False: default]

 opt_VFE@MarkersOn            =            ;Draw markers to represent models and/or obs [True] or not [False: default]?
                               ;below are valid under 'opt_VFE@MarkersOn = True'
 opt_VFE@MarkersIndex         =            ;Marker types for models and observations/reanalysis (array of 1/2 values) [default:(/4,8/)]

 opt_VFE@gsMarkerThicknessF   =            ;Marker thinckness (numeric value) [default: 1.0] 

 opt_VFE@gsMarkerSizeF        =            ;Marker size (numeric value) [default: 0.0085]

                               ;above are valid under 'opt_VFE@MarkersOn = True'

 opt_VFE@Colors               =            ;Colors of points [have default] 
                                                ;Three types to set. See readme.namelist or User Guide 

 opt_VFE@CountTxOn           =             ;Add text for count of points [True: default] or not [False]?

                              ;below are valid under 'opt_VFE@markerTxOn = True'
 opt_VFE@CountFontHeightF    =             ;Textfont height for count of points (numeric value) [default:0.0085]
                              
 opt_VFE@CountTxXOffset      =             ;X distance between point markers and point text (numeric value) [default: 0.015]
                              
 opt_VFE@CountTxYOffset      =             ;Y distance between point markers and point text (numeric value) [default:0.015]
                              ;above are valid under 'opt_VFE@markerTxOn = True'

 plot_std_l                   =            ;Plot rms_std/SD_std line [name of rms_std/SD_std in 'MVIE_filename1'] or not [False: default]?

 opt_VFE@DatatypeLegendOn     =            ;Draw data type Legend [True] or not [False: default]?

                              ;below are valid under 'opt_VFE@DatatypeLabelsOn = True'
 opt_VFE@DatatypeLegend       =            ;Legend of data type (array of 1/2 str) [default:(/"Models","Renalysis"/)]
                              
 opt_VFE@DatatypeLegendFontHeightF =       ;Data type Legend font height (numeric value) [default: 0.05]
                              
 opt_VFE@DatatypeLegendWidth  =            ;Width of data type Legend (numeric value) [default: 0.1]
                              
 opt_VFE@DatatypeLegendHeight =            ;Height of data type Legend (numeric value) [default: 0.1]

 opt_VFE@DatatypeLegendXL     =            ;X strat location of legend [default: 0.8]

 opt_VFE@DatatypeLegendYL     =            ;Y strat location of legend [default: 0.9]
                              ;above are valid under 'opt_VFE@DatatypeLabelsOn = True'

 plot_caselabels              =            ;Show caselabels on [True] or not [False: dafault]?

 opt_VFE@caseLabelsFontHeightF =           ;Font height of caselabels (numeric value) [default: 0.013]
                              ;below are valid under 'plot_caselabels = True' 
 opt_VFE@caseLabelsYinterval  =            ;Y interval between two cases in caselabels (numeric value) [default: 0.06]

 opt_VFE@caseLabelsXloc       =            ;X strat location of caselabels (numeric value) [default: 0.125]

 opt_VFE@caseLabelsYloc       =            ;Y strat location of caselabels (numeric value) [default: 0.3]
                              ;above are valid under 'plot_caselabels = True' 

 opt_VFE@obsUncer             =            ;The value to measure observational uncertainty (numeric value) [default: not set]
                                                   ;which is as the length of red horizontal bar centered at (1,0) 

 opt_VFE@draw_grid            =            ;Draw grid lines on wks [True] or not [False: default]?

;------ configuration for metrica table when 'Plot_metrics_table = True' ---------------------------------
 MVIE_filenames2       =            ;Name of NetCDF file(s) stored metrics for metrics table  (str / an array of str: up to 4)

 Var_names             =            ;Names for individual scalar or vector variables (array of str)
      
 zoom                  =            ;Width (Height) of metrics table when when 'opt_metrics@CaseLocation="Left"("Top") '(numeric value) [default: 0.95]  

 file_metrics          =            ;Name of output metrics table (str) [default: "metrics_table"]

 stats_metrics2        =            ;Statistics chosen for metrics table (array of str) [default: all variables in file]

 opt_metrics           =            ;Use metrics table attributes [True] or not [False: default]?
                        ;Below arguments are valid under 'opt_metrics = True'

 opt_metrics@pltType          =           ;Image storage format:"ps"/"eps"/"pdf"/"png" (str) [default:"eps"]

 opt_metrics@wkOrientation    =           ;PS or PDF output produced in ["portrait": default]/"landscape" 

 opt_metrics@RMSlevs          =           ;RMS levels for SD/rms, cRMSL/RMSL (array of numeric values) [have default]

 opt_metrics@MElevs           =           ;ME levels for ME, VME/MEVM (array of numeric values) [have default] 

 opt_metrics@RMSDlevs         =           ;RMSD levels for cRMSD/RMSD, cRMSVD/RMSVD, SD_std/rms_std (array of numeric values) [have default]

 opt_metrics@CORRlevs         =           ;CORR levels for CORR/uCORR, cVSC/VSC, cMISS, MISS (array of numeric values) [have default]
 
 opt_metrics@RMScmap          =           ;Colormap for RMS levels [have default], valid under setting 'RMSlevs'
                                                ;five ways to set colormap, please refer to readme.namelist.NCL-v or User Guide
 opt_metrics@MEcmap           =           ;Colormap for ME levels [have default], valid under setting 'MElevs'

 opt_metrics@RMSDcmap         =           ;Colormap for RMSD levels [have default], valid under setting 'RMSDlevs'

 opt_metrics@CORRcmap         =           ;Colormap for CORR levels [have default], valid under setting 'CORRlevs'

 opt_metrics@CaseLocation     =           ;Location of caselabels ["Top": default]/"Left" 
                              ;below are valid under 'opt_metrics@CaseLocation = "Left"'
 opt_metrics@titleHeight      =           ;Height of title box (numeric value) [default: 0.08]

 opt_metrics@titleWidth       =           ;Width of title box (numeric value) [default: 0.1]

 opt_metrics@caseHeight       =           ;Height of case box (numeric value) [default:0.035] 
                              ;above are valid under 'opt_metrics@CaseLocation = "Left"'
                              ;below are valid under 'opt_metrics@CaseLocation = "Top"'                              
 opt_metrics@varWidth         =           ;Width of var box (numeric value) [default: 0.07]

 opt_metrics@caseWidth        =           ;Width of case box(numeric value) [default: 0.1]
	          
 opt_metrics@caseHeight       =           ;Height of case box(numeric value) [default:0.02]  
                              ;above are valid under 'opt_metrics@CaseLocation = "Top"'

 opt_metrics@titleTHeight     =           ;Text font height of title (numeric value) [default: 0.015]

 opt_metrics@caseTHeight      =           ;Text font height of case-labels (numeric value) [default: 0.0075]

 opt_metrics@statsTHeight     =           ;Text font height of statistic-label (numeric value) [default: 0.0075] 

 opt_metrics@varTHeight       =           ;Text font height of var-lables (numeric value) [default: 0.0075]

 opt_metrics@metricsTHeight   =           ;Text font height of metrics (numeric value) [default: 0.006]
	
 opt_metrics@TitleBackgroundcolor =       ;Background color for title (str/int/RGB(RGBA) array) [default: "CornflowerBlue"]
                                                ;three ways to set color, please refer to readme.namelist.NCL-v or User Guide
 opt_metrics@VarBackgroundcolor =         ;Background color for case/ststs/var (str/int/RGB(RGBA) array) [default: "Gray70"]

 opt_metrics@tableTitle       =           ;Title of table (str) [default: "METRICS"]

 opt_metrics@showTextOn       =           ;Show performance metrics on [True: default] or not [False]?

 opt_metrics@plotMEVD         =           ;Plot MEVD when ME is plotted and MEVD is in files [True] or not [False: default]?

 opt_metrics@decialMetricsN   =           ;Number of decimal places for performance metrics (str) [default:"3.2"]
                                                ;valid under 'showTextOn = True'
 opt_metrics@decialBarN       =           ;Number of decimal places for colorbar marker (str) [default:"3.2"]
                                                ;valid under 'showTextOn = False'
 opt_metrics@colorbarFHeight  =           ;Colorbar font height (numeric value) [default:opt_metrics@varTHeight]
                                                ;valid under 'showTextOn = False'
 opt_metrics@box_legend       =           ;Draw legend for box (array of str for legend) or not [False: default]?

 opt_metrics@box_lgFontHeightF =          ;Text font height in box legend (numeric value) [opt_metrics@varTHeight*1.2]
                                                ;valid under setting 'box_legend'
 opt_metrics@box_lgheight     =           ;Height of box legend (numeric value) [have default]                                               
                                                ;valid under setting 'box_legend'
 opt_metrics@highlightsummary =           ;Enclose stats for summary, i.e.,cMISS,uMISS, with red box for emphasis [True: default] or not [False]?

 opt_metrics@draw_grid        =           ;draw grid on wks or not (a logical value) (False: default)
;============== user's editing ends here =============================================================

;************************
;* Check error for data *
;************************

   Header = (/"###################################","#      MVIETool v1.0 (NCL)        #", \
             "###################################"/)
   print_table([/Header/],"%s")

; Model names
   if ((.not.isvar("Model_names")).or.(.not.isstring(Model_names))) then
      print("Plot_MVIE error: cannot find Model_names, "+\
               "or Model_names is not string!")
      exit
   end if

; Obs names
   if ((.not.isvar("Obs_names")).or.(.not.isstring(Obs_names))) then
      print("Plot_MVIE error: cannot find Obs_names, "+\
               "or Obs_names is not string!")
      exit
   end if

; Plot VFE
   if (.not.isvar("Plot_VFE_diagram")) then
      print("Plot_MVIE error: Plot_VFE_diagram must be set with True or False !")
      exit
   else
      if ((.not.islogical(Plot_VFE_diagram)) .or. (.not.isscalar(Plot_VFE_diagram))) then
         print("Plot_MVIE error: Plot_VFE_diagram should be set with True or False !")
         exit
      end if
   end if

; Plot metrics table
   if (.not.isvar("Plot_metrics_table")) then
      print("Plot_MVIE error: Plot_metrics_table must be set with True or False !")
      exit
   else
      if ((.not.islogical(Plot_metrics_table)) .or. (.not.isscalar(Plot_metrics_table))) then
         print("Plot_MVIE error: Plot_metrics_table should be set with True or False !")
         exit
      end if
   end if

;************************
;* Plot for VFE diagram *
;************************
      
   if (Plot_VFE_diagram) then
      ;check datafile
      if ((.not.isvar("MVIE_filename1")).or.(.not.isstring(MVIE_filename1)) \
         .or.(.not.isscalar(MVIE_filename1))) then
         print("Plot_MVIE error: cannot find MVIE_filename1, or MVIE_filename1 is not a string !")
         exit
      end if
      if (ismissing(systemfunc("ls "+MVIE_filename1))) then 
         print("Plot_MVIE error: cannot find "+MVIE_filename1+" !")
         exit
      end if
      f_MVIE := addfile(MVIE_filename1, "r")

      ;number of models, obs and vars 
      Nmodel = dimsizes(Model_names)
      Nobs   = dimsizes(Obs_names)
      Ncase = where(Nobs.eq.1, Nmodel, Nmodel+Nobs)

      if (.not.isvar("opt_VFE")) then
         opt_VFE = False
      else
         if ((.not.islogical(opt_VFE)).or.(.not.isscalar(opt_VFE))) then
            print("Plot_MVIE error: opt_VFE should be a logical value !")
            exit
         end if
      end if   

      if isvar("Plot_caselabels") then
         if (.not.islogical(plot_caselabels)).or.(.not.isscalar(plot_caselabels)) then
            print("Plot_MVIE error: plot_caselabels should be a logical value !")
            exit
         end if
      else
         plot_caselabels = False
      end if

      ;set caselabels
      if (opt_VFE .and. plot_caselabels) then
         if (dimsizes(Obs_names).eq.1) then
            opt_VFE@caseLabels = Model_names
         else
            opt_VFE@caseLabels = array_append_record(Model_names,Obs_names,0)
         end if
      end if

      ;open workstation
      if (.not.isvar("filename_VFE")) then
         filename_VFE := "MVIE.diagram"
      else
         if ((.not.isstring(filename_VFE)).or.(.not.isscalar(filename_VFE))) then
            print("Plot_MVIE error: filename_VFE is not a string !")
            exit
         end if
      end if
      if (.not.isvar("pltType_VFE")) then
         pltType_VFE = "eps"
      else
         if ((.not.isstring(pltType_VFE)).or.(.not.isscalar(pltType_VFE))) then
            print("Plot_MVIE error: pltType_VFE is not a string !")
            exit
         else
            if ((pltType_VFE.ne."pdf").and.(pltType_VFE.ne."eps").and. \
               (pltType_VFE.ne."ps").and.(pltType_VFE.ne."png")) then
               print("Plot_MVIE error: pltType_VFE should be 'pdf', 'ps', 'eps', or 'png' !")
               exit
            end if
         end if
      end if
      wks = gsn_open_wks(pltType_VFE, filename_VFE)

      ;read stats
      if (.not.isvar("stats_metrics1")) then
         stats_metrics1 = (/"RMSL","VSC"/)
      else
         if ((.not.isstring(stats_metrics1)).or.(dimsizes(dimsizes(stats_metrics1)).ne.1) \
            .or.(dimsizes(stats_metrics1).ne.2)) then
            print("Plot_MVIE error: stats_metrics1 should be two strings !")
            exit
         end if
      end if

      if (isfilevar(f_MVIE,stats_metrics1(0)) .and. isfilevar(f_MVIE,stats_metrics1(1))) then
         stats1 = f_MVIE->$stats_metrics1(0)$
         stats2 = f_MVIE->$stats_metrics1(1)$
      else
         print("Plot_MVIE error: cannot find "+stats_metrics1(0)+","+stats_metrics1(1)+ \
               "in "+MVIE_filename1+" !")
         exit
      end if

      dim1  = dimsizes(stats1)
      dim2  = dimsizes(stats2)
      rank1 = dimsizes(dim1)
      rank2 = dimsizes(dim2)

      if ((rank1.gt.2).or.(rank2.gt.2).or.(rank1.ne.rank2)) then
         print("Plot_MVIE error: dimsizes of "+stats_metrics1(0)+" and "+stats_metrics1(1)+" in "+ \
               MVIE_filename1+" do not match !")
         exit
      end if
      if (rank1.eq.2) then
         if (.not.isvar("ivar")) then
            ivar = 0
         else
            if ((.not.isint(ivar)).or.(.not.isscalar(ivar))) then
               print("Plot_MVIE error: ivar should be a integer !")
               exit
            end if       
            if ((ivar.ge.dim1(1)).or.(ivar.ge.dim2(1))) then
               print("Plot_MVIE error: ivar is out of the range of  "+stats_metrics1(0)+ \
                     " or "+stats_metrics1(1)+" in "+MVIE_filename1+" !")
               exit
            end if
         end if
      end if

      if ((.not.ismissing(ind(stats_metrics1(1).eq.(/"VSC","cVSC","CORR","uCORR"/)))).or. \
         ((max(stats2).le.1.).and.(max(stats1).gt.1.))) then
         if (rank1.eq.2) then
            RATIO = stats1(:,ivar) 
            Rv = stats2(:,ivar)
         else 
            RATIO = stats1 
            Rv = stats2
         end if
      else
         if (rank1.eq.2) then
            RATIO = stats2(:,ivar) 
            Rv = stats1(:,ivar)
         else 
            RATIO = stats2
            Rv = stats1 
         end if
      end if

      if ((dimsizes(RATIO).lt.Ncase).or.(dimsizes(Rv).lt.Ncase)) then
         print("Plot_MVIE error: the case-dimension of "+stats_metrics1(0)+" or/and "+stats_metrics1(1)+\
            " is less than the number of case summed by 'Obs_names' and 'Model_names' !")
         exit
      end if
      if ((num(ismissing(RATIO)).ne.0).or.(num(ismissing(Rv)).ne.0)) then
         print("Plot_MVIE error:"+stats_metrics1(0)+" or/and "+stats_metrics1(1)+" has missing values !")
         exit
      end if
         
      ;std line
      if (isvar("plot_std_l")) then
         if (isstring(plot_std_l)) then
            if (isscalar(plot_std_l)) then
               if (isfilevar(f_MVIE,plot_std_l)) then
                  if (.not.opt_VFE) then
                     opt_VFE = True
                  end if
                  opt_VFE@stdline = f_MVIE->$plot_std_l$
               else
                  print("Plot_MVIE error: cannot find "+plot_std_l+" in "+ \
                        MVIE_filename1+" !")
                  exit
               end if
            else
               print("Plot_MVIE error: plot_std_l should be False or a string!")
               exit
            end if
         end if
      end if
                                 
      plot = VFE_diagram(wks,RATIO,Rv,Nmodel,Ncase,opt_VFE)

      Header := (/"|----------------------|","|      VFE diagram     |","|----------------------|"/)            
      print_table([/Header/],"%s") 
      print_table([/"*Create <"+filename_VFE+"."+pltType_VFE+">*"/],"%s")


      if ((dimsizes(RATIO).lt.Ncase).or.(dimsizes(Rv).lt.Ncase)) then
         print("Plot_MVIE error: "+stats_metrics1(0)+" or/and "+stats_metrics1(1)+" in "+ \
               MVIE_filename1+" do(es) not match Model_names and Obs_names !")
         exit
      end if
      RATIO := RATIO(0:(Ncase-1))
      Rv    := Rv(0:(Ncase-1))
   end if

;**************************
;* Plot for metrics table *
;**************************

   if (Plot_metrics_table) then 
      ;check datafile(s)
      if ((.not.isvar("MVIE_filenames2")).or.(.not.isstring(MVIE_filenames2))) then
         print("Plot_MVIE error: cannot find MVIE_filenames2, or MVIE_filenames2 is not string !")
         exit
      end if
      if (dimsizes(dimsizes("MVIE_filenames2")).ne.1) then
         print("Plot_MVIE error: MVIE_filenames2 should be 1-D array !")
         exit
      end if

      Nf = dimsizes(MVIE_filenames2)
      do i = 0,(Nf-1)
         if (ismissing(systemfunc("ls "+MVIE_filenames2(i)))) then 
            print("plot_MVIE error: cannot find "+MVIE_filenames2(i)+" !")
            exit
         end if
      end do

      ;check stats_metrics2 in datafile(s)
      if (.not.isvar("stats_metrics2")) then
         Stats_names := (/"cRMSD","SD","CORR","ME","RMSD","rms","uCORR", \
                           "cRMSVD","SD_std","cRMSL","cVSC","VME","MEVM", \
                           "RMSVD","rms_std","RMSL","VSC","cMISS","uMISS"/)
         
         if (Nf.eq.1) then
            f_MVIE := addfile(MVIE_filenames2, "r")

            do i = 0,dimsizes(Stats_names)
               if (isfilevar(f_MVIE,Stats_names(i))) then
                  if (isvar("stats_metrics2")) then
                     stats_metrics2 := array_append_record(stats_metrics2, Stats_names(i), 0)                 
                  else
                     stats_metrics2 = Stats_names(i)
                  end if
               end if
            end do
         else
            f_MVIE := addfiles(MVIE_filenames2, "r")
            ListSetType(f_MVIE, "join")

            do i = 0,dimsizes(Stats_names)
               if (isfilevar(f_MVIE[0],Stats_names(i))) then
                  is_istat = True

                  do j = 1,(Nf-1)
                     if (.not.isfilevar(f_MVIE[j],Stats_names(i))) then
                        is_istat = False
                     end if
                  end do

                  if (is_istat) then
                     if (isvar("stats_metrics2")) then
                        stats_metrics2 := array_append_record(stats_metrics2, Stats_names(i), 0)
                     else                
                        stats_metrics2 := Stats_names(i)
                     end if
                  end if
               end if
            end do
         end if 

         if (.not.isvar("stats_metrics2")) then
            print("Plot_MVIE error: find none of "+str_join(Stats_names, ",")+ \
                  " in datafile(s) of 'MVIE_filenames2' input!") 
            exit
         end if    
      else
         do j = 0,(Nf-1)
            f_MVIE := addfile(MVIE_filenames2(j),"r")
            if (any(.not.isfilevar(f_MVIE,stats_metrics2))) then
               print("Plot_MVIE error: cannot find all statistics listed in stats_metrics2 in "\
                     + MVIE_filenames2(j)+" !")
               exit
            end if
         end do
      end if

      ;var names
      if ((.not.isvar("Var_names")).or.(.not.isstring(Var_names)) \
         .or.(dimsizes(dimsizes(Var_names)).ne.1)) then
         print("Plot_MVIE error: cannot find Var_names, "+\
               "or Var_names is not string!")
         exit
      end if

      ;zoom
      if (.not.isvar("zoom")) then
         zoom = 0.95
      else
         if ((.not.isnumeric(zoom)).or.(.not.isscalar(zoom))) then
            print("Plot_MVIE error: zoom should be a numeric value !")
            exit
         end if
      end if

      ;output filename and type
      if (.not.isvar("file_metrics")) then
         file_metrics = "metrics_table"
      else
         if ((.not.isstring(file_metrics)).or.(.not.isscalar(file_metrics))) then
            print("Plot_MVIE error: file_metrics should be a string !")
            exit
         end if
      end if
         
      ;case names
      if (dimsizes(Obs_names).eq.1) then
         caseNames := Model_names
      else
         caseNames := array_append_record(Model_names,Obs_names,0)
      end if

      ;opt_metrics
      if (.not.isvar("opt_metrics")) then
         opt_metrics = False
      else
         if ((.not.islogical(opt_metrics)).or.(.not.isscalar(opt_metrics))) then
            print("Plot_MVIE error: opt_metrics should be a logical value !")
            exit
         end if
      end if   
    
      ;plot metrics table     
      metrics_table(file_metrics,MVIE_filenames2,stats_metrics2,caseNames,Var_names,zoom,opt_metrics)  

      Header := (/"|----------------------|","|     Metrics table    |","|----------------------|"/)             
      print_table([/Header/],"%s")                                        		   
   end if 

end