load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;************************************************************
; Calculate Mean of standard deviations (M_SD) derived from 
; two reanalysis datasets (JRA55 & NNRP) used in examples of Sec.5
; with and without area weighting, respectively.
;************************************************************
; Input datasets are not provided due to too big size of data.
; REA datasets are 1961-2000 monthly datasets with resolution
;  2.5x2.5 of Northern Hemisphere.
; We provide the results in Mul-REA.Mean-SD.areaweight.nc and
; Mul-REA.Mean-SD.noareaweight.nc
;************************************************************
begin
;************************************************************
; Length of year (1961-2000)
   nyear = 40

; Lat and area-weighting
   latS = 0.
   latN = 90.
   Resolution_lat =  2.5 
   nlat = tointeger((latN-latS)/Resolution_lat+1)

   lat = fspan(latS,latN,nlat)
   lat_wgt = latRegWgt(lat, "float", 0)

; Var names
   varnames = (/"SST","SLP","Q600","T850","u850","u200","v850","v200"/)
   var_output = (/"SST","SLP","Q600","T850","uv850","uv200"/)

; Season names
   season_names = (/"DJF","MAM","JJA","SON"/)

; Read Reanalysis data 
   f_REA1 = addfile("./REA_data/example.JRA55.1961-2000.nc","r")
   f_REA2 = addfile("./REA_data/example.NNRP.1961-2000.nc","r")

; Create new file to save M_SD
   if (.not.ismissing(systemfunc("ls Mul-REA.Mean-SD.areaweight.nc"))) then 
      system("rm Mul-REA.Mean-SD.areaweight.nc")
   end if
   if (.not.ismissing(systemfunc("ls Mul-REA.Mean-SD.noareaweight.nc"))) then 
      system("rm Mul-REA.Mean-SD.noareaweight.nc")
   end if

   f_out1 = addfile("Mul-REA.Mean-SD.areaweight.nc","c")
   f_out2 = addfile("Mul-REA.Mean-SD.noareaweight.nc","c")

   filedimdef(f_out1, "var", 1, False)
   filedimdef(f_out2, "var", 1, False)

   MeanSD_Mul1 = new(4, float)
   MeanSD_Mul1 = 0
   MeanSD_Mul2 = new(4, float)
   MeanSD_Mul2 = 0

; Calculate M_SD for individual variables
   print("Individual M_SD: with & without area-weighting")
   
   do i = 0,(dimsizes(var_output)-1)
      var_REA1 = f_REA1->$varnames(i)$
      var_REA2 = f_REA2->$varnames(i)$
      if ((var_output(i).eq."uv850").or.(var_output(i).eq."uv200")) then
         var2_REA1 = f_REA1->$varnames(i+2)$
         var2_REA2 = f_REA2->$varnames(i+2)$
      end if

      dim = dimsizes(var_REA1)

      do j = 0,(dimsizes(season_names)-1)
         Ref_season := (month_to_season(var_REA1, season_names(j)) + \
            month_to_season(var_REA2, season_names(j)))/2.

         var_seasonM := new((/2,dim(1),dim(2)/),typeof(var_REA1))
         var_seasonM(0,:,:) = dim_avg_n(month_to_season(var_REA1, season_names(j)),0)
         var_seasonM(1,:,:) = dim_avg_n(month_to_season(var_REA2, season_names(j)),0)

         var_Std_grid := (dim_stddev_n(var_seasonM,0)/sqrt(2.))/(dim_stddev_n(Ref_season,0)*sqrt((nyear-1)/tofloat(nyear)))

         MeanSD_var1 = avg(dim_avg_wgt_n(var_Std_grid, lat_wgt, 1, 0))
         MeanSD_var2 = avg(var_Std_grid)

         if ((var_output(i).eq."uv850").or.(var_output(i).eq."uv200")) then
            Ref_season := (month_to_season(var2_REA1, season_names(j)) + \
               month_to_season(var2_REA2, season_names(j)))/2.

            var_seasonM := new((/2,dim(1),dim(2)/),typeof(var2_REA1))
            var_seasonM(0,:,:) = dim_avg_n(month_to_season(var2_REA1, season_names(j)),0)
            var_seasonM(1,:,:) = dim_avg_n(month_to_season(var2_REA2, season_names(j)),0)

            var_Std_grid := (dim_stddev_n(var_seasonM,0)/sqrt(2.))/(dim_stddev_n(Ref_season,0)*sqrt((nyear-1)/tofloat(nyear)))

            MeanSD_var1 = (MeanSD_var1 + avg(dim_avg_wgt_n(var_Std_grid, lat_wgt, 1, 0)))/2.
            MeanSD_var2 = (MeanSD_var2 + avg(var_Std_grid))/2.

            if (var_output(i).eq."uv850") then
               saveVarname = "uv850_"+season_names(j)
            else
               saveVarname = "uv200_"+season_names(j)
            end if
         else
            saveVarname = varnames(i)+"_"+season_names(j)    
         end if
         
         MeanSD_Mul1(j) = MeanSD_Mul1(j) + MeanSD_var1
         MeanSD_Mul2(j) = MeanSD_Mul2(j) + MeanSD_var2

         filevardef(f_out1, saveVarname, typeof(MeanSD_var1), "var")
         f_out1->$saveVarname$ = (/MeanSD_var1/)
         filevardef(f_out2, saveVarname, typeof(MeanSD_var2), "var")
         f_out2->$saveVarname$ = (/MeanSD_var2/)

         print(saveVarname+":"+MeanSD_var1+" ,"+MeanSD_var2)
      end do
   end do

; Calculate M_SD of multivariable field
   MeanSD_Mul1 = MeanSD_Mul1/dimsizes(var_output)
   MeanSD_Mul2 = MeanSD_Mul2/dimsizes(var_output)

   print("Multivariable field: with & without area-weighting")

   do j = 0,(dimsizes(season_names)-1)
      saveVarname = "MulFie_"+season_names(j)

      filevardef(f_out1, saveVarname, "float", "var")
      f_out1->$saveVarname$ = (/MeanSD_Mul1(j)/)
      filevardef(f_out2, saveVarname, "float", "var")
      f_out2->$saveVarname$ = (/MeanSD_Mul2(j)/)

      print(saveVarname+":"+MeanSD_Mul1(j)+" ,"+MeanSD_Mul2(j))
   end do 
;************************************************************
end


     

     
