########################################################################
# PLOT SCRIPT FOR VFE DIAGRAM AND METRICS TABLE
#    BEFORE RUN THIS SCRIPT, CALCULATE SCRIPT HAS BEEN RUN.
########################################################################
#  Plot VFE diagram and/or metrics table            
########################################################################
# Statistics for VFE diagram:
# ----------------------------------------------------------------------
# |                             | Stats           | Dimsizes of input  |
# ----------------------------------------------------------------------
# | Individual scalar variables | uCORR, SD       | [Ncase] x [Nvar]   |
# |                             |-----------------|                    |
# |                             | CORR, rms       |                    |   
# ----------------------------------------------------------------------
# | Individual vector variable  | cVSC, cRMSL     | [Ncase]            |
# |                             |-----------------|                    |
# | / Multivariable field       | VSC, RMSL       |                    | 
# ----------------------------------------------------------------------
# Statistics that can be shown in metrics table:
# ----------------------------------------------------------------------------
# |                     | Stats                          | Dimsizes of input |
# ----------------------------------------------------------------------------
# | Individual variables| uCORR,rms,RMSD,SD,CORR,cRMSD,  | [Ncase] x [Nvar]  |
# |                     | ME(MEVD)                       |                   |
# ---------------------------------------------------------------------------
# | Multivariable field | VSC,RMSL,RMSVD,rms_std,cVSC,   | [Ncase]           |
# |                     | cRMSL,cRMSVD,SD_std,VME/MEVM   |                   |
# ----------------------------------------------------------------------------
# | Index for summary   | cMISS,uMISS                    | [Ncase]           |   
# ----------------------------------------------------------------------------
# [Ncase] - num of cases
#           - if num of obs is 1, case are models
#           - if num of obs is greater than 1, cases are models and obs
# [Nvar]  - num of variables
#################################################################
# Users control the evaluation by modifying codes for user at the 
#   beginning of this script.
#################################################################
# Please report bugs to: zhangmengzhuo1996@163.com or xuzhf@tea.ac.cn
#################################################################
import numpy as np
import xarray as xr 
import Ngl
import Nio
import function.metrics_table_withMIEI as Table
import function.VFE_diagram as VFE
import os
opt_VFE       =  Ngl.Resources()    # VFE diagram initial attribute, cannot be deleted !!!! 
opt_metrics   =  Ngl.Resources()    # metrics table initial attribute, cannot be deleted !!!! 
#              ##################################
#              # namelist to be edited by users #
#              ##################################
#============== user's editing starts here ===========================================================
Model_names          = ["M1","M2","M3","M4","M5","M6","M7","M8","M9","M10"]           
                                        # Names for models (list/tuple consisting of str)

Obs_names            = ["REA1","REA2"]  # Names for observation / reanalysis datasets (list/tuple consisting of str)

Plot_VFE_diagram     = True             # Plot Taylor/VFE diagram or not (bool)
 
Plot_metrics_table   = False            # Plot metrics table or not (bool)

#------ configuration for VFE diagram when 'Plot_VFE_diagram = True' ---------------------------------
MVIE_filename1       = "example.SON.centered.noareaweight.MIEI.nc"           
                                        # Name of NetCDF file for plotting VFE diagram (str)

stats_metrics1       = ["SD","CORR"]    # Stat names in 'MVIE_filename1' used for VFE diagram (list/tuple of two str) {default: ["RMSL","VSC"]}

ivar                 = 4                # If stat in 'stats_metrics1' has shape as Ncase x Nvar, plot ivar-var for VFE diagram (int) {default: 0}

filename_VFE         = "figure.7(b)"    # File name of Taylor/VFE diagram (str) {default:"MVIE.diagram"}

pltType_VFE          = "pdf"            # Image storage format:"ps"/"eps"/"pdf"/"png" (str) {default:"eps"}

opt_VFE.tiMainString         = "(b)"        # Diagram title (str) {default: not draw}

opt_VFE.tiMainFontHeightF    = 0.0225       # Font height of diagram title (int/float) {default: 0.0225]

#opt_VFE.xyMax               =              # Max value of axis (int/float) {have default}

opt_VFE.xyFontHeightF        = 0.0175       # Font height for axis (int/float) {default: 0.0175}

#opt_VFE.OneX                =              # X-axis label at one point (str) {default: "REF"}

opt_VFE.tiYAxisString        = "cRMSL"      # Y-axis string (str) {default: "RMSL"}

#opt_VFE.CorLabel             =             # Arc label (str) {default: "Similarity"}

opt_VFE.stnRad               = [1.05,1.1,1.15,1.2,1.25]           
                                            # Standard radius for RMSL (list/tuple consisting of int/floats) {default: not draw}
opt_VFE.ccRays               = [0.85,0.9,0.92,0.94,0.99]           
                                            # Radial lines for VSC ((list/tuple consisting of int/floats) {default: not draw}

opt_VFE.centerDiffRMS        = True         # Draw radii from REF or not (bool) {default: False}

opt_VFE.MarkersOn            = True         # Plot markers for models and observations/reanalysis or not? ? (bool) {default: False}
                            # below are valid under plotting markers by 'opt_VFE.MarkersOn = True'
opt_VFE.MarkersIndex         = [16,0]       # Marker Index for models or/and obs (list/tuple consisting of 1/2 int) {default: [4,16]}

opt_VFE.gsMarkerThicknessF   = 1.2           # Marker thinckness (int/float) {default: 1.0}
 
opt_VFE.gsMarkerSizeF        = 0.01           # Marker size (int/float) {default: 0.0085}
                            # above are valid under plotting markers by 'opt_VFE.MarkersOn = True'

opt_VFE.Colors              = ["darkolivegreen","darkorange","brown4","rosybrown1","orangered","blue2","chocolate","cadetblue4","cornflowerblue",\
    "dimgrey", "gold3","honeydew4"]         # Colors of points (list/tuple) {have default} 
                                            # Three types, refer to readme.namelist.Py-v or User Guide

opt_VFE.CountTxOn           = True          # Add count texts to points or not ? (bool) {default: True}
                                            # vaild when plotting markers by 'opt_VFE.Markers'
                                            # if 'opt_VFE.Markers = False', it is automatically set 'True' and 'markerTxXOffset'/'markerTxYOffset' = 0.
                              # below are valid under 'opt_VFE.markerTxOn = True' 
opt_VFE.CountFontHeightF    = 0.016         # Textfont height for count of points (int/float) {default:0.0085}
                              
opt_VFE.CountTxXOffset      = 0.01          # X distance between point markers and point text (int/float) {default: 0.015}
                              
opt_VFE.CountTxYOffset      = 0.015         # Y distance between point markers and point text (int/float) {default:0.015}
                              # above are valid under 'opt_VFE.markerTxOn = True'

#plot_std_l                  =              # Plot rms_std/SD_std line (name of rms_std/SD_std in 'MVIE_filename1') or not (bool) {default: False}?

opt_VFE.DatatypeLegendOn     = True         # Draw data type legend or not (bool) {default: False}?
                              # below are valid under 'opt_VFE.DatatypeLabelsOn = True'
#opt_VFE.DatatypeLegend      =              # Labels of data type (list/tuple consisting of 1/2 str) {default:["Models","Renalysis"]}
                              
opt_VFE.DatatypeLegendFontHeightF = 0.02    # Data type legend font height (int/float) {default: 0.03}
                              
opt_VFE.DatatypeLegendXL     = 0.75         # X strat location of data type legend (int/float) {default: 0.8}
                              
opt_VFE.DatatypeLegendYL     = 0.9          # Y strat location of data type legend (int/float) {default: 0.9}

opt_VFE.DatatypeLegendWidth  = 0.15         # Width of data type legend (int/float) {default: 0.1}

opt_VFE.DatatypeLegendHeight = 0.15         # Height of data type legend (int/float) {default: 0.1}
                              # above are valid under 'opt_VFE.DatatypeLabelsOn = True'

plot_caselabels              = True         # Show caselabels on or not (bool) {False: dafault}?
                              # below are valid under 'plot_caselabels = True'
opt_VFE.caseLabelsFontHeightF = 0.0175      # Font height of caselabels (int/float) {default: 0.013}
 
opt_VFE.caseLabelsYinterval  = 0.075        # Y interval between two cases in caselabels (int/float) {default: 0.06}

opt_VFE.caseLabelsXloc       = 0.05         # X strat location of caselabels (int/float) {default: 0.125}

opt_VFE.caseLabelsYloc       = 0.89         # Y strat location of caselabels (int/float) {default: 0.3}
                              # above are valid under 'plot_caselabels = True' 

opt_VFE.obsUncer             = 0.34         # The value to measure observational uncertainty (int/float) {default: not set}
                                                #which is as the length of red horizontal bar centered at (1,0)
#opt_VFE.draw_grid           =              # Whether to draw grid lines (bool) {default:False}

#------ configuration for metrica table when 'Plot_metrics_table = True' ---------------------------------
MVIE_filenames2       = ["example.SON.centered.areaweight.MIEI.nc",]           
                                            # Name of NetCDF files (up to 4) stored metrics for metrics table  (list consisting of str)
Var_names             = ["SLP","SST","Q600","T850","uv850","uv200"]           
                                            # Names for individual scalar or vector variables (list/tuple consisting of str)      
zoom                  = 0.95                # Width (Height) of metrics table when when 'opt_metrics.CaseLocation = "Left" ("Top") '(int/float) {default: 0.95}  

file_metrics          = "figure.5"          # Name of output metrics table (str) {default: "metrics_table"}

stats_metrics2        = ["ME","VME","cRMSD","cRMSVD","SD_std","SD","cRMSL","cMISS","cMIEI","cVSC","CORR","uMISS"]           
                                            # Statistics chosen for metrics table (list/tuple consisting of str) {default: all variables in file}
opt_metrics.pltType          = "eps"        # Image storage format:"ps"/"eps"/"pdf"/"png" (str) {default:"eps"}

opt_metrics.wkOrientation    = "portrait"   # PS or PDF output produced in {default: "portrait"}/"landscape" 

opt_metrics.RMSlevs          = [0.85,0.9,0.95,0.99,0.995,0.999,1.0,1.001,1.005,1.01,1.05,1.1,1.15,1.25,1.3,1.35]          
                                            # RMS levels for SD/rms, cRMSL/RMSL (list/tuple consisting of int/float) {have default}
opt_metrics.MElevs           = [-0.3,-0.25,-0.2,-0.15,-0.1,-0.075,-0.05,-0.025,-0.01,0.,0.01,0.025,0.05,0.075,0.1,0.15,\
    0.2,0.25,0.3,0.4,0.5,0.6,0.7]           # ME levels for ME, VME/MEVM (list/tuple consisting of int/float) {have default} 
opt_metrics.RMSDlevs         = [0.05,0.1,0.15,0.2,0.25,0.3,0.35,0.4,0.45,0.5,0.6,0.7]
                                            # RMSD levels for cRMSD/RMSD, cRMSVD/RMSVD, SD_std/rms_std (list/tuple consisting of int/float) {have default}
opt_metrics.CORRlevs         = [0.85,0.9,0.92,0.94,0.96,0.98,0.99,0.995,0.998,0.999]          
                                            # CORR levels for CORR/uCORR, cVSC/VSC, cMISS, MISS (list/tuple consisting of int/float) {have default}
#opt_metrics.RMScmap         =           # Colormap for RMS levels {have default}, valid under setting 'RMSlevs'
                                                # four ways to set colormap, please refer to readme.namelist.Py-v and User Guide
#opt_metrics.MEcmap          =           # Colormap for ME levels {have default}, valid under setting 'MElevs'

#opt_metrics.RMSDcmap        =           # Colormap for RMSD levels {have default}, valid under setting 'RMSDlevs'

#opt_metrics.CORRcmap        =           # Colormap for CORR levels {have default}, valid under setting 'CORRlevs'

opt_metrics.CaseLocation     = "Top"     # Location of caselabels {default: "Top"}/"Left" 

                              # below are valid under 'opt_metrics.CaseLocation = "Left"'
opt_metrics.titleHeight      = 0.07      # Height of title box (int/float) {default: 0.08}

opt_metrics.titleWidth       = 0.09      # Width of title box (int/float) {default: 0.1}

opt_metrics.caseHeight       = 0.03      # Height of case box (int/float) {default:0.035} 
                              # above are valid under 'opt_metrics.CaseLocation = "Left"'

                              # below are valid under 'opt_metrics.CaseLocation = "Top"'                              
opt_metrics.varWidth         = 0.07      # Width of var box (int/float) {default: 0.07}

opt_metrics.caseWidth        = 0.1       # Width of case box (int/float) {default: 0.1}
	          
opt_metrics.caseHeight       = 0.04      # Height of case box (int/float) {default:0.02}  
                              # above are valid under 'opt_metrics.CaseLocation = "Top"'

opt_metrics.titleTHeight     = 0.015     # Text font height of title (int/float) {default: 0.015}

opt_metrics.caseTHeight      = 0.012     # Text font height of case-label (int/float) {default: 0.0075}

opt_metrics.statsTHeight     = 0.011     # Text font height of statistic-label (int/float) {default: 0.0075} 

opt_metrics.varTHeight       = 0.01      # Text font height ofvar-label (int/float) {default: 0.006}

opt_metrics.metricsTHeight   = 0.008     # Text font height of metrics (int/float) {default: 0.006}
	
#opt_metrics.TitleBackgroundcolor =      # Background color for title (str/int/list/tuple) {default: "CornflowerBlue"}
                                                # three ways to set TitleBackgroundcolor, please refer to readme.namelist.Py-v and User Guide
#opt_metrics.VarBackgroundcolor =        # Background color for case/ststs/var (str/int/list/tuple) {default: "Gray70"}
                                                # three ways to set VarBackgroundcolor, please refer to readme.namelist.Py-v and User Guide
#opt_metrics.tableTitle       =          # Title of table (str) {default: "METRICS"}

opt_metrics.showTextOn       = True      # Show performance metrics on or not (bool)? {default: True}
                                                # when num of files greater than 1, it would set by Fasle by the tool

opt_metrics.plotMEVD         = False     # Plot MEVD when ME is plotted and MEVD is in files or not (bool)? {default: False}

opt_metrics.decialMetricsN   = "4.3"     # Number of decimal places for performance metrics (str) {default:"3.2"}

#opt_metrics.decialBarN       =          # Number of decimal places for values in colorbar (str) {default:"3.2"}
                                                # valid under 'opt_metrics.showTextOn = False'
#opt_metrics.colorbarFHeight  =          # Colorbar font height (int/float) {default:var_theight}
                                                # valid under 'opt_metrics.showTextOn = False'
#opt_metrics.box_legend        =         # Draw legend for box ( list/tuple consisting of str for legend) or not {default: False}?

#opt_metrics.box_lgFontHeightF =         # Text font height in box legend (int/float) {default: var_theight*1.2}
                                                # valid under setting 'opt_metrics.box_legend'
#opt_metrics.box_lgheight    =           # Height of box legend (int/float) {have default}                                               
                                                # valid under setting 'opt_metrics.box_legend'
#opt_metrics.highlightsummary=           # Enclose stats for summary, i.e.,cMISS,uMISS, with red box for emphasis or not (bool)? {default: True}

#opt_metrics.draw_grid       =           # Whether to draw grid lines (bool) {default:False}

#============== user's editing ends here =============================================================

#########################
## Check error for data #
#########################
      
print("###################################### \n#      MVIETool v1.0 (Python3)       # \n######################################")

# Model names
if (not "Model_names" in locals()) or (not isinstance(Model_names,(list,tuple))) or\
    (not all(isinstance(x,str) for x in Model_names)):
    print("Plot_MVIE error: cannot find Model_names or Model_names is not list/tuple consisting of str!")
    os._exit(0)

# Obs names
if (not "Obs_names" in locals()) or (not isinstance(Obs_names,(list,tuple))) or\
    (not all(isinstance(x,str) for x in Obs_names)):
    print("Plot_MVIE error: cannot find Obs_names or Obs_names is not list/tuple consisting of str!")
    os._exit(0)

# number of models, obs and vars 
Nmodel = len(Model_names)
Nobs   = len(Obs_names) 
Ncase  = np.int(np.where(Nobs==1,Nmodel,Nmodel+Nobs))

if Nmodel < Ncase:
    case_names = Model_names + Obs_names
else:
    case_names = Model_names

# Plot VFE
if (not "Plot_VFE_diagram" in locals()) or (not isinstance(Plot_VFE_diagram,bool)):
    print("plot_MVIE error: cannot find Plot_VFE_diagram or Plot_VFE_diagram is not bool!")
    os._exit(0)

# Plot metrics table
if (not "Plot_metrics_table" in locals()) or (not isinstance(Plot_metrics_table,bool)):
    print("Plot_MVIE error: cannot find Plot_metrics_table or Plot_metrics_table is not bool!")
    os._exit(0)

#########################
## Plot for VFE diagram #
#########################

if Plot_VFE_diagram:
    # check datafile
    if (not "MVIE_filename1" in locals()) or (not isinstance(MVIE_filename1,str)):
        print("Plot_MVIE error: cannot find MVIE_filename1, or MVIE_filename1 is not str!")
        os._exit(0)
    try:
        f_MVIE = Nio.open_file(MVIE_filename1,"r")
    except:
        print("Plot_MVIE error: cannot open file:",MVIE_filename1,"!")
        os._exit(0) 

    # set caselabels
    if not "plot_caselabels" in locals():
        plot_caselabels = False
    else:
        if not isinstance(plot_caselabels,bool):
            print("Plot_MVIE error: plot_caselabels should be bool!")
            os._exit(0)

    if plot_caselabels:
        opt_VFE.caseLabels = case_names

    # open workstation
    if not "filename_VFE" in locals():
        filename_VFE = "VIE.diagram"
    else:
        if not isinstance(filename_VFE,str):
            print("Plot_MVIE error: filename_VFE should be str!")
            os._exit(0)
    if not "pltType_VFE" in locals():
        pltType_VFE = "eps"
    else:
        if not isinstance(pltType_VFE,str):
            print("Plot_MVIE error: pltType_VFE should be str!")
            os._exit(0)
        if not (pltType_VFE in ["pdf","eps","ps","png"]):
            print("Plot_MVIE error: pltType_VFE should be 'pdf', 'ps', 'eps', or 'png' !")
            os._exit(0)
    wks = Ngl.open_wks(pltType_VFE, filename_VFE, Ngl.Resources())

    # read stats
    if not "stats_metrics1" in locals():
        stats_metrics1 = ["RMSL","VSC"]
    else:
        if (not isinstance(stats_metrics1,(list,tuple))) or (len(stats_metrics1)!=2)\
            or (not all(isinstance(x,str) for x in stats_metrics1)):
            print("Plot_MVIE error: stats_metrics1 should be list/tuple consisting of 2 str!")
            os._exit(0)

    try:
        stats1 = np.array(f_MVIE.variables[stats_metrics1[0]],float)
        stats2 = np.array(f_MVIE.variables[stats_metrics1[1]],float)
    except:
        print("Plot_MVIE error: error in read ",stats_metrics1[0],"or/and",stats_metrics1[1],\
            " in file:",MVIE_filename1,"!")
        os._exit(0)

    if stats1.shape != stats2.shape:
        print("Plot_MVIE error: shape of ",stats_metrics1[0]," and ",stats_metrics1[1],\
            "should be same!")
        os._exit(0)
    if stats1.ndim>2:
        print("Plot_MVIE error: ndim of ",stats_metrics1[0]," and ",stats_metrics1[1],\
            "should be less than 2!")
        os._exit(0)

    if stats1.ndim == 1:
        if (stats_metrics1[1] in ["VSC","cVSC","CORR","uCORR"]) or\
            (max(stats2)<1. and max(stats1)>1.):
            Rv = stats2
            RATIO = stats1
        else:
            Rv = stats1
            RATIO = stats2
    else:
        if not "ivar" in locals():
            ivar = 0
        else:
            if not isinstance(ivar,int):
                print("Plot_MVIE error: ivar should be int!")
                os._exit(0)
            if ivar >= stats1.shape[1]:
                print("Plot_MVIE error: ivar is out of range for 2th-dimention in ",\
                    stats_metrics1[0]," and ",stats_metrics1[1]," in file:",MVIE_filename1,"!")
                os._exit(0)
        if (stats_metrics1[1] in ["VSC","cVSC","CORR","uCORR"]) or\
            (max(stats2[:,ivar])<1. and max(stats1[:,ivar])>1.):
            Rv = stats2[:,ivar]
            RATIO = stats1[:,ivar]
        else:
            Rv = stats1[:,ivar]
            RATIO = stats2[:,ivar]

    # std line
    if "plot_std_l" in locals():
        if isinstance(plot_std_l,str):
            try:
                opt_VFE.stdline = np.array(f_MVIE.variables[plot_std_l],float)
            except:
                print("Plot_MVIE error: error in read ",plot_std_l,\
                    " in file:",MVIE_filename1,"!")
                os._exit(0)
    
    plot = VFE.VFE_diagram(wks,RATIO,Rv,Nmodel,Ncase,opt_VFE)

    print("|----------------------| \n|      VFE diagram     | \n|----------------------|")
    print("*Create <",filename_VFE,".",pltType_VFE,">*")

###########################
## Plot for metrics table #
###########################

if Plot_metrics_table:
    # check datafile(s)
    if not "MVIE_filenames2" in locals():
        print("Plot_MVIE error: cannot find 'MVIE_filenames2' under 'Plot_metrics_table = True'!")
        os._exit(0)
    if (not isinstance(MVIE_filenames2,(list,tuple))) or (not all(isinstance(x,str) for x in MVIE_filenames2)):
        print("Plot_MVIE error: 'MVIE_filenames2' should be list/tuple consisting of str!") 
        os._exit(0)
    if len(MVIE_filenames2) > 4:
        print("Plot_MVIE warning: len of 'MVIE_filenames2' should be less than 5, and first 4 files in 'MVIE_filenames2' are input!")
        MVIE_filenames2 = MVIE_filenames2[0:4]

    # open datafile(s)
    Nf = len(MVIE_filenames2)
    if Nf == 1:
        try:
            f_MVIE = Nio.open_file(MVIE_filenames2[0],"r")
            f_variables = f_MVIE.variables.keys()
        except:
            print("Plot_MVIE error: cannot open file in 'MVIE_filenames2'!")
            os._exit(0)
    else:
        f_MVIE = []
        for i in range(Nf):
            try:
                ifile = Nio.open_file(MVIE_filenames2[i],"r")
            except:
                print("Plot_MVIE error: cannot open file-",MVIE_filenames2[i]," in 'MVIE_filenames2'!")
                os._exit(0)
            f_MVIE.append(ifile)
            if i == 0:
                f_variables = f_MVIE[0].variables.keys()
            else:
                f_variables = list(set(f_variables).intersection(set(f_MVIE[i].variables.keys())))

    # check stats_metrics2 in datafile(s)
    if not "stats_metrics2" in locals():
        Stats_names = ["cRMSD","SD","CORR","ME","RMSD","rms","uCORR","cRMSVD","SD_std",\
            "cRMSL","cVSC","VME","MEVM","RMSVD","rms_std","RMSL","VSC","cMISS","uMISS"]

        stats_metrics2 = list(set(Stats_names).intersection(set(f_variables)))

        if stats_metrics2 == []:
            print("Plot_MVIE error: cannot find any one among "+",".join(Stats_names)," in file by 'MVIE_filenames2'!")
            os._exit(0)
    else:
        if (not isinstance(stats_metrics2,(list,tuple))) or (not all(isinstance(x,str) for x in stats_metrics2)):
            print("Plot_MVIE error: 'stats_metrics2' should be list/tuple consisting of str!")
            os._exit(0)
        if list(set(stats_metrics2).intersection(set(f_variables))).sort() != stats_metrics2.sort():
            print("Plot_MVIE error: cannot find all stats of 'stats_metrics2' in file by 'MVIE_filenames2'!")
            os._exit(0)

    # var names
    if not "Var_names" in locals():
        print("Plot_MVIE error: cannot find 'Var_names'!")
        os._exit(0)

    # zoom
    if not "zoom" in locals():
        zoom = 0.95
    else:
        if not isinstance(zoom,(int,float)):
            print("Plot_MVIE error: zoom should be int/float!")
            os._exit(0)

    # output filename and type
    if not "file_metrics" in locals():
        file_metrics = "metrics_table"
    else:
        if not isinstance(file_metrics,str):
            print("Plot_MVIE error: 'file_metrics' should be str!")
            os._exit(0)

    # plot metrics table
    Table.metrics_table(mfname=file_metrics, fnames=MVIE_filenames2, stats=stats_metrics2,\
        caseNames=case_names, varNames=Var_names, zoom=zoom, opt=opt_metrics)   

    print("|----------------------| \n|     Metrics table    | \n|----------------------|")
    print("*Create <",file_metrics,">*")

Ngl.end()

########################################################################



