#! /usr/bin/env python3

from pylab import *
from mpl_toolkits.basemap import Basemap
import sys

# lat is from -90 to 90; lon is from 0 to 360. "areas" is used for
# storing information about grid extents. It needs to match the data
# in gaussian_proc.h for each key.
areas = {
    'Shanghai': {'latmin': 30, 'latmax': 33, 'lonmin': 118+180, 'lonmax': 126+180},
    'EastAsia': {'latmin': 0, 'latmax': 60, 'lonmin': 245, 'lonmax': 325},
    'SouthAsia': {'latmin': 0, 'latmax': 20, 'lonmin': 245, 'lonmax': 275},
    'TESTAREA': {'latmin': 0, 'latmax': 20, 'lonmin': 268, 'lonmax': 273},
    'Helsinki': {'lonmin': 200, 'lonmax': 215, 'latmin': 57, 'latmax': 63},
    'ChinaSea': {'lonmin': 295, 'lonmax': 325, 'latmin': 27, 'latmax': 40},
    'Europe': {'latmin': 35, 'latmax': 60, 'lonmin': 170, 'lonmax': 222},
    'MiddleEast': {'latmin': 11, 'latmax': 37, 'lonmin': 209, 'lonmax': 240},
    'EuropeAfrica': {'latmin': 0, 'latmax': 70, 'lonmin': 160, 'lonmax': 240},
    'Africa': {'latmin': 0, 'latmax': 30, 'lonmin': 160, 'lonmax': 240},
    'equator': {'latmin': -10, 'latmax': 10, 'lonmin': 0, 'lonmax': 360},
    'NorthAmerica': {'latmin': 0, 'latmax': 60, 'lonmin': 50, 'lonmax': 120},
    'World': {'latmin': -85, 'latmax': 85, 'lonmin': 0, 'lonmax': 360},
    'Beijing': {'latmin': 28, 'latmax': 35, 'lonmin': 298, 'lonmax': 303+4},
}


def get_latres(co2txtdata, areadict):
    """Automatically infer grid resolution from array dimensions and
    areadict"""
    l = len(co2txtdata[0])
    invgridres = sqrt(l/(areadict['latmax'] - areadict['latmin'])/(areadict['lonmax'] - areadict['lonmin']))
    print("inverse grid res", invgridres)
    return int((areadict['latmax'] - areadict['latmin'])*invgridres + .5)
