#
# HARMONIE experiment configuration file
# 
# Please read the documentation on https://hirlam.org/trac/wiki/HarmonieSystemDocumentation first
#
# NB! All combinations may not be valid or well tested 
#
# **** Build and bin paths ****
# Definitions about Build, should fit with hm_rev
BUILD=${BUILD-yes}                      # Turn on or off the compilation and binary build ( yes|no)
case $MAKEUP in
   no)
                                              # Definitions about gmkpack, should fit with hm_rev
      BUILD_ROOTPACK=${BUILD_ROOTPACK-no}     # Build your own ROOTPACK if it doesn't exists (yes|no)
                                              # This may take several hours!
                                              # Make sure you have write permissions in ROOTPACK directory defined in Env_system
      REVISION=38h1                           # Revision ( or cycle ) number, has to be set even for the trunk!
      BRANCH=HCLIM38h1
      VERSION=01                              # Version of revision/branch to use
      OPTION=x                                # Which gmkpack/arch/SYSTEM.HOST.OPTION file to use

      # Other things to compile with gmkpack
      OTHER_PROGRAMS="pertcma mten convert_ecoclimap soda pgd blend \
                      odbtools bator ioassign odbsql \
                      blendsur addsurf surfex mandalay \
                      prep lfitools sfxtools pregpssol" 
   ;;
   yes)
   ;;
   *)
      echo "MAKEUP not valid or not set, Please set to yes/no in Env_system"
      exit
   ;;
esac

BINDIR=${BINDIR-$HM_DATA/bin}           # Binary directory

# **** Misc, defined first because it's used later ****

CNMEXP=HARM                             # Four character experiment identifier
WRK=$HM_DATA/$CYCLEDIR                  # Work directory

# **** Paths to archive ****
# We need to define ARCHIVE early since it might be used further down

ARSTRATEGY="medium"                     # Archive strategy
                                        # minimum: only logs and vfld file
                                        # medium: main results
                                        # maximum: everything

ARCHIVE_ROOT=$HM_DATA/archive           # Archive root directory
ARCHIVE_ECMWF=no                        # Archive to $ECFSLOC at ECMWF (yes|no)
ECFSLOC=ectmp                           # Archiving site at ECMWF-ECFS: "ec" or ECFS-TMP "ectmp"
ECFSGROUP=hirald                        # Group in which to chgrp the ECMWF archive, "default" or "hirald"
EXTRARCH=$ARCHIVE_ROOT/extract          # Archive for fld/obs-extractions


# **** Running mode ****
RUNNING_MODE=research                   # Research or operational mode (research|operational)
                                        # operational implies that
                                        # - Not STAGE is done for MARS requests
                                        # - No assimilation is done if no obserations are found by Bator

SIMULATION_TYPE=climate                 # Type of simulation (nwp|climate|hindcast)
                                        # nwp      : if no assimilation, cold starts every cycle
                                        # climate  : continuous runs, restart monthly, initialize atmosphere and surface from last file of previous month, SST updated from LBC
                                        # hindcast : initialise surface with file from previous cycle and update SST from LBC. Assimilation should NOT be used.


# **** Model geometry ****
DOMAIN=PALP3                            # See definitions in scr/Harmonie_domains.pm
VLEV=65                                 # Vertical level definition.
                                        # HIRLAM_60, MF_60,HIRLAM_40, or
                                        # BOUNDARIES = same number of levs as on boundary file.
                                        # See the other choices from scr/Vertical_levels.pl
LL=${LL-06}                             # Forecast length   [h]


# **** High level forecast options ****
DYNAMICS="nh"                           # Hydrostatic or non-hydrostatic dynamics (h|nh)
PHYSICS="arome"                         # Main model physics flag (arome|alaro|aladin)
SURFACE="surfex"                        # Surface flag (old_surface|surfex)
DFI="none"                              # Digital filter initialization (idfi|fdfi|none)
                                        # idfi : Incremental dfi
                                        # fdfi : Full dfi
                                        # none : No initialization (AROME case)
LSPBDC=no                               # Spectral boundary contions option off(no) | on(yes)
LGRADSP=yes                             # Apply Wedi/Hortal vorticity dealiasing
LUNBC=yes                               # Apply upper nested boundary condition

# Highlighted physics switches
CISBA="DIF"                             # Type of ISBA scheme in SURFEX. Options: "3-L","2-L" and "DIF"
CROUGH="NONE"                           # SSO scheme used in SURFEX "NONE"|"Z01D"|"BE04"
SURFEX_SEA_ICE="sice"                   # Treatment of sea ice in surfex (none|sice)
HARATU="yes"                            # Switch for HARATU turbulence scheme (no|yes)

# **** Assimilation ****
ANAATMO=none                            # Atmospheric analysis (3DVAR|4DVAR|blending|none)
ANASURF=none                            # Surface analysis (CANARI|CANARI_OI_MAIN|CANARI_EKF_SURFEX|none)
                                        # CANARI            : Old style CANARI
                                        # CANARI_OI_MAIN    : CANARI + SURFEX OI
                                        # CANARI_EKF_SURFEX : CANARI + SURFEX EKF ( experimental )
                                        # none              : No surface assimilation
ANASURF_INLINE="no"                     # Calls SODA interface from inside CANARI if set to yes (experimental)
ANASURF_MODE="before"                   # When ANASURF should be done
                                        # before            : Before ANAATMO
                                        # after             : After ANAATMO
                                        # both              : Before and after ANAATMO (Only for ANAATMO=4DVAR) 
INCV="1,1,1,1"                          # Active EKF control variables. 1=WG2 2=WG1 3=TG2 4=TG1
INCO="1,1,0"                            # Active EKF observation types (Element 1=T2m, element 2=RH2m and element 3=Soil moisture) 

MAKEODB2=no                             # Conversion of ODB-1 to ODB-2 using odb_migrator

SST_SOURCES="SURFEX"                    # List of external SST sources like IFS|HIROMB|NEMO|ROMS|SURFEX|ECE|RACMO
                                        # See util/gl_grib_api/ala/merge_ocean.F90 for more details

LSMIXBC=no                              # Spectral mixing of LBC0 file before assimilation
[ "$ANAATMO" = 3DVAR ] && LSMIXBC=yes
JB_INTERPOL=no                          # Interpolation of structure functions from a pre-defined domain to your domain

FCINT=03                                # Assimilation cycle interval [h]

# **** Observations ****
OBDIR=$HM_DATA/observations             # Observation file directory
RADARDIR=$HM_DATA/radardata             # Radar observation file directory
SINGLEOBS=no                            # Run single obs experiment with observation created by scr/Create_single_obs (no|yes)

USE_MSG=no                              # Use MSG data for adjustment of inital profiles, EXPERIMENTAL! (no|yes)
MSG_PATH=$SCRATCH/CLOUDS/               # Location of input MSG FA file, expected name is MSGcloudYYYYMMDDHH

# **** 4DVAR ****
NOUTERLOOP=1                            # 4DVAR outer loops, need to be 1 at present
ILRES=2,2                               # Resolution (in parts of full) of outer loops
TSTEP4D=120,120                         # Timestep length (seconds) of outer loops TL+AD
TL_TEST=no                              # Only active for playfile tlad_tests
AD_TEST=no                              # Only active for playfile tlad_tests

# **** DFI setting ****
TAUS=5400                               # cut-off frequency in second 
TSPAN=5400                              # 7200s or 5400s

# **** Nesting ****
HOST_MODEL="ald"                        # Host model (ifs|hir|racmo|ald|ala|aro)
                                        # ifs  : ecmwf/EC-Earth data (ECE data need to be prepared for harmonie)
                                        # hir  : hirlam data
                                        # racmo: RACMO2 data
                                        # ald  : Output from aladin physics
                                        # ala  : Output from alaro physics
                                        # aro  : Output from arome physics

HOST_SURFEX="yes"                       # yes if the host model is run with SURFEX
SURFEX_INPUT_FORMAT=fa                  # Input format for host model run with surfex (lfi|fa)

NBDMAX=4                                # Number of parallel interpolation tasks (number of nodes if MULTITASK)
MULTITASK=yes                           # Submit jobs through the multi task script
BDLIB=/nobackup/rossby18/rossby/joint_exp/eucp/HCLIM38h1_FPSconvection_ALADIN_ERAi_LBConly                            # Boundary experiment, set:
                                        # ECMWF to use MARS data
                                        # RCRa  to use RCRa data from ECFS
                                        # Other HARMONIE/HIRLAM experiment

BDDIR=${BDLIB}/archive/@YYYY@/@MM@/@DD@/@HH@   # Boundary file directory,
#BDFILE=ma@YYYY@@MM@@DD@@HH@00m                          # Boundary file,
                                                        # For more information, read in scr/Boundary_strategy.pl
INT_BDFILE=$WRK/ELSCF${CNMEXP}ALBC@NNN@                 # Interpolated boundary file name and location

BDSTRATEGY=same_forecast                # Which boundary strategy to follow 
                                        # as defined in scr/Boundary_strategy.pl
                                        # 
                                        # available            : Search for available files in BDDIR, try to keep forecast consistency
                                        #                        This is meant to be used operationally
                                        # simulate_operational : Mimic the behaviour of the operational runs using ECMWF LBC,
                                        #                        i.e. 6 hour old boundaries
                                        # same_forecast        : Use all boundaries from the same forecast, start from analysis
                                        # analysis_only        : Use only analysises as boundaries
                                        # era5                 : As for analysis_only but using ERA5 data
                                        # erain                : As for analysis_only but using ERA interim data
                                        # latest               : Use the latest possible boundary with the shortest forecast length
                                        # RCR_operational      : Mimic the behaviour of the RCR runs, ie
                                        #                        12h old boundaries at 00 and 12 and
                                        #                        06h old boundaries at 06 and 18
                                        # enda                 : use ECMWF ENDA data for running ensemble data assimilation
                                        #                        or generation of background statistic.
                                        #                        Note that only LL up to 9h is supported
                                        #                        with this you should set your ENSMSEL members
                                        # eps_ec               : ECMWF EPS members (on reduced gaussian grid)
                                        #                        Only meaningful with ENSMSEL non-empty, i.e., ENSSIZE > 0

BDINT=3                                 # Boundary interval in hours

SURFEX_PREP="yes"                       # Use offline surfex prep facility (Alt. gl + Fullpos + prep )

# *** Ensemble mode general settings. ***
# *** For member specific settings use msms/harmonie.pm ***
ENSMSEL=                                # Ensemble member selection, comma separated list, and/or range(s):
                                        # m1,m2,m3-m4,m5-m6:step    mb-me == mb-me:1 == mb,mb+1,mb+2,...,me
                                        # 0=control. ENSMFIRST, ENSMLAST, ENSSIZE derived automatically from ENSMSEL.
ENSINIPERT=                             # Ensemble perturbation method (bnd). Not yet implemented: etkf, hmsv, slaf.
ENSCTL=                                 # Which member is my control member? Needed for ENSINIPERT=bnd. See harmonie.pm.
ENSBDMBR=                               # Which host member is used for my boundaries? Use harmonie.pm to set.
ENSMFAIL=                               # Failure tolerance for all members. Not yet implemented.
ENSMDAFAIL=                             # Failure tolerance for members doing own DA. Not yet implemented.
SLAFK=1.0
SLAFLAG=0

# *** This part is for EDA with observations perturbation
PERTATMO=none                           # ECMAIN  : In-line observation perturbation using the default IFS way.
                                        # CCMA    : Perturbation of the active observations only (CCMA content)
                                        #           before the Minimization, using the PERTCMA executable.
                                        # none    : no perturbation of upper-air observations

PERTSURF="no"                           # yes     : perturb also the surface observation before Canari (recommended
                                        #         : for EDA to have full perturbation of the initial state).
                                        # no      : no perturbation for surface observations.

FESTAT=no                               # Extract differences and do Jb calculations (no|yes)

# **** Climate files **** 
CREATE_CLIMATE=${CREATE_CLIMATE-yes}    # Run climate generation (yes|no)
CLIMDIR=$HM_DATA/climate                # Climate files directory 
BDCLIM=${BDLIB}/climate                 # Boundary climate files (ald2ald,ald2aro)
                                        # This should point to intermediate aladin  
                                        # climate file in case of hir2aro,ifs2aro processes.

# Physiography input for SURFEX
ECOCLIMAP_VERSION=2.2                   # Version of ECOCLIMAP for surfex (1,2)
                                        # Available versions are 1.1-1.5,2.0-2.2
SOIL_TEXTURE_VERSION=FAO                # Soil texture input data FAO|HWSD_v2

# **** Archiving settings ****
TFLAG="h"                               # Time flag for model output. (h|min)
                                        # h   = hour based output
                                        # min = minute based output

[ "$TFLAG" = "min" ] && GRIB_TIME_UNIT=13  # GRIB_TIME_UNIT=0 1 min time unit
                                           # GRIB_TIME_UNIT=1 hourly time unit (default)
                                           # GRIB_TIME_UNIT=13 15 min time unit
                                           # GRIB_TIME_UNIT=14 30 min time unit
                                           # see scr/Makegrib

# Writeup times of model output (space separated list).
# The content of WRITUPTIMES, SWRITUPTIMES, PWRITUPTIMES 
# and OUTINT should be: 
#   - hours   if TFLAG="h"
#   - minutes if TFLAG="min"
# Regular output interval can be switched on by setting OUTINT>0.
# Consequently, OUTINT will override the WRITUPTIMES lists!
 
# history files (space separated list)
WRITUPTIMES="00"
OUTINT="1"                              # Regular output interval if > 0. Not used if <= 0.

# surface fields (space separated list)
SWRITUPTIMES="00"
SFXOUTINT="3"                           # Regular output interval if > 0. Not used if <= 0.
SURFEX_LSELECT=yes                      # Use nam/surfex_selected_output.pm for selected SURFEX output (yes|no)

[ "$ANAATMO" = 4DVAR ] && OUTINT="3"

SURFEX_OUTPUT_FORMAT=fa                 # Output format for surfex (fa|lfi)
INT_SINI_FILE=$WRK/SURFXINI.$SURFEX_OUTPUT_FORMAT       # Surfex initial file name and location

# **** Postprocessing/output ****
IO_SERVER=no                            # Use IO server (yes|no). Set the number of cores to be used
                                        # in your Env_submit
POSTP="inline"                          # Postprocessing by Fullpos (inline|offline|none).
                                        # See Setup_postp.pl for selection of fields.
                                        # inline: this is run inside of the forecast
                                        # offline: this is run in parallel to the forecast in a separate task

CONVERTFA=yes                           # Conversion to NetCDF/grib (yes|no)
SAVE_FAOUTPUT=                          # Which FA output to save in ARCHIVE after succesful conversion by convertFA (colon separated list)
OUTPUT_FORMAT=nc                        # Format of output files (nc|grib)
MAKEGRIB_LISTENERS=1                    # Number of parallel listeners for Makegrib
                                        # Only applicable if ARCHIVE_FORMAT=grib
INSTITUTE=SMHI                          # Name of your institute (used in netcdf attributes)

# Postprocessing times (space separated list)
PWRITUPTIMES="03 06 09 12 15 18 21 24 30 36 42 48 54 60"
FPOUTINT="1"                            # Regular  interval if > 0. Not used if <= 0.

FREQ_RESET=24                           # Reset frequency of max/min values in hours, controls NRAZTS


# **** Obs verification ****
VERIFY=no                               # Run verification in the experiment (yes|no)
OBSEXTR=bufr                            # Extract observations from BUFR (bufr|vobs|none)
                                        # bufr = create vobs file from BUFR files
                                        # vobs = copy pre-extracted vobs file from VOBSDIR
VOBSDIR=$EXTRARCH                       # Local directory of pre-extracted vobs files
FLDEXTR=no                              # Extract model data for verification from model files (yes|no)
FLDEXTR_TASKS=1                         # Number of parallel tasks for field extraction (number of nodes if MULTITASK)
VFLDEXP=$EXP
VERITIMES=$WRITUPTIMES                  # Verification times
VVOUTINT="-1"                           # Regular output interval for verification if > 0. Not used if <= 0.
VER_SDATE=$DTGBEG                       # Start verification date in format ($DTGBEG|YYYYMMDDHH)
                                        # applicable if VERIFY=yes


# *** Field verification ***
FLDVER=no                               # Main switch for field verification (yes|no)
FLDVER_HOURS="06 12 18 24 30 36 42 48"  # Hours for field verification

# *** Observation monitoring ***
OBSMONITOR=plotlog:obstat               # Create Observation statistics plots
                                        # Format: OBSMONITOR=Option1:Option2:...:OptionN
                                        # obstat: Daily usage maps and departures
                                        # plotlog: IFS log statistics
                                        #  - Grid point and spectral norms evolution
                                        #  - Cost function evolution, if applicable
                                        #  - Observation usage from the minimization, if applicable
                                        # no: Nothing at all
                                        #
                                        # The assimilation related monitoring is
                                        # only active if ANAATMO != none

#  *** Monitoring maps for hirlam.org. ***
#      Note that at ECMWF this is run on ecgb (grads is only there)
#      In  this version You must check out manually contrib/mapbin to the 
#      directory referred as MAPBIN 
FIELDMONITOR=no
MAPBIN=$HM_DATA/lib/util/mapbin

# Recipient(s) to send mail to when a task aborts
MAIL_ON_ABORT=                          # you@work,you@home

# Exporting variables for the system
export ARCHIVE_ROOT EXTRARCH BINDIR LL WRK CLIMDIR MODEL
export BDLIB BDDIR BDINT BDSTRATEGY NBDMAX MARS_EXPVER HOST_MODEL
export TFLAG OUTINT SFXOUTINT FPOUTINT VVOUTINT GRIB_TIME_UNIT
export POSTP CONVERTFA MAKEGRIB_LISTENERS OUTPUT_FORMAT SAVE_FAOUTPUT
export ECFSLOC ECFSGROUP NLBC FCINT DOMAIN BDCLIM LSMIXBC CISBA INCV INCO CROUGH SURFEX_SEA_ICE
export VERITIMES OBSEXTR FLDEXTR FLDEXTR_TASKS VFLDEXP VOBSDIR SURFEX_OUTPUT_FORMAT SURFEX_INPUT_FORMAT
export BUILD CREATE_CLIMATE VERIFY REVISION BRANCH OPTION PROGRAM OTHER_PROGRAMS BUILD_ROOTPACK VERSION
export WRITUPTIMES SWRITUPTIMES PWRITUPTIMES FLDVER_HOURS FLDVER SURFEX_PREP HOST_SURFEX SURFEX_LSELECT
export ANASURF_MODE EXT_BDDIR EXT_BDFILE EXT_ACCESS JB_INTERPOL SINGLEOBS
export FIELDMONITOR MAPBIN
export BDFILE

export ANAATMO ANASURF ANASURF_INLINE VLEV VER_SDATE ARCHIVE_ECMWF FLDEXTR SST_SOURCES
export MAKEODB2
export NOUTERLOOP ILRES TSTEP4D
export OBDIR RADARDIR OBSMONITOR
export DYNAMICS PHYSICS SURFACE DFI TAUS TSPAN LGRADSP LSPBDC LUNBC
export CNMEXP INSTITUTE RUNNING_MODE HARATU
export INT_BDFILE INT_SINI_FILE
export TL_TEST AD_TEST
export ECOCLIMAP_VERSION SOIL_TEXTURE_VERSION
export SIMULATION_TYPE
export ARSTRATEGY FREQ_RESET
export IO_SERVER
export MAIL_ON_ABORT

export USE_MSG MSG_PATH
export PERTATMO PERTSURF SLAFLAG SLAFK
export ENSMSEL ENSBDMBR ENSINIPERT ENSCTL ENSMFAIL ENSMDAFAIL FESTAT
export MULTITASK

# Define your testbed list here
# The definition of the different configurations can be found in scr/Harmonie_testbed.pl
export TESTBED_LIST="AROME AROME_1D AROME_3DVAR AROME_MUSC \
                     ALARO ALARO_1D ALARO_3DVAR \
                     AROME_BD_ARO \
                     AROME_EKF \
                     ALARO_3DVAR_OLD \
                     AROME_CLIMSIM \
                     AROME_EPS \
                     AROME_EPS_COMP ALARO_EPS_COMP \
                     AROME_3DVAR_FA_IO_SERVER"

# Under investigation
# ALARO_MUSC \
# AROME_BD_ALA \

# Let the testbed continue when a child fails
export CONT_ON_FAILURE=0
