module erosion
  implicit none
  
  contains
  
  subroutine main(S,K,R,C,veget,crop,gravel,rows,kols,E) !input should be crop[t] etc..;
    
    implicit none
    
    integer,intent(in)                          :: kols, rows
    real(8),dimension(kols*rows),intent(in)     :: gravel,S,K,R,C,crop
    character (LEN=4),intent(in)                :: veget
    integer                                     :: i   
    real(8),dimension(kols*rows),intent(out)    :: E 
    
    do i=1,size(gravel)
      E(i)=S(i)*K(i)*R(i)*C(i)
      if (veget=="crop") then
        if ((crop(i))>=0.01) then
          if (gravel(i)>12.) then
            E(i)=E(i)-(0.8*E(i))
          else
            E(i)=E(i)
          endif
        else
          if (gravel(i)>30.) then
            E(i)=E(i)-(0.3*E(i))
          else
            E(i)=E(i)
          endif
        endif
      else
        if (gravel(i)>30.) then
          E(i)=E(i)-(0.3*E(i))
        else
          E(i)=E(i)
        endif
      endif  
    enddo
  end subroutine main
end module erosion
     
