#!/bin/ksh
#data processing to calculate erosion rates

work_dir=... #Enter here your work directory
gridfile1=... #Enter here the path to the txt file specifying the gridtype at 5arcminute resolution
gridfile2=... Enter here the path to the txt or nc file specifying the gridtype at the resolution or ORCHIDEE
landvars="tree gras crop bare"

###############################
# Part 1: execute before running erosion.py
###############################
#setgrid R files
a=1851
for f in $work_dir/R_factor/*;do
    echo $f
    new=$(printf "$work_dir/R_factor/ISIMIP2b_R_%04d.nc" "$a")
    new_out=$(printf "$work_dir/R_factor/ISIMIP2b_R_%04d_5m.nc" "$a")
    cdo setgrid,$gridfile1 ${new} ${new_out}
    let a=a+1
done

# setgrid & remap C factor 
a=1851
for f in $work_dir/C_factor/*;do
    new=$(printf "$work_dir/C_factor/C_%04d_025deg.nc" "$a")
    new2=$(printf "$work_dir/C_factor/C_%04d_025deg_grid.nc" "$a")
    new3=$(printf "$work_dir/C_factor/C_%04d_5m.nc" "$a")
    cdo setgrid,$gridfile2 ${new} ${new2}
    cdo remapbil,$gridfile1 ${new2} ${new3}
    let a=a+1
done

###############################
# Part 2: execute after running erosion.py
###############################
# setgrid erosion 
a=1851
for f in $work_dir/erosion/*;do
  for lc in $landvars;do
    new=$(printf "$work_dir/erosion/E_${lc}_%04d.nc" "$a")
    cdo setgrid,$gridfile1 ${new} ${new%%.*}_grid.nc
  done
  let a=a+1
done

###############################
# Part 3: execute after running erosion_per_PFT.py
###############################
#sum erosion over all landcover types
a=1851
for y in {1..154};do
  file1=$(printf "$work_dir/erosion/E_tree_%04d_grid.nc" "$a")
  file2=$(printf "$work_dir/erosion/E_crop_%04d_grid.nc" "$a")
  file3=$(printf "$work_dir/erosion/E_gras_%04d_grid.nc" "$a")
  file4=$(printf "$work_dir/erosion/E_bare_%04d_grid.nc" "$a")
  file_out1=$(printf "$work_dir/erosion/E_total/E_tot_%04d_grid.nc" "$a")
  file_out2=$(printf "$work_dir/erosion/E_total/E_sum_%04d_grid.nc" "$a")
  cdo cat ${file1} ${file2} ${file3} ${file4} ${file_out1}
  cdo timsum ${file_out1} ${file_out2}
  let a=a+1
done





