# -*- coding: utf-8 -*-
import numpy as np
from netCDF4 import Dataset
import erosivity
######################################################################################
#This script calculates the R factor according to method from Naipal et al.(2015) at a yearly timestep
######################################################################################
#settings 
fname=' ' #enter here your work directory
rows=1680 #global 5arcmin resolution grid
kols=4322
years=range(1851,2006)

data = Dataset('%s/climate/climate_classification_5m.nc' % (fname) ,'r')
k= data.variables['climate'][:]
k[k<0.]=np.nan
k = np.ravel(k)
data.close()    

data = Dataset('%s/topo/etopo5_5m.nc' % (fname),'r')
elev = data.variables['elev'][:]
elev[elev<0.]=-9999.
elev = np.ravel(elev)
data.close()

# remove too small elevation values and zeros
z = []
for i in range(len(elev)):
  if elev[i] >=0.:
    if elev[i] < 0.001:
      z.append(0.001)
    else:
      z.append(elev[i])
  else:
    z.append(np.nan)
z = np.asarray(z)
z = np.ma.masked_array(z,[np.isnan(x) for x in z])
k = np.ma.masked_array(k,[np.isnan(x) for x in k])

print 'data processing done, starting R calculation'
#############################################################
# new R calculation according to linear regression with fortran90
#############################################################
for t in years:
  data = Dataset('%s/climate/R_factor/P/ISIMIP2b_%04i_P_5m.nc' % (fname,t),'r') # total yearly precipitation
  precip= data.variables['p'][:]
  precip[precip<=0.]=-9999.
  precip[precip>10000.]=-9999. 
  p = np.ravel(precip)
  p = np.ma.masked_array(p,[np.isnan(x) for x in p])
  data.close()
  
  data = Dataset('%s/climate/R_factor/SDII/ISIMIP2b_%04i_SDII_5m.nc' % (fname,t),'r') #SDII
  sdii = data.variables['SDII'][:] 
  sdii[sdii<0.]=-9999.
  sdii[sdii>10000.]=-9999.
  sdii = np.ravel(sdii)
  data.close()
  
  # calculate R factor     
  r=erosivity.erosivity.main(sdii,z,k,p,rows,kols)
  r[r<0.]=np.nan
  r=r.reshape(rows,kols)
  #output
  output = Dataset('%s/climate/R_factor/R/ISIMIP2b_R_%04i.nc' % (fname,t),'w') 
  output.create_dimension('lat',rows)
  output.create_dimension('lon',kols)
  output.create_variable('r','d',('lat','lon',))
  output.variables['r'][:] = r
  output.close()
