module cfactor
  implicit none
  
  contains
  
  subroutine main(cf,lcfrac,lc,rows,kols,c_out) !input should be tree[t] etc..;
    
    implicit none
    
    integer,intent(in)                          :: kols, rows
    real(8),dimension(kols*rows),intent(in)     :: cf, lcfrac
    integer                                     :: i
    real(8)                                     :: a,b
    character (LEN=4), dimension(4)             :: veget
    character (LEN=4), intent(in)               :: lc
    real(8),dimension(kols*rows),intent(out)    :: c_out 
    
    veget=(/"tree","crop","gras","bare"/)
    do i=1,size(cf)
      if (lc==veget(1)) then
        if (cf(i)>=0.75) then
          a=-0.0036
          b=0.0037
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>=0.45) then
          a=-0.008
          b=0.0076
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>=0.2) then
          a=-0.03
          b=0.015
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>0.) then
          a=-2.3333
          b=0.45
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        else
          c_out(i)= -9999.
        endif
      elseif (lc==veget(2)) then
        if (cf(i)>=0.75) then
          a=-0.108
          b=0.111
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>=0.5) then
          a=-0.5
          b=0.39
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>=0.25) then
          a=-0.95
          b=0.5774
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>0.) then
          a=-0.5
          b=0.45
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        else
          c_out(i)= -9999.
        endif
      elseif (lc==veget(3)) then
        if (cf(i)>=0.75) then
          a=-0.028
          b=0.031
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>=0.5) then
          a=-0.1
          b=0.09
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>=0.25) then
          a=-0.2
          b=0.13
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        elseif (cf(i)>0.) then
          a=-1.75
          b=0.45
          c_out(i)=((a*cf(i))+b)*lcfrac(i)
        else
          c_out(i)= -9999.
        endif
      else
        c_out(i)=lcfrac(i)*0.45
      endif
    enddo
  end subroutine main
  
end module cfactor
     
