module multi_flow
  implicit none
  
  contains
  
  subroutine main(DEM_in,bound_in,number_in1,weight_in1,rows,kols,x,y,number_out,weight_out)
    implicit none
    
    real(8),dimension(rows)			:: lat, lat_rad
    real(8),dimension(kols)			:: lon, lon_rad
    real(8),dimension(kols,rows) 		:: DEM, tau
    integer,dimension(kols,rows)                :: bound
    real(8),dimension(7*kols*rows),intent(in)   :: weight_in1
    integer,dimension(7*kols*rows),intent(in)   :: number_in1
    real(8),dimension(7,kols,rows)              :: weight_in
    integer,dimension(7,kols,rows)              :: number_in
    real(8),dimension(7,kols,rows),intent(out)  :: weight_out
    integer,dimension(7,kols,rows),intent(out)  :: number_out
    integer 					:: k, l, number
    integer,dimension(:),allocatable 		:: xi, yi
    integer,dimension(kols*rows),intent(in) 	:: x, y
    integer,intent(in) 				:: kols, rows
    integer 					:: i, j, z
    real(8) 					:: a, c, d, s, d_latt, d_long
    real(8),dimension(9) 			:: part, weight
    real(8),dimension(rows*kols),intent(in) 	:: DEM_in
    integer,dimension(kols*rows),intent(in)     :: bound_in
    real(8), parameter 				:: pi = 3.141592653589793
    
    ! x is kols and y is rows; j is kols and i is rows
    ! x and y are already sorted index arrays
    DEM=reshape(DEM_in,(/kols,rows/))
    bound=reshape(bound_in,(/kols,rows/))
    number_in=reshape(number_in1,(/7,kols,rows/))
    weight_in=reshape(weight_in1,(/7,kols,rows/))
    lat(1)=52.325
    do z=2,rows
      lat(z) = lat(z-1)-0.0833333
    enddo
    lat_rad=(lat/180.)*pi
    lon(1)=4.04166
    do z=2,kols
      lon(z) = lon(z-1)+0.0833333
    enddo
    lon_rad=(lon/180.)*pi
    d_latt = (-0.0833333/180.)*pi
    d_long = (0.0833333/180.)*pi
    !now  do the multiple flowacc
    do z=1, size(DEM_in)
      if (bound(x(z),y(z))==8) then
        if (y(z)>1 .and. y(z)<rows) then !rows
          allocate (yi(3))
          yi=(/0,-1,1/)
        elseif (y(z)>1) then
          allocate (yi(2))
          yi=(/0,-1/)
        else
          allocate (yi(2))
          yi=(/0,1/)
        endif
        if (x(z)>1 .and. x(z)<kols) then !kols now
          allocate (xi(3))
          xi=(/0,-1,1/)
        elseif (x(z)>1) then
          allocate (xi(2))
          xi=(/0,-1/)
        else
          allocate (xi(2))
          xi=(/0,1/)
        endif

        part=(/0,0,0,0,0,0,0,0,0/)
        weight=(/0.353553,0.5,0.353553,0.5,0.5,0.353553,0.5,0.353553,0.5/)
        s=0.
        number=1  
        do j=1, size(xi)
          do i=1, size(yi)
            k=xi(j) !kols
            l=yi(i) !rows
            if (k==0 .and. l==0) then
              continue
            endif
            if (DEM(x(z)+k,y(z)+l)<=DEM(x(z),y(z))) then
              a = sin(d_latt/2)**2 + cos(lat_rad(y(z))) * cos(lat_rad(y(z)+l)) * sin(d_long/2)**2  
              c = 2 * asin(sqrt(a))
              d = 6378137.*c
              part(number)=(DEM(x(z),y(z))-DEM(x(z)+k,y(z)+l))/d
              s=s+part(number)*weight(number)
            else
              part(number)=0
            endif
            number=number+1
          enddo
        enddo
        number=1
        do j=1, size(xi)
          do i=1, size(yi)
            k=xi(j) !kols
            l=yi(i) !rows
            if (k==0 .and. l==0) then
              continue
            endif
            if (part(number)>0) then
              number_in(number,x(z),y(z))=1*number
              weight_in(number,x(z),y(z))=(part(number)*weight(number)/s)
            endif
            number=number+1
          enddo
        enddo
      else
        allocate (xi(0))
        allocate (yi(0))
      endif
      deallocate(xi)
      deallocate(yi)       
    enddo
    number_out=number_in
    weight_out=weight_in
  end subroutine main
end module multi_flow


