module multi_flow
  implicit none
  
  contains
  
  subroutine main(A_in,DEM_in,M_in,str_bas_in,weight_in1,number_in1, &
                  bound_in,tau_in,rows,kols,x,y,b,M_T_out,flux_out,kout,k_flux_out)
    implicit none
    
    real(8),dimension(rows)     		 :: lat, lat_rad
    real(8),dimension(kols)			 :: lon, lon_rad
    integer		                         :: k, l, number,num
    integer,intent(in)                           :: b
    real(8),dimension(kols,rows)                 :: M, DEM, tau, flux, M_T_tot, k_tot, k_flux, M_tot, A_FL 
    real(8),dimension(kols,rows),intent(out)     :: flux_out, kout, M_T_out, k_flux_out
    integer,dimension(kols,rows)                 :: str_bas, bound
    integer,dimension(:),allocatable 		 :: xi, yi
    integer,dimension(b),intent(in)              :: x, y
    integer,dimension(7*kols*rows),intent(in)    :: number_in1
    real(8),dimension(7*kols*rows),intent(in)    :: weight_in1
    integer,dimension(7,kols,rows)               :: number_in
    real(8),dimension(7,kols,rows)               :: weight_in
    integer,intent(in) 				 :: kols, rows
    integer 					 :: i, j, z, pft
    real(8) 					 :: a, c, d, s, d_latt, d_long, M_T, k_T
    real(8),dimension(9) 			 :: part, weight
    real(8),dimension(rows*kols),intent(in)      :: M_in, DEM_in, tau_in, A_in
    integer,dimension(kols*rows),intent(in)      :: str_bas_in, bound_in
    real(8), parameter 				 :: pi = 3.141592653589793
    
    ! x is kols and y is rows; j is kols and i is rows
    ! x and y are already sorted index arrays
    ! there are two flow routines: the first one for all non-boundary gridcells in a selected basin
    ! the second one for boundery gridcells of a basin with id num
    ! M:soili
    DEM=reshape(DEM_in,(/kols,rows/))
    M=reshape(M_in,(/kols,rows/))
    tau=reshape(tau_in,(/kols,rows/))
    A_FL=reshape(A_in,(/kols,rows/))
    str_bas=reshape(str_bas_in,(/kols,rows/))
    num=str_bas(x(1),y(1))
    bound=reshape(bound_in,(/kols,rows/))
    flux=str_bas-str_bas
    k_flux=1*flux
    k_tot=1*flux
    M_T_tot=1*flux
    number_in=reshape(number_in1,(/7,kols,rows/))
    weight_in=reshape(weight_in1,(/7,kols,rows/))
    lat(1)=52.325
    do z=2,rows
      lat(z) = lat(z-1)-0.0833333
    enddo
    lat_rad=(lat/180.)*pi
    lon(1)=4.04166
    do z=2,kols
      lon(z) = lon(z-1)+0.0833333
    enddo
    lon_rad=(lon/180.)*pi
    d_latt = (-0.0833333/180.)*pi
    d_long = (0.0833333/180.)*pi
    !now  do the multiple flowacc
    do z=1, size(x)
      if (bound(x(z),y(z))/=8) then
        if (y(z)>1 .and. y(z)<rows) then
          allocate (yi(3))
          yi=(/0,-1,1/)
        elseif (y(z)>1) then
	  allocate (yi(2))
	  yi=(/0,-1/)
        else
	  allocate (yi(2))
	  yi=(/0,1/)
        endif
        if (x(z)>1 .and. x(z)<kols) then !kols now
	  allocate (xi(3))
	  xi=(/0,-1,1/)
        elseif (x(z)>1) then
	  allocate (xi(2))
	  xi=(/0,-1/)
        else
	  allocate (xi(2))
	  xi=(/0,1/)
        endif
        part=(/0,0,0,0,0,0,0,0,0/)
        weight=(/0.353553,0.5,0.353553,0.5,0.5,0.353553,0.5,0.353553,0.5/)
        s=0.
        number=1  
        do j=1, size(xi)
	  do i=1, size(yi)
	    k=xi(j) !kols
	    l=yi(i) !rows
	    if (k==0 .and. l==0) then
	      continue
	    endif
	    if (DEM(x(z)+k,y(z)+l)<=DEM(x(z),y(z))) then
	      a = sin(d_latt/2)**2 + cos(lat_rad(y(z))) * cos(lat_rad(y(z)+l)) * sin(d_long/2)**2  
	      c = 2 * asin(sqrt(a))
	      d = 6378137.*c
	      part(number)=(DEM(x(z),y(z))-DEM(x(z)+k,y(z)+l))/d
	      s=s+part(number)*weight(number)
	    else
	      part(number)=0
	    endif
	    number=number+1
	  enddo
        enddo
        number=1
        do j=1, size(xi)
	  do i=1, size(yi)
	    k=xi(j) !kols
	    l=yi(i) !rows
	    if (k==0 .and. l==0) then
	      continue
	    endif
	    if (part(number)>0) then
              k_T=(part(number)*weight(number)/s)/tau(x(z),y(z))
              M_T=M(x(z),y(z))*k_T !sum over pfts              
              M_T_tot(x(z)+k,y(z)+l)=M_T_tot(x(z)+k,y(z)+l)+M_T
              if (M_T==0.) then 
                 k_T=0.
              endif
              k_tot(x(z)+k,y(z)+l)=k_tot(x(z)+k,y(z)+l)+(k_T*A_FL(x(z),y(z))) !total transport rate of inflowing grids weighted with Area
	    endif
	    number=number+1
	  enddo
        enddo
      else
        allocate (xi(0))
        allocate (yi(0))
        do i=1, 8
          number=number_in(i,x(z),y(z))
          if (number==2) then
            k=0
            l=-1
          elseif (number==3) then
            k=0
            l=1
          elseif (number==4) then
            k=-1
            l=0
          elseif (number==5) then
            k=-1
            l=-1
          elseif (number==6) then
            k=-1
            l=1
          elseif (number==7) then
            k=1
            l=0
          elseif (number==8) then
            k=1
            l=-1
          elseif (number==9) then
            k=1
            l=1
          else
            k=0
            l=0
          endif
          if (str_bas(x(z)+k,y(z)+l)/=num .and. number>1) then
	    flux(x(z)+k,y(z)+l)=flux(x(z)+k,y(z)+l)+(M(x(z),y(z))*(weight_in(i,x(z),y(z)) &
            /tau(x(z),y(z))))
            k_flux(x(z)+k,y(z)+l)=k_flux(x(z)+k,y(z)+l)+(weight_in(i,x(z),y(z))/tau(x(z),y(z)))*A_FL(x(z),y(z))
            !M_flux(x(z)+k,y(z)+l)=M_flux(x(z)+k,y(z)+l)+M(x(z),y(z))
	  elseif (str_bas(x(z)+k,y(z)+l)/=num .and. number<=1) then
	    continue
          elseif (str_bas(x(z)+k,y(z)+l)==num .and. number>1) then
            M_T=M(x(z),y(z))*(weight_in(i,x(z),y(z))/tau(x(z),y(z))) !sum over pfts
            M_T_tot(x(z)+k,y(z)+l)=M_T_tot(x(z)+k,y(z)+l)+M_T
            k_tot(x(z)+k,y(z)+l)=k_tot(x(z)+k,y(z)+l)+(weight_in(i,x(z),y(z))/tau(x(z),y(z)))*A_FL(x(z),y(z))
            !M_tot(x(z)+k,y(z)+l)=M_tot(x(z)+k,y(z)+l)+M(x(z),y(z))
          else
            continue
          endif
        enddo
      endif
      deallocate(xi)
      deallocate(yi)
    enddo
    kout=k_tot !for all grids
    M_T_out=M_T_tot !for all grids
    flux_out=flux !for boundary grids only
    k_flux_out=k_flux !for boundary grids only
  end subroutine main
end module multi_flow


