#!/usr/bin/env python
from PythonTools import *
import numpy as np
#This script calculates the root-profile parameter 'r' per pft

def r_pft(veget,rows,kols):
  pfts=range(0,13)
  veget=veget.reshape(len(pfts),rows*kols)
  r_out=np.zeros((len(pfts),rows*kols))
  for i in range(rows*kols):
    for pft in pfts:
      if veget[pft,i]>0.:
        if pft==9 or pft==10 or pft==11 or pft==12:
          r_out[pft,i]=4.
        elif pft==3 or pft==6 or pft==7:
          r_out[pft,i]=1.
        elif pft==0:
          r_out[pft,i]=5.
        else:
          r_out[pft,i]=0.8
      else:
        r_out[pft,i]=0.
  r_out=r_out.reshape(len(pfts),rows,kols)
  return r_out
