#!/usr/bin/env python
#######################################################################
# This script calculates the daily changes to biomass, litter and SOC stocks at a daily timestep
# Biomass and litter changes are performed at the coarse resolution of ORCHIDEE
# After each year routing takes place between the subbasins in simulation S2
#######################################################################
def func_tr(OptPath,num,year,rows_c,kols_c,row_bas_sel,kol_bas_sel,rows_h,kols_h,\
            x_new,y_new,id_sub,DEM_in,soila_FL,soils_FL,soilp_FL,soila_HS,soils_HS,\
            soilp_HS,tau_in,bound_in,weight_out,number_out,NPP_leaf,NPP_sapab,\
            NPP_sapbe,NPP_root,NPP_fruit,NPP_reserv,ynpp_pft11,ynpp_pft11_new,\
            kmb_res,kmort_leaf,kmort_sapab,kmort_sapbe,kmort_hrtab,kmort_hrtbe,\
            kmort_root,kmort_fruit,kmort_reserv,kturn_leaf,\
            kturn_sapab,kturn_root,kturn_fruit,kharv_leaf,kharv_sapab,kharv_root,kharv_fruit,\
            kfire_leaf,kfire_sapab,kfire_hrtab,kfire_fruit,kfire_reserv,klitma_soila,\
            klitmb_soila,klitsa_soila,klitsa_soils,klitsb_soila,klitsb_soils,kresp_litma,\
            kresp_litmb,kresp_litsa,kresp_litsb,kfire_litma,kfire_litsa,kresp_soila,\
            kresp_soils,kresp_soilp,ksoila_s,ksoila_p,ksoils_a,ksoils_p,ksoilp_a,logfile_SOC,logfile_BL,queue):
  import sys
  #sys.path.insert(0,' ') #Enter path to modules if neccessary 
  from PythonTools import *
  import numpy as np
  from netCDF4 import Dataset
  import os
  import inspect  
  import csv
  from rootprofile import r_pft
  from D import D_pft
  import routing_main_all
  ######################################################################
  #settings
  ######################################################################
  print('THIS tile IS NUMBER ',num) #respective subbasin
  fname=' ' #Enter here your workdir
  maskfile_h='%s/Rhine_mask_5m_new.nc' % (fname) Enter here the path to the 5 arcmin mask file
  OrcPath2='%s/' % (fname) #Enter here the path to vegetation fractions at the coarse resolution of ORCHIDEE
  OrcPath=' ' #Enter here the path to the turnover files of ORCHIDEE
  vegetPath='%s/' % (fname) #Enter here the path to vegetation fractions at 5 arcmin
  BDPath='%s/' % (fname) #Enter here the path to bulk density data
  EPath='%s/ ' % (fname) # Enter here the path to erosion data
  b=len(id_sub) #number of gridcells of subbasin
  #soil layer parameters
  dz0=0.1
  zmax0=2
  soil_layers=np.arange(zmax0/dz0) #20 soil layers of each 0.1m thickness
  soil_layers=soil_layers.astype(int)
  dz_all=np.empty(len(soil_layers))
  dz_all.fill(dz0)
  zmin=np.arange(0.,zmax0,dz0) 
  zmax=np.arange(0.+dz0,zmax0+dz0,dz0)
  Lab_top=0.1
  soil_layers_top=np.arange(Lab_top/dz0)
  soil_layers_top=soil_layers_top.astype(int)
  # fraction of plants turned to metabolic/structural litter
  LC=np.array([0.22,0.35,0.35,0.35,0.35,0.22,0.22,0.22])
  litfrac_m=0.85-0.018*LC*40.  # metabolic_ref_frac - metabolic_LN_ratio * LC(k) * CN(k)
  litfrac_s=1.-litfrac_m
  # fraction of woody parts turned to products when LUC happens (1 bare land + 8 forest PFTs); 
  #bare land have no carbon, 0 for convenience
  LUCfrac001=np.array([0.,0.897,0.897,0.597,0.597,0.597,0.597,0.597,0.597,0.597,0.597,0.597,0.597]).reshape(13,1,1)
  LUCfrac010=np.array([0.,0.103,0.103,0.299,0.299,0.299,0.299,0.299,0.299,0.299,0.403,0.299,0.403]).reshape(13,1,1)
  LUCfrac100=1.-LUCfrac001-LUCfrac010
  if OptPath=='%s/' % (fname): #Enter here the output directory of simulation S2
    luc='y'
    set_eros='cc_luc'
    depo='y'
  elif OptPath=='%s/' % (fname): #Enter here the output directory of simulation S0
    luc='y'
    set_eros='0'  
    depo='n'
  elif OptPath=='%s/' % (fname): #Enter here the output directory of simulation S1
    luc='y'
    set_eros='cc_luc' 
    depo='n'
  x=np.array([1.]*15)
  xNPP=x[0]
  xmort=x[1:-4]
  xl,xa,xs,xp=x[-4:]
  SOC_HS_old=soila_HS+soils_HS+soilp_HS
  SOC_FL_old=soila_FL+soils_FL+soilp_FL
  ######################################################################
  #neccessary input files
  ######################################################################
  Anc=Dataset('%s/stomate.1851_1901.lmdz_monthly.TRENDY.newVCmax.Rhine.nc' %(OrcPath),'r') #coarse-resolution area
  AREA_c=Anc.variables['Areas'][rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] #m2
  contfrac=Anc.variables['CONTFRAC'][rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  AREA_c=AREA_c*contfrac
  AREA_c=np.where(abs(AREA_c)>1.e36,0.,AREA_c)
  land=contfrac<=1.
  sea=True-land
  Anc.close()
  data_h=Dataset(maskfile_h,'r')
  mask=data_h.variables['mask'][:]
  data_h.close()
  Bnc=Dataset('%s/BD5min.nc' %(BDPath),'r') # bulkdensity
  BD=Bnc.variables['BD'][0:3,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1]*0.01
  Bnc.close()
  BD=BD.astype(float)
  BD[BD<0.]=np.nan
  BD_top=np.nanmean(BD,axis=0) #average over toplayers, (lat,lon)    
  Snc = Dataset('%s/Rhine_slope_scaled_rad_5m_new.nc' % (fname),'r') #slope
  slope= Snc.variables['slope'][:] #radials
  Snc.close()
  slope=np.array(slope)
  slope=np.tan(slope)
  slope[np.isnan(slope)==True]=0.001
  slope[slope<=0.001] = 0.001
  f=D_pft(slope,rows_h,kols_h) #floodplain deposition factor
  Snc=Dataset('%s/Rhine_regions_final2_grid.nc' %(fname),'r') 
  str_bas=Snc.variables['str_bas'][:]
  str_bas=np.ravel(str_bas)
  str_bas_in=str_bas.astype(int)
  Snc.close()
  number_out=np.ravel(number_out)
  weight_out=np.ravel(weight_out)
  bound_in=bound_in.astype(int)
  ######################################################################
  #Read the harvest index and NPP modifier index for C3 crops (PFT=11)
  ######################################################################
  DataOut=[]
  hvfile='%snew_harvest_index_1851-2005.csv' % (fname)
  with open(hvfile) as data:
    next(data)
    reader=csv.reader(data,delimiter=',')
    for row in reader:
      DataOut.append(row)
  DataOut=np.asarray(DataOut)
  harv_new_id=[float(x) for x in DataOut[:,1]]
  harv_new_id=np.asarray(harv_new_id)
  DataOut=[]
  yield_file='%s/observed_yield.txt' % (fname)
  with open(yield_file) as data:
    next(data)
    reader=csv.reader(data,delimiter=',')
    for row in reader:
      DataOut.append(row)
  DataOut=np.asarray(DataOut)
  obs_yield=[float(x) for x in DataOut[:,0]]
  obs_yield=np.asarray(obs_yield)*100. #t/ha to g/m2/y
  
  ######################################################################
  #calcultation of floodplain and hillslope fractions
  ######################################################################
  areanc=Dataset('%s/Global_land_grid_area_5m_grid.nc' % (fname),'r') 
  AREA_h=areanc.variables['area'][rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1]*1000000. 
  AREA_h[AREA_h<=0.]=np.nan
  Ahs_nc=Dataset('%s/hill-slope_valley-bottom_Rhine_5m_new.nc' % (fname),'r')
  Ahs=Ahs_nc.variables['Band1'][:] 
  Afl_nc=Dataset('%s/Rhine_Floodplain_vs_Hillslope_5m.nc' % (fname),'r')
  lowland=Afl_nc.variables['Band1'][:]
  lowland[lowland!=2.]=0.
  Ahs[lowland>0.]=0.
  AREA_HS_old=Ahs*AREA_h
  AREA_FL_old=(1-Ahs)*AREA_h
  Ahs_nc.close();Afl_nc.close();areanc.close()
  Anc=Dataset('%s/FL_contr_area2_grid.nc' % (fname),'r')
  Acontr=Anc.variables['A'][:]*1E-6 #m2 to km2
  Acontr[mask!=1]=np.nan
  Anc.close()
  Lnc=Dataset('%s/Rhine_streamL_final.nc' % (fname),'r')
  stream_L=Lnc.variables['Band1'][:]*1000. #km to m
  stream_L[mask!=1]=np.nan
  Lnc.close()
  stream_w=60.8*Acontr**0.3 #m
  AREA_FL_new=stream_L*stream_w #new floodplain area estimation in m2
  Afl=np.ravel(1-Ahs)
  Afl_new=np.zeros((7030,))
  for i in range(7030):
    if Afl[i]<0.1:
      Afl_new[i]=np.ravel(AREA_FL_new)[i]/np.ravel(AREA_h)[i]
    else:
      Afl_new[i]=1.*Afl[i]
  AREA_FL=Afl_new.reshape(74,95)*AREA_h
  AREA_HS=(1-Afl_new.reshape(74,95))*AREA_h
  AREA_FL[np.isnan(AREA_FL)==True]=0.
  AREA_HS[np.isnan(AREA_HS)==True]=0.
  AREA_HS_sel=np.ravel(AREA_HS)[id_sub] #select data of subbasin only
  AREA_FL_sel=np.ravel(AREA_FL)[id_sub] 
  
  ######################################################################
  #Read high-resolution and coarse-resolution vegetation fractions
  ######################################################################
  vegetnc=Dataset('%s/VEGET_TRENDY_withoutNoBio.nc' %(OrcPath2),'r')
  if luc=='y':
    oldveget=vegetnc.variables['VEGET_MAX'][year-1852,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    veget=vegetnc.variables['VEGET_MAX'][year-1851,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    veget0=vegetnc.variables['VEGET_MAX'][0,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    veget1=vegetnc.variables['VEGET_MAX'][155,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    dveget_c=np.nansum((veget1[11:,:,:]-veget0[11:,:,:]),axis=0)
    dveget_c=np.ravel(dveget_c)
    vegetnc.close()
    vegetnc_h=Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_%i_5m.nc' % (vegetPath,year),'r')
    veget_h=np.array(vegetnc_h.variables['maxvegetfrac'][0,:,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1])
    veget_h[veget_h>10.]=0.
    veget_h=veget_h.reshape(13,7030)
    oldvegetnc_h=Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_%i_5m.nc' % (vegetPath,year-1),'r')
    oldveget_h=np.array(oldvegetnc_h.variables['maxvegetfrac'][0,:,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1])
    oldveget_h[oldveget_h>10.]=0.
    oldveget_h=oldveget_h.reshape(13,7030)
    oldvegetnc_h.close()     
    veget_sel=veget_h[:,id_sub] #select data of subbasin only
    oldveget_sel=oldveget_h[:,id_sub] #select data of subbasin only
    veget_sel[veget_sel>10.]=0.
    oldveget_sel[oldveget_sel>10.]=0.        
  else:           
    veget0=vegetnc.variables['VEGET_MAX'][0,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    veget=vegetnc.variables['VEGET_MAX'][0,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    vegetnc.close()
    vegetnc_h=Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_1851_5m.nc' %(vegetPath),'r')
    veget_h=np.array(vegetnc_h.variables['maxvegetfrac'][0,:,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1])
    veget_h[veget_h>10.]=0.
    veget_h=veget_h.reshape(13,7030)
    veget_sel=veget_h[:,id_sub] #select data of subbasin only
    veget_sel[veget_sel>10.]=0.

  ######################################################################
  #Prepare erosion, deposition and sediment export rates
  ######################################################################
  if set_eros=='cc_luc' and depo=='y':
    Enc=Dataset('%sE_pft_%i_Rhine.nc' %(EPath,year),'r') 
    E=Enc.variables['E'][:] #t/m2/y #(pft,rows,kols)
    E=np.array(E)
    E_tot=np.nansum((E[1::]*veget_h.reshape(13,74,95)[1::]),axis=0)
    E_tot=np.ravel(E_tot)
    E=E.reshape(13,7030)
    for i in range(7030):
      if E_tot[i]>0.002: #erosion <=20t/ha/year
        for pft in range(1,13):
          E[pft,i]=(E[pft,i]*0.002)/E_tot[i]
    E=E.reshape(13,74,95)
    kEE=(E/365.)/(BD_top*dz0) #gross erosion rate
    kE=f*((E/365.)/(BD_top*dz0)) #net erosion rate
    kE[np.isnan(kE)==True]=0.
    kEE[np.isnan(kEE)==True]=0.
    kE=kE.reshape(13,7030)
    kE=np.transpose([kE[:,i] for i in id_sub]) #select data of subbasin only
    kE[0]=0.
    kEE=kEE.reshape(13,7030)
    kEE=np.transpose([kEE[:,i] for i in id_sub]) #select data of subbasin only
    kEE[0]=0.
    kD=(kE*AREA_HS_sel)/AREA_FL_sel #deposition rate
    kD[np.isnan(kD)==True]=0.
    kD[np.isfinite(kD)==False]=0.
    Enc.close()
    kout=(np.ravel(1/tau_in)[id_sub]) #sediment export rate; select data of subbasin only
    kout[kout>1.]=1.
    kout=kout/365.
    Ma_in=np.zeros((7030))
    Ms_in=np.zeros((7030))
    Mp_in=np.zeros((7030))
  elif set_eros=='cc_luc' and depo=='n':
    Enc=Dataset('%sE_pft_%i_Rhine.nc' %(EPath,year),'r') 
    E=Enc.variables['E'][:] 
    E=np.array(E)
    E_tot=np.nansum((E[1::]*veget_h.reshape(13,74,95)[1::]),axis=0)
    E_tot=np.ravel(E_tot)
    E=E.reshape(13,7030)
    for i in range(7030):
      if E_tot[i]>0.002: 
        for pft in range(1,13):
          E[pft,i]=(E[pft,i]*0.002)/E_tot[i]
    E=E.reshape(13,74,95)
    kEE=(E/365.)/(BD_top*dz0)
    kE=(E/365.)/(BD_top*dz0) 
    kE[np.isnan(kE)==True]=0.
    kEE[np.isnan(kEE)==True]=0.
    kE=kE.reshape(13,7030)
    kE=np.transpose([kE[:,i] for i in id_sub])
    kE[0]=0.
    kEE=kEE.reshape(13,7030)
    kEE=np.transpose([kEE[:,i] for i in id_sub])
    kEE[0]=0.
    kD=0.
    Enc.close()
    kout=0.
    ka_out=0.;ks_out=0.;kp_out=0.
  else:
    kE=0.;kEE=0.;kE=0.;kD=0.
    kout=0.;ka_out=0.;ks_out=0.;kp_out=0.
    
  ######################################################################
  #relate coarse res gridcells to high res
  ######################################################################
  kresp_soila[np.isnan(kresp_soila)==True]=0.
  kresp_soils[np.isnan(kresp_soils)==True]=0.  
  kresp_soilp[np.isnan(kresp_soilp)==True]=0.
  kresp_soila_FL=1.*kresp_soila[:,:,:,row_bas_sel[:],kol_bas_sel[:]]
  kresp_soils_FL=1.*kresp_soils[:,:,:,row_bas_sel[:],kol_bas_sel[:]]
  kresp_soilp_FL=1.*kresp_soilp[:,:,:,row_bas_sel[:],kol_bas_sel[:]]
  kresp_soila_HS=1.*kresp_soila[:,:,:,row_bas_sel[:],kol_bas_sel[:]]
  kresp_soils_HS=1.*kresp_soils[:,:,:,row_bas_sel[:],kol_bas_sel[:]]
  kresp_soilp_HS=1.*kresp_soilp[:,:,:,row_bas_sel[:],kol_bas_sel[:]]
  ksoila_s=ksoila_s[:,:,row_bas_sel[:],kol_bas_sel[:]]
  ksoila_p=ksoila_p[:,:,row_bas_sel[:],kol_bas_sel[:]]
  ksoils_a=ksoils_a[:,:,row_bas_sel[:],kol_bas_sel[:]]
  ksoils_p=ksoils_p[:,:,row_bas_sel[:],kol_bas_sel[:]]
  ksoilp_a=ksoilp_a[:,:,row_bas_sel[:],kol_bas_sel[:]]
  
  ######################################################################
  # Run biomass and litter scheme for equilibrium conditions first,\
  # then read yearly biomass and litter pools from output files of previous year
  ######################################################################
  if year==1852:
    kc=Dataset('%s/K0_RESP_1851_1860_mean.Rhine.nc' %(OrcPath),'r')
    kresp_soila0=kc.variables['krespa0'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]*365.
    kresp_soils0=kc.variables['kresps0'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]*365.
    kresp_soilp0=kc.variables['krespp0'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]*365.
    kresp_soila0[kresp_soila0<1E-10]=0.
    kresp_soils0[kresp_soils0<1E-10]=0.
    kresp_soilp0[kresp_soilp0<1E-10]=0.
    kc.close()
    nc=Dataset('%s/K_ORCHIDEE.1851_1860_mean.TRENDY.newVCmax.Rhine.nc' %(OrcPath),'r')
    NPP_leaf_old  =nc.variables['NPP_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_sapab_old =nc.variables['NPP_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_sapbe_old =nc.variables['NPP_sapbe' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_root_old  =nc.variables['NPP_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_fruit_old =nc.variables['NPP_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_reserv_old=nc.variables['NPP_reserv'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmb_res_old=nc.variables['kmb_res'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_leaf_old  =nc.variables['kmort_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_sapab_old =nc.variables['kmort_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_sapbe_old =nc.variables['kmort_sapbe' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_hrtab_old =nc.variables['kmort_hrtab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_hrtbe_old =nc.variables['kmort_hrtbe' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_root_old  =nc.variables['kmort_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_fruit_old =nc.variables['kmort_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kmort_reserv_old=nc.variables['kmort_reserv'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kturn_leaf_old  =nc.variables['kturn_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kturn_sapab_old =nc.variables['kturn_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kturn_root_old  =nc.variables['kturn_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kturn_fruit_old =nc.variables['kturn_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    #kconv_sapab =(1./730.)*np.ones((veget.shape))
    #kconv_sapbe =(1./730.)*np.ones((veget.shape))
    kconv_sapab =0.5*np.ones((veget.shape))
    kconv_sapbe =0.5*np.ones((veget.shape))
    kharv_leaf_old  =nc.variables['kharv_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kharv_sapab_old =nc.variables['kharv_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kharv_root_old  =nc.variables['kharv_root'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kharv_fruit_old =nc.variables['kharv_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kharv_leaf_new=1.*kharv_leaf_old
    kharv_sapab_new=1.*kharv_sapab_old
    kharv_fruit_new=1.*kharv_fruit_old
    kharv_root_new=1.*kharv_root_old
    kfire_leaf_old  =nc.variables['kfire_leaf'  ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kfire_sapab_old =nc.variables['kfire_sapab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kfire_hrtab_old =nc.variables['kfire_hrtab' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kfire_fruit_old =nc.variables['kfire_fruit' ][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    kfire_reserv_old=nc.variables['kfire_reserv'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
    klitma_soila_old=nc.variables['klitma_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    klitmb_soila_old=nc.variables['klitmb_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    klitsa_soila_old=nc.variables['klitsa_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    klitsa_soils_old=nc.variables['klitsa_soils'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    klitsb_soila_old=nc.variables['klitsb_soila'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    klitsb_soils_old=nc.variables['klitsb_soils'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kresp_litma_old=nc.variables['kresp_litma'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kresp_litmb_old=nc.variables['kresp_litmb'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kresp_litsa_old=nc.variables['kresp_litsa'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kresp_litsb_old=nc.variables['kresp_litsb'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kfire_litma_old=nc.variables['kfire_litma'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    kfire_litsa_old=nc.variables['kfire_litsa'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]      
    # 1. biomass
    kharv_leaf_new[11]     =kharv_leaf_old[11]*(harv_new_id[0]/0.45)
    kharv_fruit_new[11]    =kharv_fruit_old[11]*(harv_new_id[0]/0.45)
    kharv_sapab_new[11]    =kharv_sapab_old[11]*(harv_new_id[0]/0.45)
    kharv_root_new[11]     =kharv_root_old[11]*(harv_new_id[0]/0.45)
    # kloss
    kloss_leaf     =kmort_leaf_old*xmort[0]+kturn_leaf_old+kharv_leaf_new+kfire_leaf_old
    kloss_sapab    =kmort_sapab_old*xmort[0]+kturn_sapab_old+kharv_sapab_new+kfire_sapab_old+kconv_sapab
    kloss_sapbe    =kmort_sapbe_old*xmort[0]+kconv_sapbe
    kloss_hrtab    =kmort_hrtab_old*xmort[0]+kfire_hrtab_old
    kloss_hrtbe    =kmort_hrtbe_old*xmort[0]
    kloss_root     =kmort_root_old*xmort[0]+kturn_root_old+kharv_root_new
    kloss_fruit    =kmort_fruit_old*xmort[0]+kturn_fruit_old+kharv_fruit_new+kfire_fruit_old
    kloss_reserv   =kmort_reserv_old*xmort[0]+kfire_reserv_old+kmb_res_old
    # equilibrium of biomass without NPP changes
    leaf_old     =NPP_leaf_old*xNPP/kloss_leaf
    leaf_old     =np.where((leaf_old!=leaf_old),0.,leaf_old)
    sapab_old    =NPP_sapab_old*xNPP/kloss_sapab
    sapab_old    =np.where((sapab_old!=sapab_old),0.,sapab_old)
    sapbe_old    =NPP_sapbe_old*xNPP/kloss_sapbe
    sapbe_old    =np.where((sapbe_old!=sapbe_old),0.,sapbe_old)
    hrtab_old    =sapab_old*kconv_sapab/kloss_hrtab
    hrtab_old    =np.where((hrtab_old!=hrtab_old),0.,hrtab_old)
    hrtab_old[np.isfinite(hrtab_old)==False]=0.
    hrtbe_old    =sapbe_old*kconv_sapbe/kloss_hrtbe
    hrtbe_old    =np.where((hrtbe_old!=hrtbe_old),0.,hrtbe_old)
    root_old    =NPP_root_old*xNPP/kloss_root
    root_old    =np.where((root_old!=root_old),0.,root_old)
    fruit_old    =NPP_fruit_old*xNPP/kloss_fruit
    fruit_old    =np.where((fruit_old!=fruit_old),0.,fruit_old)
    reserv_old   =NPP_reserv_old*xNPP/kloss_reserv
    reserv_old   =np.where((reserv_old!=reserv_old),0.,reserv_old)
    #scale NPP PFT 11
    NPP_leaf_new=1.*NPP_leaf_old;NPP_sapab_new=1.*NPP_sapab_old
    NPP_root_new=1.*NPP_root_old;NPP_fruit_new=1.*NPP_fruit_old
    NPP_sapbe_new=1.*NPP_sapbe_old;NPP_reserv_new=1.*NPP_reserv_old
    mod_yield=((kharv_leaf_new[11]*leaf_old[11])+(kharv_fruit_new[11]*fruit_old[11])\
               +(kharv_sapab_new[11]*sapab_old[11])+(kharv_root_new[11]*root_old[11]))\
               *veget0[11]
    scale_factor=obs_yield[0]/mod_yield
    scale_factor[mod_yield<=0.]=1.
    NPP_leaf_new[11]=scale_factor*NPP_leaf_old[11]
    NPP_sapab_new[11]=scale_factor*NPP_sapab_old[11]
    NPP_root_new[11]=scale_factor*NPP_root_old[11]
    NPP_fruit_new[11]=scale_factor*NPP_fruit_old[11]
    NPP_sapbe_new[11]=scale_factor*NPP_sapbe_old[11]
    NPP_reserv_new[11]=scale_factor*NPP_reserv_old[11]    
    # equilibrium of biomass with NPP change
    leaf     =NPP_leaf_new*xNPP/kloss_leaf
    leaf     =np.where((leaf!=leaf),0.,leaf)
    sapab    =NPP_sapab_new*xNPP/kloss_sapab
    sapab    =np.where((sapab!=sapab),0.,sapab)
    sapbe    =NPP_sapbe_new*xNPP/kloss_sapbe
    sapbe    =np.where((sapbe!=sapbe),0.,sapbe)
    hrtab    =sapab*kconv_sapab/kloss_hrtab
    hrtab    =np.where((hrtab!=hrtab),0.,hrtab)
    hrtab[np.isfinite(hrtab)==False]=0.
    hrtbe    =sapbe*kconv_sapbe/kloss_hrtbe
    hrtbe    =np.where((hrtbe!=hrtbe),0.,hrtbe)
    root     =NPP_root_new*xNPP/kloss_root
    root     =np.where((root!=root),0.,root)
    fruit    =NPP_fruit_new*xNPP/kloss_fruit
    fruit    =np.where((fruit!=fruit),0.,fruit)
    reserv   =NPP_reserv_new*xNPP/kloss_reserv
    reserv   =np.where((reserv!=reserv),0.,reserv)
    # 2. litter
    mort_ma=(kmort_leaf_old  *leaf  *litfrac_m[0]+kmort_sapab_old *sapab *litfrac_m[1]\
             +kmort_hrtab_old *hrtab *litfrac_m[3]+kmort_fruit_old *fruit *litfrac_m[6]\
             +kmort_reserv_old*reserv*litfrac_m[7])*xmort[0]
    mort_sa=(kmort_leaf_old  *leaf  *litfrac_s[0]+kmort_sapab_old *sapab *litfrac_s[1]\
             +kmort_hrtab_old *hrtab *litfrac_s[3]+kmort_fruit_old *fruit *litfrac_s[6]\
             +kmort_reserv_old*reserv*litfrac_s[7])*xmort[0]
    mort_mb=(kmort_sapbe_old *sapbe *litfrac_m[2]+kmort_hrtbe_old *hrtbe *litfrac_m[4]\
            +kmort_root_old  *root  *litfrac_m[5])*xmort[0]
    mort_sb=(kmort_sapbe_old *sapbe *litfrac_s[2]+kmort_hrtbe_old *hrtbe *litfrac_s[4]\
            +kmort_root_old  *root  *litfrac_s[5])*xmort[0]
    turn_ma= kturn_leaf_old  *leaf  *litfrac_m[0]+kturn_sapab_old *sapab \
             *litfrac_m[1]+kturn_fruit_old *fruit *litfrac_m[6]
    turn_sa= kturn_leaf_old  *leaf  *litfrac_s[0]+kturn_sapab_old *sapab \
             *litfrac_s[1]+kturn_fruit_old *fruit *litfrac_s[6]
    turn_mb= kturn_root_old* root* litfrac_m[5]
    turn_sb= kturn_root_old* root* litfrac_s[5]
    kloss_ma=(klitma_soila_old                 +kresp_litma_old)*xl+kfire_litma_old
    kloss_mb=(klitmb_soila_old                 +kresp_litmb_old)*xl
    kloss_sa=(klitsa_soila_old+klitsa_soils_old+kresp_litsa_old)*xl+kfire_litsa_old
    kloss_sb=(klitsb_soila_old+klitsb_soils_old+kresp_litsb_old)*xl
    # equilibrium of litter 
    lit_ma=(mort_ma+turn_ma)/kloss_ma
    lit_mb=(mort_mb+turn_mb)/kloss_mb
    lit_sa=(mort_sa+turn_sa)/kloss_sa
    lit_sb=(mort_sb+turn_sb)/kloss_sb
    lit_ma[kresp_soila0==0.]=0.
    lit_sa[kresp_soila0==0.]=0.
    lit_mb[kresp_soila0==0.]=0.
    lit_sb[kresp_soila0==0.]=0.
    
    lit_ma=np.where(land*(lit_ma!=lit_ma),0.,lit_ma)
    lit_mb=np.where(land*(lit_mb!=lit_mb),0.,lit_mb)
    lit_sa=np.where(land*(lit_sa!=lit_sa),0.,lit_sa)
    lit_sb=np.where(land*(lit_sb!=lit_sb),0.,lit_sb)
    nc.close()
    PROD001=np.zeros((len(rows_c),len(kols_c)))
    PROD010=np.zeros((len(rows_c),len(kols_c)))
    PROD100=np.zeros((len(rows_c),len(kols_c)))
    leaf [:,sea]=np.nan;sapab[:,sea]=np.nan;sapbe[:,sea]=np.nan;hrtab [:,sea]=np.nan
    hrtbe[:,sea]=np.nan;root [:,sea]=np.nan;fruit[:,sea]=np.nan;reserv[:,sea]=np.nan
    lit_ma[:,sea]=np.nan;lit_mb[:,sea]=np.nan;lit_sa[:,sea]=np.nan;lit_sb[:,sea]=np.nan
    soila_FL[np.isnan(soila_FL)==True]=0.
    soils_FL[np.isnan(soils_FL)==True]=0.
    soilp_FL[np.isnan(soilp_FL)==True]=0.    
    soila_FL[np.isfinite(soila_FL)==False]=0.
    soils_FL[np.isfinite(soils_FL)==False]=0.
    soilp_FL[np.isfinite(soilp_FL)==False]=0.
    soila_HS[np.isnan(soila_HS)==True]=0.
    soils_HS[np.isnan(soils_HS)==True]=0.
    soilp_HS[np.isnan(soilp_HS)==True]=0.  
    soila_HS[np.isfinite(soila_HS)==False]=0.
    soils_HS[np.isfinite(soils_HS)==False]=0.
    soilp_HS[np.isfinite(soilp_HS)==False]=0.
  else:
    # READ biomass,litter and wood product pools from yearly output file
    BLnc=Dataset('%s/BLpools_%i.nc' % (OptPath,year-1),'r')
    leaf   =BLnc.variables['leaf'   ][:]
    root   =BLnc.variables['root'   ][:]
    fruit  =BLnc.variables['fruit'  ][:]
    sapab  =BLnc.variables['sapab'  ][:]
    sapbe  =BLnc.variables['sapbe'  ][:]
    reserv =BLnc.variables['reserv' ][:]
    hrtab  =BLnc.variables['hrtab'  ][:]
    hrtbe  =BLnc.variables['hrtbe'  ][:]
    lit_ma =BLnc.variables['lit_ma' ][:]
    lit_mb =BLnc.variables['lit_mb' ][:]
    lit_sa =BLnc.variables['lit_sa' ][:]
    lit_sb =BLnc.variables['lit_sb' ][:]
    PROD001=BLnc.variables['prod001'][:]
    PROD010=BLnc.variables['prod010'][:]
    PROD100=BLnc.variables['prod100'][:]
    BLnc.close()
  ######################################################################
  # Land use change scheme
  ######################################################################  
  if luc=='y':
    print("start land use change")
    #first biomass and litter
    pos1=oldveget>veget
    PROD001+=np.nansum((oldveget-veget)*pos1*(sapab+hrtab)*LUCfrac001,axis=0)
    PROD010+=np.nansum((oldveget-veget)*pos1*(sapab+hrtab)*LUCfrac010,axis=0)
    PROD100+=np.nansum((oldveget-veget)*pos1*(sapab+hrtab)*LUCfrac100,axis=0)
    LUClit_ma=np.nansum((leaf  *litfrac_m[0]\
                        +fruit *litfrac_m[6]\
                        +reserv*litfrac_m[7]\
                        +lit_ma)*pos1*(oldveget-veget),axis=0)
    LUClit_sa=np.nansum((leaf  *litfrac_s[0]\
                        +fruit *litfrac_s[6]\
                        +reserv*litfrac_s[7]\
                        +lit_sa)*pos1*(oldveget-veget),axis=0)
    LUClit_mb=np.nansum((sapbe *litfrac_m[2]\
                        +hrtbe *litfrac_m[4]\
                        +root  *litfrac_m[5]\
                        +lit_mb)*pos1*(oldveget-veget),axis=0)
    LUClit_sb=np.nansum((sapbe *litfrac_s[2]\
                        +hrtbe *litfrac_s[4]\
                        +root  *litfrac_s[5]
                        +lit_sb)*pos1*(oldveget-veget),axis=0)
    pos2=oldveget<veget
    leaf  [pos2]=leaf  [pos2]*oldveget[pos2]/veget[pos2]
    sapab [pos2]=sapab [pos2]*oldveget[pos2]/veget[pos2]
    sapbe [pos2]=sapbe [pos2]*oldveget[pos2]/veget[pos2]
    hrtab [pos2]=hrtab [pos2]*oldveget[pos2]/veget[pos2]
    hrtbe [pos2]=hrtbe [pos2]*oldveget[pos2]/veget[pos2]
    root  [pos2]=root  [pos2]*oldveget[pos2]/veget[pos2]
    fruit [pos2]=fruit [pos2]*oldveget[pos2]/veget[pos2]
    reserv[pos2]=reserv[pos2]*oldveget[pos2]/veget[pos2]
    inc_ma=LUClit_ma/np.nansum((veget-oldveget)[1:,:]*pos2[1:,:],axis=0)
    inc_mb=LUClit_mb/np.nansum((veget-oldveget)[1:,:]*pos2[1:,:],axis=0)
    inc_sa=LUClit_sa/np.nansum((veget-oldveget)[1:,:]*pos2[1:,:],axis=0)
    inc_sb=LUClit_sb/np.nansum((veget-oldveget)[1:,:]*pos2[1:,:],axis=0)
    inc_ma=np.where(inc_ma==inc_ma,inc_ma,0.)
    inc_mb=np.where(inc_mb==inc_mb,inc_mb,0.)
    inc_sa=np.where(inc_sa==inc_sa,inc_sa,0.)
    inc_sb=np.where(inc_sb==inc_sb,inc_sb,0.)    
    pos3=np.nansum(pos2,axis=0)>0.
    newlit_ma=np.array(lit_ma)
    newlit_mb=np.array(lit_mb)
    newlit_sa=np.array(lit_sa)
    newlit_sb=np.array(lit_sb)
    newlit_ma[1:,pos3]=(lit_ma[1:,pos3]*oldveget[1:,pos3]\
                     +inc_ma[pos3]*((veget-oldveget)*pos2)[1:,pos3])/veget[1:,pos3]
    newlit_mb[1:,pos3]=(lit_mb[1:,pos3]*oldveget[1:,pos3]\
                     +inc_mb[pos3]*((veget-oldveget)*pos2)[1:,pos3])/veget[1:,pos3]
    newlit_sa[1:,pos3]=(lit_sa[1:,pos3]*oldveget[1:,pos3]\
                     +inc_sa[pos3]*((veget-oldveget)*pos2)[1:,pos3])/veget[1:,pos3]
    newlit_sb[1:,pos3]=(lit_sb[1:,pos3]*oldveget[1:,pos3]\
                     +inc_sb[pos3]*((veget-oldveget)*pos2)[1:,pos3])/veget[1:,pos3]
    newlit_ma[pos1]=lit_ma[pos1]
    newlit_mb[pos1]=lit_mb[pos1]
    newlit_sa[pos1]=lit_sa[pos1]
    newlit_sb[pos1]=lit_sb[pos1]
    lit_ma=np.array(newlit_ma)
    lit_mb=np.array(newlit_mb)
    lit_sa=np.array(newlit_sa)
    lit_sb=np.array(newlit_sb)
    lit_ma[np.isnan(lit_ma)==True]=0.
    lit_mb[np.isnan(lit_mb)==True]=0.
    lit_sa[np.isnan(lit_sa)==True]=0.
    lit_sb[np.isnan(lit_sb)==True]=0.   
    #SOC
    pos1=oldveget_sel>veget_sel #use high res vegetation file
    pos2=oldveget_sel<veget_sel
    pos3=np.nansum(pos2,axis=0)>0.
    newsoila_FL=np.array(soila_FL)
    newsoils_FL=np.array(soils_FL)
    newsoilp_FL=np.array(soilp_FL) 
    newsoila_HS=np.array(soila_HS)
    newsoils_HS=np.array(soils_HS)
    newsoilp_HS=np.array(soilp_HS) 
    for z in soil_layers:
      #for floodplains
      newsa=newsoila_FL[z]
      newss=newsoils_FL[z]
      newsp=newsoilp_FL[z]
      sa=soila_FL[z]
      ss=soils_FL[z]
      sp=soilp_FL[z]
      LUCsoila=np.nansum(soila_FL[z]*pos1*(oldveget_sel-veget_sel),axis=0) #sum all the SOC that will be transfered to a specific pft due to LUC
      LUCsoils=np.nansum(soils_FL[z]*pos1*(oldveget_sel-veget_sel),axis=0)
      LUCsoilp=np.nansum(soilp_FL[z]*pos1*(oldveget_sel-veget_sel),axis=0)
      inc_soila=LUCsoila/np.nansum((veget_sel-oldveget_sel)[1:,:]*pos2[1:,:],axis=0)
      inc_soils=LUCsoils/np.nansum((veget_sel-oldveget_sel)[1:,:]*pos2[1:,:],axis=0)
      inc_soilp=LUCsoilp/np.nansum((veget_sel-oldveget_sel)[1:,:]*pos2[1:,:],axis=0) 
      inc_soila=np.where(inc_soila==inc_soila,inc_soila,0.)
      inc_soils=np.where(inc_soils==inc_soils,inc_soils,0.)
      inc_soilp=np.where(inc_soilp==inc_soilp,inc_soilp,0.)           
      newsa[1:,pos3]=(sa[1:,pos3]*oldveget_sel[1:,pos3]\
                        +inc_soila[pos3]*((veget_sel-oldveget_sel)*pos2)[1:,pos3])/veget_sel[1:,pos3]
      newss[1:,pos3]=(ss[1:,pos3]*oldveget_sel[1:,pos3]\
                        +inc_soils[pos3]*((veget_sel-oldveget_sel)*pos2)[1:,pos3])/veget_sel[1:,pos3]
      newsp[1:,pos3]=(sp[1:,pos3]*oldveget_sel[1:,pos3]\
                        +inc_soilp[pos3]*((veget_sel-oldveget_sel)*pos2)[1:,pos3])/veget_sel[1:,pos3]
      newsoila_FL[z]=newsa
      newsoils_FL[z]=newss
      newsoilp_FL[z]=newsp
      newsoila_FL[z,pos1]=soila_FL[z,pos1]
      newsoils_FL[z,pos1]=soils_FL[z,pos1]
      newsoilp_FL[z,pos1]=soilp_FL[z,pos1]                   
      soila_FL[z]=np.array(newsoila_FL)[z]
      soils_FL[z]=np.array(newsoils_FL)[z]
      soilp_FL[z]=np.array(newsoilp_FL)[z]
      #for hillslopes
      newsa=newsoila_HS[z]
      newss=newsoils_HS[z]
      newsp=newsoilp_HS[z]
      sa=soila_HS[z]
      ss=soils_HS[z]
      sp=soilp_HS[z]
      LUCsoila=np.nansum(soila_HS[z]*pos1*(oldveget_sel-veget_sel),axis=0) #sum all the SOC that will be transfered to a specific pft due to LUC
      LUCsoils=np.nansum(soils_HS[z]*pos1*(oldveget_sel-veget_sel),axis=0)
      LUCsoilp=np.nansum(soilp_HS[z]*pos1*(oldveget_sel-veget_sel),axis=0)
      inc_soila=LUCsoila/np.nansum((veget_sel-oldveget_sel)[1:,:]*pos2[1:,:],axis=0)
      inc_soils=LUCsoils/np.nansum((veget_sel-oldveget_sel)[1:,:]*pos2[1:,:],axis=0)
      inc_soilp=LUCsoilp/np.nansum((veget_sel-oldveget_sel)[1:,:]*pos2[1:,:],axis=0)
      inc_soila=np.where(inc_soila==inc_soila,inc_soila,0.)
      inc_soils=np.where(inc_soils==inc_soils,inc_soils,0.)
      inc_soilp=np.where(inc_soilp==inc_soilp,inc_soilp,0.)  
      newsa[1:,pos3]=(sa[1:,pos3]*oldveget_sel[1:,pos3]\
                        +inc_soila[pos3]*((veget_sel-oldveget_sel)*pos2)[1:,pos3])/veget_sel[1:,pos3]
      newss[1:,pos3]=(ss[1:,pos3]*oldveget_sel[1:,pos3]\
                        +inc_soils[pos3]*((veget_sel-oldveget_sel)*pos2)[1:,pos3])/veget_sel[1:,pos3]
      newsp[1:,pos3]=(sp[1:,pos3]*oldveget_sel[1:,pos3]\
                        +inc_soilp[pos3]*((veget_sel-oldveget_sel)*pos2)[1:,pos3])/veget_sel[1:,pos3]
      newsoila_HS[z]=newsa
      newsoils_HS[z]=newss
      newsoilp_HS[z]=newsp
      newsoila_HS[z,pos1]=soila_HS[z,pos1]
      newsoils_HS[z,pos1]=soils_HS[z,pos1]
      newsoilp_HS[z,pos1]=soilp_HS[z,pos1]                   
      soila_HS[z]=np.array(newsoila_HS)[z]
      soils_HS[z]=np.array(newsoils_HS)[z]
      soilp_HS[z]=np.array(newsoilp_HS)[z]
    soila_FL=np.where(soila_FL==soila_FL,soila_FL,0.)
    soils_FL=np.where(soils_FL==soils_FL,soils_FL,0.)
    soilp_FL=np.where(soilp_FL==soilp_FL,soilp_FL,0.)
    soila_HS=np.where(soila_HS==soila_HS,soila_HS,0.)
    soils_HS=np.where(soils_HS==soils_HS,soils_HS,0.)
    soilp_HS=np.where(soilp_HS==soilp_HS,soilp_HS,0.)
  #########################################################
  # Run transient simulation
  #########################################################
  ynpp=0.;yharv_tot=0.;yresp_veg_fire=0.;yresp_lit=0.
  kharv_leaf_new=1.*kharv_leaf
  kharv_sapab_new=1.*kharv_sapab
  kharv_fruit_new=1.*kharv_fruit
  kharv_root_new=1.*kharv_root
  Resp_HS_y=np.zeros((13,b));Resp_HS_bur_y=np.zeros((13,b))
  Resp_FL_y=np.zeros((13,b));Resp_FL_bur_y=np.zeros((13,b))
  litter_tot=0.;yEsoil=0.;yDsoil=0.
  M_T_in=np.zeros((b,));M_T_out=np.zeros((13,b))  
  fluxa_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  fluxs_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  fluxp_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  ka_flux_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  ks_flux_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  kp_flux_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64) 
  dresp_HS=np.zeros((20,13,b));dresp_FL=np.zeros((20,13,b))
  dresp_HS_bur=np.zeros((13,b));dresp_FL_bur=np.zeros((13,b))
  for dd in range(365):
    #########################################################
    # Run SOC scheme
    #########################################################
    xsoila_FL=xa*soila_FL
    xsoils_FL=xs*soils_FL
    xsoilp_FL=xp*soilp_FL
    xsoila_HS=xa*soila_HS
    xsoils_HS=xs*soils_HS
    xsoilp_HS=xp*soilp_HS
    # below versus aboveground litter
    littera_ab=(klitma_soila[dd]*lit_ma+klitsa_soila[dd]*lit_sa)*xl
    littera_bl=(klitmb_soila[dd]*lit_mb+klitsb_soila[dd]*lit_sb)*xl
    litters_ab=(klitsa_soils[dd]*lit_sa)*xl
    litters_bl=(klitsb_soils[dd]*lit_sb)*xl
    #litter distribution over depth
    r_out=r_pft(veget,len(rows_c),len(kols_c))
    littera_bl0=(-littera_bl*r_out)/(np.exp(-r_out*zmin[19])-1)*dz0
    litters_bl0=(-litters_bl*r_out)/(np.exp(-r_out*zmin[19])-1)*dz0
    littera_bl_top=np.zeros((13,len(rows_c),len(kols_c)),)
    litters_bl_top=np.zeros((13,len(rows_c),len(kols_c)),)
    littera_zh=np.zeros((20,13,len(rows_c),len(kols_c)))
    litters_zh=np.zeros((20,13,len(rows_c),len(kols_c)))
    for z in soil_layers_top:
      littera_bl_top=littera_bl_top+(littera_bl0*np.exp(-r_out*zmin[z]))
      litters_bl_top=litters_bl_top+(litters_bl0*np.exp(-r_out*zmin[z]))
    for z in soil_layers:
      if zmax[z]<=Lab_top:
        littera_ab_z=littera_ab*(dz_all[z]/Lab_top)
        litters_ab_z=litters_ab*(dz_all[z]/Lab_top)
        littera_bl_z=littera_bl_top*(dz_all[z]/Lab_top)
        litters_bl_z=litters_bl_top*(dz_all[z]/Lab_top)
        littera_zh[z]=littera_ab_z+littera_bl_z
        litters_zh[z]=litters_ab_z+litters_bl_z
      else:
        littera_ab_z=np.zeros((13,len(rows_c),len(kols_c)),)
        litters_ab_z=np.zeros((13,len(rows_c),len(kols_c)),)
        littera_bl_z=littera_bl0*np.exp(-r_out*(zmin[z]-Lab_top))
        litters_bl_z=litters_bl0*np.exp(-r_out*(zmin[z]-Lab_top))
        littera_zh[z]=littera_ab_z+littera_bl_z
        litters_zh[z]=litters_ab_z+litters_bl_z
    littera_zh=littera_zh[:,:,row_bas_sel[:],kol_bas_sel[:]]
    litters_zh=litters_zh[:,:,row_bas_sel[:],kol_bas_sel[:]]
    littera_zh[np.isnan(littera_zh)==True]=0.
    litters_zh[np.isnan(litters_zh)==True]=0.
    
    # HILLSLOPES
    for z in soil_layers:      
      soils_a_HS=ksoils_a[dd]*xsoils_HS[z]
      soilp_a_HS=ksoilp_a[dd]*xsoilp_HS[z]
      soila_s_HS=ksoila_s[dd]*xsoila_HS[z]
      soila_p_HS=ksoila_p[dd]*xsoila_HS[z]
      soils_p_HS=ksoils_p[dd]*xsoils_HS[z]                    
      klossa_HS=kresp_soila_HS[z,dd]+ksoila_s[dd]+ksoila_p[dd]+kE
      klosss_HS=kresp_soils_HS[z,dd]+ksoils_a[dd]+ksoils_p[dd]+kE
      klossp_HS=kresp_soilp_HS[z,dd]+ksoilp_a[dd]+kE    
      if z==19:
        soila_HS[z]+=littera_zh[z]+soils_a_HS+soilp_a_HS-klossa_HS*xsoila_HS[z]
        soils_HS[z]+=litters_zh[z]+soila_s_HS-klosss_HS*xsoils_HS[z]
        soilp_HS[z]+=soila_p_HS+soils_p_HS-klossp_HS*xsoilp_HS[z]
        dresp_HS[z]=kresp_soila_HS[z,dd]*xsoila_HS[z]+kresp_soils_HS[z,dd]\
        *xsoils_HS[z]+kresp_soilp_HS[z,dd]*xsoilp_HS[z]
      elif z==0:
        soila_HS[z]+=littera_zh[z]+soils_a_HS+soilp_a_HS+(kE*soila_HS[z+1])-klossa_HS*xsoila_HS[z]
        soils_HS[z]+=litters_zh[z]+soila_s_HS+(kE*soils_HS[z+1])-klosss_HS*xsoils_HS[z]
        soilp_HS[z]+=soila_p_HS+soils_p_HS+(kE*soilp_HS[z+1])-klossp_HS*xsoilp_HS[z]
        dresp_HS[z]=kresp_soila_HS[z,dd]*xsoila_HS[z]+kresp_soils_HS[z,dd]*\
        xsoils_HS[z]+kresp_soilp_HS[z,dd]*xsoilp_HS[z]
        dresp_HS_bur=((kEE-kE)*xsoila_HS[z]*kresp_soila_HS[z,dd])+((kEE-kE)*xsoils_HS[z]*kresp_soils_HS[z,dd])\
           +((kEE-kE)*xsoilp_HS[z]*kresp_soilp_HS[z,dd])
      else:
        soila_HS[z]+=littera_zh[z]+soils_a_HS+soilp_a_HS+(kE*soila_HS[z+1])-klossa_HS*xsoila_HS[z]
        soils_HS[z]+=litters_zh[z]+soila_s_HS+(kE*soils_HS[z+1])-klosss_HS*xsoils_HS[z]
        soilp_HS[z]+=soila_p_HS+soils_p_HS+(kE*soilp_HS[z+1])-klossp_HS*xsoilp_HS[z]
        dresp_HS[z]=kresp_soila_HS[z,dd]*xsoila_HS[z]+kresp_soils_HS[z,dd]*\
        xsoils_HS[z]+kresp_soilp_HS[z,dd]*xsoilp_HS[z]
    soila_HS[np.isnan(soila_HS)==True]=0.
    soils_HS[np.isnan(soils_HS)==True]=0.
    soilp_HS[np.isnan(soilp_HS)==True]=0.  
    soila_HS[np.isfinite(soila_HS)==False]=0.
    soils_HS[np.isfinite(soils_HS)==False]=0.
    soilp_HS[np.isfinite(soilp_HS)==False]=0.
    xsoila=1.*xsoila_HS;xsoils=1.*xsoils_HS;xsoilp=1.*xsoilp_HS
    xsoila[soila_HS>0.]=0.;xsoils[soils_HS>0.]=0.;xsoilp[soilp_HS>0.]=0.
    soila_HS+=xsoila;soils_HS+=xsoils;soilp_HS+=xsoilp
    Resp_HS_y+=np.nansum(dresp_HS,axis=0)
    Resp_HS_bur_y+=dresp_HS_bur
    
    # FLOODPLAINS
    for z in soil_layers:      
      soils_a_FL=ksoils_a[dd]*xsoils_FL[z]
      soilp_a_FL=ksoilp_a[dd]*xsoilp_FL[z]
      soila_s_FL=ksoila_s[dd]*xsoila_FL[z]
      soila_p_FL=ksoila_p[dd]*xsoila_FL[z]
      soils_p_FL=ksoils_p[dd]*xsoils_FL[z]                        
      if z==19:
        klossa_FL=kresp_soila_FL[z,dd]+ksoila_s[dd]+ksoila_p[dd]+kout
        klosss_FL=kresp_soils_FL[z,dd]+ksoils_a[dd]+ksoils_p[dd]+kout
        klossp_FL=kresp_soilp_FL[z,dd]+ksoilp_a[dd]+kout
        soila_FL[z]+=littera_zh[z]+soils_a_FL+soilp_a_FL+(kD+ka_out)*xsoila_FL[z-1]-klossa_FL*xsoila_FL[z]
        soils_FL[z]+=litters_zh[z]+soila_s_FL+(kD+ks_out)*xsoils_FL[z-1]-klosss_FL*xsoils_FL[z]
        soilp_FL[z]+=soila_p_FL+soils_p_FL+(kD+kp_out)*xsoilp_FL[z-1]-klossp_FL*xsoilp_FL[z]
        dresp_FL[z]=kresp_soila_FL[z,dd]*xsoila_FL[z]+kresp_soils_FL[z,dd]*\
        xsoils_FL[z]+kresp_soilp_FL[z,dd]*xsoilp_FL[z]
      elif z==0:
        M_out=kout*(soila_FL[z]+soils_FL[z]+soilp_FL[z])
        M_T_out[1:13,:]+=M_out[1:13,:]
        klossa_FL=kresp_soila_FL[z,dd]+ksoila_s[dd]+ksoila_p[dd]+kD+kout
        klosss_FL=kresp_soils_FL[z,dd]+ksoils_a[dd]+ksoils_p[dd]+kD+kout
        klossp_FL=kresp_soilp_FL[z,dd]+ksoilp_a[dd]+kD+kout
        soila_FL[z]+=littera_zh[z]+soils_a_FL+soilp_a_FL+kD*xsoila_HS[z]+kout*soila_FL[z+1]-klossa_FL*xsoila_FL[z]
        soils_FL[z]+=litters_zh[z]+soila_s_FL+kD*xsoils_HS[z]+kout*soils_FL[z+1]-klosss_FL*xsoils_FL[z]
        soilp_FL[z]+=soila_p_FL+soils_p_FL+kD*xsoilp_HS[z]+kout*soilp_FL[z+1]-klossp_FL*xsoilp_FL[z]
        dresp_FL[z]=kresp_soila_FL[z,dd]*xsoila_FL[z]+kresp_soils_FL[z,dd]\
        *xsoils_FL[z]+kresp_soilp_FL[z,dd]*xsoilp_FL[z]  
        dresp_FL_bur=(kD*xsoila_HS[z]*kresp_soila_FL[z,dd])+(kD*xsoils_HS[z]*kresp_soils_FL[z,dd])\
           +(kD*xsoilp_HS[z]*kresp_soilp_FL[z,dd])
        soila_FL[np.isnan(soila_FL)==True]=0.
        soils_FL[np.isnan(soils_FL)==True]=0.
        soilp_FL[np.isnan(soilp_FL)==True]=0.
        if depo=='y':
          #routing  
          Ma_in[id_sub]=np.nansum((xsoila_FL[z,1:13,:]*veget_h[1:13,id_sub]),axis=0)*AREA_FL_sel #sum over all pfts before routing
          Ms_in[id_sub]=np.nansum((xsoils_FL[z,1:13,:]*veget_h[1:13,id_sub]),axis=0)*AREA_FL_sel
          Mp_in[id_sub]=np.nansum((xsoilp_FL[z,1:13,:]*veget_h[1:13,id_sub]),axis=0)*AREA_FL_sel
          Ma_in[np.isnan(Ma_in)==True]=0.
          Ms_in[np.isnan(Ms_in)==True]=0.
          Mp_in[np.isnan(Mp_in)==True]=0.
          A_in=np.ravel(AREA_FL)*np.nansum(veget_h[1:13,:],axis=0)

          Ma_T,fluxa_out,ka,ka_flux_out= routing_main_all.multi_flow.main\
                                         (A_in,DEM_in,Ma_in,str_bas_in,weight_out,\
                                          number_out,bound_in,tau_in*365.,len(rows_h),\
                                          len(kols_h),x_new,y_new,b)
          Ms_T,fluxs_out,ks,ks_flux_out= routing_main_all.multi_flow.main\
                                            (A_in,DEM_in,Ms_in,str_bas_in,weight_out,\
                                             number_out,bound_in,tau_in*365.,len(rows_h),\
                                             len(kols_h),x_new,y_new,b)
          Mp_T,fluxp_out,kp,kp_flux_out= routing_main_all.multi_flow.main\
                                            (A_in,DEM_in,Mp_in,str_bas_in,weight_out,\
                                             number_out,bound_in,tau_in*365.,len(rows_h),\
                                             len(kols_h),x_new,y_new,b)
          Ma_T=np.ravel(Ma_T,order='F')
          Ms_T=np.ravel(Ms_T,order='F')
          Mp_T=np.ravel(Mp_T,order='F')
          ka=np.ravel(ka,order='F')
          ks=np.ravel(ks,order='F')
          kp=np.ravel(kp,order='F')      
          Ma_T=np.reshape(Ma_T,(len(rows_h)*len(kols_h)),order='C')
          Ms_T=np.reshape(Ms_T,(len(rows_h)*len(kols_h)),order='C')
          Mp_T=np.reshape(Mp_T,(len(rows_h)*len(kols_h)),order='C')                    
          ka=np.reshape(ka,(len(rows_h)*len(kols_h)),order='C')  
          ks=np.reshape(ks,(len(rows_h)*len(kols_h)),order='C') 
          kp=np.reshape(kp,(len(rows_h)*len(kols_h)),order='C') 

          fluxa_out=np.ravel(fluxa_out,order='F') #total C flux from neighboring grids that flow into a certain grid
          fluxs_out=np.ravel(fluxs_out,order='F')
          fluxp_out=np.ravel(fluxp_out,order='F')
          fluxa_out=np.reshape(fluxa_out,(len(rows_h),len(kols_h)),order='C') 
          fluxs_out=np.reshape(fluxs_out,(len(rows_h),len(kols_h)),order='C') 
          fluxp_out=np.reshape(fluxp_out,(len(rows_h),len(kols_h)),order='C') 
          fluxa_out[np.isnan(fluxa_out)==True]=0.
          fluxs_out[np.isnan(fluxs_out)==True]=0.
          fluxp_out[np.isnan(fluxp_out)==True]=0.
          fluxa_out2=fluxa_out2+fluxa_out
          fluxs_out2=fluxs_out2+fluxs_out
          fluxp_out2=fluxp_out2+fluxp_out 

          Ma_T[str_bas!=num]=0.;Ms_T[str_bas!=num]=0.;Mp_T[str_bas!=num]=0.
          ka_out=ka[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0))
          ks_out=ks[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0))
          kp_out=kp[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0))
          Ma_T_in=(Ma_T[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0)))
          Ms_T_in=(Ms_T[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0)))
          Mp_T_in=(Mp_T[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0)))
          M_T_in+=Ma_T_in+Ms_T_in+Mp_T_in
          soila_FL[z,1:13,:]+=Ma_T_in-(ka_out*xsoila_FL[z,1:13,:])
          soils_FL[z,1:13,:]+=Ms_T_in-(ks_out*xsoils_FL[z,1:13,:])
          soilp_FL[z,1:13,:]+=Mp_T_in-(kp_out*xsoilp_FL[z,1:13,:])

          ka_flux_out=np.ravel(ka_flux_out,order='F') #total SOC stock from neighboring grids that flow into a certain grid
          ks_flux_out=np.ravel(ks_flux_out,order='F')
          kp_flux_out=np.ravel(kp_flux_out,order='F')    
          ka_flux_out[np.isnan(ka_flux_out)==True]=0.
          ks_flux_out[np.isnan(ks_flux_out)==True]=0.
          kp_flux_out[np.isnan(kp_flux_out)==True]=0.
          ka_flux_out[np.isfinite(ka_flux_out)==False]=0.
          ks_flux_out[np.isfinite(ks_flux_out)==False]=0.
          kp_flux_out[np.isfinite(kp_flux_out)==False]=0.
          ka_flux_out2=ka_flux_out2+np.reshape(ka_flux_out,(len(rows_h),len(kols_h)),order='C') 
          ks_flux_out2=ks_flux_out2+np.reshape(ks_flux_out,(len(rows_h),len(kols_h)),order='C') 
          kp_flux_out2=kp_flux_out2+np.reshape(kp_flux_out,(len(rows_h),len(kols_h)),order='C')     
      else:
        klossa_FL=kresp_soila_FL[z,dd]+ksoila_s[dd]+ksoila_p[dd]+kD+kout+ka_out
        klosss_FL=kresp_soils_FL[z,dd]+ksoils_a[dd]+ksoils_p[dd]+kD+kout+ks_out
        klossp_FL=kresp_soilp_FL[z,dd]+ksoilp_a[dd]+kD+kout+kp_out
        soila_FL[z]+=littera_zh[z]+soils_a_FL+soilp_a_FL+(kD+ka_out)*xsoila_FL[z-1]+kout*soila_FL[z+1]-klossa_FL*xsoila_FL[z]
        soils_FL[z]+=litters_zh[z]+soila_s_FL+(kD+ks_out)*xsoils_FL[z-1]+kout*soils_FL[z+1]-klosss_FL*xsoils_FL[z]
        soilp_FL[z]+=soila_p_FL+soils_p_FL+(kD+kp_out)*xsoilp_FL[z-1]+kout*soilp_FL[z+1]-klossp_FL*xsoilp_FL[z]
        dresp_FL[z]=kresp_soila_FL[z,dd]*xsoila_FL[z]+kresp_soils_FL[z,dd]\
        *xsoils_FL[z]+kresp_soilp_FL[z,dd]*xsoilp_FL[z]

    if set_eros!='0':
      Esoila=kEE*xsoila_HS[0] 
      Esoils=kEE*xsoils_HS[0]
      Esoilp=kEE*xsoilp_HS[0]
      yEsoil+=Esoila+Esoils+Esoilp
    else:
      Esoila=np.zeros((13,b));Esoils=np.zeros((13,b));Esoilp=np.zeros((13,b));yEsoil=np.zeros((13,b))
    if depo=='y':
      Dsoila=(kE*xsoila_HS[0]*AREA_HS_sel)/AREA_FL_sel
      Dsoils=(kE*xsoils_HS[0]*AREA_HS_sel)/AREA_FL_sel 
      Dsoilp=(kE*xsoilp_HS[0]*AREA_HS_sel)/AREA_FL_sel 
      yDsoil+=Dsoila+Dsoils+Dsoilp
    else:
      Dsoila=np.zeros((13,b));Dsoils=np.zeros((13,b));Dsoilp=np.zeros((13,b))
      yDsoil=np.zeros((13,b))

    soila_FL[np.isnan(soila_FL)==True]=0.
    soils_FL[np.isnan(soils_FL)==True]=0.
    soilp_FL[np.isnan(soilp_FL)==True]=0.    
    soila_FL[np.isfinite(soila_FL)==False]=0.
    soils_FL[np.isfinite(soils_FL)==False]=0.
    soilp_FL[np.isfinite(soilp_FL)==False]=0.
    xsoila=1.*xsoila_FL;xsoils=1.*xsoils_FL;xsoilp=1.*xsoilp_FL
    xsoila[soila_FL>0.]=0.;xsoils[soils_FL>0.]=0.;xsoilp[soilp_FL>0.]=0.
    soila_FL+=xsoila;soils_FL+=xsoils;soilp_FL+=xsoilp
    Resp_FL_y+=np.nansum(dresp_FL,axis=0)
    Resp_FL_bur_y+=dresp_FL_bur
    
    litter_tot+=np.nansum((littera_zh+litters_zh),axis=0)    
    ##########################################################
    # 2. litter
    ##########################################################
    mort_ma=(kmort_leaf[dd]  *leaf  *litfrac_m[0]+kmort_sapab[dd]  *sapab *litfrac_m[1]\
            +kmort_hrtab[dd]  *hrtab *litfrac_m[3]+kmort_fruit[dd]  *fruit *litfrac_m[6]\
            +kmort_reserv[dd] *reserv*litfrac_m[7])*xmort[0]
    mort_sa=(kmort_leaf[dd]   *leaf  *litfrac_s[0]+kmort_sapab[dd]  *sapab *litfrac_s[1]\
            +kmort_hrtab[dd]  *hrtab *litfrac_s[3]+kmort_fruit[dd]  *fruit *litfrac_s[6]\
            +kmort_reserv[dd] *reserv*litfrac_s[7])*xmort[0]
    mort_mb=(kmort_sapbe[dd]  *sapbe *litfrac_m[2]+kmort_hrtbe[dd]  *hrtbe *litfrac_m[4]\
            +kmort_root[dd]   *root  *litfrac_m[5])*xmort[0]
    mort_sb=(kmort_sapbe[dd]  *sapbe *litfrac_s[2]+kmort_hrtbe[dd]  *hrtbe *litfrac_s[4]\
            +kmort_root[dd]   *root  *litfrac_s[5])*xmort[0]
    turn_ma= kturn_leaf[dd]   *leaf  *litfrac_m[0]+kturn_sapab[dd]  *sapab *litfrac_m[1]+kturn_fruit[dd]  *fruit *litfrac_m[6]
    turn_sa= kturn_leaf[dd]   *leaf  *litfrac_s[0]+kturn_sapab[dd]  *sapab *litfrac_s[1]+kturn_fruit[dd]  *fruit *litfrac_s[6]
    turn_mb= kturn_root[dd]   *root  *litfrac_m[5]
    turn_sb= kturn_root[dd]   *root  *litfrac_s[5]

    if luc=='y':
      # turn goes to harvest for crop where crop increases strongly historically
      turn_ma=turn_ma.reshape(13,4)
      turn_mb=turn_mb.reshape(13,4)
      turn_sa=turn_sa.reshape(13,4)
      turn_sb=turn_sb.reshape(13,4)
      for i in range(4):
        if dveget_c[i]>=0.2:
          for j in range(11,13):
            turn_ma[j,i]=0.
            turn_mb[j,i]=0.
            turn_sa[j,i]=0.
            turn_sb[j,i]=0.
      turn_ma=turn_ma.reshape(13,2,2)
      turn_mb=turn_mb.reshape(13,2,2)
      turn_sa=turn_sa.reshape(13,2,2)
      turn_sb=turn_sb.reshape(13,2,2)

    #continue litter ...
    kloss_ma=(klitma_soila[dd]              +kresp_litma[dd] )*xl+kfire_litma[dd] 
    kloss_mb=(klitmb_soila[dd]              +kresp_litmb[dd] )*xl
    kloss_sa=(klitsa_soila[dd] +klitsa_soils[dd] +kresp_litsa[dd] )*xl+kfire_litsa[dd] 
    kloss_sb=(klitsb_soila[dd] +klitsb_soils[dd] +kresp_litsb[dd] )*xl
    
    dresp_lit=(kresp_litma[dd] +kfire_litma[dd] )*lit_ma+(kresp_litmb[dd] )*lit_mb \
               +(kresp_litsa[dd] +kfire_litsa[dd] )*lit_sa+(kresp_litsb[dd] )*lit_sb
    
    lit_ma+=mort_ma+turn_ma-lit_ma*kloss_ma
    lit_mb+=mort_mb+turn_mb-lit_mb*kloss_mb
    lit_sa+=mort_sa+turn_sa-lit_sa*kloss_sa
    lit_sb+=mort_sb+turn_sb-lit_sb*kloss_sb
    lit_ma[np.isnan(lit_ma)==True]=0.
    lit_mb[np.isnan(lit_mb)==True]=0.
    lit_sa[np.isnan(lit_sa)==True]=0.
    lit_sb[np.isnan(lit_sb)==True]=0.
    
    ##########################################################
    # 3. biomass
    ##########################################################
    NPP_leaf_new=1.*NPP_leaf;NPP_sapab_new=1.*NPP_sapab
    NPP_root_new=1.*NPP_root;NPP_fruit_new=1.*NPP_fruit
    NPP_reserv_new=1.*NPP_reserv;NPP_sapbe_new=1.*NPP_sapbe        
    dnpp_pft11=(NPP_leaf[dd,11]+NPP_sapab[dd,11]+NPP_sapbe[dd,11]+NPP_root[dd,11]\
          +NPP_fruit[dd,11]+NPP_reserv[dd,11])*1.
    NPP_ratio=dnpp_pft11/ynpp_pft11
    dnpp_pft11_new=NPP_ratio*ynpp_pft11_new    
    NPP_leaf_new[dd,11]=dnpp_pft11_new*(NPP_leaf[dd,11]/dnpp_pft11)
    NPP_root_new[dd,11]=dnpp_pft11_new*(NPP_root[dd,11]/dnpp_pft11)
    NPP_fruit_new[dd,11]=dnpp_pft11_new*(NPP_fruit[dd,11]/dnpp_pft11)
    NPP_sapab_new[dd,11]=dnpp_pft11_new*(NPP_sapab[dd,11]/dnpp_pft11)
    NPP_sapbe_new[dd,11]=dnpp_pft11_new*(NPP_sapbe[dd,11]/dnpp_pft11)
    NPP_reserv_new[dd,11]=dnpp_pft11_new*(NPP_reserv[dd,11]/dnpp_pft11)
    NPP_leaf_new[np.isnan(NPP_leaf_new)==True]=0.;NPP_sapab_new[np.isnan(NPP_sapab_new)==True]=0.
    NPP_fruit_new[np.isnan(NPP_fruit_new)==True]=0.;NPP_sapbe_new[np.isnan(NPP_sapbe_new)==True]=0
    NPP_root_new[np.isnan(NPP_root_new)==True]=0.;NPP_reserv_new[np.isnan(NPP_reserv_new)==True]=0   
    kharv_leaf_new[dd,11]  =kharv_leaf[dd,11]*(harv_new_id[year-1851]/0.45)    
    kharv_sapab_new[dd,11] =kharv_sapab[dd,11]*(harv_new_id[year-1851]/0.45)    
    kharv_fruit_new[dd,11] =kharv_fruit[dd,11]*(harv_new_id[year-1851]/0.45)    
    kharv_root_new[dd,11]  =kharv_root[dd,11]*(harv_new_id[year-1851]/0.45)   
    kconv=1./730.*np.ones((veget.shape))
    kconv[9:]=0.
    kloss_leaf     =kmort_leaf[dd]*xmort[0]+kturn_leaf[dd]+kfire_leaf[dd]+kharv_leaf_new[dd]
    kloss_sapab    =kmort_sapab[dd]*xmort[0]+kturn_sapab[dd]+kfire_sapab[dd]+kconv+kharv_sapab_new[dd]
    kloss_sapbe    =kmort_sapbe[dd]*xmort[0]+kconv
    kloss_hrtab    =kmort_hrtab[dd]*xmort[0]+kfire_hrtab[dd]
    kloss_hrtbe    =kmort_hrtbe[dd]*xmort[0]
    kloss_root     =kmort_root[dd]*xmort[0]+kturn_root[dd]+kharv_root_new[dd]
    kloss_fruit    =kmort_fruit[dd]*xmort[0]+kturn_fruit[dd]+kfire_fruit[dd]+kharv_fruit_new[dd]
    kloss_reserv   =kmort_reserv[dd]*xmort[0]+kfire_reserv[dd]+kmb_res[dd]

    dharv_tot=(kharv_leaf_new[dd]*leaf + kharv_sapab_new[dd]*sapab + kharv_fruit_new[dd]*fruit + \
              kharv_root_new[dd]*root)
    dresp_veg_fire=(kfire_leaf[dd]*leaf  + kfire_sapab[dd]*sapab + kfire_hrtab[dd]*hrtab \
                    + kfire_fruit[dd]*fruit + kfire_reserv[dd]*reserv)

    hrtab +=kconv*sapab-kloss_hrtab *hrtab 
    hrtbe +=kconv*sapbe-kloss_hrtbe *hrtbe 
    leaf  +=NPP_leaf_new[dd]   -kloss_leaf  *leaf 
    sapab +=NPP_sapab_new[dd]  -kloss_sapab *sapab
    sapbe +=NPP_sapbe_new[dd]  -kloss_sapbe *sapbe
    root  +=NPP_root_new[dd]   -kloss_root  *root
    fruit +=NPP_fruit_new[dd]  -kloss_fruit *fruit
    reserv+=NPP_reserv_new[dd] -kloss_reserv*reserv 
    hrtab =np.where(hrtab <0.,0.,hrtab )
    hrtbe =np.where(hrtbe <0.,0.,hrtbe )
    leaf  =np.where(leaf  <0.,0.,leaf  )
    sapab =np.where(sapab <0.,0.,sapab )
    sapbe =np.where(sapbe <0.,0.,sapbe )
    root  =np.where(root  <0.,0.,root  )
    fruit =np.where(fruit <0.,0.,fruit )
    reserv =np.where(reserv<0.,0.,reserv) 
    PROD001-=PROD001/365.
    PROD010-=PROD010/3650.
    PROD100-=PROD100/36500.

    #yearly output    
    biomass=(leaf+sapab+sapbe+hrtab+hrtbe+root+fruit+reserv)
    litter=(lit_ma+lit_mb+lit_sa+lit_sb)
    dnpp=(NPP_leaf_new[dd]+NPP_sapab_new[dd]+NPP_sapbe_new[dd]+NPP_root_new[dd]+NPP_fruit_new[dd]+NPP_reserv_new[dd])*xNPP
    ynpp+=dnpp;yharv_tot+=dharv_tot;yresp_veg_fire+=dresp_veg_fire;yresp_lit+=dresp_lit

  ##########################################################  
  #output
  ##########################################################
  soila_HS_tot=np.nansum(soila_HS,axis=0) #sum over soil layers
  soils_HS_tot=np.nansum(soils_HS,axis=0)
  soilp_HS_tot=np.nansum(soilp_HS,axis=0)
  SOC_HS_old_tot=np.nansum(SOC_HS_old,axis=0)
  litter_tot_HS=1.*litter_tot
  soila_FL_tot=np.nansum(soila_FL,axis=0) #sum over soil layers
  soils_FL_tot=np.nansum(soils_FL,axis=0)
  soilp_FL_tot=np.nansum(soilp_FL,axis=0)
  SOC_FL_old_tot=np.nansum(SOC_FL_old,axis=0)
  litter_tot_FL=1.*litter_tot
  
  prod_tot=np.nansum(((PROD001+PROD010+PROD100)*veget*AREA_c)[:,land])*1.e-12
  tbC=np.nansum((biomass*veget*AREA_c)[:,land])*1.e-12
  tlC=np.nansum((litter*veget*AREA_c)[:,land])*1.e-12
  tnpp=np.nansum((ynpp*veget*AREA_c)[:,land])*1.e-12
  tresp_veg=np.nansum((yresp_veg_fire*veget*AREA_c)[:,land])*1.e-12
  tresp_lit=np.nansum((yresp_lit*veget*AREA_c)[:,land])*1.e-12
  tharv=np.nansum((yharv_tot[11,:,:]*veget[11,:,:]*AREA_c)[land])*1.e-12

  aC_FL=np.nansum((soila_FL_tot*veget_sel*AREA_FL_sel))*1e-12
  sC_FL=np.nansum((soils_FL_tot*veget_sel*AREA_FL_sel))*1e-12
  pC_FL=np.nansum((soilp_FL_tot*veget_sel*AREA_FL_sel))*1e-12
  C_FL=aC_FL+sC_FL+pC_FL
  C_FL_old=np.nansum(SOC_FL_old_tot*veget_sel*AREA_FL_sel)*1e-12
  aC_HS=np.nansum((soila_HS_tot*veget_sel*AREA_HS_sel))*1e-12
  sC_HS=np.nansum((soils_HS_tot*veget_sel*AREA_HS_sel))*1e-12
  pC_HS=np.nansum((soilp_HS_tot*veget_sel*AREA_HS_sel))*1e-12
  C_HS=aC_HS+sC_HS+pC_HS
  C_HS_old=np.nansum(SOC_HS_old_tot*veget_sel*AREA_HS_sel)*1e-12
  E_HS=np.nansum((yEsoil*veget_sel*AREA_HS_sel))*1.e-12
  D_FL=np.nansum((yDsoil*veget_sel*AREA_FL_sel))*1.e-12
  R_FL=np.nansum((Resp_FL_y*veget_sel*AREA_FL_sel))*1.e-12
  R_FL_bur=np.nansum((Resp_FL_bur_y*veget_sel*AREA_FL_sel))*1.e-12
  R_HS=np.nansum((Resp_HS_y*veget_sel*AREA_HS_sel))*1.e-12 
  R_HS_bur=np.nansum((Resp_HS_bur_y*veget_sel*AREA_HS_sel))*1.e-12 
  L_FL=np.nansum(litter_tot_FL*veget_sel*AREA_FL_sel)*1e-12
  L_HS=np.nansum(litter_tot_HS*veget_sel*AREA_HS_sel)*1e-12
  
  print tbC,tlC,tnpp,tresp_veg,tresp_lit,tharv,C_FL,\
        C_HS,E_HS,D_FL,R_FL,R_HS

  if num==1:
    resultfile=Dataset('%s/BLpools_%i.nc' % (OptPath,year),'w')
    resultfile.createDimension('latitude',len(rows_c))
    resultfile.createDimension('longitude',len(kols_c))
    resultfile.createDimension('PFT',13)
    var_leaf=    resultfile.createVariable('leaf','f',('PFT','latitude','longitude',))
    var_fruit=  resultfile.createVariable('fruit','f',('PFT','latitude','longitude',))
    var_root=    resultfile.createVariable('root','f',('PFT','latitude','longitude',))
    var_sapab=  resultfile.createVariable('sapab','f',('PFT','latitude','longitude',))
    var_sapbe=  resultfile.createVariable('sapbe','f',('PFT','latitude','longitude',))
    var_hrtab=  resultfile.createVariable('hrtab','f',('PFT','latitude','longitude',))
    var_hrtbe=  resultfile.createVariable('hrtbe','f',('PFT','latitude','longitude',))
    var_reserv=resultfile.createVariable('reserv','f',('PFT','latitude','longitude',))
    var_lit_ma=resultfile.createVariable('lit_ma','f',('PFT','latitude','longitude',))
    var_lit_mb=resultfile.createVariable('lit_mb','f',('PFT','latitude','longitude',))
    var_lit_sa=resultfile.createVariable('lit_sa','f',('PFT','latitude','longitude',))
    var_lit_sb=resultfile.createVariable('lit_sb','f',('PFT','latitude','longitude',))
    var_prod001=    resultfile.createVariable('prod001','f',('latitude','longitude',))
    var_prod010=    resultfile.createVariable('prod010','f',('latitude','longitude',))
    var_prod100=    resultfile.createVariable('prod100','f',('latitude','longitude',))
    var_leaf[:,:,:]=leaf[:,:,:]
    var_fruit[:,:,:]=fruit[:,:,:]
    var_root[:,:,:]=root[:,:,:]
    var_sapab[:,:,:]=sapab[:,:,:]
    var_sapbe[:,:,:]=sapbe[:,:,:]
    var_hrtab[:,:,:]=hrtab[:,:,:]
    var_hrtbe[:,:,:]=hrtbe[:,:,:]
    var_reserv[:,:,:]=reserv[:,:,:]
    var_lit_ma[:,:,:]=lit_ma[:,:,:]
    var_lit_mb[:,:,:]=lit_mb[:,:,:]
    var_lit_sa[:,:,:]=lit_sa[:,:,:]
    var_lit_sb[:,:,:]=lit_sb[:,:,:]
    var_prod001[:,:]=PROD001[:,:]
    var_prod010[:,:]=PROD010[:,:]
    var_prod100[:,:]=PROD100[:,:]
    resultfile.close()

    resultfile=Dataset('%s/BL_tr_%i.nc' % (OptPath,year),'w')
    resultfile.createDimension('latitude',len(rows_c))
    resultfile.createDimension('longitude',len(kols_c))
    resultfile.createDimension('PFT',13)
    var_biomass=resultfile.createVariable('biomass','f',('PFT','latitude','longitude',))
    var_litter=resultfile.createVariable('litter','f',('PFT','latitude','longitude',))
    var_npp=resultfile.createVariable('npp','f',('PFT','latitude','longitude',))
    var_biomass[:,:,:]=biomass[:,:,:]
    var_litter[:,:,:]=litter[:,:,:]
    var_npp[:,:,:]=ynpp[:,:,:]
    resultfile.close()
    
    check.display(str(year)+','+str(tbC)+','+str(tlC)+','+str(tnpp)+','+str(tresp_veg)+','+\
                  str(tresp_lit)+','+str(tharv)+','+str(prod_tot),logfile_BL)

  resultfile=Dataset('%s/SOC_tr_%i_%1i.nc' % (OptPath,year,num),'w')
  resultfile.createDimension('id',b)
  resultfile.createDimension('PFT',13)
  resultfile.createDimension('z',20)
  var_soil_HS=resultfile.createVariable('soil_HS','f',('z','PFT','id',))
  var_soil_FL=resultfile.createVariable('soil_FL','f',('z','PFT','id',))
  var_resp_tot_FL=resultfile.createVariable('resp_tot_FL','f',('PFT','id',))
  var_resp_tot_HS=resultfile.createVariable('resp_tot_HS','f',('PFT','id',))
  var_Esoil=resultfile.createVariable('Esoil','f',('PFT','id',))
  var_Dsoil=resultfile.createVariable('Dsoil','f',('PFT','id',))
  var_M_T_in=resultfile.createVariable('M_T_in','f',('id',))
  var_M_T_out=resultfile.createVariable('M_T_out','f',('PFT','id',))
  var_lit_soil=resultfile.createVariable('lit_soil','f',('PFT','id',))
  var_soil_FL[:,:,:]=(soila_FL+soils_FL+soilp_FL)[:,:,:]
  var_resp_tot_FL[:,:]=Resp_FL_y[:,:]
  var_soil_HS[:,:,:]=(soila_HS+soils_HS+soilp_HS)[:,:,:]
  var_resp_tot_HS[:,:]=Resp_HS_y[:,:]
  var_Esoil[:,:]=yEsoil[:,:]
  var_Dsoil[:,:]=yDsoil[:,:]
  var_M_T_in[:]=M_T_in[:]
  var_M_T_out[:,:]=M_T_out[:,:]
  var_lit_soil[:,:]=litter_tot[:,:]
  resultfile.close()

  check.display(str(year)+','+str(L_HS)+','+str(L_FL)+','+str(C_HS)+','+\
                  str(C_FL)+','+str(E_HS)+','+str(D_FL)+','+ str(R_HS)+','+\
                str(R_FL)+','+str(R_HS_bur)+','+str(R_FL_bur),logfile_SOC)  
    
  data=dict(Ha=soila_HS,Hs=soils_HS,Hp=soilp_HS,Ma=soila_FL,Ms=soils_FL,Mp=soilp_FL,\
            fluxa=fluxa_out2,fluxs=fluxs_out2,fluxp=fluxp_out2,ka_flux=ka_flux_out2,\
            ks_flux=ks_flux_out2,kp_flux=kp_flux_out2,idx=num)
  queue.put(data)

  return
  
