#!/usr/bin/env python
#######################################################################
# This script calculates the changes to SOC stocks at a daily timestep and at a 5 arcmin resolution
# After each year routing takes place between the subbasins in simulation S2
#######################################################################
def SOC_eq(num,year_start,set_depo,rows_h,kols_h,x_new,y_new,id_sub,DEM_in,\
           kresp_soila_FL,kresp_soils_FL,kresp_soilp_FL,kresp_soila_HS,\
           kresp_soils_HS,kresp_soilp_HS,ksoila_s_h,ksoila_p_h,ksoils_a_h,\
           ksoils_p_h,ksoilp_a_h,kE,kEE,littera_zh,litters_zh,soila_FL,\
           soils_FL,soilp_FL,soila_HS,soils_HS,soilp_HS,tau_in,bound_in,weight_out,\
           number_out,OptPath,logfile,queue):

  import sys
  sys.path.insert(0,'/home/orchidee04/vnaipal/Ce_code')
  import numpy as np
  import os
  import inspect
  from PythonTools import *
  from netCDF4 import Dataset
  sys.path.insert(0,'/home/orchidee04/vnaipal/sediment_budget_model/Rhine')
  import routing_main_all
  ######################################################################
  #settings
  ######################################################################
  print('THIS tile IS NUMBER ',num) #respective subbasin
  fname=' ' #Enter here your workdir
  maskfile_h='%s/Rhine_mask_5m_new.nc' % (fname) #Enter here the path to the 5 arcmin mask file
  vegetPath='%s/ ' % (fname) #Enter here the path to vegetation fractions at the coarse resolution of ORCHIDEE
  b=len(id_sub) #number of gridcells of subbasin
  x=np.array([1.]*15)
  xNPP=x[0]
  xmort=x[1:-4]
  xl,xa,xs,xp=x[-4:]
  dz0=0.1
  zmax0=2
  soil_layers=np.arange(zmax0/dz0) #20 soil layers of each 0.01m thickness
  soil_layers=soil_layers.astype(int)
  zmin=np.arange(0.,zmax0,dz0) #the bottom of each soil layer
  zmax=np.arange(0.+dz0,zmax0+dz0,dz0)
  Lab_top=0.1
  ######################################################################
  #neccessary input files
  ######################################################################
  data_h=Dataset(maskfile_h,'r')
  mask=data_h.variables['mask'][:]
  data_h.close()
  vegetnc_h=Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_1851_5m.nc' %(vegetPath),'r')
  veget_h=vegetnc_h.variables['maxvegetfrac'][0,:,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1]
  veget_h=veget_h.reshape(13,7030)
  veget_h[np.isnan(veget_h)==True]=0.
  vegetnc_h.close()
  veget_sel=veget_h[:,id_sub] #select data for subbasin only
  veget_sel[veget_sel>100.]=0.
  Snc=Dataset('%s/sediment_budget_model/Rhine/Rhine_regions_final2_grid.nc' %(fname),'r') 
  str_bas=Snc.variables['str_bas'][:]
  str_bas=np.ravel(str_bas)
  str_bas_in=str_bas.astype(int)
  Snc.close()
  number_out=np.ravel(number_out)
  weight_out=np.ravel(weight_out)
  bound_in=bound_in.astype(int) 
  ######################################################################
  #calcultation of floodplain and hillslope fractions
  ######################################################################
  areanc=Dataset('%s/Global_land_grid_area_5m_grid.nc' % (fname),'r') 
  AREA_h=areanc.variables['area'][rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1]*1000000. 
  AREA_h[AREA_h<=0.]=np.nan
  Ahs_nc=Dataset('%s/hill-slope_valley-bottom_Rhine_5m_new.nc' % (fname),'r')
  Ahs=Ahs_nc.variables['Band1'][:] 
  Afl_nc=Dataset('%s/Rhine_Floodplain_vs_Hillslope_5m.nc' % (fname),'r')
  lowland=Afl_nc.variables['Band1'][:]
  lowland[lowland!=2.]=0.
  Ahs[lowland>0.]=0.
  AREA_HS_old=Ahs*AREA_h
  AREA_FL_old=(1-Ahs)*AREA_h
  Ahs_nc.close();Afl_nc.close();areanc.close()
  Anc=Dataset('%s/FL_contr_area2_grid.nc' % (fname),'r')
  Acontr=Anc.variables['A'][:]*1E-6 #m2 to km2
  Acontr[mask!=1]=np.nan
  Anc.close()
  Lnc=Dataset('%s/Rhine_streamL_final.nc' % (fname),'r')
  stream_L=Lnc.variables['Band1'][:]*1000. #km to m
  stream_L[mask!=1]=np.nan
  Lnc.close()
  stream_w=60.8*Acontr**0.3 #m
  AREA_FL_new=stream_L*stream_w #new floodplain area estimation in m2
  Afl=np.ravel(1-Ahs)
  Afl_new=np.zeros((7030,))
  for i in range(7030):
    if Afl[i]<0.1:
      Afl_new[i]=np.ravel(AREA_FL_new)[i]/np.ravel(AREA_h)[i]
    else:
      Afl_new[i]=1.*Afl[i]
  AREA_FL=Afl_new.reshape(74,95)*AREA_h
  AREA_HS=(1-Afl_new.reshape(74,95))*AREA_h
  AREA_FL[np.isnan(AREA_FL)==True]=0.
  AREA_HS[np.isnan(AREA_HS)==True]=0.
  AREA_HS_sel=np.ravel(AREA_HS)[id_sub] #select data of subbasin only
  AREA_FL_sel=np.ravel(AREA_FL)[id_sub]
  ######################################################################
  #derive floodplain deposition rate (kD) and sediment export rate (kout)
  ######################################################################
  if set_depo=='y':
    kD=(kE*AREA_HS_sel)/AREA_FL_sel
    kD[np.isnan(kD)==True]=0.
    kD[np.isfinite(kD)==False]=0.
    kout=np.ravel(1/(tau_in))[id_sub]
    kout[kout>=1.]=0.
    kout=kout/365.
    Ma_in=np.zeros((7030))
    Ms_in=np.zeros((7030))
    Mp_in=np.zeros((7030))
  else:
    kD=0.
    kout=0.
    ka_out=0.;ks_out=0.;kp_out=0. 
  #######################################################################
  # Run SOC scheme
  #######################################################################
  fluxa_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  fluxs_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  fluxp_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  ka_flux_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  ks_flux_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  kp_flux_out2=np.zeros((len(rows_h),len(kols_h)),dtype=np.float64)
  E_tot=0.;D_tot=0.;litter_tot=0.
  M_T_in=np.zeros((b,));M_T_out=np.zeros((13,b))
  dresp_FL=np.zeros((20,13,b));dresp_HS=np.zeros((20,13,b))
  Resp_FL_y=np.zeros((13,b));Resp_HS_y=np.zeros((13,b))
  for dd in range(365):
    soila_FL[np.isnan(soila_FL)==True]=0.
    soils_FL[np.isnan(soils_FL)==True]=0.
    soilp_FL[np.isnan(soilp_FL)==True]=0.
    xsoila_HS=xa*soila_HS
    xsoila_FL=xa*soila_FL
    xsoils_HS=xs*soils_HS
    xsoils_FL=xs*soils_FL
    xsoilp_HS=xp*soilp_HS
    xsoilp_FL=xp*soilp_FL
    if dd==0:
      SOC_HS_old=xsoila_HS+xsoils_HS+xsoilp_HS
      SOC_FL_old=xsoila_FL+xsoils_FL+xsoilp_FL     
    #####################################
    # Hillslopes
    #####################################
    for z in soil_layers:
      soils_a_HS=ksoils_a_h*xsoils_HS[z]
      soilp_a_HS=ksoilp_a_h*xsoilp_HS[z]
      soila_s_HS=ksoila_s_h*xsoila_HS[z]
      soila_p_HS=ksoila_p_h*xsoila_HS[z]
      soils_p_HS=ksoils_p_h*xsoils_HS[z]
      klossa_HS=kresp_soila_HS[z]+ksoila_s_h+ksoila_p_h+kE
      klosss_HS=kresp_soils_HS[z]+ksoils_a_h+ksoils_p_h+kE
      klossp_HS=kresp_soilp_HS[z]+ksoilp_a_h+kE    
      if z==19:
        soila_HS[z]+=littera_zh[z]+soils_a_HS+soilp_a_HS-klossa_HS*xsoila_HS[z]
        soils_HS[z]+=litters_zh[z]+soila_s_HS-klosss_HS*xsoils_HS[z]
        soilp_HS[z]+=soila_p_HS+soils_p_HS-klossp_HS*xsoilp_HS[z]
        dresp_HS[z]=kresp_soila_HS[z]*xsoila_HS[z]+kresp_soils_HS[z]*xsoils_HS[z]+kresp_soilp_HS[z]*xsoilp_HS[z]
      elif z==0:
        soila_HS[z]+=littera_zh[z]+soils_a_HS+soilp_a_HS+(kE*soila_HS[z+1])-klossa_HS*xsoila_HS[z]
        soils_HS[z]+=litters_zh[z]+soila_s_HS+(kE*soils_HS[z+1])-klosss_HS*xsoils_HS[z]
        soilp_HS[z]+=soila_p_HS+soils_p_HS+(kE*soilp_HS[z+1])-klossp_HS*xsoilp_HS[z]
        dresp_HS[z]=kresp_soila_HS[z]*xsoila_HS[z]+kresp_soils_HS[z]*xsoils_HS[z]+kresp_soilp_HS[z]*xsoilp_HS[z]        
      else:
        soila_HS[z]+=littera_zh[z]+soils_a_HS+soilp_a_HS+(kE*soila_HS[z+1])-klossa_HS*xsoila_HS[z]
        soils_HS[z]+=litters_zh[z]+soila_s_HS+(kE*soils_HS[z+1])-klosss_HS*xsoils_HS[z]
        soilp_HS[z]+=soila_p_HS+soils_p_HS+(kE*soilp_HS[z+1])-klossp_HS*xsoilp_HS[z]
        dresp_HS[z]=kresp_soila_HS[z]*xsoila_HS[z]+kresp_soils_HS[z]*xsoils_HS[z]+kresp_soilp_HS[z]*xsoilp_HS[z]
    soila_HS[np.isfinite(soila_HS)==False]=0.
    soils_HS[np.isfinite(soils_HS)==False]=0.
    soilp_HS[np.isfinite(soilp_HS)==False]=0.
    soila_HS[np.isnan(soila_HS)==True]=0.
    soils_HS[np.isnan(soils_HS)==True]=0.
    soilp_HS[np.isnan(soilp_HS)==True]=0.
    #####################################
    # FLOODPLAINS
    #####################################
    for z in soil_layers:
      soils_a_FL=ksoils_a_h*xsoils_FL[z]
      soilp_a_FL=ksoilp_a_h*xsoilp_FL[z]
      soila_s_FL=ksoila_s_h*xsoila_FL[z]
      soila_p_FL=ksoila_p_h*xsoila_FL[z]
      soils_p_FL=ksoils_p_h*xsoils_FL[z]                     
      if z==19:
        klossa_FL=kresp_soila_FL[z]+ksoila_s_h+ksoila_p_h+kout
        klosss_FL=kresp_soils_FL[z]+ksoils_a_h+ksoils_p_h+kout
        klossp_FL=kresp_soilp_FL[z]+ksoilp_a_h+kout
        soila_FL[z]+=littera_zh[z]+soils_a_FL+soilp_a_FL+(kD+ka_out)*xsoila_FL[z-1]-klossa_FL*xsoila_FL[z]
        soils_FL[z]+=litters_zh[z]+soila_s_FL+(kD+ks_out)*xsoils_FL[z-1]-klosss_FL*xsoils_FL[z]
        soilp_FL[z]+=soila_p_FL+soils_p_FL+(kD+kp_out)*xsoilp_FL[z-1]-klossp_FL*xsoilp_FL[z]
        dresp_FL[z]=kresp_soila_FL[z]*xsoila_FL[z]+kresp_soils_FL[z]*xsoils_FL[z]+kresp_soilp_FL[z]*xsoilp_FL[z]
      elif z==0:
        if set_depo=='y':
          M_out=kout*(soila_FL[z]+soils_FL[z]+soilp_FL[z])
          M_T_out[1:13,:]+=M_out[1:13,:]
          #routing          
          Ma_in[id_sub]=np.nansum((xsoila_FL[z,1:13,:]*veget_h[1:13,id_sub]),axis=0)*AREA_FL_sel #sum over all pfts before routing
          Ms_in[id_sub]=np.nansum((xsoils_FL[z,1:13,:]*veget_h[1:13,id_sub]),axis=0)*AREA_FL_sel
          Mp_in[id_sub]=np.nansum((xsoilp_FL[z,1:13,:]*veget_h[1:13,id_sub]),axis=0)*AREA_FL_sel

          A_in=np.ravel(AREA_FL)*np.nansum(veget_h[1:13,:],axis=0)

          Ma_T,fluxa_out,ka,ka_flux_out= routing_main_all.multi_flow.main\
                                           (A_in,DEM_in,Ma_in,str_bas_in,weight_out,\
                                            number_out,bound_in,tau_in*365.,len(rows_h),\
                                            len(kols_h),x_new,y_new,b)
          Ms_T,fluxs_out,ks,ks_flux_out= routing_main_all.multi_flow.main\
                                            (A_in,DEM_in,Ms_in,str_bas_in,weight_out,\
                                             number_out,bound_in,tau_in*365.,len(rows_h),\
                                             len(kols_h),x_new,y_new,b)
          Mp_T,fluxp_out,kp,kp_flux_out= routing_main_all.multi_flow.main\
                                            (A_in,DEM_in,Mp_in,str_bas_in,weight_out,\
                                             number_out,bound_in,tau_in*365.,len(rows_h),\
                                             len(kols_h),x_new,y_new,b)
          Ma_T=np.ravel(Ma_T,order='F')
          Ms_T=np.ravel(Ms_T,order='F')
          Mp_T=np.ravel(Mp_T,order='F')
          ka=np.ravel(ka,order='F')
          ks=np.ravel(ks,order='F')
          kp=np.ravel(kp,order='F')      
          Ma_T=np.reshape(Ma_T,(len(rows_h)*len(kols_h)),order='C')
          Ms_T=np.reshape(Ms_T,(len(rows_h)*len(kols_h)),order='C')
          Mp_T=np.reshape(Mp_T,(len(rows_h)*len(kols_h)),order='C')                    
          ka=np.reshape(ka,(len(rows_h)*len(kols_h)),order='C')  
          ks=np.reshape(ks,(len(rows_h)*len(kols_h)),order='C') 
          kp=np.reshape(kp,(len(rows_h)*len(kols_h)),order='C')

          fluxa_out=np.ravel(fluxa_out,order='F') #total C flux from neighboring grids that flow into a certain grid
          fluxs_out=np.ravel(fluxs_out,order='F')
          fluxp_out=np.ravel(fluxp_out,order='F')
          fluxa_out=np.reshape(fluxa_out,(len(rows_h),len(kols_h)),order='C') 
          fluxs_out=np.reshape(fluxs_out,(len(rows_h),len(kols_h)),order='C') 
          fluxp_out=np.reshape(fluxp_out,(len(rows_h),len(kols_h)),order='C') 
          fluxa_out2=fluxa_out2+fluxa_out
          fluxs_out2=fluxs_out2+fluxs_out
          fluxp_out2=fluxp_out2+fluxp_out 

          Ma_T[str_bas!=num]=0.;Ms_T[str_bas!=num]=0.;Mp_T[str_bas!=num]=0.
          ka_out=ka[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0))
          ks_out=ks[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0))
          kp_out=kp[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0))
          Ma_T_in=(Ma_T[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0)))
          Ms_T_in=(Ms_T[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0)))
          Mp_T_in=(Mp_T[id_sub]/(AREA_FL_sel*np.nansum(veget_sel[1:13,:],axis=0)))

          M_T_in+=Ma_T_in+Ms_T_in+Mp_T_in

          ka_flux_out=np.ravel(ka_flux_out,order='F') #inflow rate from neighboring grids that flow into a certain grid
          ks_flux_out=np.ravel(ks_flux_out,order='F')
          kp_flux_out=np.ravel(kp_flux_out,order='F')
          ka_flux_out2=ka_flux_out2+np.reshape(ka_flux_out,(len(rows_h),len(kols_h)),order='C') 
          ks_flux_out2=ks_flux_out2+np.reshape(ks_flux_out,(len(rows_h),len(kols_h)),order='C') 
          kp_flux_out2=kp_flux_out2+np.reshape(kp_flux_out,(len(rows_h),len(kols_h)),order='C') 

        klossa_FL=kresp_soila_FL[z]+ksoila_s_h+ksoila_p_h+kD+kout
        klosss_FL=kresp_soils_FL[z]+ksoils_a_h+ksoils_p_h+kD+kout
        klossp_FL=kresp_soilp_FL[z]+ksoilp_a_h+kD+kout
        soila_FL[z]+=littera_zh[z]+soils_a_FL+soilp_a_FL+kD*xsoila_HS[z]+kout*soila_FL[z+1]-klossa_FL*xsoila_FL[z]
        soils_FL[z]+=litters_zh[z]+soila_s_FL+kD*xsoils_HS[z]+kout*soils_FL[z+1]-klosss_FL*xsoils_FL[z]
        soilp_FL[z]+=soila_p_FL+soils_p_FL+kD*xsoilp_HS[z]+kout*soilp_FL[z+1]-klossp_FL*xsoilp_FL[z]
        dresp_FL[z]=kresp_soila_FL[z]*xsoila_FL[z]+kresp_soils_FL[z]*xsoils_FL[z]+kresp_soilp_FL[z]*xsoilp_FL[z]      

        soila_FL[z,1:13,:]+=Ma_T_in-(ka_out*xsoila_FL[z,1:13,:])
        soils_FL[z,1:13,:]+=Ms_T_in-(ks_out*xsoils_FL[z,1:13,:])
        soilp_FL[z,1:13,:]+=Mp_T_in-(kp_out*xsoilp_FL[z,1:13,:])      
        
      else:
        klossa_FL=kresp_soila_FL[z]+ksoila_s_h+ksoila_p_h+kD+kout+ka_out
        klosss_FL=kresp_soils_FL[z]+ksoils_a_h+ksoils_p_h+kD+kout+ks_out
        klossp_FL=kresp_soilp_FL[z]+ksoilp_a_h+kD+kout+kp_out
        soila_FL[z]+=littera_zh[z]+soils_a_FL+soilp_a_FL+(kD+ka_out)*xsoila_FL[z-1]+kout*soila_FL[z+1]-klossa_FL*xsoila_FL[z]
        soils_FL[z]+=litters_zh[z]+soila_s_FL+(kD+ks_out)*xsoils_FL[z-1]+kout*soils_FL[z+1]-klosss_FL*xsoils_FL[z]
        soilp_FL[z]+=soila_p_FL+soils_p_FL+(kD+kp_out)*xsoilp_FL[z-1]+kout*soilp_FL[z+1]-klossp_FL*xsoilp_FL[z]
        dresp_FL[z]=kresp_soila_FL[z]*xsoila_FL[z]+kresp_soils_FL[z]*xsoils_FL[z]+kresp_soilp_FL[z]*xsoilp_FL[z]

    soila_FL[np.isfinite(soila_FL)==False]=0.
    soils_FL[np.isfinite(soils_FL)==False]=0.
    soilp_FL[np.isfinite(soilp_FL)==False]=0.
    soila_FL[np.isnan(soila_FL)==True]=0.
    soils_FL[np.isnan(soils_FL)==True]=0.
    soilp_FL[np.isnan(soilp_FL)==True]=0.
    xsoila=1.*xsoila_FL;xsoils=1.*xsoils_FL;xsoilp=1.*xsoilp_FL
    xsoila[soila_FL>0.]=0.;xsoils[soils_FL>0.]=0.;xsoilp[soilp_FL>0.]=0.
    soila_FL+=xsoila;soils_FL+=xsoils;soilp_FL+=xsoilp
    Resp_FL_y+=np.nansum(dresp_FL,axis=0)    
    
    Esoila=kEE*xsoila_HS[0]   #daily net carbon erosion flux in equilibrium
    Esoils=kEE*xsoils_HS[0]
    Esoilp=kEE*xsoilp_HS[0]
    E_tot+=Esoila+Esoils+Esoilp
    Dsoila=(kE*xsoila_HS[0]*AREA_HS_sel)/AREA_FL_sel #daily carbon deposition flux in equilibrium in FLs
    Dsoils=(kE*xsoils_HS[0]*AREA_HS_sel)/AREA_FL_sel
    Dsoilp=(kE*xsoilp_HS[0]*AREA_HS_sel)/AREA_FL_sel
    D_tot+=Dsoila+Dsoils+Dsoilp
    litter_tot+=np.nansum((littera_zh+litters_zh),axis=0)
  #for hillslopes
  soila_HS_tot=np.nansum(soila_HS,axis=0)
  soils_HS_tot=np.nansum(soils_HS,axis=0)
  soilp_HS_tot=np.nansum(soilp_HS,axis=0)
  Resp_HS=np.nansum(kresp_soila_HS*xsoila_HS+kresp_soils_HS*xsoils_HS+kresp_soilp_HS*xsoilp_HS,axis=0) #sum over soil layers
  #for floodplains
  soila_FL_tot=np.nansum(soila_FL,axis=0) #sum over soil layers
  soils_FL_tot=np.nansum(soils_FL,axis=0)
  soilp_FL_tot=np.nansum(soilp_FL,axis=0)
  SOC_FL_old_tot=np.nansum(SOC_FL_old,axis=0)

  aC_HS=np.nansum(soila_HS_tot*veget_sel*AREA_HS_sel)*1e-12
  sC_HS=np.nansum(soils_HS_tot*veget_sel*AREA_HS_sel)*1e-12
  pC_HS=np.nansum(soilp_HS_tot*veget_sel*AREA_HS_sel)*1e-12
  C_HS=aC_HS+sC_HS+pC_HS
  R_HS=np.nansum(Resp_HS*365*veget_sel*AREA_HS_sel)*1e-12
  aC_FL=np.nansum(soila_FL_tot*veget_sel*AREA_FL_sel)*1e-12
  sC_FL=np.nansum(soils_FL_tot*veget_sel*AREA_FL_sel)*1e-12
  pC_FL=np.nansum(soilp_FL_tot*veget_sel*AREA_FL_sel)*1e-12
  C_FL=aC_FL+sC_FL+pC_FL
  C_FL_old=np.nansum(SOC_FL_old_tot*veget_sel*AREA_FL_sel)*1e-12
  R_FL=np.nansum(Resp_FL_y*veget_sel*AREA_FL_sel)*1e-12
  E_HS=np.nansum(E_tot*veget_sel*AREA_HS_sel)*1e-12
  D_FL=np.nansum(D_tot*veget_sel*AREA_FL_sel)*1e-12
  L_FL=np.nansum(litter_tot*veget_sel*AREA_FL_sel)*1e-12
  L_HS=np.nansum(litter_tot*veget_sel*AREA_HS_sel)*1e-12
  print year_start,L_HS,L_FL,C_HS,C_FL,E_HS,D_FL,R_HS,R_FL

  check.display(str(year_start)+','+str(L_HS)+','+str(L_FL)+','+str(C_HS)+','+\
                str(C_FL)+','+str(E_HS)+','+str(D_FL)+','+ str(R_HS)+','+str(R_FL),logfile)

  if year_start==200 or year_start==500 or 1000<=year_start<1200 or year_start>1800\
     or year_start>2800:
    resultfile=Dataset('%s/SOC_cc_eq_%i_%1i.nc' % (OptPath,year_start,num),'w')
    resultfile.createDimension('id',b)
    resultfile.createDimension('PFT',13)
    resultfile.createDimension('layer',20)
    var_soila_HS=resultfile.createVariable('soila_HS','f',('layer','PFT','id',))
    var_soils_HS=resultfile.createVariable('soils_HS','f',('layer','PFT','id',))
    var_soilp_HS=resultfile.createVariable('soilp_HS','f',('layer','PFT','id',))
    var_soila_FL=resultfile.createVariable('soila_FL','f',('layer','PFT','id',))
    var_soils_FL=resultfile.createVariable('soils_FL','f',('layer','PFT','id',))
    var_soilp_FL=resultfile.createVariable('soilp_FL','f',('layer','PFT','id',))
    var_soila_FL[:,:,:]=soila_FL[:,:,:]
    var_soils_FL[:,:,:]=soils_FL[:,:,:]
    var_soilp_FL[:,:,:]=soilp_FL[:,:,:]
    var_soila_HS[:,:,:]=soila_HS[:,:,:]
    var_soils_HS[:,:,:]=soils_HS[:,:,:]
    var_soilp_HS[:,:,:]=soilp_HS[:,:,:]
    resultfile.close()

  if 1000<=year_start<1200 or 1800<=year_start<2000 or year_start>2800:
    resultfile=Dataset('%s/Rest_cc_eq_%i_%1i.nc' % (OptPath,year_start,num),'w')
    resultfile.createDimension('id',b)
    resultfile.createDimension('PFT',13)
    var_Esoil=resultfile.createVariable('Esoil','f',('PFT','id',))
    var_Dsoil=resultfile.createVariable('Dsoil','f',('PFT','id',))
    var_resp_tot_FL=resultfile.createVariable('resp_tot_FL','f',('PFT','id',))
    var_resp_tot_HS=resultfile.createVariable('resp_tot_HS','f',('PFT','id',))
    var_lit_soil=resultfile.createVariable('lit_soil','f',('PFT','id',))
    var_M_T_in=resultfile.createVariable('M_T_in','f',('id',))
    var_M_T_out=resultfile.createVariable('M_T_out','f',('PFT','id',))
    var_Esoil[:,:]=E_tot[:,:]
    var_Dsoil[:,:]=D_tot[:,:]
    var_resp_tot_FL[:,:]=Resp_FL_y[:,:]
    var_resp_tot_HS[:,:]=Resp_HS_y[:,:]
    var_lit_soil[:,:]=litter_tot[:,:]
    var_M_T_in[:]=M_T_in[:]
    var_M_T_out[:,:]=M_T_out[:,:]
    resultfile.close()

  #output
  data=dict(Ha=soila_HS,Hs=soils_HS,Hp=soilp_HS,Ma=soila_FL,Ms=soils_FL,Mp=soilp_FL,\
            fluxa=fluxa_out2,fluxs=fluxs_out2,fluxp=fluxp_out2,ka_flux=ka_flux_out2,\
            ks_flux=ks_flux_out2,kp_flux=kp_flux_out2,idx=num)
  queue.put(data)
  
  return
