#!/usr/bin/env python
#######################################################################
# This script extracts the k's of the Rhine sub-catchment
# output from this file goes to func2
#######################################################################
def func_proc(year,rows_c,kols_c):
  import sys
  #sys.path.insert(0,' ') #Enter path to modules if neccessary 
  import numpy as np
  import os
  import inspect
  from PythonTools import *
  import csv
  from netCDF4 import Dataset
  ######################################################################
  #settings
  ######################################################################
  fname=' ' #Enter here your workdir
  OrcPath=' ' #Enter here the path to the turnover files of ORCHIDEE
  OrcPath2='%s/' % (fname) #Enter here the path to vegetation fractions at the coarse resolution of ORCHIDEE
  maskfile_c='%s/Rhine_mask_LMDZ.nc' % (fname) #Enter here the path to the mask file of ORCHIDEE
  maskfile_h='%s/Rhine_mask_5m_new.nc' % (fname) #Enter here the path to the 5 arcmin mask file
  #soil layer parameters
  dz0=0.1
  zmax0=2
  soil_layers=np.arange(zmax0/dz0) 
  soil_layers=soil_layers.astype(int)
  dz_all=np.empty(len(soil_layers))
  dz_all.fill(dz0)
  zmin=np.arange(0.,zmax0,dz0) 
  zmax=np.arange(0.+dz0,zmax0+dz0,dz0)
  Lab_top=0.1
  soil_layers_top=np.arange(Lab_top/dz0)
  soil_layers_top=soil_layers_top.astype(int)
  ######################################################################
  #Other neccessary input data 
  ######################################################################
  Rnc=Dataset('%s/re_1851_1860_mean.Rhine.nc' %(fname),'r') #re (SOC profile modifier)
  re=Rnc.variables['re'][:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  Rnc.close()
  ######################################################################
  #Read yearly ORCHIDEE files and extract the K's
  ######################################################################
  kc=Dataset('%s/K0_RESP_%i_calib.Rhine.nc' % (OrcPath,year),'r')
  kresp_soila0=kc.variables['k0_soila'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_soils0=kc.variables['k0_soils'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_soilp0=kc.variables['k0_soilp'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_soila0[kresp_soila0<1E-10]=0.
  kresp_soils0[kresp_soils0<1E-10]=0.
  kresp_soilp0[kresp_soilp0<1E-10]=0.
  if year==1932: #this year is treated seperately due to bugs in the NPP
    nc=Dataset('%s/K_ORCHIDEE.%s.lmdz.TRENDY.newVCmax.Rhine.nc' %(OrcPath,1931),'r')
    NPP_leaf  =nc.variables['NPP_leaf'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_sapab =nc.variables['NPP_sapab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_sapbe =nc.variables['NPP_sapbe' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_root  =nc.variables['NPP_root'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_fruit =nc.variables['NPP_fruit' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_reserv=nc.variables['NPP_reserv'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  else:
    nc=Dataset('%s/K_ORCHIDEE.%s.lmdz.TRENDY.newVCmax.Rhine.nc' %(OrcPath,year),'r')
    NPP_leaf  =nc.variables['NPP_leaf'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_sapab =nc.variables['NPP_sapab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_sapbe =nc.variables['NPP_sapbe' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_root  =nc.variables['NPP_root'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_fruit =nc.variables['NPP_fruit' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
    NPP_reserv=nc.variables['NPP_reserv'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kmb_res=nc.variables['kmb_res'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_leaf  =nc.variables['kmort_leaf'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_sapab =nc.variables['kmort_sapab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_sapbe =nc.variables['kmort_sapbe' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_hrtab =nc.variables['kmort_hrtab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_hrtbe =nc.variables['kmort_hrtbe' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_root  =nc.variables['kmort_root'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_fruit =nc.variables['kmort_fruit' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kmort_reserv=nc.variables['kmort_reserv'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_leaf  =nc.variables['kturn_leaf'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_sapab =nc.variables['kturn_sapab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_root  =nc.variables['kturn_root'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kturn_fruit =nc.variables['kturn_fruit' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kharv_leaf  =nc.variables['kharv_leaf'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_sapab =nc.variables['kharv_sapab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_root  =nc.variables['kharv_root'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kharv_fruit =nc.variables['kharv_fruit' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_leaf  =nc.variables['kfire_leaf'  ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_sapab =nc.variables['kfire_sapab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_hrtab =nc.variables['kfire_hrtab' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kfire_fruit =nc.variables['kfire_fruit' ][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  kfire_reserv=nc.variables['kfire_reserv'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  klitma_soila=nc.variables['klitma_soila'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitmb_soila=nc.variables['klitmb_soila'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsa_soila=nc.variables['klitsa_soila'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsa_soils=nc.variables['klitsa_soils'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsb_soila=nc.variables['klitsb_soila'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  klitsb_soils=nc.variables['klitsb_soils'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litma=nc.variables['kresp_litma'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litmb=nc.variables['kresp_litmb'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litsa=nc.variables['kresp_litsa'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kresp_litsb=nc.variables['kresp_litsb'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kfire_litma=nc.variables['kfire_litma'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  kfire_litsa=nc.variables['kfire_litsa'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #kresp_soila=nc.variables['kresp_soila'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #kresp_soils=nc.variables['kresp_soils'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  #kresp_soilp=nc.variables['kresp_soilp'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  ksoila_s=nc.variables['ksoila_s'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoila_p=nc.variables['ksoila_p'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoils_a=nc.variables['ksoils_a'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoils_p=nc.variables['ksoils_p'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1] 
  ksoilp_a=nc.variables['ksoilp_a'][:,:,rows_c[0]:rows_c[-1]+1,kols_c[0]:kols_c[-1]+1]
  nc.close()
  kc.close()

  kresp_soila=np.zeros((20,365,13,len(rows_c),len(kols_c)))
  kresp_soils=np.zeros((20,365,13,len(rows_c),len(kols_c)))
  kresp_soilp=np.zeros((20,365,13,len(rows_c),len(kols_c)))    
  ktop_soila=np.zeros((365,13,2,2))
  ktop_soils=np.zeros((365,13,2,2))
  ktop_soilp=np.zeros((365,13,2,2))
  soil_layers_top=np.arange(Lab_top/0.01)
  soil_layers_top=soil_layers_top.astype(int)
  for z in soil_layers_top:
    ktop_soila=ktop_soila+(kresp_soila0*np.exp(-re*zmin[z]))
    ktop_soils=ktop_soils+(kresp_soils0*np.exp(-re*zmin[z]))
    ktop_soilp=ktop_soilp+(kresp_soilp0*np.exp(-re*zmin[z]))
  for z in soil_layers:
    if zmax[z]<=Lab_top:
      kresp_soila[z]=ktop_soila*0.1
      kresp_soils[z]=ktop_soils*0.1
      kresp_soilp[z]=ktop_soilp*0.1
    else: 
      kresp_soila[z]=kresp_soila0*np.exp(-re*zmin[z])
      kresp_soils[z]=kresp_soils0*np.exp(-re*zmin[z])
      kresp_soilp[z]=kresp_soilp0*np.exp(-re*zmin[z])
  
  return NPP_leaf,NPP_sapab,NPP_sapbe,NPP_root,NPP_fruit,NPP_reserv,kmb_res,kmort_leaf,\
          kmort_sapab,kmort_sapbe,kmort_hrtab,kmort_hrtbe,kmort_root,kmort_fruit,kmort_reserv,kturn_leaf,\
          kturn_sapab,kturn_root,kturn_fruit,kharv_leaf,kharv_sapab,kharv_root,kharv_fruit,kfire_leaf,\
          kfire_sapab,kfire_hrtab,kfire_fruit,kfire_reserv,klitma_soila,klitmb_soila,klitsa_soila,\
          klitsa_soils,klitsb_soila,klitsb_soils,kresp_litma,kresp_litmb,kresp_litsa,kresp_litsb,\
          kfire_litma,kfire_litsa,kresp_soila,kresp_soils,kresp_soilp,\
          ksoila_s,ksoila_p,ksoils_a,ksoils_p,ksoilp_a
