#!/usr/bin/env python
########################################################################
#This is the run script for the equilibrium simulations
########################################################################
from multiprocessing import Process,Queue
import sys
from netCDF4 import Dataset
from PythonTools import *
import mod_append
import mod_sorting
import routing_main_basin
#sys.path.insert(0,' ') #Enter path to modules if neccessary 
from func1 import eq
from func2 import SOC_eq
from D import D_pft
########################################################################
#simulation settings
########################################################################
regions=7 #number of subbasins in the Rhine
region_start=1 #start with subbasin number 1
dataout={};logfile_SOC={};logfile_out={}
fname=' ' #Enter here your workdir
OrcPath=' ' #Enter here the path to the turnover files of ORCHIDEE
vegetPath='%s/' % (fname) #Enter here the path to vegetation fractions
EPath0='%s/' % (fname) #Enter here the path to erosion data
BDPath='%s/' % (fname) #enter here the path to bulk density data
maskfile_h='%s/Rhine_mask_5m_new.nc' % (fname) #Enter here the path to the 5 arcmin mask file
maskfile_c='%s/Rhine_mask_LMDZ.nc' % (fname) #Enter here the path to the mask file of ORCHIDEE
set_eros='y' # erosion or no erosion
set_depo='y' #deposiition or no deposition
if set_eros=='y' and set_depo=='y': #simulation S2
  OptPath='%s/' % (fname) # Enter here your output directory
elif set_eros=='n' and set_depo=='n': #simulation S0
  OptPath='%s/' % (fname) # Enter here your output directory
elif set_eros=='y' and set_depo=='n': #simulation S1
  OptPath='%s/' % (fname) # Enter here your output directory
dz0=0.1 #soillayer thickness
########################################################################
#read domain & calulate indices
########################################################################
data_c=Dataset(maskfile_c,'r')
lat_c=data_c.variables['lat'][:]
lon_c=data_c.variables['lon'][:] 
data_c.close()
data_h=Dataset(maskfile_h,'r')
lat_h=data_h.variables['lat'][:]
lon_h=data_h.variables['lon'][:]
mask=data_h.variables['mask'][:]
data_h.close()
vegetnc_h=Dataset('%s/PFTmap_LUHv2_BM3_HoughtonCountryForestarea_withoutNoBio_1851_5m.nc' %(vegetPath),'r')
lats_h=vegetnc_h.variables['lat'][:]
lons_h=vegetnc_h.variables['lon'][:]
rows_h=[]
for i in range(len(lats_h)):
  if lats_h[i]>(lat_h[-1]-0.0833) and lats_h[i]<=lat_h[0]:
    rows_h.append(i)
kols_h=[]
for j in range(len(lons_h)):
  if lons_h[j]>=lon_h[0] and lons_h[j]<(lon_h[-1]+0.0833):
    kols_h.append(j)
rows_h=np.asarray(rows_h)
kols_h=np.asarray(kols_h)
veget_h=np.array(vegetnc_h.variables['maxvegetfrac'][0,:,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1])
veget_h[np.isnan(veget_h)==True]=0.
veget_h[veget_h>10.]=0.
veget_h=veget_h.reshape(13,7030)
vegetnc_h.close()

nc=Dataset('%s/K_ORCHIDEE.1851_1860_mean.TRENDY.newVCmax.Rhine.nc' %(OrcPath),'r')
lats=nc.variables['latitude'][:]
lons=nc.variables['longitude'][:]
rows_c=[]
for i in range(len(lats)):
  if lats[i]>=lat_c[-1] and lats[i]<=lat_c[0]:
    rows_c.append(i)
kols_c=[]
for j in range(len(lons)):
  if lons[j]+1.875>=lon_c[0] and lons[j]+1.875<=lon_c[-1]:
    kols_c.append(j)
rows_c=np.asarray(rows_c)
kols_c=np.asarray(kols_c)
nc.close()

#############################################################################
#derive the coarse-resolution rows and kols corresponding to the high-resolution rows and kols of basin
#############################################################################
Snc=Dataset('%s/sediment_budget_model/Rhine/Rhine_regions_final2_grid.nc' %(fname),'r')  
str_bas=Snc.variables['str_bas'][:]
lat_bas=Snc.variables['lat'][:]
lon_bas=Snc.variables['lon'][:]
Snc.close()
row_bas_sel={}
kol_bas_sel={}
for rgn in range(regions):
  lat_bas_sel=[]
  lon_bas_sel=[]
  for j in range(len(lat_bas)):
    for i in range(len(lon_bas)):
      if str_bas[j,i]==region_start+rgn:
        lat_bas_sel.append(lat_bas[j])
        lon_bas_sel.append(lon_bas[i])
  lat_bas_sel=np.asarray(lat_bas_sel)
  lon_bas_sel=np.asarray(lon_bas_sel)
  #define relating coarse res gridcells to high res gridcells
  r_sel=[]
  for i in range(len(lat_bas_sel)):
    dlat_min=1000.
    row_min=0
    for j in range(len(lat_c)):
      dlat=abs(lat_bas_sel[i]-lat_c[j])
      if dlat<dlat_min:
        dlat_min=1*dlat
        row_min=j      
    r_sel.append(row_min)
  k_sel=[]
  for i in range(len(lon_bas_sel)):
    dlon_min=1000.
    kol_min=0
    for j in range(len(lon_c)):
      dlon=abs(lon_bas_sel[i]-lon_c[j])
      if dlon<dlon_min:
        dlon_min=1*dlon
        kol_min=j      
    k_sel.append(kol_min)
  row_bas_sel[rgn]=np.asarray(r_sel) 
  kol_bas_sel[rgn]=np.asarray(k_sel)
#############################################################################
#derive hillslope and floodplain fractions, and gridcell area
#############################################################################
areanc=Dataset('%s/Global_land_grid_area_5m_grid.nc' % (fname),'r') #global 5arcmin area
AREA_h=areanc.variables['area'][rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1]*1000000. #km2 to m2
AREA_h[AREA_h<=0.]=np.nan
Ahs_nc=Dataset('%s/hill-slope_valley-bottom_Rhine_5m_new.nc' % (fname),'r')
Ahs=Ahs_nc.variables['Band1'][:] #fraction of gridcell belonging to hillslope
Afl_nc=Dataset('%s/Rhine_Floodplain_vs_Hillslope_5m.nc' % (fname),'r')
lowland=Afl_nc.variables['Band1'][:] #fraction of gridcell belonging to lowland
lowland[lowland!=2.]=0.
Ahs[lowland>0.]=0.
AREA_HS_old=Ahs*AREA_h
AREA_FL_old=(1-Ahs)*AREA_h
Ahs_nc.close();Afl_nc.close();areanc.close()

Anc=Dataset('%s/FL_contr_area2_grid.nc' % (fname),'r') #floodplain upstream contributing area
Acontr=Anc.variables['A'][:]*1E-6 #m2 to km2
Acontr[mask!=1]=np.nan
Anc.close()
Lnc=Dataset('%s/Rhine_streamL_final.nc' % (fname),'r') #stream length
stream_L=Lnc.variables['Band1'][:]*1000. #km to m
stream_L[mask!=1]=np.nan
Lnc.close()
stream_w=60.8*Acontr**0.3 #m
AREA_FL_new=stream_L*stream_w #new floodplain area estimation in m2
Afl=np.ravel(1-Ahs)
Afl_new=np.zeros((7030,))
for i in range(7030):
  if Afl[i]<0.1:
    Afl_new[i]=np.ravel(AREA_FL_new)[i]/np.ravel(AREA_h)[i]
  else:
    Afl_new[i]=1.*Afl[i]
AREA_FL=Afl_new.reshape(74,95)*AREA_h #final floodplain fraction for the Rhine
AREA_HS=(1-Afl_new.reshape(74,95))*AREA_h #final hillslope fraction for the Rhine
###########################################################################
#Calculate boundery cells for every subbasin of the Rhine
###########################################################################  
rows_out=[]
kols_out=[]
for j in range(len(rows_h)):
  for i in range(len(kols_h)):
    rows_out.append(j)
    kols_out.append(i)
rows_out=np.asarray(rows_out)
kols_out=np.asarray(kols_out)
border=[]
for j in range(1,8):
  for z in range(len(rows_h)*len(kols_h)):
    if str_bas[rows_out[z],kols_out[z]]==j:
      if rows_out[z]>0 and rows_out[z]<(len(rows_h)-1):
        yr=(0,-1,1)
      elif rows_out[z]==(len(rows_h)-1):
        yr=(0,-1)
      else:
        yr=(0,1)
      if kols_out[z]>0 and kols_out[z]<(len(kols_h)-1):
        xr=(0,-1,1)
      elif kols_out[z]==(len(kols_h)-1):
        xr=(0,-1)
      else:
        xr=(0,1)
      for k in xr:
        for l in yr:
          if str_bas[rows_out[z]+l,kols_out[z]+k]!=j and str_bas[rows_out[z]+l,kols_out[z]+k]>0 : #all bordering gridcells
            border.append(z)
border=np.asarray(border)
str_bas=np.ravel(str_bas)
str_bas_sel=1*str_bas
for i in border:
  str_bas_sel[i]=8
str_bas_sel=str_bas_sel.reshape(len(rows_h),len(kols_h)) # bordercells have id=8, other cells have normal basin id

###########################################################################
# Calculae sediment residence time (tau)
###########################################################################
FLnc= Dataset('%s/Rhine_flowacc_aggregated_5m_new.nc' % (fname),'r') #5arcmin flowaccumulation of the Rhine
flowacc= FLnc.variables['flowacc'][:]
flowacc_tot=1*flowacc
flowacc=np.ravel(flowacc)
flowacc=flowacc.astype(float)
flowacc[flowacc<0.]=np.nan
#flowaccmax=290724. whole Rhine
tau =[]
for i in range(len(flowacc)):
  tau.append(np.exp((flowacc[i]+922442.535249)/165886.773683)*(np.ravel(AREA_FL)[i]/np.nanmax(AREA_FL)))  
  #tau increases with basin area
tau_in = np.asarray(tau)
tau_in[tau_in<1.]=1.
tau_in[np.isnan(tau_in)==True] = 1.

###########################################################################
#Calculate neighboring gridcells for every boundary cell (number_out)
#and the amount of flow that boundary cells exchange (weight_out)
###########################################################################
flowacc[np.isnan(flowacc)==True]=1e+33
DEM_in = []
for i in range(len(flowacc)):
  if flowacc[i] > 0. and flowacc[i] < 1e+30:
    DEM_in.append(1./flowacc[i])
  else:
    DEM_in.append(np.nan)
DEM_in = np.asarray(DEM_in)

bound_in=1* str_bas_sel
bound_in=np.ravel(bound_in)
number_in1=np.zeros((len(rows_h)*len(kols_h)*7),dtype=np.int)
weight_in1=np.zeros((len(rows_h)*len(kols_h)*7),dtype=np.float64)
DEM_in=np.ravel(DEM_in)

x=mod_append.append.resize_array(len(rows_h),len(kols_h))[0] #kols
y=mod_append.append.resize_array(len(rows_h),len(kols_h))[1] #rows
n=len(rows_h)*len(kols_h)
fl=flowacc
x_sorted=mod_sorting.sorting.sort(fl,x,n)[1] #sorted kols according to fl
fl=flowacc
y_sorted=mod_sorting.sorting.sort(fl,y,n)[1] #sorted rows according to fl
x=x_sorted
y=y_sorted

number_out,weight_out=routing_main_basin.multi_flow.main(DEM_in,bound_in,number_in1,\
                                                         weight_in1,len(rows_h),len(kols_h),x,y)
number_out=np.ravel(number_out,order='F')
weight_out=np.ravel(weight_out,order='F')
number_out=np.reshape(number_out,(len(rows_h),len(kols_h),7),order='C')
weight_out=np.reshape(weight_out,(len(rows_h),len(kols_h),7),order='C')

###########################################################################
# Subbasin settings for parallel processing
##########################################################################
#read domain subcatchment (id_sub, row_sel & kol_sel)
rows_out=[j for j in range(len(rows_h)) for i in range(len(kols_h))]
kols_out=[i for j in range(len(rows_h)) for i in range(len(kols_h))]
rows_out=np.asarray(rows_out)
kols_out=np.asarray(kols_out)
id_sub={};x_new={};y_new={}
for rgn in range(regions):                    
  x_sel=[kols_out[i] for i in range(7030) if str_bas[i]==region_start+rgn]
  y_sel=[rows_out[i] for i in range(7030) if str_bas[i]==region_start+rgn]
  b=[i for i in range(7030) if str_bas[i]==region_start+rgn]
  x_sel=np.asarray(x_sel)
  y_sel=np.asarray(y_sel)
  id_sub[rgn]=np.asarray(b)
  x_new[rgn]=[x_sorted[i] for i in range(len(x_sorted)) for j in range(len(x_sel)) \
      if x_sorted[i]==x_sel[j] and y_sorted[i]==y_sel[j]]
  y_new[rgn]=[y_sorted[i] for i in range(len(x_sorted)) for j in range(len(x_sel)) \
      if x_sorted[i]==x_sel[j] and y_sorted[i]==y_sel[j]]
  x_new[rgn]=np.asarray(x_new[rgn])+1
  y_new[rgn]=np.asarray(y_new[rgn])+1
  	
  dataout['Ma%1i' % (region_start+rgn)]=np.zeros((20,13,len(id_sub[rgn])))
  dataout['Ms%1i' % (region_start+rgn)]=np.zeros((20,13,len(id_sub[rgn])))
  dataout['Mp%1i' % (region_start+rgn)]=np.zeros((20,13,len(id_sub[rgn])))
  dataout['Ha%1i' % (region_start+rgn)]=np.zeros((20,13,len(id_sub[rgn])))
  dataout['Hs%1i' % (region_start+rgn)]=np.zeros((20,13,len(id_sub[rgn])))
  dataout['Hp%1i' % (region_start+rgn)]=np.zeros((20,13,len(id_sub[rgn])))
  
############################################
# Calculate and read litter input and turnover times
############################################
littera_z,litters_z,kresp_soila,kresp_soils,kresp_soilp,\
  ksoila_s,ksoila_p,ksoils_a,ksoils_p,ksoilp_a,mmod_old=eq(OptPath,)

############################################
# Calculate erosion depth for equilibrium simulation
############################################
if set_eros=='y': #simulation S1 or S2
  # bulkdensity 
  Bnc=opennc('%s/BD5min.nc' %(BDPath),'r')
  BD=Bnc.variables['BD'][0:3,rows_h[0]:rows_h[-1]+1,kols_h[0]:kols_h[-1]+1]*0.01 # (depth,lat,lon), units: g/cm3
  BD=BD.astype(float)
  BD[BD<0.]=np.nan
  BD_top=np.nanmean(BD,axis=0) #average BD for topsoil (first 30cm), (lat,lon)    
  Bnc.close()

  #slope and floodplain deposition factor 
  Snc = Dataset('%s/Rhine_slope_scaled_rad_5m_new.nc' % (fname),'r')
  slope= Snc.variables['slope'][:] #units: radialen
  slope=np.array(slope)
  slope=np.tan(slope) # percent slope
  slope[np.isnan(slope)==True]=0.001
  slope[slope<=0.001] = 0.001
  f=D_pft(slope,rows_h,kols_h) #floodplain deposition factor
  Snc.close()

  #initial soil erosion & deposition rates
  Enc=Dataset('%sE_pft_eq_Rhine.nc' %(EPath0),'r') 
  E=Enc.variables['E'][:] # soil erosion rate in t/m2/y #(pft,rows,kols)
  E=np.array(E)
  E_tot=np.nansum((E[1::]*veget_h.reshape(13,74,95)[1::]),axis=0)
  E_tot=np.ravel(E_tot)
  E=E.reshape(13,7030)
  for i in range(7030):
    if E_tot[i]>0.002: #erosion <=20t/ha/year
      for pft in range(1,13):
        E[pft,i]=(E[pft,i]*0.002)/E_tot[i]
  E=E.reshape(13,74,95)
  kEE=(E)/(BD_top*dz0) #gross soil erosion depth
  if set_depo=='y':
    kE=f*((E)/(BD_top*dz0)) # net soil erosion depth; g/m2/year to m soil per year to dimensionless
  else:
    kE=1.*kEE
  kE[np.isnan(kE)==True]=0.
  kEE[np.isnan(kEE)==True]=0.
  kE=kE.reshape(13,7030)
  kEE=kEE.reshape(13,7030)
  kEE[0]=0.;kEE=kEE/365. #do not include erosion from bare soil; daily rate
  kE[0]=0.;kE=kE/365. #do not include erosion from bare soil; daily rate
  Enc.close()
else: #simulation S0
  kE=np.zeros((13,7030)); kEE=np.zeros((13,7030))

############################################
# Initialize output txt files and derive turnover rates for each subbasin at 5arcmin
############################################
kresp_soila_FL={};kresp_soils_FL={};kresp_soilp_FL={}
kresp_soila_HS={};kresp_soils_HS={};kresp_soilp_HS={}
ksoila_s_h={};ksoila_p_h={};ksoils_a_h={};ksoils_p_h={}
ksoilp_a_h={};littera_zh={};litters_zh={};kE_sel={};kEE_sel={}
for rgn in range(regions): 
  logfile_SOC['file%1i' % (region_start+rgn)]= \
  open('%s/output_eq_%1i.txt' % (OptPath,region_start+rgn),'w',1)
  check.display('year,'+'L_HS,'+'L_FL,'+'C_HS,'+'C_FL,'+'E_HS,'+'D_FL,'+'R_HS,'+'R_FL,'+'\neq,'+\
                str(0)+','+str(0)+','+str(0)+','+str(0)+','+str(0)+','+str(0)+','+str(0)+','+str(0)\
                ,logfile_SOC['file%1i' % (region_start+rgn)])
  if set_depo=='y':
    logfile_out['file%1i' % (region_start+rgn)]= \
    open('%s/exchange_eq_%1i.txt' % (OptPath,region_start+rgn),'w',1)
    check.display('year,'+'tot_out,'+'tot_in,'+'\neq,'+str(0)+','+str(0),\
                  logfile_out['file%1i' % (region_start+rgn)])
  
  mmod_FL=mmod_HS=1.
  kresp_soila_FL[rgn]=kresp_soila[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*mmod_FL*1/365.
  kresp_soils_FL[rgn]=kresp_soils[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*mmod_FL*1/365.
  kresp_soilp_FL[rgn]=kresp_soilp[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*mmod_FL*1/365.
  kresp_soila_HS[rgn]=kresp_soila[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*mmod_HS*1/365.
  kresp_soils_HS[rgn]=kresp_soils[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*mmod_HS*1/365.
  kresp_soilp_HS[rgn]=kresp_soilp[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*mmod_HS*1/365.
  ksoila_s_h[rgn]=ksoila_s[:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.
  ksoila_p_h[rgn]=ksoila_p[:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.
  ksoils_a_h[rgn]=ksoils_a[:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.
  ksoils_p_h[rgn]=ksoils_p[:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.
  ksoilp_a_h[rgn]=ksoilp_a[:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.
  littera_zh[rgn]=littera_z[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.
  litters_zh[rgn]=litters_z[:,:,row_bas_sel[rgn][:],kol_bas_sel[rgn][:]]*1/365.  
  kE_sel[rgn]=np.transpose([kE[:,i] for i in id_sub[rgn]])
  kEE_sel[rgn]=np.transpose([kEE[:,i] for i in id_sub[rgn]])  

############################################
# Start simulation
############################################
start=datetime.datetime.now()
if __name__=='__main__': 
  for year_start in range(2000): 
    print('year_start = ',year_start)
    process=[]
    queue=Queue()
    for rgn in range(regions):
      p=Process(target=SOC_eq,args=(region_start+rgn,year_start,set_depo,rows_h,kols_h,x_new[rgn],y_new[rgn],id_sub[rgn],DEM_in,\
                                    kresp_soila_FL[rgn],kresp_soils_FL[rgn],kresp_soilp_FL[rgn],kresp_soila_HS[rgn],\
                                    kresp_soils_HS[rgn],kresp_soilp_HS[rgn],ksoila_s_h[rgn],ksoila_p_h[rgn],ksoils_a_h[rgn],\
                                    ksoils_p_h[rgn],ksoilp_a_h[rgn],kE_sel[rgn],kEE_sel[rgn],littera_zh[rgn],litters_zh[rgn],\
                                    dataout['Ma%1i' % (region_start+rgn)],dataout['Ms%1i' % (region_start+rgn)],\
                                    dataout['Mp%1i' % (region_start+rgn)],dataout['Ha%1i' % (region_start+rgn)],\
                                    dataout['Hs%1i' % (region_start+rgn)],dataout['Hp%1i' % (region_start+rgn)],\
                                    tau_in,bound_in,weight_out,number_out,OptPath,logfile_SOC['file%1i' % (region_start+rgn)],queue)) 
      process.append(p)

    for p in process:
      p.start() 
    for p in process:
      data=queue.get()
      dataout['Ha%1i' %(data['idx'])]=data['Ha']
      dataout['Hs%1i' %(data['idx'])]=data['Hs']
      dataout['Hp%1i' %(data['idx'])]=data['Hp']
      dataout['Ma%1i' %(data['idx'])]=data['Ma']
      dataout['Ms%1i' %(data['idx'])]=data['Ms']
      dataout['Mp%1i' %(data['idx'])]=data['Mp']
      dataout['fluxa%1i' %(data['idx'])]=data['fluxa']
      dataout['fluxs%1i' %(data['idx'])]=data['fluxs']
      dataout['fluxp%1i' %(data['idx'])]=data['fluxp']
      dataout['ka_flux%1i' %(data['idx'])]=data['ka_flux']
      dataout['ks_flux%1i' %(data['idx'])]=data['ks_flux']
      dataout['kp_flux%1i' %(data['idx'])]=data['kp_flux']

    if set_depo=='y':

      fluxa_tot=dataout['fluxa%1i' % (1)]+dataout['fluxa%1i' % (2)] \
                 + dataout['fluxa%1i' % (3)]+dataout['fluxa%1i' % (4)] \
                 + dataout['fluxa%1i' % (5)]+dataout['fluxa%1i' % (6)] \
                 + dataout['fluxa%1i' % (7)]
      fluxs_tot=dataout['fluxs%1i' % (1)]+dataout['fluxs%1i' % (2)] \
                 + dataout['fluxs%1i' % (3)]+dataout['fluxs%1i' % (4)] \
                 + dataout['fluxs%1i' % (5)]+dataout['fluxs%1i' % (6)] \
                 + dataout['fluxs%1i' % (7)]
      fluxp_tot=dataout['fluxp%1i' % (1)]+dataout['fluxp%1i' % (2)] \
                 + dataout['fluxp%1i' % (3)]+dataout['fluxp%1i' % (4)] \
                 + dataout['fluxp%1i' % (5)]+dataout['fluxp%1i' % (6)] \
                 + dataout['fluxp%1i' % (7)]

      ka_flux=dataout['ka_flux%1i' % (1)]+dataout['ka_flux%1i' % (2)] \
               + dataout['ka_flux%1i' % (3)]+dataout['ka_flux%1i' % (4)] \
               + dataout['ka_flux%1i' % (5)]+dataout['ka_flux%1i' % (6)] \
               + dataout['ka_flux%1i' % (7)]
      ks_flux=dataout['ks_flux%1i' % (1)]+dataout['ks_flux%1i' % (2)] \
               + dataout['ks_flux%1i' % (3)]+dataout['ks_flux%1i' % (4)] \
               + dataout['ks_flux%1i' % (5)]+dataout['ks_flux%1i' % (6)] \
               + dataout['ks_flux%1i' % (7)]
      kp_flux=dataout['kp_flux%1i' % (1)]+dataout['kp_flux%1i' % (2)] \
               + dataout['kp_flux%1i' % (3)]+dataout['kp_flux%1i' % (4)] \
               + dataout['kp_flux%1i' % (5)]+dataout['kp_flux%1i' % (6)] \
               + dataout['kp_flux%1i' % (7)]

      fluxa_tot=np.ravel(fluxa_tot)
      fluxs_tot=np.ravel(fluxs_tot)
      fluxp_tot=np.ravel(fluxp_tot)
      flux_in_tot=fluxa_tot+fluxs_tot+fluxp_tot

      ka_out=np.ravel(ka_flux)
      ks_out=np.ravel(ks_flux)
      kp_out=np.ravel(kp_flux)
      for rgn in range(regions):
        sub=np.array(id_sub[rgn]) 
        ka_sub=ka_out[sub]/(np.ravel(AREA_FL)[sub]*np.nansum(veget_h[1:13,sub],axis=0))/365.
        ks_sub=ks_out[sub]/(np.ravel(AREA_FL)[sub]*np.nansum(veget_h[1:13,sub],axis=0))/365.
        kp_sub=kp_out[sub]/(np.ravel(AREA_FL)[sub]*np.nansum(veget_h[1:13,sub],axis=0))/365.
        ka_sub[np.isnan(ka_sub)==True]=0.
        ks_sub[np.isnan(ks_sub)==True]=0.
        kp_sub[np.isnan(kp_sub)==True]=0.
        fluxa_sub=(fluxa_tot[sub]/(np.ravel(AREA_FL)[sub]*np.nansum(veget_h[1:13,sub],axis=0)))/365.
        fluxs_sub=(fluxs_tot[sub]/(np.ravel(AREA_FL)[sub]*np.nansum(veget_h[1:13,sub],axis=0)))/365.
        fluxp_sub=(fluxp_tot[sub]/(np.ravel(AREA_FL)[sub]*np.nansum(veget_h[1:13,sub],axis=0)))/365.
        fluxa_sub[np.isnan(fluxa_sub)==True]=0.
        fluxs_sub[np.isnan(fluxs_sub)==True]=0.
        fluxp_sub[np.isnan(fluxp_sub)==True]=0.
        soila_FL=1*dataout['Ma%1i' % (region_start+rgn)][:]
        soils_FL=1*dataout['Ms%1i' % (region_start+rgn)][:]
        soilp_FL=1*dataout['Mp%1i' % (region_start+rgn)][:]
        for t in range(365):
          soila_old_FL=1*soila_FL
          soils_old_FL=1*soils_FL  
          soilp_old_FL=1*soilp_FL   
          for z in range(20):  
            if z==0:                   
              soila_FL[z,1:13]+=fluxa_sub-ka_sub*soila_old_FL[z,1:13]
              soils_FL[z,1:13]+=fluxs_sub-ks_sub*soils_old_FL[z,1:13]
              soilp_FL[z,1:13]+=fluxp_sub-kp_sub*soilp_old_FL[z,1:13] 
            elif z==19:
              soila_FL[z,1:13]+=ka_sub*soila_old_FL[z-1,1:13]
              soils_FL[z,1:13]+=ks_sub*soils_old_FL[z-1,1:13]
              soilp_FL[z,1:13]+=kp_sub*soilp_old_FL[z-1,1:13]
            else:  
              soila_FL[z,1:13]+=ka_sub*soila_old_FL[z-1,1:13]-ka_sub*soila_FL[z,1:13]
              soils_FL[z,1:13]+=ks_sub*soils_old_FL[z-1,1:13]-ks_sub*soils_FL[z,1:13]
              soilp_FL[z,1:13]+=kp_sub*soilp_old_FL[z-1,1:13]-kp_sub*soilp_FL[z,1:13]
        dataout['Ma%1i' % (region_start+rgn)][:]=1*soila_FL
        dataout['Ms%1i' % (region_start+rgn)][:]=1*soils_FL
        dataout['Mp%1i' % (region_start+rgn)][:]=1*soilp_FL
        flux_out_tot=dataout['fluxa%1i' % (region_start+rgn)]+dataout['fluxs%1i' % (region_start+rgn)]\
                            + dataout['fluxp%1i' % (region_start+rgn)]

        flux_in_sub=1*flux_in_tot[sub]

        check.display(str(year_start+1)+','+str(np.nansum(flux_out_tot)*1E-12)+\
                      ','+str(np.nansum(flux_in_sub)*1E-12),logfile_out['file%1i' % (region_start+rgn)])

      if year_start>1800:
        resultfile=Dataset('%s/Flux_cc_eq_%i.nc' % (OptPath,year_start),'w')
        resultfile.createDimension('lat',74)
        resultfile.createDimension('lon',95)
        var_flux=resultfile.createVariable('flux','f',('lat','lon'))
        var_flux[:,:]=flux_in_tot.reshape(74,95)[:,:]
        resultfile.close()

    for p in process:
      p.join()

elapsed=(datetime.datetime.now()-start).seconds
print('EQUILIBRIUM is finished and Time cost(seconds): ',elapsed)

