# -*- coding: utf-8 -*-
import numpy as np
from netCDF4 import Dataset
#This script calculates the floodplain deposition fraction of sediment 

def D_pft(slope,rows_h,kols_h):
  f=np.zeros((13,len(rows_h),len(kols_h)))
  for pft in range(0,13):
    if pft<=10 and pft > 0:
      f[pft]=0.5*np.exp(0.47*(slope/0.88)) #0.5<f<0.8; f increases when slope increases
    elif pft>10:
      f[pft]=0.2*np.exp(0.917*(slope/0.88)) #0.2<f<0.5; f increases when slope increases
    else:
      f[pft]=0.9
  return f
