#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Tue 23 May 12:08:55 2018

@author: davevanwees

"""

import numpy as np
import matplotlib.pyplot as plt
from matplotlib import gridspec
from matplotlib import rcParams
from mpl_toolkits.basemap import Basemap
from matplotlib.widgets import MultiCursor
from matplotlib.colors import BoundaryNorm
from matplotlib.colors import LinearSegmentedColormap
from matplotlib.colors import ListedColormap
import matplotlib.patches as patches
import gdal
import netCDF4 as netcdf
import sys
import os
import glob
import time as timer
import h5py
import gdal, gdalconst
import copy
import scipy.ndimage
import scipy.stats
import pandas as pd
from scipy import io
from scipy import LowLevelCallable
from numba import cfunc, carray
from numba.types import intc, intp, float64, voidptr
from numba.types import CPointer
from collections import OrderedDict
from functools import partial
from pyhdf.SD import SD, SDC
from cdo import *;  cdo = Cdo()
del CDF_MOD_NETCDF4, CDF_MOD_SCIPY, CDO_PY_VERSION
plt.rc('image', interpolation='none')       # change default image interpolation
plt.rcParams["font.family"] = "Times New Roman"
plt.rcParams["mathtext.fontset"] = "stix"   # works well with Times new roman, for subscripts, superscripts, etc.
gdal.UseExceptions()

wdir =     '/Volumes/Mac_HD/Work/Vici_project/Koolstof_model/'            # Model directory
wdir_geo = '/Volumes/Mac_HD/Work/Data/MODIS_old/MODIS_geolocation_500m/'       # geolocation file directory
ddir =     '/Volumes/Mac_HD/Work/Data/MODIS_old/'                              # data directory

# via external hard-drive:
wdir_geo = '/Volumes/LaCie/Data_backup/MODIS_old/MODIS_geolocation_500m/'
ddir =     '/Volumes/LaCie/Data_backup/MODIS_old/'

rdir = wdir + 'results/paper_results/'                          # general results directory (not run-specific)

sys.path.append(wdir)
try:
    print 'Reloading class'
    reload(sys.modules['carbonmodel_class3'])
    from carbonmodel_class3 import Model
except:
    print 'Importing class'
    from carbonmodel_class3 import Model    



years = list(np.arange(2002, 2017+1).astype(str))       # mode 2 years, 2002 until 2017.
tiles = sorted(set(Model.regions['NHAF'][1] + Model.regions['SHAF'][1]))
sdate = '30-07'
sdateT2 = '17-06_2'



def plot_spin_curve(fign, filename=None):
    
    textsize = 18
    tickredux = 0.8
    
    sdir =  wdir + 'results/FL_500m_Africa_'+sdate+'/'
    n = Model(sdir, mode=1, resolution=500, tile='h20v08', act='passive')
    n.load()
    
    fig = plt.figure(1, (6, 4))
    ax = fig.add_subplot(111)
    
    data = n.diagm_pool['stem'] / 1000.0
    
    ax.plot(n.times, data)
    ax.scatter([2, 125], [175/1000.0, 6640/1000.0], s=100)
    ax.plot(n.times, np.repeat(7.3, len(n.times)), linestyle='--', c='black', alpha=0.5)
    
    fit500 = np.polyfit(n.times[0:4*12], data[0:4*12], 1);
    fit_fn500 = np.poly1d(fit500)
    ax.plot(n.times[:35*12], fit_fn500(n.times[:35*12]), color='black', alpha=0.9, zorder=1)
    
    fit025 = np.polyfit(n.times[123*12:127*12], data[123*12:127*12], 1);
    fit_fn025 = np.poly1d(fit025)
    ax.plot(n.times[75*12:175*12], fit_fn025(n.times[75*12:175*12]), color='black', alpha=0.9, zorder=1)
    
    ax.text(10, 250/1000.0, '500-meter; %0.0f g C $\mathregular{yr^{-1}}$' % (fit500[0]*1000), fontsize=textsize*0.9)
    ax.text(125, 6000/1000.0, r'$0.25\degree$; %0.0f g C $\mathregular{yr^{-1}}$' % (fit025[0]*1000), fontsize=textsize*0.9)
    
    ax.set_xlabel('Year', fontsize=textsize)
    ax.set_ylabel('Stem biomass (kg C $\mathregular{m^{-2}}$)', fontsize=textsize)
    ax.xaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    #ax.set_yticklabels(['{:,}'.format(int(x)).replace(',',' ') for x in ax.get_yticks().tolist()])
    
    ax.grid(linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    ax.set_xlim([0, 200])
    ax.set_ylim([0, 8000/1000.0])
    
    plt.tight_layout()
    
    if filename != None:
        fig.savefig(filename, dpi=300)
    else:
        plt.show()
#plot_spin_curve(1, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure12_TNR')


def save_500m_image(sdirn):
    # Save 500m image as png.
    
    def readfunc_LC(tilen):
        return Model.readdata_MODIS('LC2', 500, years[len(years)/2], tilen)[0]
    
    def readfunc_Hansen(tilen):
        X = Model.readdata_Hansen(500, '2017', tilen)[0]
        X[X==-1] = np.nan
        return X
    
    def readfunc_var(tilen):
        sdir = wdir + 'results/' + sdirn
        X = Model.load_2dvar(sdir, 500, tilen, 'DB', 'sum')
        X[X>300] = 300
        return X
    
    # regions = ['SHAF', 'NHAF', 'MIDE']
    # full = Model.region_paste(readfunc_var, regions)
    # filename = 'pic500_DB_500m_NHAF_SHAF_MIDE_regions'
    # plt.imsave(rdir + filename+'.png', full)
    
    tiles = sorted(set(Model.regions['NHAF'][1] + Model.regions['SHAF'][1])) # + Model.regions['MIDE'][1]))
    #tiles = Model.regions['EQAS'][1]
    full = Model.tile_paste(readfunc_LC, tiles)
    #full[full>0.5]=0.5
    #full = full/0.5
    
    #filename = 'pic500_DB_500m_NHAF_SHAF' #_zoom'
    filename = 'pic500_LC_500m_NHAF_SHAF'
    plt.imsave(rdir + filename+'.png', full) #[7700:9800, 9000:11000])
#save_500m_image('FL_500m_Africa_'+sdate+'/')
#save_500m_image('_')
print 'debug'

# tilen = 'h19v06'
# sdir = wdir + 'results/FL_500m_Africa_21-10/'
# n = Model(sdir, mode=2, resolution=500, tile=tilen, act='passive')
# n.load(full='all')
# n.save_hdf(sdir + 'data/', 'mode2_16yr_500m_fmode-on_'+tilen+'_test', diag_dict=n.diag_dict, diagf=n.diagf)


#region /// Biome area
''' Biome percentages, determine relevant biomes '''

def biome_areas(res, biomes):
    
    if res == 500:
        def readfunc(tilen):
            return np.ones((2400,2400))
        LC_area = Model.biome_calctile(readfunc, biomes, res, years[len(years) / 2], tiles)[0]
        
    else:
        arrsize = Model.load_degbox(res, 'Africa')[1].values()
        LC_area = Model.biome_calc(np.ones(arrsize), biomes, res, years[len(years) / 2], 'Africa')[0]
    
    total = np.sum(np.array(LC_area.values()))
    LC_perc = OrderedDict([(biome, LC_area[biome] / total * 100) for biome in biomes])    # calculate percentage.
    
    return LC_biome, LC_perc
LC025_area, LC025_perc = Model.saver(lambda: biome_areas(0.25, Model.biomes_UMD.keys()[1:-1]), rdir+'LC025_area.npy')
LC500_area, LC500_perc = Model.saver(lambda: biome_areas(500, Model.biomes_UMD.keys()[1:-1]), rdir+'LC500_area.npy')

def remove_minor_biomes(LC_area, LC_perc):
    minor_biomes = []
    for biome in LC_area.keys():    # arctic, non-vegetated biomes, and remove deciduous broadleaf.
        if (biome in ['1','3','12','13','14','15']): #or (LC_perc[biome] < 0.1):      # and remove vegetated biomes that contribute <0.1%
            minor_biomes.append(biome)
            del LC_area[biome], LC_perc[biome]
            
    total = np.sum(np.array(LC_area.values()))
    LC_perc = OrderedDict([(biome, LC_area[biome] / total * 100) for biome in LC_perc.keys()])  # calculate percentage.

    return LC_area, LC_perc
LC025_area, LC025_perc = remove_minor_biomes(LC025_area, LC025_perc)
LC500_area, LC500_perc = remove_minor_biomes(LC500_area, LC500_perc)

biomes = OrderedDict([(biome, Model.biomes_UMD[biome][0]) for biome in LC500_area.keys()])
biomes['2'] = 'Tropical forest'
biomes['4'] = 'Deciduous forest'
biomes['5'] = 'Mixed forest'
biomes['6'] = 'Closed shrubland'
biomes['7'] = 'Open shrubland'
biomes['8'] = 'Woody savanna'
biomes['9'] = 'Open savanna'
biomes['10'] = 'Grassland'
biomes['11'] = 'Cropland'

def plot_biome_area(fign):
    fig = plt.figure(fign)
    ax = fig.add_subplot(111)
    
    x_ax = np.arange(1, len(biomes) + 1)
    width = 0.35
    ax.bar(x_ax - 0.21, np.array(LC500_area.values()) / 1e12, width)
    ax.bar(x_ax + 0.21, np.array(LC025_area.values()) / 1e12, width)
    ax.set_xticks(x_ax)
    ax.set_xticklabels(biomes.values(), rotation = 25, ha='right', rotation_mode='anchor')
    ax.legend(['500 meter', '0.25 degree'])
    ax.set_ylabel('Area [million km$^{2}$]')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)              # gridlines behind plot objects.
    plt.show()
#plot_biome_area(1)     # can only run before biomes is altered below.

biomes_AGB = OrderedDict([(keyn, biomes[keyn]) for keyn in ['2','5','8','9']])

biomes_field = OrderedDict([(keyn, biomes[keyn]) for keyn in ['7','8','9','10']])
biomes_field['7'] = 'Shrubland'

biomes['4 5'] = 'Mixed forest'     # combine deciduous and mixed forest biomes.
biomes.pop('4')     # remove individual deciduous and mixed forest biomes.
biomes.pop('5')

biomes['6 7'] = 'Shrubland'
biomes.pop('6')
biomes.pop('7')

biomes = OrderedDict((k, biomes[k]) for k in ['2', '4 5', '6 7', '8', '9', '10', '11'])  # change order of dict items.

#endregion \\\


#region /// NPP validation
''' NPP comparison '''

def load_NPPgfed(res):
    # load NPP, available until 2015 (-2 years).
    NPP = np.mean(np.sum(np.reshape(Model.loadGFED(res, 'NPP', years[:-2], 'Africa'), (len(years[:-2]),12,310,310)), axis=1), axis=0)
    lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    return NPP * lwmask * tilemask
NPPgfed = Model.saver(lambda: load_NPPgfed(0.25), rdir + 'NPPgfed025_Africa.npy')

NPP_modis = np.mean(Model.readdata_MODIS('NPP', 0.25, years[:-3], 'Africa'), axis=0)    # available until 2014.


def load_NPP(sdirn, res):
    
    # old code
    # n = Model(sdir, mode=2, resolution=res, tile='h19v10', act='passive')
    # n.load(full=['NPP'], addtxt='times')
    # if NPP.ndim == 2:
    #     NPP = n.diagf['NPP']
    # elif NPP.ndim == 3:
    #     NPP = np.mean(np.sum(np.reshape(n.diagf['NPP'], (n.n_years,12,310,310)), axis=1), axis=0)
    # n.diagf = {}
    # lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    # tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    # return NPP * lwmask * tilemask
    
    sdir = wdir + 'results/' + sdirn
    
    mode = 2
    if res == 500:
        data = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode), sdir + 'translate_025deg_mode%s.npz' % mode)

    if res == 0.25:
        data = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode), sdir + 'load_025deg_mode%s.npz' % mode)

    return data['NPPsum']

NPP = load_NPP('FL_025deg_Africa_'+sdate+'/', 0.25)
#NPP500 = load_NPP('FL_500m_Africa_'+sdate+'/', 500)

abs = NPP - NPPgfed
rel = (NPP - NPPgfed) / NPPgfed

NPPgfed_biome = Model.biome_calc(NPPgfed, biomes.keys(), 0.25, '2005', 'Africa')
NPP_biome = Model.biome_calc(NPP, biomes.keys(), 0.25, '2005', 'Africa', Xref=NPPgfed)

def plot_NPP_bp(fign):
    fig = plt.figure(fign, (8,10))
    ax = fig.add_subplot(311)

    # x_ax = np.arange(1, len(biomes) + 1)
    # width = 0.35
    # ax.bar(x_ax - 0.21, AGB_biome[2].values(), width)
    # ax.bar(x_ax + 0.21, WUR_biome[2].values(), width)

    n_plots = 2
    width = 1
    spacing = n_plots + 1
    xlen = len(biomes)
    x_ax = np.arange(1, xlen * spacing, spacing)

    b1 = ax.bar(x_ax, NPPgfed_biome[1].values(), width)
    b2 = ax.bar(x_ax + 1.2, NPP_biome[1].values(), width)

    bp1 = ax.boxplot(NPPgfed_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(NPP_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(biomes.values(), rotation=45)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.legend([b1, b2], ['GFED4s', 'model'])
    ax.set_ylabel('NPP (gC m$^{-2}$ yr$^{-1}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)              # gridlines behind plot objects.
    
    ax = fig.add_subplot(212)
    da = ax.imshow(rel, vmin=-1, vmax=1, cmap='RdBu_r')
    cb = plt.colorbar(da)
    cb.set_label('NPP (gC m$^{-2}$ yr$^{-1}$)', rotation=270)
    ax.set_title('Relative difference, model - GFED4s')
    plt.show()
#plot_NPP_bp(2)
#endregion \\\


#region /// Biomass validation
''' WUR biomass comparison '''
# Avitable 2016: "Therefore the complete fused map cannot be attributed to a specific year /
#  and more generally it represents the first decade of the 2000s."

def load_WUR(res):
    WUR = Model.readdata_WURbiomass(res, 'Africa') 
    lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    return WUR * lwmask * tilemask
WUR = Model.saver(lambda: load_WUR(0.25), rdir+'WUR025_Africa.npy')

def load_Bouvet(res):
    BOU = Model.readdata_BouvetAGB(res, 'Africa')
    lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    return BOU * lwmask * tilemask
BOU = Model.saver(lambda: load_Bouvet(0.25), rdir+'Bouvet025_Africa.npy')

def load_AGB(sdirn, res, biome=None):
    
    # # old code
    # n = Model(sdir, mode=2, resolution=res, tile='Africa', act='passive')
    # #n.n_years = 200
    # n.load(full=['stem', 'leaf'])
    # AGB = np.mean(n.diagf['stem'] + n.diagf['leaf'], axis=0)
    # n.diagf = {}
    # lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    # tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    # return AGB * lwmask * tilemask
    
    sdir = wdir + 'results/' + sdirn
    
    mode = 2
    if biome == None:
        if res == 500:
            data = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode), sdir + 'translate_025deg_mode%s.npz' % mode)
    
        if res == 0.25:
            data = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode), sdir + 'load_025deg_mode%s.npz' % mode)
        
    if biome == 'yes':
        data = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='biome'), sdir + 'load_025deg_mode%s_biome.npz' % mode)

    return data['AGBw']
    
AGB = load_AGB('FL_025deg_Africa_'+sdate+'/', 0.25)
AGB500 = load_AGB('FL_500m_Africa_'+sdate+'/', 500)

#AGB_pb = load_AGB('FL_025deg_Africa_'+sdate+'/', 0.25, biome='yes')

def effective_turn():
    
    sdir = wdir + 'results/' + 'FL_025deg_Africa_' + sdate + '/'
    stem = Model.load_2dvar(sdir, 0.25, 'Africa', 'stem', 'avg', mode=2, fmode='off')
    leaf = Model.load_2dvar(sdir, 0.25, 'Africa', 'leaf', 'avg', mode=2, fmode='off')
    gras = Model.load_2dvar(sdir, 0.25, 'Africa', 'gras', 'avg', mode=2, fmode='off')
    FTC = Model.load_2dvar(sdir, 0.25, 'Africa', 'FTC', 'avg', mode=2)
    NTV = Model.load_2dvar(sdir, 0.25, 'Africa', 'NTV', 'avg', mode=2)
    FTC_NTVr = (FTC / (FTC + NTV))
    
    # Poorter et al. 2012
    # [leaf, stem, root]
    alloc = OrderedDict([
        ('1', [0.04, 0.75, 0.21]),  # boreal forest
        ('2', [0.02, 0.82, 0.16]),  # tropical forest
        ('3', [0.04, 0.75, 0.21]),  # boreal forest
        ('4', [0.03, 0.76, 0.21]),  # temperate forest
        ('5', [0.03, 0.76, 0.21]),  # temperate forest
        ('6', [0.09, 0.49, 0.47]),  # shrubland
        ('7', [0.09, 0.49, 0.47]),  # shrubland
        ('8', [0.06, 0.57, 0.36]),  # woodland
        ('9', [0.17, 0.27, 0.77]),  # grassland
        ('10', [0.17, 0.27, 0.77]),  # grassland
        ('11', [0.1, 0.5, 0.4]),  # self defined
        ('12', [0.1, 0.5, 0.4]),  # self defined
        ('13', [0.09, 0.28, 0.56]),  # desert
        ('14', [0.04, 0.75, 0.21]),  # boreal forest
        ('15', [0.09, 0.37, 0.69]),  # tundra
    ])
    for key in alloc.keys():
        alloc[key] = alloc[key] / np.sum(alloc[key])  # normalize fractions.
    
    #BOU[AGB < 100] = np.nan
    #WUR[AGB < 100] = np.nan
    #AGB[AGB < 100] = np.nan
    
    AGB_turn = AGB / ((1/3.0) * NPP * FTC_NTVr * 0.8)      # only consider stem NPP, which is approx. AGBw.
    WUR_turn = WUR / ((1/3.0) * NPP * FTC_NTVr * 0.8)
    BOU_turn = BOU / ((1/3.0) * NPP * FTC_NTVr * 0.8)
    #AGB_turn[AGB_turn>100] = np.nan
    #WUR_turn[WUR_turn>200] = np.nan      # remove blown up pixels.
    #BOU_turn[BOU_turn>1000] = np.nan
    stem_turn = stem / ((1/3.0) * NPP * FTC_NTVr * 0.8)
    leaf_turn = leaf / ((1/3.0) * NPP * FTC_NTVr)
    gras_turn = gras / ((1/2.0) * NPP * (1-FTC_NTVr))
    
    AGB_turn_biome = np.array(Model.biome_calc(AGB_turn, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    WUR_turn_biome = np.array(Model.biome_calc(WUR_turn, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    BOU_turn_biome = np.array(Model.biome_calc(BOU_turn, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    stem_turn_biome = np.array(Model.biome_calc(stem_turn, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    leaf_turn_biome = np.array(Model.biome_calc(leaf_turn, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    gras_turn_biome = np.array(Model.biome_calc(gras_turn, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    
    AGB_biome = np.array(Model.biome_calc(AGB, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    WUR_biome = np.array(Model.biome_calc(WUR, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    BOU_biome = np.array(Model.biome_calc(BOU, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    stem_biome = np.array(Model.biome_calc(stem, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    leaf_biome = np.array(Model.biome_calc(leaf, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    gras_biome = np.array(Model.biome_calc(gras, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    
    NPP_biome = np.array(Model.biome_calc(NPP, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    FTC_NTVr_biome = np.array(Model.biome_calc(FTC_NTVr, ['total'] + biomes.keys(), 0.25, '2009', 'Africa')[1].values())
    
    AGB_turn2_biome = AGB_biome / ((1/3.0) * NPP_biome * FTC_NTVr_biome * 0.8)
    WUR_turn2_biome = WUR_biome / ((1/3.0) * NPP_biome * FTC_NTVr_biome * 0.8)
    BOU_turn2_biome = BOU_biome / ((1/3.0) * NPP_biome * FTC_NTVr_biome * 0.8)
    stem_turn2_biome = stem_biome / ((1/3.0) * NPP_biome * FTC_NTVr_biome * 0.8)
    leaf_turn2_biome = leaf_biome / ((1/3.0) * NPP_biome * FTC_NTVr_biome * 0.8)
    gras_turn2_biome = gras_biome / ((1/3.0) * NPP_biome * FTC_NTVr_biome * 0.8)
    
    fig = plt.figure(1, (8, 10))
    ax = fig.add_subplot(111)
    
    width = 1
    spacing = 4
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    b1 = ax.bar(x_ax, stem_turn_biome, width)
    b2 = ax.bar(x_ax + 1.2, leaf_turn_biome, width)
    b3 = ax.bar(x_ax + 2.4, gras_turn_biome, width)
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=-20)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.legend([b1, b2, b3], ['Model', 'Avitabile et al. (2016)', 'Bouvet et al. (2018)'])
    ax.set_ylabel('Effective stem turnover time [yr]')
    
    #for i, barn in enumerate(x_ax):
    #    ax.text(barn, 1, '%2.2f' % (np.array(turn_est2_biome.values())[i] / np.array(turn_est1_biome.values())[i]))
    
    plt.ylim([0, 10])
    
    plt.show()
    print 'debug'
    
#effective_turn()

print 'debug'

REF = WUR.copy()

abs = AGB - REF
rel = (AGB - REF) / REF
rel = Model.perc_cut(rel, 5)[0]

abs2 = AGB - BOU
rel2 = (AGB - BOU) / BOU

# abs500 = AGB500 - REF
# rel500 = (AGB500 - REF) / REF
# rel500 = Model.perc_cut(rel500, 5)[0]

REF_biome = Model.biome_calc(REF, ['total'] + biomes_AGB.keys(), 0.25, '2005', 'Africa')
AGB_biome = Model.biome_calc(AGB, ['total'] + biomes_AGB.keys(), 0.25, '2005', 'Africa', Xref=REF)
AGB500_biome = Model.biome_calc(AGB500, ['total'] + biomes_AGB.keys(), 0.25, '2005', 'Africa', Xref=REF)

AGB_T2 = load_AGB('FL_025deg_Africa_'+sdateT2+'/', 0.25)
AGB500_T2 = load_AGB('FL_500m_Africa_'+sdateT2+'/', 500)
AGB_biome_T2 = Model.biome_calc(AGB_T2, ['total'] + biomes_AGB.keys(), 0.25, '2005', 'Africa', Xref=REF)
AGB500_biome_T2 = Model.biome_calc(AGB500_T2, ['total'] + biomes_AGB.keys(), 0.25, '2005', 'Africa', Xref=REF)

def plot_AGB_bp(fign):
    ''' PAPER FIGURE '''
    textsize = 12
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    fig = plt.figure(fign, (8,10))
    ax = fig.add_subplot(211)
    
    width = 1
    spacing = 4
    xlen = len(biomes_AGB)+1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    b1 = ax.bar(x_ax, np.array(REF_biome[0].values()) / 1e15, width, color='C2')
    b2 = ax.bar(x_ax + 1.2, np.array(AGB500_biome[0].values()) / 1e15, width, color='C0')
    b3 = ax.bar(x_ax + 2.4, np.array(AGB_biome[0].values()) / 1e15, width, color='C1')
    
    #rect = patches.Rectangle((0.2, -1), (spacing-2)*1.2+1.6, 45, linewidth=1, edgecolor='black', facecolor='none', clip_on=False)
    #ax.add_patch(rect)
    
    ax.set_xticks(x_ax + ((spacing-2) * 1.2)/2.0)
    ax.set_xticklabels(['Africa'] + biomes_AGB.values(), rotation=-20, fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    #ax.legend([b1, b3], ['Avitabile et al. (2016)', 'Model'], fontsize=textsize)
    ax.legend([b1, b2, b3], ['Avitabile et al. (2016)', 'Model 500m', u'Model 0.25\u00b0'])
    ax.set_ylabel('Woody AGB (PgC)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    
    ax = fig.add_subplot(212)
    
    bp1 = ax.boxplot(REF_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(AGB500_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp3 = ax.boxplot(AGB_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 2.4, meanprops={'marker': '.'}, whis=[5, 95], widths=width)

    #for bp, color in zip([bp1, bp3], ['C2', 'C0']):
    for bp, color in zip([bp1, bp2, bp3], ['C2', 'C0', 'C1']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
        
    #rect = patches.Rectangle((0.2, -10), (spacing-2)*1.2+1.6, 30000, linewidth=1, edgecolor='black', facecolor='none', clip_on=False)
    #ax.add_patch(rect)
    
    ax.set_xticks(x_ax + ((spacing-2) * 1.2)/2.0)
    ax.set_xticklabels(['Africa'] + biomes_AGB.values(), rotation=-20, fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    #ax.legend([bp1['boxes'][0], bp3['boxes'][0]], ['Avitabile et al. (2016)', 'Model'], fontsize=textsize)
    ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp3['boxes'][0]], ['Avitabile et al. (2016)', 'Model 500m', u'Model 0.25\u00b0'])
    ax.set_ylabel('Woody AGB (gC m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    ax.set_yscale('symlog', basey=2, linthreshy=100)
    ax.set_yticks([0, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000])
    ax.set_ylim([0, 25000])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()
    
    #ax = fig.add_subplot(313)
    #da = ax.imshow(rel500, vmin=-1, vmax=1, cmap='RdBu_r')
    #plt.colorbar(da)
    
    plt.show()
#plot_AGB_bp(3)


def FIGURE1(fign, filename=None):
    textsize = 16
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    fig = plt.figure(fign, (7, 5))
    ax = fig.add_subplot(111)
    
    width = 1
    spacing = 3
    xlen = len(biomes_AGB) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    bp1 = ax.boxplot(REF_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(AGB500_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    for bp, color in zip([bp1, bp2], ['C2', 'C0']):
        plt.setp(bp['boxes'], color=color, linewidth=1.5)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
    
    l1 = ax.scatter([],[],c='C2')       # empty scatter objects to create handles with dots for legend.
    l2 = ax.scatter([],[],c='C0')
    
    ax.plot([x_ax[0] - width/2.0+0.1, x_ax[0] + width/2.0-0.1], [0, 0], linewidth=5, c='C2')
    ax.plot([x_ax[0] - (width-0.1)/4.0, x_ax[0] + (width-0.1)/4.0], [0, 0], linewidth=3, c='black')
    
    ax.plot([x_ax[0]+1.2 - width/2.0+0.1, x_ax[0]+1.2 + width/2.0-0.1], [0, 0], linewidth=5, c='C0')
    ax.plot([x_ax[0]+1.2 - (width-0.1)/4.0, x_ax[0]+1.2 + (width-0.1)/4.0], [0, 0], linewidth=3, c='black')
    
    ax.plot([x_ax[4] - width/2.0+0.1, x_ax[4] + width/2.0-0.1], [0, 0], linewidth=5, c='C2')
    ax.plot([x_ax[4] - (width-0.1)/4.0, x_ax[4] + (width-0.1)/4.0], [0, 0], linewidth=3, c='black')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes_AGB.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    #ax.legend([bp1['boxes'][0], bp2['boxes'][0]], ['Avitabile et al. (2016)', 'Model 500m'], fontsize=textsize)
    ax.legend([l1, l2], ['Avitabile et al. (2016)', 'Model 500m'], fontsize=textsize)
    ax.set_ylabel('Woody AGB (g C m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    #plt.subplots_adjust(bottom=0.15)
    
    ax.set_yscale('symlog', basey=2, linthreshy=100)
    ax.set_yticks([0, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000])
    ax.set_ylim([0, 25000])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    #ax.get_yaxis().set_major_formatter(ticker.StrMethodFormatter('{x:,.0f}'))
    ax.set_yticklabels(['{:,}'.format(int(x)).replace(',',' ') for x in ax.get_yticks().tolist()])
    ax.minorticks_off()
    
    plt.tight_layout()
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
    
#FIGURE1(1, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure1_TNR')


def alloc_biome_average(sdirn):
    
    sdir = wdir + 'results/' + sdirn
    mode = 2
    res = 0.25
    
    n = Model(sdir, mode=mode, resolution=res, tile='Africa', act='passive', firemode='on')
    n.load(full=['leaf', 'stem', 'gras', 'cwd', 'litt', 'rootc', 'rootf'])
    
    n_leaf = np.mean(n.diagf['leaf'], axis=0)
    n_stem = np.mean(n.diagf['stem'], axis=0)
    n_root = np.mean(n.diagf['rootc'] + n.diagf['rootf'], axis=0)
    n_gras = np.mean(n.diagf['gras'], axis=0)

    # Poorter et al. 2012
    # [leaf, stem, root]
    alloc = OrderedDict([
        ('1', [0.04, 0.75, 0.21]),  # boreal forest
        ('2', [0.02, 0.82, 0.16]),  # tropical forest
        ('3', [0.04, 0.75, 0.21]),  # boreal forest
        ('4', [0.03, 0.76, 0.21]),  # temperate forest
        ('5', [0.03, 0.76, 0.21]),  # temperate forest
        ('4 5', [0.03, 0.76, 0.21]),
        ('6', [0.09, 0.49, 0.47]),  # shrubland
        ('7', [0.09, 0.49, 0.47]),  # shrubland
        ('6 7', [0.09, 0.49, 0.47]),
        ('8', [0.06, 0.57, 0.36]),  # woodland
        ('9', [0.17, 0.27, 0.77]),  # grassland
        ('10', [0.17, 0.27, 0.77]),  # grassland
        ('11', [0.1, 0.5, 0.4]),  # self defined
        ('12', [0.1, 0.5, 0.4]),  # self defined
        ('13', [0.09, 0.28, 0.56]),  # desert
        ('14', [0.04, 0.75, 0.21]),  # boreal forest
        ('15', [0.09, 0.37, 0.69]),  # tundra
    ])
    for key in alloc.keys():
        alloc[key] = alloc[key] / np.sum(alloc[key])  # normalize fractions.
       
    n_leaf_biome = Model.biome_calc(n_leaf, biomes, res, years[len(years)/2], 'Africa')[1]
    n_stem_biome = Model.biome_calc(n_stem, biomes, res, years[len(years)/2], 'Africa')[1]
    n_root_biome = Model.biome_calc(n_root, biomes, res, years[len(years)/2], 'Africa')[1]
    n_gras_biome = Model.biome_calc(n_gras, biomes, res, years[len(years)/2], 'Africa')[1]
    n_total_biome = Model.biome_calc(n_leaf+n_stem+n_root+n_gras, biomes, res, years[len(years)/2], 'Africa')[1]
    
    n_leaf_biome2 = [n_total_biome[biome] * alloc[biome][0] for biome in biomes]
    n_stem_biome2 = [n_total_biome[biome] * alloc[biome][1] for biome in biomes]
    n_root_biome2 = [n_total_biome[biome] * alloc[biome][2] for biome in biomes]
    
    return n_leaf_biome, n_stem_biome, n_root_biome, n_gras_biome, n_leaf_biome2, n_stem_biome2, n_root_biome2
n_leaf_biome, n_stem_biome, n_root_biome, n_gras_biome, n_leaf_biome2, n_stem_biome2, n_root_biome2 = alloc_biome_average('FL_025deg_Africa_'+sdate+'/')

def plot_alloc(fign):
    fig = plt.figure(fign, (7, 4))
    ax = fig.add_subplot(111)
    
    width = 1
    spacing = 3
    xlen = len(biomes)
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    pl1 = ax.bar(x_ax, n_root_biome.values(), width, color='brown')
    pl2 = ax.bar(x_ax, n_stem_biome.values(), width, bottom=n_root_biome.values(), color='orange')
    pl3 = ax.bar(x_ax, n_leaf_biome.values(), width, bottom=np.array(n_root_biome.values()) + np.array(n_stem_biome.values()), color='green')
    pl4 = ax.bar(x_ax, n_gras_biome.values(), width, bottom=np.array(n_root_biome.values()) + np.array(n_stem_biome.values()) + np.array(n_leaf_biome.values()), color='yellow')

    ax.bar(x_ax + 1.2, n_root_biome2, width, color='brown')
    ax.bar(x_ax + 1.2, n_stem_biome2, width, bottom=n_root_biome2, color='orange')
    ax.bar(x_ax + 1.2, n_leaf_biome2, width, bottom=np.array(n_root_biome2) + np.array(n_stem_biome2), color='green')

    ax.yaxis.grid(linestyle='--')

    ax.legend([pl1, pl2, pl3, pl4], ['root', 'stem', 'leaf', 'grass'])

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(biomes, rotation=45)
    ax.set_ylabel('Biomass, carbon (gC $\mathregular{m^{-2}}$)')

    plt.tight_layout
    plt.gcf().subplots_adjust(bottom=0.18)
    # plt.savefig(wdir + 'leaf_stem_root_ratio')
    plt.show()

def plot_alloc_rel(fign):
    fig = plt.figure(fign, (7, 4))
    ax = fig.add_subplot(111)
    
    width = 1
    spacing = 3
    xlen = len(biomes)
    x_ax = np.arange(1, xlen * spacing, spacing)

    n_total_biome = np.array(n_root_biome.values()) + np.array(n_stem_biome.values()) + np.array(n_leaf_biome.values()) + np.array(n_gras_biome.values())
    n_root_biome_rel = (np.array(n_root_biome.values()) / n_total_biome)
    n_stem_biome_rel = (np.array(n_stem_biome.values()) / n_total_biome)
    n_leaf_biome_rel = (np.array(n_leaf_biome.values()) / n_total_biome)
    n_gras_biome_rel = (np.array(n_gras_biome.values()) / n_total_biome)

    n_total_biome2 = np.array(n_root_biome2) + np.array(n_stem_biome2) + np.array(n_leaf_biome2)
    n_root_biome2_rel = (np.array(n_root_biome2) / n_total_biome2)
    n_stem_biome2_rel = (np.array(n_stem_biome2) / n_total_biome2)
    n_leaf_biome2_rel = (np.array(n_leaf_biome2) / n_total_biome2)

    pl1 = ax.bar(x_ax, n_root_biome_rel, width, color='brown')
    pl2 = ax.bar(x_ax, n_stem_biome_rel, width, bottom=n_root_biome_rel, color='orange')
    pl3 = ax.bar(x_ax, n_leaf_biome_rel, width, bottom=np.array(n_root_biome_rel) + np.array(n_stem_biome_rel), color='green')
    pl4 = ax.bar(x_ax, n_gras_biome_rel, width, bottom=np.array(n_root_biome_rel) + np.array(n_stem_biome_rel) + np.array(n_leaf_biome_rel), color='yellow')

    ax.bar(x_ax + 1.2, n_root_biome2_rel, width, color='brown')
    ax.bar(x_ax + 1.2, n_stem_biome2_rel, width, bottom=n_root_biome2_rel, color='orange')
    ax.bar(x_ax + 1.2, n_leaf_biome2_rel, width, bottom=np.array(n_root_biome2_rel) + np.array(n_stem_biome2_rel), color='green')

    ax.yaxis.grid(linestyle='--')

    ax.legend([pl1, pl2, pl3, pl4], ['root', 'stem', 'leaf', 'grass'])

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(biomes, rotation=45)
    ax.set_ylabel('Biomass, carbon, relative (-)')

    plt.tight_layout
    plt.gcf().subplots_adjust(bottom=0.18)
    # plt.savefig(wdir + 'leaf_stem_root_ratio_relative')
    plt.show()

#plot_alloc(1)
#plot_alloc_rel(2)

#endregion \\\


#region /// Fuel load and consumption
''' Leeuwen comparison '''

def make_database_Africa():
    import openpyxl as excl
    time0 = timer.time()
    wb = excl.load_workbook(filename='/Volumes/Mac_HD/Work/Data/FC_Leeuwen2014/FCdata_Dec2014_edit3.xlsx', read_only=True, data_only=True);
    wb_names = wb.get_sheet_names()
    ws = wb.get_sheet_by_name('Africa')

    sheet = np.array([[k.value for k in j] for j in ws['A4':'M153']])
    sheet[sheet == '-'] = np.nan

    sheet = sheet[np.all(sheet==None, axis=1) == False]     # remove rows that are all-None

    imeas = np.nonzero(sheet[:, 0])[0]
    leaf = np.zeros((len(imeas), 3))
    gras = np.zeros((len(imeas), 3))
    stem = np.zeros((len(imeas), 3))
    cwd = np.zeros((len(imeas), 3))
    litt = np.zeros((len(imeas), 3))
    total = np.zeros((len(imeas), 3))
    live = np.zeros((len(imeas), 3))
    dead = np.zeros((len(imeas), 3))
    results = {}

    def sheet_grab(meas, meas_end, POOL):
        # Grabs FL, CC, FC from data sheet.
        index = np.where(sheet[meas:meas_end, 5] == POOL)[0]

        if index.size != 0:
            FL = float(sheet[meas:meas_end][index, 6])
            CC = float(sheet[meas:meas_end][index, 7])
            FC = float(sheet[meas:meas_end][index, 8])
        else:
            return [np.nan, np.nan, np.nan]

        return [FL, CC, FC]

    for i, (meas, meas_end) in enumerate(zip(imeas, np.append(imeas[1:], len(sheet)))):

        total[i] = sheet_grab(meas, meas_end, 'Total')
        leaf[i] = sheet_grab(meas, meas_end, 'leaf')
        gras[i] = sheet_grab(meas, meas_end, 'grass')
        stem[i] = sheet_grab(meas, meas_end, 'stem')
        litt[i] = sheet_grab(meas, meas_end, 'litt')
        cwd[i] = sheet_grab(meas, meas_end, 'cwd')
        live[i] = [leaf[i][0] + gras[i][0] + stem[i][0], 0, leaf[i][2] + gras[i][2] + stem[i][2]]
        live[i][1] = round((live[i][2] / live[i][0]) * 100)
        dead[i] = [litt[i][0] + cwd[i][0], 0, litt[i][2] + cwd[i][2]]
        dead[i][1] = round((dead[i][2] / dead[i][0]) * 100)

    results['ref'] = sheet[imeas, 0]
    results['lat'] = sheet[imeas, 1]
    results['lon'] = sheet[imeas, 2]
    results['year'] = sheet[imeas, 3]
    results['month'] = sheet[imeas, 4]
    results['biome'] = sheet[imeas, 10][np.newaxis].T
    results['pools'] = [x.split(', ') for x in sheet[imeas,12]]
    results['condi'] = sheet[imeas, 9]
    results['slash'] = sheet[imeas, 11]

    results['leaf'] = leaf
    results['gras'] = gras
    results['stem'] = stem
    results['litt'] = litt
    results['cwd'] = cwd
    results['total'] = total
    results['live'] = live
    results['dead'] = dead

    def ftimes(years, months):

        fyears = np.zeros(len(years))
        for i in range(len(years)):
            try:
                fyears[i] = int(years[i])
            except:
                if str(years[i]) == 'nan':
                    fyears[i] = 2005
                else:
                    fyears[i] = int(years[i].split(', ')[-1])

        fmonths = np.zeros(len(months))
        for i in range(len(months)):
            try:
                fmonths[i] = int(months[i])
            except:
                if str(months[i]) == 'nan':
                    fmonths[i] = 6
                else:
                    fmonths[i] = int(months[i].split(', ')[0])

        fyears[fyears < 2002] = 2002
        return fyears, fmonths
    fyears, fmonths = ftimes(results['year'], results['month'])
    results['ftimes'] = {'fyears': fyears, 'fmonths': fmonths}

    measlist = []
    for i in range(len(imeas)):
        loc500, tile500 = Model.loci(500, [results['lat'][i], results['lon'][i]])
        loc025, _ = Model.loci(0.25, [results['lat'][i], results['lon'][i]])
        measlist.append((tile500, loc500, loc025))  # loci output is: tile, loc (index in tile), loc_25deg (global index).
        print ('\r{0} / ' + str(len(imeas))).format(i),  # overwrites previous print
        sys.stdout.flush()

    meta = 'Made with Leeuwen_2014.py, includes Leeuwen et al. 2014 measurements grouped in model pools (results), and location tiles and indices per measurement (measlist).'
    return OrderedDict([('results', results), ('measlist', measlist), ('meta', meta)])
dictn = Model.saver(make_database_Africa, ddir + 'FC_Leeuwen2014/' + 'Leeuwen_2014_Africa' + '.npy')
results, measlist, meta = dictn.values()
FL_total_ref = results['total'][:,0] * 50       # conversion [t/ha] -> [gC/m2] = *50
FC_total_ref = results['total'][:,2] * 50
FL_dead_ref = results['dead'][:,0] * 50
FC_dead_ref = results['dead'][:,2] * 50

def compare_biomes():
    field_biome500 = []
    field_biome025 = []
    for i in range(len(measlist)):
        
        fyear = str(int(results['ftimes']['fyears'][i]))
        biomes_map = Model.readdata_MODIS('LC2', 500, [fyear], measlist[i][0])[0, :, :]
        biome_num = biomes_map[measlist[i][1][0], measlist[i][1][1]]
        biome_name = Model.biomes_UMD[str(biome_num)][0]
        field_biome500.append([biome_num, biome_name])
        
        biomes_map = Model.readdata_MODIS('LC2', 0.25, [fyear], 'global')[0, :, :]
        biome_num = biomes_map[measlist[i][2][0], measlist[i][2][1]]
        biome_name = Model.biomes_UMD[str(biome_num)][0]
        field_biome025.append([biome_num, biome_name])
        print ('\r{0} / ' + str(len(measlist))).format(i),  # overwrites previous print
        sys.stdout.flush()
        
    compare = np.hstack((results['total'][:,0][np.newaxis].T, np.array(results['biome']), np.array(field_biome500), np.array(field_biome025)))
    return compare
compare = Model.saver(compare_biomes, ddir + 'FC_Leeuwen2014/' + 'compare_Africa' + '.npy')
field_biome500 = compare[:,2]
field_biome025 = compare[:,4]

def fire_return_time():
    tile = 'h20v09'
    years = Model.allyears[1:]
    BA_500 = Model.readdata_MODIS('BA', 500, years, tile)
    BA_025 = Model.readdata_MODIS('BA', 0.25, years, tile)

    FTC_500 = Model.readdata_MODIS('FTC', 500, years, tile)
    NTV_500 = Model.readdata_MODIS('NTV', 500, years, tile)
    BAR_500 = 1 - FTC_500 - NTV_500
    del FTC_500, NTV_500

    FTC_025 = Model.readdata_MODIS('FTC', 0.25, years, tile)
    NTV_025 = Model.readdata_MODIS('NTV', 0.25, years, tile)
    BAR_025 = 1 - FTC_025 - NTV_025

    lwmask_500 = Model.readdata_LWMASK('LWM', 500, tile, frac='yes')
    lwmask_025 = Model.readdata_LWMASK('LWM', 0.25, tile, frac='yes')

    # BA_500 = BA_500 * np.arange(len(BA_500))[:, None, None]     # apply month number.

    # b = BA_500[:,2300,250]

    def calculate_interval_500():
        sdir = wdir + 'results/' + 'run1_500m_Africa_v6_f32/'
        filename = 'fire_return_time_500'

        if os.path.isfile(sdir + filename + '.npz'):
            interval_dict = np.load(sdir + filename + '.npz')
            interval_dict = {key: interval_dict[key] for key in interval_dict.keys()}

        else:
            interval_mean = np.zeros((BA_500.shape[1], BA_500.shape[2]))
            interval_medi = np.zeros((BA_500.shape[1], BA_500.shape[2]))
            interval_mode = np.zeros((BA_500.shape[1], BA_500.shape[2]))
            for i in range(BA_500.shape[1]):
                for j in range(BA_500.shape[2]):
                    event_months = np.flatnonzero(BA_500[:, i, j])
                    interval = np.diff(event_months)
                    interval_mean[i, j] = np.mean(interval)
                    interval_medi[i, j] = np.median(interval)
                    if event_months != []:
                        interval_mode[i, j] = scipy.stats.mode(interval)[0][0]
                    else:
                        interval_mode[i, j] = np.nan

            interval_dict = {'mean': interval_mean, 'medi': interval_medi, 'mode': interval_mode}

            np.savez(sdir + filename, **interval_dict)

        return interval_dict

    interval_dict = calculate_interval_500()
    interval_500 = interval_dict['mode']
    index12 = (interval_500 >= 11) & (interval_500 <= 13)
    interval_500[~index12] = 0
    interval_500[interval_500 == 0] = np.nan

    class ImageCursor():
        def __init__(self, axes, fmt='x:{x}\ny:{y}\nz:{z:.3f}'):
            self.fmt = fmt
            self.axes = axes
            self.fig = self.axes[0].figure
            self.ims = []
            self.annot = []
            for ax in self.axes:
                ax.images[0].set_picker(True)
                self.ims.append(ax.images[0])
                annot = ax.annotate("", xy=(0, 0), xytext=(-30, 30),
                                    textcoords="offset points",
                                    arrowprops=dict(arrowstyle="->", color="w",
                                                    connectionstyle="arc3"),
                                    va="bottom", ha="left", fontsize=10,
                                    bbox=dict(boxstyle="round", fc="w"), )
                annot.set_visible(False)
                self.annot.append(annot)
            self.cid = self.fig.canvas.mpl_connect("pick_event", self.pick)

        def pick(self, event):
            e = event.mouseevent
            if e.inaxes:
                x, y = int(np.round(e.xdata)), int(np.round(e.ydata))
                self.annotate((x, y))

        def annotate(self, X):
            for annot, im in zip(self.annot, self.ims):
                z = im.get_array()[X[1], X[0]]
                annot.set_visible(True)
                annot.set_text(self.fmt.format(x=X[0], y=X[1], z=z))
                annot.xy = X
            self.fig.canvas.draw_idle()

    max_BA_lw = BA_025[36 + 7] - lwmask_025
    for i in range(len(BA_025)):
        diff = BA_025[i] / lwmask_025
        index = np.where(diff == np.nanmax(diff))
        if len(index[0]) == 1:
            print BA_025[i][index], lwmask_025[index]

    fig = plt.figure(1)
    ax1 = fig.add_subplot(211)
    ax1.imshow(BA_025[36 + 7])
    ax2 = fig.add_subplot(212)
    ax2.imshow(lwmask_025)
    # MultiCursor(fig.canvas, (ax1, ax2), color='r')
    ImageCursor([ax1, ax2])

    print 'debug'
#fire_return_time()

def check_fieldplot(sdirn, i):
    
    sdir = wdir + 'results/' + sdirn
    border = 5
    
    latlon = [results['lat'][i], results['lon'][i]]
    tile = measlist[i][0]
    index500 = measlist[i][1]
    
    n = Model(sdir, mode=1, resolution=500, tile=tile, firemode='on', act='passive')
    n.load(full='all')
    
    FL = np.mean(n.diagf['AGB'] + n.diagf['LIT'], axis=0)
    FC = np.mean(n.diagf['AGB_fire'] + n.diagf['LIT_fire'], axis=0)
    n.diagf = {}
    lwmask = Model.readdata_LWMASK('LWM', 500, tile)
    LC = Model.readdata_MODIS('LC2', 500, ['2010'], tile)[0]
    
    FL = FL*lwmask
    FC = FC*lwmask
    LC = LC*lwmask
    
    FLfield = FL[index500[0] - border : index500[0] + border+1, index500[1] - border : index500[1] + border+1]
    FCfield = FC[index500[0] - border : index500[0] + border+1, index500[1] - border : index500[1] + border+1]
    LCfield = LC[index500[0] - border : index500[0] + border+1, index500[1] - border : index500[1] + border+1]
    
    print 'current index: %s lat, %s lon' %(index500[0], index500[1])
    # 1 arcminute = 0.0167 ~= 1200 m 
    # 500m = 0.006944..
    unit500 = 0.01666666/2.4
    latlonnew = [latlon[0] - unit500 / 2.0, latlon[1]]
    indexnew, _ = Model.loci(500, latlonnew)
    print 'new index: %s lat, %s lon' %(indexnew[0], indexnew[1])
    print 'current coor: %s' %(latlon)
    
    fig = plt.figure()
    ax1 = fig.add_subplot(211)
    da1 = ax1.imshow(FL, vmin=0, vmax=np.nanmax(FLfield))
    plt.colorbar(da1, ax=ax1)
    ax1.scatter(index500[1], index500[0], c='red')
    
    ax2 = fig.add_subplot(212)
    da2 = ax2.imshow(LCfield, vmin=0)
    plt.colorbar(da2, ax=ax2)
    ax2.scatter(len(FLfield)/2, len(FLfield)/2, c='red')
    
    plt.show()
    
    print 'debug'
#check_fieldplot('FL_500m_Africa_'+sdate+'/', 20)


def load_model_FC(sdir, resolution):
    
    border = 0
    
    d = np.load(ddir + 'FC_Leeuwen2014/' + 'Leeuwen_2014_Africa' + '.npy')[()]
    results = d['results']
    measlist = d['measlist']
    fyears = results['ftimes']['fyears']
    fmonths = results['ftimes']['fmonths']
    
    df0 = pd.DataFrame([results['year'], results['month']]).transpose()
    df1 = pd.DataFrame([results['lat'], results['lon']]).transpose()
    df2 = pd.concat([pd.DataFrame([measlist[i][0], measlist[i][1], measlist[i][2]]).transpose() for i in range(len(measlist))], ignore_index=True)
    df3 = pd.concat([df1, df2, df0], axis=1, ignore_index=True)
    samplecoor = df3.drop_duplicates().as_matrix()
    print 'Note %s duplicate(s) is/are removed at location(s): %s' % (len(df3) - len(samplecoor), np.where(df3.duplicated() == True)[0])
    
    # Calculate model values
    
    f_FL_total = []
    f_FC_total = []
    f_FL_live = []
    f_FC_live = []
    f_FL_dead = []
    f_FC_dead = []
    f_FL_deadcwd = []
    f_FC_deadcwd = []
    f_FL_deadlitt = []
    f_FC_deadlitt = []
    f_landfrac = []
    for i in range(len(measlist)):
        if resolution == 500:   tile = measlist[i][0]
        else:                   tile = 'global'
        sampleloc = [[float(results['lat'][i]), float(results['lon'][i])], border]
        # tile = samplecoor[i][2]
        # sampleloc = [[float(samplecoor[i, 0]), float(samplecoor[i, 1])], 1]
        f = Model(sdir, mode=2, resolution=resolution, tile=tile, firemode='on', act='passive', sampleloc=sampleloc)
        try:
            f.load(addtxt='FC')
        except:
            f_FL_total.append(0)
            f_FC_total.append(0)
            f_FL_live.append(0)
            f_FC_live.append(0)
            f_FL_dead.append(0)
            f_FC_dead.append(0)
            f_FL_deadcwd.append(0)
            f_FC_deadcwd.append(0)
            f_FL_deadlitt.append(0)
            f_FC_deadlitt.append(0)
            continue
        
        loc, _ = Model.loci(resolution, sampleloc[0])
        ycoor = loc[0]
        xcoor = loc[1]
        lwmask = Model.readdata_LWMASK('LWM', resolution, tile, frac='yes')
        
        landfrac = np.nanmean(lwmask[ycoor - border: ycoor + border + 1, xcoor - border: xcoor + border + 1])
        
        f_FL_totali = 0
        f_FC_totali = 0
        f_FL_livei = 0
        f_FC_livei = 0
        f_FL_deadi = 0
        f_FC_deadi = 0
        f_FL_deadcwdi = 0
        f_FC_deadcwdi = 0
        f_FL_deadlitti = 0
        f_FC_deadlitti = 0
        for pool in results['pools'][i]:
            if pool in ['soil']:
                continue
                
            else:
                if pool in ['leaf', 'stem', 'cwd', 'litt', 'gras']:
                    f_FC_totali = np.nansum((f_FC_totali, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                    f_FL_totali = np.nansum((f_FL_totali, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
                    
                # elif pool == 'litt':
                #     if compare[i,3] == 'norma_SA':
                #     #if compare[i,3] == 'woody_SA':
                #         f_FC_totali = np.nansum((f_FC_totali, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                #         f_FL_totali = np.nansum((f_FL_totali, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
                #     else:
                #         f_FC_totali = np.nansum((f_FC_totali, np.max(f.diagm_fire[pool + '_fire']) / 3.0)) * landfrac
                #         f_FL_totali = np.nansum((f_FL_totali, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1] / 3.0)) * landfrac
                # elif pool == 'gras':
                #     if compare[i,3] in ['open_SH', 'grass_G', 'crops_C']:
                #         f_FC_totali = np.nansum((f_FC_totali, np.max(f.diagm_fire[pool + '_fire']) / 3.0)) * landfrac
                #         f_FL_totali = np.nansum((f_FL_totali, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1] / 3.0)) * landfrac
                #     else:
                #         f_FC_totali = np.nansum((f_FC_totali, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                #         f_FL_totali = np.nansum((f_FL_totali, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
                
                if pool in ['leaf', 'stem', 'gras']:
                    f_FC_livei = np.nansum((f_FC_livei, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                    f_FL_livei = np.nansum((f_FL_livei, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
                elif pool in ['litt', 'cwd']:
                    f_FC_deadi = np.nansum((f_FC_deadi, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                    f_FL_deadi = np.nansum((f_FL_deadi, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
                
                if pool in ['cwd']:
                    f_FC_deadcwdi = np.nansum((f_FC_deadcwdi, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                    f_FL_deadcwdi = np.nansum((f_FL_deadcwdi, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
                elif pool in ['litt']:
                    f_FC_deadlitti = np.nansum((f_FC_deadlitti, np.max(f.diagm_fire[pool + '_fire']))) * landfrac
                    f_FL_deadlitti = np.nansum((f_FL_deadlitti, f.diagm_pool[pool][np.argmax(f.diagm_fire[pool + '_fire']) - 1])) * landfrac
        
        if results['slash'][i] == 'slashburn':
            pass
            # # if ~np.isnan(results['cwd'][i][1]):
            # #     CC_stem = results['cwd'][i][1] / 100.0
            # # else:
            # #     CC_stem = 0.7
            # 
            # if ~np.isnan(results['stem'][i][1]):
            #     CC_stem = results['stem'][i][1] / 100.0
            # elif ~np.isnan(results['cwd'][i][1]):
            #     CC_stem = results['cwd'][i][1] / 100.0
            # elif ~np.isnan(results['total'][i][1]):
            #     CC_stem = results['total'][i][1] / 100.0  # new 2018-03-12
            # else:
            #     CC_stem = 0.5
            # 
            # f_FL_stemi = f.diagm_pool['stem'][np.argmax(f.diagm_fire['stem_fire']) - 1]
            # 
            # f_FL_totali = f_FL_totali  # + f_FL_stemi             # stem is already in total fuel load!
            # f_FC_totali = f_FC_totali + f_FL_stemi * CC_stem  # count slashed stem as cwd.
            # f_FL_deadi = f_FL_deadi  # + f_FL_stemi               # stem is already in total fuel load!
            # f_FC_deadi = f_FC_deadi + f_FL_stemi * CC_stem  # count slashed stem as cwd.
        
        f_FL_total.append(f_FL_totali)
        f_FC_total.append(f_FC_totali)
        f_FL_live.append(f_FL_livei)
        f_FC_live.append(f_FC_livei)
        f_FL_dead.append(f_FL_deadi)
        f_FC_dead.append(f_FC_deadi)
        f_FL_deadcwd.append(f_FL_deadcwdi)
        f_FC_deadcwd.append(f_FC_deadcwdi)
        f_FL_deadlitt.append(f_FL_deadlitti)
        f_FC_deadlitt.append(f_FC_deadlitti)
        
    return OrderedDict([('f_FL_total',f_FL_total), ('f_FC_total',f_FC_total), ('f_FL_live',f_FL_live), ('f_FC_live',f_FC_live), ('f_FL_dead',f_FL_dead), ('f_FC_dead',f_FC_dead),
                        ('f_FL_deadcwd', f_FL_deadcwd), ('f_FC_deadcwd', f_FC_deadcwd), ('f_FL_deadlitt',f_FL_deadlitt), ('f_FC_deadlitt',f_FC_deadlitt)])

sdir = wdir + 'results/' + 'FL_500m_Africa_'+sdate+'/'
model_FC = Model.saver(lambda: load_model_FC(sdir, 500), sdir + 'model_FC'+'.npy')  # _litt0.2_cwd3.0
FL_total = model_FC['f_FL_total']
FC_total = model_FC['f_FC_total']
FL_dead = model_FC['f_FL_dead']
FC_dead = model_FC['f_FC_dead']

sdir = wdir + 'results/' + 'FL_025deg_Africa_'+sdate+'/'
model_FC025 = Model.saver(lambda: load_model_FC(sdir, 0.25), sdir + 'model_FC'+'.npy')
FL_total025 = model_FC025['f_FL_total']
FC_total025 = model_FC025['f_FC_total']

sdir = wdir + 'results/' + 'FL_500m_Africa_17-06_2/'
model_FC_set2 = Model.saver(lambda: load_model_FC(sdir, 500), sdir + 'model_FC'+'.npy')
FL_total_set2 = model_FC_set2['f_FL_total']
FC_total_set2 = model_FC_set2['f_FC_total']

sdir = wdir + 'results/' + 'FL_025deg_Africa_17-06_2/'
model_FC025_set2 = Model.saver(lambda: load_model_FC(sdir, 0.25), sdir + 'model_FC'+'.npy')
FL_total025_set2 = model_FC025_set2['f_FL_total']
FC_total025_set2 = model_FC025_set2['f_FC_total']


def plot_fieldplots_spatial():
    fig = plt.figure(110)
    ax = fig.add_subplot(111)
    diff = FL_total - FL_total_ref
    
    lat = []
    lon = []
    for i in range(len(measlist)):
        lat.append(measlist[i][2][0] - Model.region_box['Africa'][0][0])
        lon.append(measlist[i][2][1] - Model.region_box['Africa'][1][0])
    
    sdir = wdir + 'results/' + 'FL_025deg_Africa_17-06_2/'
    var = Model.load_deg(sdir, 0.25, 1)
    
    lwmask = Model.readdata_LWMASK('LWM', 0.25, 'Africa')
    ax.imshow(var['FL'], vmax=3000)
    da = ax.scatter(lon, lat, c=diff, cmap='RdBu_r', vmin=-300, vmax=300)
    plt.colorbar(da)
#plot_fieldplots_spatial()

print 'debug'


def group_per_biome(FL_total, FL_total025):
    FL_perbiome = OrderedDict()
    FL_perbiome025 = OrderedDict()
    FL_perbiome_ref = OrderedDict()
    for i in range(len(measlist)):
        for biome in ['total'] + Model.biomes_UMD.keys():
            if i == 0:
                FL_perbiome[biome] = []
                FL_perbiome025[biome] = []
                FL_perbiome_ref[biome] = []
            if compare[i,2] == biome:
                FL_perbiome[biome].append(FL_total[i])
                FL_perbiome025[biome].append(FL_total025[i])
                FL_perbiome_ref[biome].append(FL_total_ref[i])
            elif biome == 'total':
                FL_perbiome[biome].append(FL_total[i])
                FL_perbiome025[biome].append(FL_total025[i])
                FL_perbiome_ref[biome].append(FL_total_ref[i])
    return FL_perbiome, FL_perbiome025, FL_perbiome_ref
FL_bp, FL025_bp, FLref_bp = group_per_biome(FL_total, FL_total025)
FL_bp_set2, FL025_bp_set2, FLref_bp_set2 = group_per_biome(FL_total_set2, FL_total025_set2)

def plot_FCfield_line(fign):
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(211)
    ax.plot(range(len(measlist)), FL_total, range(len(measlist)), FL_total_ref, marker='o', markersize=1)
    ax.plot(range(len(measlist)), FL_dead, marker='o', markersize=1, linestyle='--', color='#1f77b4', alpha=0.6)
    ax.plot(range(len(measlist)), FL_dead_ref, marker='o', markersize=1, linestyle='--', color='#ff7f0e', alpha=0.6)
    #ax.plot(range(len(measlist)), model_FC['f_FL_deadcwd'], marker='o', markersize=1, linestyle='--', color='red', alpha=0.6)
    ax.plot(range(len(measlist)), FL_total025, marker='o', markersize=1, color='green', alpha=0.6)
    plt.xticks(range(len(measlist)), compare[:,3], rotation=90)
    
    # ax.plot(range(len(measlist)), np.array(f_landfrac) * 10000)
    # biomes = np.array(results['biome'])[:, 0]
    # plt.xticks(biomes_starts, biomes_list)
    plt.ylim([0,800])
    plt.legend(('Model 500m', 'Leeuwen et al. 2014', 'Model dead (cwd+litt)', 'Leeuwen dead (cwd+litt)', 'Model 0.25deg'))
    ax.set_ylabel('FL [gC/m2]')
    
    ax = fig.add_subplot(212)
    ax.plot(range(len(measlist)), FC_total, range(len(measlist)), FC_total_ref, marker='o', markersize=1)  # conversion [t/ha] -> [gC/m2] = *50
    ax.plot(range(len(measlist)), FC_dead, marker='o', markersize=1, linestyle='--', color='#1f77b4', alpha=0.6)
    ax.plot(range(len(measlist)), FC_dead_ref, marker='o', markersize=1, linestyle='-.', color='#ff7f0e', alpha=0.6)
    ax.plot(range(len(measlist)), FC_total025, marker='o', markersize=1, color='green', alpha=0.6)
    plt.xticks(range(len(measlist)), compare[:,3], rotation=90)
    
    # ax.plot(range(len(measlist)), np.array(f_landfrac) * 10000)
    # ax.plot(range(125), gfed4_FC_Leeuwen, marker='o', markersize=1)
    # plt.xticks(biomes_starts, biomes_list)
    plt.ylim([0, 800])
    plt.legend(('Model 500m', 'Leeuwen et al. 2014', 'Model dead (cwd+litt)', 'Leeuwen dead (cwd+litt)', 'Model 0.25deg'))
    ax.set_ylabel('FC [gC/m2]')
    plt.show()

def plot_FCfield_sc(fign):
    ''' PAPER FIGURE '''
    
    fig = plt.figure(fign, (11,7))
    gs = gridspec.GridSpec(1, 2, width_ratios=[3, 1])
    
    ax = fig.add_subplot(gs[0])
    ax.plot(range(800), color='grey', alpha=0.5)
    
    sc1 = ax.scatter(results['total'][:, 0] * 50, FL_total025, alpha=0.4, color='C1')
    reg025 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total025)
    fit025 = np.polyfit(results['total'][:, 0] * 50, FL_total025, 1);
    fit_fn025 = np.poly1d(fit025)
    ax.plot(results['total'][:, 0] * 50, fit_fn025(results['total'][:, 0] * 50), color='black', alpha=0.4)
    
    sc2 = ax.scatter(results['total'][:, 0] * 50, FL_total, c=field_biome500.astype(int), cmap='Blues', edgecolor='black')
    reg500 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total)
    fit500 = np.polyfit(results['total'][:, 0] * 50, FL_total, 1);
    fit_fn500 = np.poly1d(fit500)
    ax.plot(results['total'][:, 0] * 50, fit_fn500(results['total'][:, 0] * 50), color='black', alpha=0.9)
    
    ax.set_xlim([0, 800])
    ax.set_ylim([0, 800])
    boxprop = dict(facecolor='white', alpha=0.5, edgecolor='blue')
    ax.text(50, 700, 'y = %.3f x + %.1f \nR2 = %.3f' % (reg500[0], reg500[1], reg500[2] ** 2), bbox=boxprop)
    boxprop = dict(facecolor='white', alpha=0.5, edgecolor='C1')
    ax.text(50, 600, 'y = %.3f x + %.1f \nR2 = %.3f' % (reg025[0], reg025[1], reg025[2] ** 2), bbox=boxprop)
    
    ax.legend([sc2, sc1], ['Model 500m', u'Model 0.25\u00b0'], loc=4)
    
    ax.set_xlabel('Fuel Load - Leeuwen et al. (2014) (gC m$^{-2}$)')
    ax.set_ylabel('Fuel Load - model (gC m$^{-2}$)')
    
    
    ax = fig.add_subplot(gs[1])
    width = 1
    spacing = 4
    xlen = len(['total'] + biomes_field.keys())
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    FLref_bp_plot = [FLref_bp[biome] for biome in ['total'] + biomes_field.keys()]
    FL_bp_plot = [FL_bp[biome] for biome in ['total'] + biomes_field.keys()]
    FL025_bp_plot = [FL025_bp[biome] for biome in ['total'] + biomes_field.keys()]
    
    bp1 = ax.boxplot(FLref_bp_plot, showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FL_bp_plot, showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp3 = ax.boxplot(FL025_bp_plot, showmeans=True, showfliers=False, positions=x_ax + 2.4, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    for bp, color in zip([bp1, bp2, bp3], ['C2', 'C0', 'C1']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    xlabels = ax.set_xticklabels(['Total'] + biomes_field.values(), rotation=30, ha='right')
    plt.xlim([0.1, np.max(x_ax) + spacing])
    #ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp3['boxes'][0]], ['Leeuwen et al. 2014', 'Model 500m', 'Model 0.25 degree'])
    ax.set_ylabel('Fuel load (gC m$^{-2}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    plt.subplots_adjust(bottom=0.15)
    
    #fig.savefig(wdir + 'FC_field_30-07-2018')
    
    plt.show()


def plot_FCfield_sc_500m(fign, FL_total, FL_bp, filename=None):
    ''' PAPER FIGURE '''
    textsize = 18
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    custom_colors = ['C0','C1','C2','C3']
    custom_cmap = LinearSegmentedColormap.from_list('custom_cmap', custom_colors, N=4)
    
    fig = plt.figure(fign, (11, 6))
    gs = gridspec.GridSpec(1, 2, width_ratios=[2.5, 1.5])
    
    ax = fig.add_subplot(gs[0])
    ax.plot(range(800), color='grey', alpha=0.5, zorder=1)
    
    ax.scatter(results['total'][:, 0] * 50, FL_total, c=field_biome500.astype(int), cmap='Blues', edgecolor='black')
    reg500 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total)
    fit500 = np.polyfit(results['total'][:, 0] * 50, FL_total, 1);
    fit_fn500 = np.poly1d(fit500)
    pl1, = ax.plot(results['total'][:, 0] * 50, fit_fn500(results['total'][:, 0] * 50), color='black', alpha=0.9, zorder=1)
    
    ax.set_xlim([0, 800])
    ax.set_ylim([0, 800])
    #ax.text(-120, 800, '(a)', size=textsize, weight='bold')
    fig.text(0, 0.99, '(a)', size=textsize, verticalalignment='top') #, weight='bold')
    #boxprop = dict(facecolor='white', alpha=0.5, edgecolor='blue')
    #ax.text(50, 700, 'y = %.3f x + %.1f \nR2 = %.3f' % (reg500[0], reg500[1], reg500[2] ** 2), bbox=boxprop, fontsize=textsize)
    
    Blues_cmap = plt.get_cmap('Blues',4)
    l1 = ax.scatter([], [], c=Blues_cmap(0), edgecolor='black')
    l2 = ax.scatter([], [], c=Blues_cmap(1), edgecolor='black')
    l3 = ax.scatter([], [], c=Blues_cmap(2), edgecolor='black')
    l4 = ax.scatter([], [], c=Blues_cmap(3), edgecolor='black')
    regline_text = 'y = %.2f x + %.0f \nR$^{2}$ = %.2f' % (reg500[0], reg500[1], reg500[2] ** 2)
    ax.legend([l1, l2, l3, l4, pl1], ['Shrubland','Woody Savanna','Open Savanna','Grassland', regline_text], fontsize=textsize-2, borderpad=0.25, labelspacing=0.25)
    
    ax.set_xlabel('Measured fuel load (g C m$^{-2}$)', fontsize=textsize)
    ax.set_ylabel('Modelled fuel load (g C m$^{-2}$)', fontsize=textsize)
    ax.xaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    
    ax = fig.add_subplot(gs[1])
    width = 1
    spacing = 3
    xlen = len(['total'] + biomes_field.keys())
    x_ax = np.arange(1, xlen * spacing, spacing)

    FLref_bp_plot = [FLref_bp[biome] for biome in ['total'] + biomes_field.keys()]
    FL_bp_plot = [FL_bp[biome] for biome in ['total'] + biomes_field.keys()]
    
    bp1 = ax.boxplot(FLref_bp_plot, showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis='range', widths=width)
    bp2 = ax.boxplot(FL_bp_plot, showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis='range', widths=width)
    
    for bp, color in zip([bp1, bp2], ['C2', 'C0']):     # apply boxplot coloring.
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
    
    biome_count = [len(field_biome500)] + list(np.trim_zeros(np.bincount(field_biome500.astype(int))))
    for i, w in enumerate(bp1['whiskers'][1::2]):
        x,y = w.get_xydata()[1]
        #ax.text(x, y+10, str(biome_count[i]), ha='center')      # show number of measurements above whiskers.
        ax.text(x_ax[i] + 1.2/2, 4, str(biome_count[i]), ha='center', fontsize=textsize * tickredux)
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    xlabels = ax.set_xticklabels(['Total'] + biomes_field.values(), rotation=30, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    
    
    ax.set_xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0,800])
    fig.text(0.6, 0.99, '(b)', size=textsize, verticalalignment='top') #, weight='bold')
    l1 = ax.scatter([], [], c='C2')
    l2 = ax.scatter([], [], c='C0')
    ax.legend([l1, l2], ['van Leeuwen et al. (2014)', 'Model 500m'], fontsize=textsize-2, loc=(0.11, 0.85), borderpad=0.25, labelspacing=0.25, handletextpad=0.1)
    #ax.legend([l1, l2], ['Leeuwen et al. (2014)$^{3}$', 'Model 500m'], fontsize=14, loc=(0.09, 0.85)) #, loc=(0.11, 0.86))
    ax.set_ylabel('Fuel load (g C m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    #plt.subplots_adjust(bottom=0.15)
    plt.tight_layout()
    
    if filename != None:
        fig.savefig(filename, dpi=300)
    else:
        plt.show()


def plot_FCfield_sc_025deg(fign, FL_total, FL_bp, filename=None):
    ''' PAPER FIGURE '''
    textsize = 18
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    custom_colors = ['C0','C1','C2','C3']
    custom_cmap = LinearSegmentedColormap.from_list('custom_cmap', custom_colors, N=4)
    
    fig = plt.figure(fign, (11, 6))
    gs = gridspec.GridSpec(1, 2, width_ratios=[2.5, 1.5])

    ax = fig.add_subplot(gs[0])
    ax.plot(range(800), color='grey', alpha=0.5, zorder=1)

    field_biome025_filtered = [10 if x==11 else x for x in field_biome025.astype(int)]
    field_biome025_filtered = [7 if x == 2 else x for x in field_biome025_filtered]
    ax.scatter(results['total'][:, 0] * 50, FL_total, c=field_biome025_filtered, cmap='Blues', edgecolor='black')
    reg025 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total)
    fit025 = np.polyfit(results['total'][:, 0] * 50, FL_total, 1);
    fit_fn025 = np.poly1d(fit025)
    pl1, = ax.plot(results['total'][:, 0] * 50, fit_fn025(results['total'][:, 0] * 50), color='black', alpha=0.9, zorder=1)
    
    ax.set_xlim([0, 800])
    ax.set_ylim([0, 800])
    fig.text(0, 0.99, '(c)', size=textsize, verticalalignment='top') #, weight='bold')
    #boxprop = dict(facecolor='white', alpha=0.5, edgecolor='blue')
    #ax.text(50, 700, 'y = %.3f x + %.1f \nR2 = %.3f' % (reg025[0], reg025[1], reg025[2] ** 2), bbox=boxprop, fontsize=textsize)
    
    Blues_cmap = plt.get_cmap('Blues',4)
    l1 = ax.scatter([], [], c=Blues_cmap(0), edgecolor='black')
    l2 = ax.scatter([], [], c=Blues_cmap(1), edgecolor='black')
    l3 = ax.scatter([], [], c=Blues_cmap(2), edgecolor='black')
    l4 = ax.scatter([], [], c=Blues_cmap(3), edgecolor='black')
    regline_text = 'y = %.2f x + %.0f \nR$^{2}$ = %.2f' % (reg025[0], reg025[1], reg025[2] ** 2)
    ax.legend([l1, l2, l3, l4, pl1], ['Shrubland','Woody Savanna','Open Savanna','Grassland', regline_text], fontsize=textsize-2, borderpad=0.25, labelspacing=0.25)
    
    ax.set_xlabel('Measured fuel load (g C m$^{-2}$)', fontsize=textsize)
    ax.set_ylabel('Modelled fuel load (g C m$^{-2}$)', fontsize=textsize)
    ax.xaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    
    ax = fig.add_subplot(gs[1])
    width = 1
    spacing = 3
    xlen = len(['total'] + biomes_field.keys())
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    FLref_bp_plot = [FLref_bp[biome] for biome in ['total'] + biomes_field.keys()]
    FL_bp_plot = [FL_bp[biome] for biome in ['total'] + biomes_field.keys()]

    bp1 = ax.boxplot(FLref_bp_plot, showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis='range', widths=width)
    bp2 = ax.boxplot(FL_bp_plot, showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis='range', widths=width)

    for bp, color in zip([bp1, bp2], ['C2', 'C0']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
    
    biome_count = [len(field_biome025_filtered)] + list(np.trim_zeros(np.bincount(field_biome025_filtered)))
    for i, w in enumerate(bp1['whiskers'][1::2]):
        x,y = w.get_xydata()[1]
        #ax.text(x, y+10, str(biome_count[i]), ha='center')      # show number of measurements above whiskers.
        ax.text(x_ax[i] + 1.2/2, 4, str(biome_count[i]), ha='center', fontsize=textsize * tickredux)
    
    ax.annotate('%4.0f' % np.max(FL_bp_plot[0]), xy=(8.8, 800), xytext=(8.8, 730), fontsize=(textsize-2)*tickredux, arrowprops=dict(facecolor='black', headwidth=10, headlength=10, shrink=0.05))
    ax.annotate('%4.0f' % np.max(FL_bp_plot[0]), xy=(2.8, 800), xytext=(2.8, 730), fontsize=(textsize-2)*tickredux, arrowprops=dict(facecolor='black', headwidth=10, headlength=10, shrink=0.05))
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    xlabels = ax.set_xticklabels(['Total'] + biomes_field.values(), rotation=30, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    
    
    ax.set_xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0,800])
    fig.text(0.6, 0.99, '(d)', size=textsize, verticalalignment='top') #, weight='bold')
    l1 = ax.scatter([], [], c='C2')
    l2 = ax.scatter([], [], c='C0')
    ax.legend([l1, l2], ['van Leeuwen et al. (2014)', r'Model 0.25$\degree$'], fontsize=textsize-2, loc=(0.11,0.53), borderpad=0.25, labelspacing=0.25, handletextpad=0.1)
    #ax.legend([l1, l2], ['Leeuwen et al. (2014)$^{3}$', r'Model $0.25\degree$'], fontsize=14, loc=(0.09, 0.55)) #, loc=(0.11,0.55))
    ax.set_ylabel('Fuel load (g C m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    #plt.subplots_adjust(bottom=0.15)
    plt.tight_layout()
    
    if filename != None:
        fig.savefig(filename, dpi=300)
    else:
        plt.show()


def plot_FCfield_sc_set2(fign):
    ''' PAPER FIGURE '''
    textsize = 12
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    fig = plt.figure(fign)
    gs = gridspec.GridSpec(1, 2, width_ratios=[3, 1])
    
    ax = fig.add_subplot(gs[0])
    ax.plot(range(800), color='grey', alpha=0.5)
    
    ax.scatter(results['total'][:, 0] * 50, FL_total025_set2, alpha=0.4, color='C1')
    reg025 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total025_set2)
    fit025 = np.polyfit(results['total'][:, 0] * 50, FL_total025_set2, 1);
    fit_fn025 = np.poly1d(fit025)
    ax.plot(results['total'][:, 0] * 50, fit_fn025(results['total'][:, 0] * 50), color='black', alpha=0.4)
    
    ax.scatter(results['total'][:, 0] * 50, FL_total_set2, c=field_biome500.astype(int), cmap='Blues', edgecolor='black')
    reg500 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total_set2)
    fit500 = np.polyfit(results['total'][:, 0] * 50, FL_total_set2, 1);
    fit_fn500 = np.poly1d(fit500)
    ax.plot(results['total'][:, 0] * 50, fit_fn500(results['total'][:, 0] * 50), color='black', alpha=0.9)
    
    ax.set_xlim([0, 800])
    ax.set_ylim([0, 800])
    boxprop = dict(facecolor='white', alpha=0.5, edgecolor='blue')
    ax.text(50, 700, 'y = %.3f x + %.1f \nR2 = %.3f' % (reg500[0], reg500[1], reg500[2] ** 2), bbox=boxprop, fontsize=textsize)
    boxprop = dict(facecolor='white', alpha=0.5, edgecolor='C1')
    ax.text(50, 600, 'y = %.3f x + %.1f \nR2 = %.3f' % (reg025[0], reg025[1], reg025[2] ** 2), bbox=boxprop, fontsize=textsize)
    ax.set_xlabel('Fuel Load - Leeuwen et al. 2014 (gC m$^{-2}$)', fontsize=textsize)
    ax.set_ylabel('Fuel Load - model (gC m$^{-2}$)', fontsize=textsize)
    ax.xaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    
    ax = fig.add_subplot(gs[1])
    width = 1
    spacing = 4
    xlen = len(['total'] + biomes_field.keys())
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    FLref_bp_plot = [FLref_bp_set2[biome] for biome in ['total'] + biomes_field.keys()]
    FL_bp_plot = [FL_bp_set2[biome] for biome in ['total'] + biomes_field.keys()]
    FL025_bp_plot = [FL025_bp_set2[biome] for biome in ['total'] + biomes_field.keys()]
    
    bp1 = ax.boxplot(FLref_bp_plot, showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FL_bp_plot, showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp3 = ax.boxplot(FL025_bp_plot, showmeans=True, showfliers=False, positions=x_ax + 2.4, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    for bp, color in zip([bp1, bp2, bp3], ['C2', 'C0', 'C1']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Total'] + biomes_field.values())
    plt.xlim([0.1, np.max(x_ax) + spacing])
    # ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp3['boxes'][0]], ['Leeuwen et al. 2014', 'Model 500m', 'Model 0.25 degree'])
    ax.set_ylabel('Fuel load (gC m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    plt.show()


def plot_FConly(fign):
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(111)
    width = 1
    spacing = 3

    bp1 = ax.boxplot(results['total'][57:,2]*50, positions=[1], showmeans=True, showfliers=False, meanprops={'marker': '.'}, whis='range', widths=width)
    bp2 = ax.boxplot(FC_total[57:], showmeans=True, positions=[2.2], showfliers=False, meanprops={'marker': '.'}, whis='range', widths=width)
    
    for bp, color in zip([bp1, bp2], ['C2', 'C0']):     # apply boxplot coloring.
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
    
    ax.set_xlim([0.1, 1 + spacing])
    
    plt.show()
#plot_FConly(1)

#plot_FCfield_line(4)
#plot_FCfield_sc(5)
#plot_FCfield_sc_500m(5, FL_total, FL_bp, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure2_v2ab_TNR')
#plot_FCfield_sc_025deg(6, FL_total025, FL025_bp, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure2_v2cd_TNR')

#plot_FCfield_sc_500m(7, FL_total_set2, FL_bp_set2, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure11_v2ab_TNR')
#plot_FCfield_sc_025deg(8, FL_total025_set2, FL025_bp_set2, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure11_v2cd_TNR')

#plot_FCfield_sc_set2(6)
#endregion \\\

print 'debug'

#region /// Fuel consumption GFED
''' GFED FC comparison '''
def load_gfed4s(res, mode=None):
    if mode == 1:   years = ['2002','2003','2004','2005','2006']
    elif mode == 2: years = Model.allyears[2:-2]    # 2002-2015
    elif mode is None:  years = list(np.arange(1997, 2015+1).astype(str))   # full GFED4 period.
    
    C = Model.loadGFED(res, 'C', years, 'Africa')
    
    DM_gfed = np.mean(np.sum(np.reshape(Model.loadGFED(res, 'DM', years, 'Africa')*1000, (len(years),12,310,310)), axis=1), axis=0)
    C_gfed = np.mean(np.sum(np.reshape(C, (len(years),12,310,310)), axis=1), axis=0)
    BA_gfed = Model.loadGFED(res, 'burned_fraction', years, 'Africa') * Model.loadGFED(res, 'grid_cell_area', ['2002','2003','2004','2005','2006'], 'Africa')
    BA_gfed = np.mean(np.sum(np.reshape(BA_gfed, (len(years),12,310,310)), axis=1), axis=0)
    
    Sf = Model.loadGFED(res, 'small_fire_fraction', years, 'Africa')
    Sf_gfed = np.mean(np.sum(np.reshape(C * Sf, (len(years),12,310,310)), axis=1), axis=0)      # emissions due to small fires.
    
    lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    return DM_gfed * lwmask*tilemask, C_gfed * lwmask*tilemask, BA_gfed * lwmask*tilemask, Sf_gfed * lwmask*tilemask
mode = 2
_, C_gfed4s, BA_gfed4s, Sf_gfed = Model.saver(lambda: load_gfed4s(0.25, mode), rdir + 'GFED4s_DM_C_BA_mode%s.npy' % mode)
_, C_gfed4s, BA_gfed4s, Sf_gfed = Model.saver(lambda: load_gfed4s(0.25), rdir + 'GFED4s_DM_C_BA_1997-2015.npy')

FC_gfed4s = C_gfed4s * Model.load_area(0.25, 'Africa')[0] / BA_gfed4s

C_gfed4 = C_gfed4s - Sf_gfed


def load_C(sdirn, res):
    sdir = wdir + 'results/' + sdirn
    mode = 2
    if res == 500:
        data = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode), sdir + 'translate_025deg_mode%s.npz' % mode)
        
    if res == 0.25:
        data = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode), sdir + 'load_025deg_mode%s.npz' % mode)
    elif res == 0.05:
        data = Model.saver(lambda: Model.load_deg(sdir, 0.05, mode), sdir + 'load_005deg_mode%s.npz' % mode)
        
    C = data['DBsum']
    BA = data['BAsum']
    FC = data['FCsum']
    
    return C, BA, FC
C_model, BA_model, FC_model = load_C('FL_025deg_Africa_'+sdate+'/', 0.25)
C_model500, BA_model500, FC_model500 = load_C('FL_500m_Africa_'+sdate+'/', 500)

C_model_T2, BA_model_T2, FC_model_T2 = load_C('FL_025deg_Africa_'+sdateT2+'/', 0.25)
C_model500_T2, BA_model500_T2, FC_model500_T2 = load_C('FL_500m_Africa_'+sdateT2+'/', 500)


def load_gfedv6(res, mode):
    if mode == 1:   years = ['2002','2003','2004','2005','2006']
    elif mode == 2: years = Model.allyears[2:-2]    # 2002-2015
    
    C_gfed4s = Model.loadGFED(res, 'C', years, 'Africa')
    DM_gfed4s = Model.loadGFED(res, 'DM', years, 'Africa')*1000
    BA_gfed4s = Model.loadGFED(res, 'burned_fraction', years, 'Africa')
    
    BA_model = Model.readdata_MODIS('BA', res, years, 'Africa')
    C_gfed = C_gfed4s * (BA_model / BA_gfed4s)
    DM_gfed = DM_gfed4s * (BA_model / BA_gfed4s)

    C_gfed[~np.isnan(C_gfed4s) & np.isnan(C_gfed)] = 0
    DM_gfed[~np.isnan(C_gfed4s) & np.isnan(C_gfed)] = 0
    
    C_gfed = np.mean(np.sum(np.reshape(C_gfed, (len(years),12,310,310)), axis=1), axis=0)
    DM_gfed = np.mean(np.sum(np.reshape(DM_gfed, (len(years),12,310,310)), axis=1), axis=0)
    
    lwmask = Model.readdata_LWMASK('LWM', res, 'Africa')
    tilemask = Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
    return DM_gfed * lwmask*tilemask, C_gfed * lwmask*tilemask
_, C_gfedv6 = Model.saver(lambda: load_gfedv6(0.25, mode), rdir + 'GFEDv6_DM_C_BA_mode%s.npy' % mode)


C_gfed = C_gfedv6.copy()

FC_gfed = C_gfed * Model.load_area(0.25, 'Africa')[0] / BA_model

FC_gfed[FC_gfed == 0] = np.nan
FC_model[FC_model == 0] = np.nan
FC_model500[FC_model500 == 0] = np.nan
FC_model_T2[FC_model_T2 == 0] = np.nan
FC_model500_T2[FC_model500_T2 == 0] = np.nan

C_model4s = C_model * BA_gfed4s / BA_model
C_model4s[~np.isnan(C_model) & np.isnan(C_model4s)] = 0
C_model5004s = C_model500 * BA_gfed4s / BA_model500
C_model5004s[~np.isnan(C_model500) & np.isnan(C_model5004s)] = 0

C_model4s_T2 = C_model_T2 * BA_gfed4s / BA_model
C_model4s_T2[~np.isnan(C_model_T2) & np.isnan(C_model4s_T2)] = 0
C_model5004s_T2 = C_model500_T2 * BA_gfed4s / BA_model500_T2
C_model5004s_T2[~np.isnan(C_model500_T2) & np.isnan(C_model5004s_T2)] = 0

C_gfed_biome = Model.biome_calc(C_gfed, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
C_model_biome = Model.biome_calc(C_model, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
C_model500_biome = Model.biome_calc(C_model500, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
C_model_biome_T2 = Model.biome_calc(C_model_T2, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
C_model500_biome_T2 = Model.biome_calc(C_model500_T2, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

FC_gfed_biome = Model.biome_calc(FC_gfed, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
FC_model_biome = Model.biome_calc(FC_model, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
FC_model500_biome = Model.biome_calc(FC_model500, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
FC_model_biome_T2 = Model.biome_calc(FC_model_T2, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
FC_model500_biome_T2 = Model.biome_calc(FC_model500_T2, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

#FC_ttest = scipy.stats.ttest_ind(FC_model[~np.isnan(FC_model)], FC_model500[~np.isnan(FC_model500)])

BA_model_biome = Model.biome_calc(BA_model / Model.load_area(0.25, 'Africa')[0], ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
BA_model500_biome = Model.biome_calc(BA_model500 / Model.load_area(0.25, 'Africa')[0], ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

FC_gfed_biome2 = np.array(C_gfed_biome[0].values()) / np.array(BA_model_biome[0].values())      # use BA_model, BA_gfed is with small fires.
FC_model_biome2 = np.array(C_model_biome[0].values()) / np.array(BA_model_biome[0].values())
FC_model500_biome2 = np.array(C_model500_biome[0].values()) / np.array(BA_model500_biome[0].values())

FC_gfed_biome2b = np.array(C_gfed_biome[4].values()) / np.array(BA_model_biome[1].values())
FC_model_biome2b = np.array(C_model_biome[4].values()) / np.array(BA_model_biome[1].values())
FC_model500_biome2b = np.array(C_model500_biome[4].values()) / np.array(BA_model500_biome[1].values())


def weighted_pdf(FC, BA, biomes, n_intervals=1000):
    
    BA[np.isnan(FC)] = np.nan
    
    lwmask = Model.readdata_LWMASK('LWM', 0.25, 'Africa', frac='no')
    area = Model.load_area(0.25, 'Africa')[0]
    land_area = lwmask * area
    
    tiles = Model.regions['NHAF'][1] + Model.regions['SHAF'][1]
    tiles = sorted(set(tiles))
    tile_mask = Model.tile_mask(0.25, tiles, frac='yes', extent='Africa')[0]
    land_area = land_area * tile_mask
    
    BFint = np.ceil((BA / area) * n_intervals)
    
    biome_dict = Model.biome_mask(['total'] + biomes.keys(), 0.25, years[len(years)/2], 'Africa')[1]
    wbiome = OrderedDict()
    for bio in ['total'] + biomes.keys():
        biome_mask = biome_dict[bio]
        w_list = []
        
        # FC_flat = (FC * biome_mask).flatten()
        land_area_biome = land_area * biome_mask
        FC_flat = (FC * land_area_biome).flatten()
        
        BFint_flat = (BFint * biome_mask * lwmask * tile_mask).flatten()    # mask with all but area.
        
        for i, bf_int in enumerate(BFint_flat):
            if bf_int > 0:
                w_list.extend(np.repeat(FC_flat[i], bf_int))
        wbiome[bio] = np.array(w_list) / np.nanmean(land_area_biome)
    
    return wbiome
FC_gfed_biomeW = weighted_pdf(FC_gfed, BA_model, biomes)
FC_model_biomeW = weighted_pdf(FC_model, BA_model, biomes)
FC_model500_biomeW = weighted_pdf(FC_model500, BA_model, biomes)
FC_model_biomeW_T2 = weighted_pdf(FC_model_T2, BA_model, biomes)
FC_model500_biomeW_T2 = weighted_pdf(FC_model500_T2, BA_model, biomes)

def plot_C_bp(fign, filename=None):
    
    textsize = 14
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    fig = plt.figure(fign, (8,8))
    
    width = 1
    spacing = 3
    xlen = len(biomes)+1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(211)
    b1 = ax.bar(x_ax, np.array(C_gfed_biome[0].values()) / 1e15, width, color='C2')
    b2 = ax.bar(x_ax + 1.2, np.array(C_model500_biome[0].values()) / 1e15, width, color='C0')
    #b3 = ax.bar(x_ax + 2.4, np.array(C_model_biome[0].values()) / 1e15, width, color='C1')
    
    #b4 = ax.bar(x_ax + 1.2, np.array(C_model500_biome_T2[0].values()) / 1e15, width, alpha=0.4, zorder=0, color='C0')
    #b5 = ax.bar(x_ax + 2.4, np.array(C_model_biome_T2[0].values()) / 1e15, width, alpha=0.4, zorder=0, color='C1')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels([])
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0,0.95])
    ax.legend([b1, b2], ['GFED4', 'model 500m'], fontsize=textsize)
    #ax.legend([b1, b2, b3], ['GFED', 'model 500m', u'model 0.25\u00b0'], fontsize=textsize)
    ax.set_ylabel('Carbon emissions (Pg C)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)
    
    fig.text(0, 1, 'a)', size=textsize, verticalalignment='top') #, weight='bold')
    
    
    ax = fig.add_subplot(212)
    bp1 = ax.boxplot(FC_gfed_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FC_model500_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    #bp3 = ax.boxplot(FC_model_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 2.4, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    for bp, color in zip([bp1, bp2], ['C2', 'C0']):
    #for bp, color in zip([bp1, bp2, bp3], ['C2', 'C0', 'C1']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
    
    l1 = ax.scatter([],[],c='C2')       # empty scatter objects to create handles with dots for legend.
    l2 = ax.scatter([],[],c='C0')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.legend([l1, l2], ['GFED4', 'model 500m'], fontsize=textsize)
    #ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp3['boxes'][0]], ['GFED4', 'model 500m', u'model 0.25\u00b0'], fontsize=textsize)
    ax.set_ylabel('Fuel consumption (g C m$^{-2}$ burned)', fontsize=textsize, position=(0,0.45))   # move ylabel slightly down to fit 'b)'.
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    # USE for the version not divided by BA.
    # ax.set_yscale('symlog', basey=2, linthreshy=0.01)
    # ax.set_yticks([0, 0.01, 0.05, 0.2, 1, 5, 20, 100, 400])
    # ax.set_ylim([0,400])
    # from matplotlib import ticker
    # ax.get_yaxis().set_major_formatter(ticker.FuncFormatter(lambda y, _: '{:g}'.format(y)))
    
    ax.set_yscale('symlog', basey=2, linthreshy=40)
    ax.set_yticks([0, 25, 50, 100, 200, 500, 1000, 2000, 4000])
    ax.set_ylim([0, 6000])
    
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    #ax.get_yaxis().set_major_formatter(ticker.StrMethodFormatter('{x:,.0f}'))
    ax.set_yticklabels(['{:,}'.format(int(x)).replace(',',' ') for x in ax.get_yticks().tolist()])
    ax.minorticks_off()
    
    fig.text(0, 0.57, 'b)', size=textsize, verticalalignment='top') #, weight='bold')
    
    
    plt.tight_layout()
    plt.subplots_adjust(hspace=0.1)
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
#plot_C_bp(7) #, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/figures_final/' + 'Figure4')


def plot_C_poster(fign, filename=None):
    
    textsize = 16
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    # Remove '4 5', '6 7', bundle '10' and '11'
    
    biomes_p = OrderedDict((k, biomes[k]) for k in ['2', '8', '9'])  # change order of dict items.
    biomes_p['6 7 10 11'] = 'Shrub/grass/crop'
    
    C_gfed4s_biome_p = Model.biome_calc(C_gfed4s, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_gfed_biome_p = Model.biome_calc(C_gfed, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model_biome_T2_p = Model.biome_calc(C_model_T2, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model500_biome_p = Model.biome_calc(C_model500, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    fig = plt.figure(fign, (8,5))
    
    width = 1
    spacing = 4
    xlen = len(biomes_p.keys())+1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(111)
    b1s = ax.bar(x_ax, np.array(C_gfed4s_biome_p[0].values()) / 1e15, width, color='C2', alpha=0.4)
    b1 = ax.bar(x_ax, np.array(C_gfed_biome_p[0].values()) / 1e15, width, color='C2')
    b2 = ax.bar(x_ax + 1.2, np.array(C_model_biome_T2_p[0].values()) / 1e15, width, color='C1')
    b3 = ax.bar(x_ax + 2.4, np.array(C_model500_biome_p[0].values()) / 1e15, width, color='C0')
    
    #b4 = ax.bar(x_ax + 1.2, np.array(C_model500_biome_T2[0].values()) / 1e15, width, alpha=0.4, zorder=0, color='C0')
    #b5 = ax.bar(x_ax + 2.4, np.array(C_model_biome_T2[0].values()) / 1e15, width, alpha=0.4, zorder=0, color='C1')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa\n(all biomes)'] + biomes_p.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0,1.15])
    #ax.legend([b1, b2], ['GFED4', 'model 500m'], fontsize=textsize)
    ax.legend([b1, b1s, b2, b3], ['GFED4', 'GFED4s', u'model 0.25\u00b0', 'model 500m'], fontsize=textsize)
    ax.set_ylabel('Carbon emissions (Pg C yr$^{-1}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)
    
    
    plt.tight_layout()
    plt.subplots_adjust(hspace=0.1)
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
#plot_C_poster(100) #, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/figures_final/' + 'Figure4_poster')


def plot_C_final(fign, filename=None):
    
    textsize = 16
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    # Remove '4 5', '6 7', bundle '10' and '11'
    
    biomes_p = OrderedDict((k, biomes[k]) for k in ['2', '8', '9'])  # change order of dict items.
    biomes_p['6 7 10 11'] = 'Shrub/grass/crop'
    
    C_gfed4s_biome_p = Model.biome_calc(C_gfed4s, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_gfed_biome_p = Model.biome_calc(C_gfed, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model_biome_T2_p = Model.biome_calc(C_model_T2, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model500_biome_p = Model.biome_calc(C_model500, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model_biome_p = Model.biome_calc(C_model, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model500_biome_T2_p = Model.biome_calc(C_model500_T2, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    fig = plt.figure(fign, (8,5))
    
    width = 1
    spacing = 4
    xlen = len(biomes_p.keys())+1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(111)
    b1s = ax.bar(x_ax, np.array(C_gfed4s_biome_p[0].values()) / 1e15, width, color='C2', alpha=0.4)
    b1 = ax.bar(x_ax, np.array(C_gfed_biome_p[0].values()) / 1e15, width, color='C2')
    b2 = ax.bar(x_ax + 1.2, np.array(C_model_biome_T2_p[0].values()) / 1e15, width, color='C1')
    b3 = ax.bar(x_ax + 2.4, np.array(C_model500_biome_p[0].values()) / 1e15, width, color='C0')
    
    for i in range(len(['total'] + biomes_p.keys())):
        ax.plot((x_ax[i]+1.2 - 0.47, x_ax[i]+1.2 + 0.47), np.repeat(np.array(C_model_biome_p[0].values())[i] / 1e15, 2), c='grey', alpha=0.6)
        ax.plot((x_ax[i]+2.4 - 0.47, x_ax[i]+2.4 + 0.47), np.repeat(np.array(C_model500_biome_T2_p[0].values())[i] / 1e15, 2), c='grey', alpha=0.6)
    
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa\n(all biomes)'] + biomes_p.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0,1.15])
    #ax.legend([b1, b2], ['GFED4', 'model 500m'], fontsize=textsize)
    ax.legend([b1, b1s, b2, b3], ['GFED4', 'GFED4s', u'0.25\u00b0 simulation', '500 m simulation'], fontsize=textsize)
    ax.set_ylabel('Carbon emissions (Pg C yr$^{-1}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)
    
    # fig.text(0, 1, 'a)', size=textsize, verticalalignment='top') #, weight='bold')
    
    
    # FC_gfed_biomeW = weighted_pdf(FC_gfed, BA_model, biomes_p)
    # FC_model_biomeW_T2 = weighted_pdf(FC_model_T2, BA_model, biomes_p)
    # FC_model500_biomeW = weighted_pdf(FC_model500, BA_model, biomes_p)
    # 
    # ax = fig.add_subplot(212)
    # bp1 = ax.boxplot(FC_gfed_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    # bp2 = ax.boxplot(FC_model_biomeW_T2.values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    # bp3 = ax.boxplot(FC_model500_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax + 2.4, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    # 
    # #for bp, color in zip([bp1, bp2], ['C2', 'C0']):
    # for bp, color in zip([bp1, bp2, bp3], ['C2', 'C1', 'C0']):
    #     plt.setp(bp['boxes'], color=color)
    #     plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
    #     plt.setp(bp['medians'], color='black')
    # 
    # l1 = ax.scatter([],[],c='C2')       # empty scatter objects to create handles with dots for legend.
    # l2 = ax.scatter([],[],c='C1')
    # l3 = ax.scatter([],[],c='C0')
    # 
    # ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    # ax.set_xticklabels(['Africa'] + biomes.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    # plt.xlim([0.1, np.max(x_ax) + spacing])
    # ax.legend([l1, l2, l3], ['GFED4', u'model 0.25\u00b0', 'model 500m'], fontsize=textsize)
    # #ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp3['boxes'][0]], ['GFED4', 'model 500m', u'model 0.25\u00b0'], fontsize=textsize)
    # ax.set_ylabel('Fuel consumption (g C m$^{-2}$ burned)', fontsize=textsize, position=(0,0.45))   # move ylabel slightly down to fit 'b)'.
    # ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    # ax.grid(axis='y', linestyle='--')
    # ax.set_axisbelow(True)  # gridlines behind plot objects.
    # 
    # # USE for the version not divided by BA.
    # # ax.set_yscale('symlog', basey=2, linthreshy=0.01)
    # # ax.set_yticks([0, 0.01, 0.05, 0.2, 1, 5, 20, 100, 400])
    # # ax.set_ylim([0,400])
    # # from matplotlib import ticker
    # # ax.get_yaxis().set_major_formatter(ticker.FuncFormatter(lambda y, _: '{:g}'.format(y)))
    # 
    # ax.set_yscale('symlog', basey=2, linthreshy=40)
    # ax.set_yticks([0, 25, 50, 100, 200, 500, 1000, 2000, 4000])
    # ax.set_ylim([0, 6000])
    # 
    # from matplotlib import ticker
    # ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    # #ax.get_yaxis().set_major_formatter(ticker.StrMethodFormatter('{x:,.0f}'))
    # ax.set_yticklabels(['{:,}'.format(int(x)).replace(',',' ') for x in ax.get_yticks().tolist()])
    # ax.minorticks_off()
    # 
    # fig.text(0, 0.57, 'b)', size=textsize, verticalalignment='top') #, weight='bold')
    # 
    plt.tight_layout()
    plt.subplots_adjust(hspace=0.1)
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
#plot_C_final(102) #, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/figures_final/' + 'Figure4_final')


def plot_C_final2(fign, filename=None):
    textsize = 19
    tickredux = 0.9  # ticklabel fontsize smaller.
    
    # Remove '4 5', '6 7', bundle '10' and '11'
    
    biomes_p = OrderedDict((k, biomes[k]) for k in ['2', '8', '9'])  # change order of dict items.
    biomes_p['6 7 10 11'] = 'Shrub/grass/crop'
    
    C_gfed4s_biome_p = Model.biome_calc(C_gfed4s, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_gfed_biome_p = Model.biome_calc(C_gfed, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model_biome_T2_p = Model.biome_calc(C_model_T2, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model500_biome_p = Model.biome_calc(C_model500, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model_biome_p = Model.biome_calc(C_model, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    C_model500_biome_T2_p = Model.biome_calc(C_model500_T2, ['total'] + biomes_p.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    fig = plt.figure(fign, (8, 5))
    
    width = 1
    spacing = 4
    xlen = len(biomes_p.keys()) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(111)
    #b1s = ax.bar(x_ax, np.array(C_gfed4s_biome_p[0].values()) / 1e15, width, color='C2', alpha=0.4)
    b1 = ax.bar(x_ax, np.array(C_gfed_biome_p[0].values()) / 1e15, width, color='C2')
    b2 = ax.bar(x_ax + 1.2, np.array(C_model_biome_p[0].values()) / 1e15, width, color='C1')
    b3 = ax.bar(x_ax + 2.4, np.array(C_model500_biome_p[0].values()) / 1e15, width, color='C0')
    
    b4 = ax.bar(x_ax + 1.2, np.array(C_model_biome_T2_p[0].values()) / 1e15, width, alpha=0.4, zorder=0, color='C1')
    b5 = ax.bar(x_ax + 2.4, np.array(C_model500_biome_T2_p[0].values()) / 1e15, width, alpha=0.4, zorder=0, color='C0')
    
    for i in range(len(['total'] + biomes_p.keys())):
        ax.plot((x_ax[i] - 0.47, x_ax[i] + 0.47), np.repeat(np.array(C_gfed4s_biome_p[0].values())[i] / 1e15, 2), c='C2')
    b1s, = ax.plot([],[], c='C2')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa\n(all biomes)'] + biomes_p.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0, 1.15])
    # ax.legend([b1, b2], ['GFED4', 'model 500m'], fontsize=textsize)
    ax.legend([b1, b1s, b2, b3], ['GFED4', 'GFED4s', u'0.25\u00b0 simulation', '500 m simulation'], fontsize=textsize)
    ax.set_ylabel('Carbon emissions (Pg C yr$^{-1}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)
    
    # fig.text(0, 1, 'a)', size=textsize, verticalalignment='top') #, weight='bold')
    
    
    # FC_gfed_biomeW = weighted_pdf(FC_gfed, BA_model, biomes_p)
    # FC_model_biomeW_T2 = weighted_pdf(FC_model_T2, BA_model, biomes_p)
    # FC_model500_biomeW = weighted_pdf(FC_model500, BA_model, biomes_p)
    # 
    # ax = fig.add_subplot(212)
    # bp1 = ax.boxplot(FC_gfed_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    # bp2 = ax.boxplot(FC_model_biomeW_T2.values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    # bp3 = ax.boxplot(FC_model500_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax + 2.4, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    # 
    # #for bp, color in zip([bp1, bp2], ['C2', 'C0']):
    # for bp, color in zip([bp1, bp2, bp3], ['C2', 'C1', 'C0']):
    #     plt.setp(bp['boxes'], color=color)
    #     plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
    #     plt.setp(bp['medians'], color='black')
    # 
    # l1 = ax.scatter([],[],c='C2')       # empty scatter objects to create handles with dots for legend.
    # l2 = ax.scatter([],[],c='C1')
    # l3 = ax.scatter([],[],c='C0')
    # 
    # ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    # ax.set_xticklabels(['Africa'] + biomes.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    # plt.xlim([0.1, np.max(x_ax) + spacing])
    # ax.legend([l1, l2, l3], ['GFED4', u'model 0.25\u00b0', 'model 500m'], fontsize=textsize)
    # #ax.legend([bp1['boxes'][0], bp2['boxes'][0], bp3['boxes'][0]], ['GFED4', 'model 500m', u'model 0.25\u00b0'], fontsize=textsize)
    # ax.set_ylabel('Fuel consumption (g C m$^{-2}$ burned)', fontsize=textsize, position=(0,0.45))   # move ylabel slightly down to fit 'b)'.
    # ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    # ax.grid(axis='y', linestyle='--')
    # ax.set_axisbelow(True)  # gridlines behind plot objects.
    # 
    # # USE for the version not divided by BA.
    # # ax.set_yscale('symlog', basey=2, linthreshy=0.01)
    # # ax.set_yticks([0, 0.01, 0.05, 0.2, 1, 5, 20, 100, 400])
    # # ax.set_ylim([0,400])
    # # from matplotlib import ticker
    # # ax.get_yaxis().set_major_formatter(ticker.FuncFormatter(lambda y, _: '{:g}'.format(y)))
    # 
    # ax.set_yscale('symlog', basey=2, linthreshy=40)
    # ax.set_yticks([0, 25, 50, 100, 200, 500, 1000, 2000, 4000])
    # ax.set_ylim([0, 6000])
    # 
    # from matplotlib import ticker
    # ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    # #ax.get_yaxis().set_major_formatter(ticker.StrMethodFormatter('{x:,.0f}'))
    # ax.set_yticklabels(['{:,}'.format(int(x)).replace(',',' ') for x in ax.get_yticks().tolist()])
    # ax.minorticks_off()
    # 
    # fig.text(0, 0.57, 'b)', size=textsize, verticalalignment='top') #, weight='bold')
    # 
    plt.tight_layout()
    plt.subplots_adjust(hspace=0.1)
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
#plot_C_final2(102) #, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure4_final2_TNR')

#endregion \\\

print 'debug'

#region /// Resolution comparison, visual
''' Resolution comparison '''
# nf = no fire (BA=0), b = per biome turnover, m = modified burn fraction (mbf), bm = per biome turnover with mbf, ba = per biome BA, bp = per biome BA, FTC, NTV and Fpar, mort4 = mortality=0.4, mort0 = mortality=0.0

mode = 2
sdirn = 'FL_025deg_Africa_'+sdate+'/' #'run4b_025deg_Africa_v6_f32/'
sdir = wdir + 'results/' + sdirn
data025 = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode), sdir + 'load_025deg_mode%s.npz' % mode)
data025nf = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode, fmode='off'), sdir + 'load_025deg_mode%s_nf.npz' % mode)
data025bnf = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, fmode='off'), sdir + 'load_025deg_mode%s_b_nf.npz' % mode)
data025bpnf = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, fmode='off', addtxt='perc'), sdir + 'load_025deg_mode%s_bp_nf.npz' % mode)

data025b = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode), sdir + 'load_025deg_mode%s_b.npz' % mode)
data025m = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode, addtxt='MBF'), sdir + ' load_025deg_mode%s_mbf.npz' % mode)
data025bm = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='MBF'), sdir + 'load_025deg_mode%s_b_mbf.npz' % mode)
data025bp = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='perc'), sdir + 'load_025deg_mode%s_bp.npz' % mode)
data025bpm = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMBF'), sdir + 'load_025deg_mode%s_bp_mbf.npz' % mode)
data025mort0 = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode, addtxt='MORT00'), sdir + 'load_025deg_mode%s_mort0.npz' % mode)
data025mort4 = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode, addtxt='MORT04'), sdir + 'load_025deg_mode%s_mort4.npz' % mode)
data025mort0bp = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMORT00'), sdir + 'load_025deg_mode%s_bp_mort0.npz' % mode)
data025mort4bp = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMORT04'), sdir + 'load_025deg_mode%s_bp_mort4.npz' % mode)
data025mort0m = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode, addtxt='MBFMORT00'), sdir + 'load_025deg_mode%s_mbf_mort0.npz' % mode)
data025mort4m = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode, addtxt='MBFMORT04'), sdir + 'load_025deg_mode%s_mbf_mort4.npz' % mode)
data025mort0bpm = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMBFMORT00'), sdir + 'load_025deg_mode%s_bp_mbf_mort0.npz' % mode)
data025mort4bpm = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMBFMORT04'), sdir + 'load_025deg_mode%s_bp_mbf_mort4.npz' % mode)

data025bpa = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percBA'), sdir + 'load_025deg_mode%s_bpa.npz' % mode)
data025bpr = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percR'), sdir + 'load_025deg_mode%s_bpr.npz' % mode)
data025bpn = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percNOMISC'), sdir + 'load_025deg_mode%s_bpn.npz' % mode)

data025mortX4 = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMORTX4'), sdir + 'load_025deg_mode%s_bp_mortx4.npz' % mode)
data025mortX42 = Model.saver(lambda: Model.load_deg_perbiome(sdir, 0.25, mode, addtxt='percMORTX42'), sdir + 'load_025deg_mode%s_bp_mortx42.npz' % mode)

#mortX42 is self.mortality4[month,:,:] = self.mortality4perc[int(self.biome)][month,:,:], NOT DIVIDED BY LCperc.
#mortX43 is self.mortality = self.mortality * self.LCperc[int(self.biome)][0]
#bpa is per biome with f_cw and turnover, and with BA, but without FTC, NTV, Fpar
#bpr is per biome with f_cw and turnover, and with FTC, NTV, Fpar, but without BA
#bpn is per biome without f_cw and turnover, and with BA, FTC, NTV, Fpar. So only aggr. fix, no misclassification fix.

sdirn = 'FL_500m_Africa_'+sdate+'/' #'run5_500m_Africa_v6_f32/'
sdir = wdir + 'results/' + sdirn
data500 = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode), sdir + 'translate_025deg_mode%s.npz' % mode)
data500nf = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode, fmode='off'), sdir + 'translate_025deg_mode%s_nf.npz' % mode)
data500mort0 = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode, addtxt='MORT00'), sdir + 'translate_025deg_mode%s_mort00.npz' % mode)
data500mort4 = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode, addtxt='MORT04', avail=True), sdir + 'translate_025deg_mode%s_mort04.npz' % mode)

sdir = 'FL_500m_Africa_'+sdate+'/'
sdir = wdir + 'results/' + sdirn
data500_013 = Model.saver(lambda: Model.translate_to_deg(sdir, 0.125, mode), sdir + 'translate_013deg_mode%s.npz' % mode)
data500_005 = Model.saver(lambda: Model.translate_to_deg(sdir, 0.05, mode), sdir + 'translate_005deg_mode%s.npz' % mode)

sdirn = 'FL_005deg_Africa_'+sdate+'/'
sdir = wdir + 'results/' + sdirn
data005 = Model.saver(lambda: Model.load_deg(sdir, 0.05, mode), sdir + 'load_005deg_mode%s.npz' % mode)
data005nf = Model.saver(lambda: Model.load_deg(sdir, 0.05, mode, fmode='off'), sdir + 'load_005deg_mode%s_nf.npz' % mode)

sdirn = 'FL_013deg_Africa_'+sdate+'/'
sdir = wdir + 'results/' + sdirn
data013 = Model.saver(lambda: Model.load_deg(sdir, 0.125, mode), sdir + 'load_013deg_mode%s.npz' % mode)
data013nf = Model.saver(lambda: Model.load_deg(sdir, 0.125, mode, fmode='off'), sdir + 'load_013deg_mode%s_nf.npz' % mode)



FL_025 = data025['FL']
FL_500 = data500['FL']
FC_025 = data025['FCsum']
FC_500 = data500['FCsum']
DB_025 = data025['DBsum']
DB_500 = data500['DBsum']

FL_025nf = data025nf['FL']
FL_500nf = data500nf['FL']
FL_025b = data025b['FL']
FC_025b = data025b['FCsum']
FL_025bnf = data025bnf['FL']
FL_025m = data025m['FL']
FC_025m = data025m['FCsum']
FL_025bm = data025bm['FL']
FC_025bm = data025bm['FCsum']
FL_025bp = data025bp['FL']
FC_025bp = data025bp['FCsum']
FL_025bpm = data025bpm['FL']
FC_025bpm = data025bpm['FCsum']
FL_025bpnf = data025bpnf['FL']
FL_025mort = data025mort0['FL']
FC_025mort = data025mort0['FCsum']
FL_500mort = data500mort0['FL']
FC_500mort = data500mort0['FCsum']
FL_025mortbp = data025mort0bp['FL']
FC_025mortbp = data025mort0bp['FCsum']
FL_025mortm = data025mort0m['FL']
FC_025mortm = data025mort0m['FCsum']
FL_025mortbpm = data025mort0bpm['FL']
FC_025mortbpm = data025mort0bpm['FCsum']

FL_025bpa = data025bpa['FL']
FC_025bpa = data025bpa['FCsum']
FL_025bpr = data025bpr['FL']
FC_025bpr = data025bpr['FCsum']
FL_025bpn = data025bpn['FL']
FC_025bpn = data025bpn['FCsum']

FL_025mortX4bp = data025mortX4['FL']
FC_025mortX4bp = data025mortX4['FCsum']
FL_025mortX42bp = data025mortX42['FL']
FC_025mortX42bp = data025mortX42['FCsum']

mask = Model.readdata_LWMASK('LWM', 0.25, 'Africa', frac='no') * Model.tile_mask(0.25, tiles, frac='no', extent='Africa')[0]
FL_005 = Model.translate_deg_to_coarser(data005['FL'], 0.05, 0.25, False) * mask
FL_013 = Model.translate_deg_to_coarser(data013['FL'], 0.125, 0.25, False) * mask
FC_005 = Model.translate_deg_to_coarser(data005['FCsum'], 0.05, 0.25, False) * mask
FC_013 = Model.translate_deg_to_coarser(data013['FCsum'], 0.125, 0.25, False) * mask

def abs_diff(x1, x2, mode='norm'):
    
    if mode == 'norm':
        return x1 - x2
    
    elif mode == 'rev':
        return x2 - x1

def rel_diff(x1, x2, mode='log'):
    
    if mode=='norm':
        return (x1 - x2) / x2
    
    elif mode == 'rev':
        rel = (x2 - x1) / x1
        rel[(x1==0) | (x2==0)] = np.nan
    
    elif mode == 'log':
        return np.log(x1 / x2)
    
    elif mode == 'logrev':
        return np.log(x2 / x1)

FL_abs = abs_diff(FL_025, FL_500)
FC_abs = abs_diff(FC_025, FC_500)
DB_abs = abs_diff(DB_025, DB_500)

FL_rel = rel_diff(FL_025, FL_500)
FC_rel = rel_diff(FC_025, FC_500)
DB_rel = rel_diff(DB_025, DB_500)     # Exactly the same as FC_rel.

FL_relnf = rel_diff(FL_025nf, FL_500nf)
FL_relb = rel_diff(FL_025b, FL_500)
FC_relb = rel_diff(FC_025b, FC_500)
FL_relbnf = rel_diff(FL_025bnf, FL_500nf)
FL_relm = rel_diff(FL_025m, FL_500)
FC_relm = rel_diff(FC_025m, FC_500)
FL_relbm = rel_diff(FL_025bm, FL_500)
FC_relbm = rel_diff(FC_025bm, FC_500)
FL_relbp = rel_diff(FL_025bp, FL_500)
FC_relbp = rel_diff(FC_025bp, FC_500)
FL_relbpm = rel_diff(FL_025bpm, FL_500)
FC_relbpm = rel_diff(FC_025bpm, FC_500)
FL_relbpnf = rel_diff(FL_025bpnf, FL_500nf)
FL_relmort = rel_diff(FL_025mort, FL_500mort)
FC_relmort = rel_diff(FC_025mort, FC_500mort)
FL_relmortbp = rel_diff(FL_025mortbp, FL_500mort)
FC_relmortbp = rel_diff(FC_025mortbp, FC_500mort)
FL_relmortm = rel_diff(FL_025mortm, FL_500mort)
FC_relmortm = rel_diff(FC_025mortm, FC_500mort)
FL_relmortbpm = rel_diff(FL_025mortbpm, FL_500mort)
FC_relmortbpm = rel_diff(FC_025mortbpm, FC_500mort)

FL_relbpa = rel_diff(FL_025bpa, FL_500)
FC_relbpa = rel_diff(FC_025bpa, FC_500)
FL_relbpr = rel_diff(FL_025bpr, FL_500)
FC_relbpr = rel_diff(FC_025bpr, FC_500)
FL_relbpn = rel_diff(FL_025bpn, FL_500)
FC_relbpn = rel_diff(FC_025bpn, FC_500)

FL_relmortX4bp = rel_diff(FL_025mortX4bp, FL_500)
FC_relmortX4bp = rel_diff(FC_025mortX4bp, FC_500)
FL_relmortX42bp = rel_diff(FL_025mortX42bp, FL_500)
FC_relmortX42bp = rel_diff(FC_025mortX42bp, FC_500)


def res_transition(fign, filename=None):
    
    FL_025 = data025['FL']
    FL_013 = data013['FL']
    FL_005 = data005['FL']
    FL_500 = data500['FL']
    # FL_500_013 = data500_013['FL']
    # FL_500_005 = data500_005['FL']
    
    FC_025 = data025['DBsum']
    FC_013 = data013['DBsum']
    FC_005 = data005['DBsum']
    FC_500 = data500['DBsum']
    # FC_500_013 = data500_013['DBsum']
    # FC_500_005 = data500_005['DBsum']
    
    mask = Model.readdata_LWMASK('LWM', 0.25, 'Africa', frac='no') * Model.tile_mask(0.25, tiles, frac='no', extent='Africa')[0]
    FL_005 = Model.translate_deg_to_coarser(FL_005, 0.05, 0.25) * mask
    FL_013 = Model.translate_deg_to_coarser(FL_013, 0.125, 0.25) * mask
    FC_005 = Model.translate_deg_to_coarser(FC_005, 0.05, 0.25) * mask
    FC_013 = Model.translate_deg_to_coarser(FC_013, 0.125, 0.25) * mask
    
    FL_abs025 = abs_diff(FL_025, FL_500)
    FL_abs013 = abs_diff(FL_013, FL_500)
    FL_abs005 = abs_diff(FL_005, FL_500)
    FC_abs025 = abs_diff(FC_025, FC_500)
    FC_abs013 = abs_diff(FC_013, FC_500)
    FC_abs005 = abs_diff(FC_005, FC_500)
    
    FL_rel025 = rel_diff(FL_025, FL_500)
    FL_rel013 = rel_diff(FL_013, FL_500)
    FL_rel005 = rel_diff(FL_005, FL_500)
    FC_rel025 = rel_diff(FC_025, FC_500)
    FC_rel013 = rel_diff(FC_013, FC_500)
    FC_rel005 = rel_diff(FC_005, FC_500)
    
    bmask025 = Model.biome_mask(['total'] + biomes.keys(), 0.25, years[len(years)/2], 'Africa')[1]
    LC005 = Model.readdata_MODIS('LC2', 0.05, years[len(years)/2], 'Africa')
    
    cutoff = 0
    FL_rel025, _ = Model.perc_cut(FL_rel025, cutoff)
    FL_rel013, _ = Model.perc_cut(FL_rel013, cutoff)
    FL_rel005, _ = Model.perc_cut(FL_rel005, cutoff)
    FC_rel025, _ = Model.perc_cut(FC_rel025, cutoff)
    FC_rel013, _ = Model.perc_cut(FC_rel013, cutoff)
    FC_rel005, _ = Model.perc_cut(FC_rel005, cutoff)
    
    FL_abs025_biome = Model.biome_calc(FL_abs025, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FL_abs013_biome = Model.biome_calc(FL_abs013, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FL_abs005_biome = Model.biome_calc(FL_abs005, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_abs025_biome = Model.biome_calc(FC_abs025, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_abs013_biome = Model.biome_calc(FC_abs013, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_abs005_biome = Model.biome_calc(FC_abs005, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    FL_rel025_biome = Model.biome_calc(FL_rel025, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FL_rel013_biome = Model.biome_calc(FL_rel013, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FL_rel005_biome = Model.biome_calc(FL_rel005, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_rel025_biome = Model.biome_calc(FC_rel025, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_rel013_biome = Model.biome_calc(FC_rel013, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_rel005_biome = Model.biome_calc(FC_rel005, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    
    textsize = 16
    tickredux = 0.9  # ticklabel fontsize smaller.
    
    fig = plt.figure(100, (10, 6))
    
    axres = np.array([0.005, 0.05, 0.125, 0.25])
    axresp = axres.copy()
    #axresp = np.log(1/axres)    # x axis values for plotting.
    
    colorlist = ['black', 'C0', 'C0', 'C3', 'C1', 'C1', 'C2', 'C2']
    stylelist = ['-','-',':','-','-',':','-',':']
    
    def func(x, a, b, c):   return a * np.log(x+c) + b
    #def func(x, a, b):      return a * np.log(x) + b
    #def func(x, a, b, c):   return a * np.exp(x+c) + b
    #def func(x, a, b, c):   return a * x**2 + b * x + c
    #def func(x, a, b, c):   return a * (x - b)**2 + c
    
    
    ''' Subplot 1 '''
    ax = fig.add_subplot(121)
    pcov_FL = OrderedDict()
    popt_FL = OrderedDict()
    for i, b in enumerate(['total'] + biomes.keys()):
        
        ax.scatter(axresp, [0, FL_abs005_biome[1][b], FL_abs013_biome[1][b], FL_abs025_biome[1][b]], c=colorlist[i])
        #ax.plot(axres, [0, FL_abs005_biome[1][b], FL_abs013_biome[1][b], FL_abs025_biome[1][b]], c=colorlist[i], linestyle=stylelist[i])
        
        try:
            y_FL = np.array([0, FL_abs005_biome[1][b], FL_abs013_biome[1][b], FL_abs025_biome[1][b]])
            popt_FL[b], pcov_FL[b] = scipy.optimize.curve_fit(func, axres, y_FL)
            axres_fit = np.linspace(axresp[0], axresp[-1], 50)
            #axres_fit = np.linspace(0, axresp[-1], 50)
            ax.plot(axres_fit, func(axres_fit, *popt_FL[b]), c=colorlist[i], linestyle=stylelist[i])
        except:
            ax.plot(axresp, [0, FL_abs005_biome[1][b], FL_abs013_biome[1][b], FL_abs025_biome[1][b]], c=colorlist[i], linestyle=stylelist[i], alpha=0.5)
        
    for axr in axresp:
        ax.axvline(axr, linestyle='--', alpha=0.5, c='black', zorder=0)
    
    FL_min_v1 = np.min(np.array(popt_FL.values()), axis=0)
    FL_max_v1 = np.max(np.array(popt_FL.values()), axis=0)
    FL_min_v2 = popt_FL['2']
    FL_max_v2 = popt_FL['6 7']
    
    boxprops = dict(boxstyle='round', facecolor='white', alpha=0.5)

    if len(popt_FL.values()[0]) == 3:
        ax.text(0.25+0.02, FL_abs025_biome[1]['2']-10, '%.3g log( x + %.1g ) - %.3g' % (FL_min_v2[0], FL_min_v2[2], np.abs(FL_min_v2[1])), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
        ax.text(0.25+0.02, FL_abs025_biome[1]['6 7']-18, '%.3g log( x + %.1g ) - %.3g' % (FL_max_v2[0], FL_max_v2[2], np.abs(FL_max_v2[1])), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
    elif len(popt_FL.values()[0]) == 2:
        ax.text(0.25+0.02, FL_abs025_biome[1]['2']-10, '%.3g log( x ) - %.3g' % (FL_min_v2[0], np.abs(FL_min_v2[1])), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
        ax.text(0.25+0.02, FL_abs025_biome[1]['6 7']-18, '%.3g log( x ) - %.3g' % (FL_max_v2[0], np.abs(FL_max_v2[1])), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
    
    # example:
    # reg025 = scipy.stats.linregress(results['total'][:, 0] * 50, FL_total)
    # fit025 = np.polyfit(results['total'][:, 0] * 50, FL_total, 1);
    # fit_fn025 = np.poly1d(fit025)
    # pl1, = ax.plot(results['total'][:, 0] * 50, fit_fn025(results['total'][:, 0] * 50), color='black', alpha=0.9, zorder=1)

    #ax.set_yscale('symlog', basey=np.e, linthreshy=0.005)
    #ax.set_xscale('log', basex=np.e)
    #ax.set_xscale('symlog', basey=2, linthreshy=10)
    ax.set_xticks(axresp)
    ax.set_xticklabels(['500m', r'$0.05\degree$', r'$0.125\degree$', r'$0.25\degree$'], fontsize=textsize*tickredux)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.set_ylim([-600, 0])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()
    
    ax.set_xlabel('Spatial resolution', fontsize=textsize)
    ax.set_ylabel('Difference in AGBL (g C m$^{-2}$)', fontsize=textsize)
    
    fig.text(0.02, 0.99, '(a)', size=textsize, verticalalignment='top')
    
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    pl_legend = []
    for i, b in enumerate(['total'] + biomes.keys()):
        pl, = ax.plot([], [], linestyle=stylelist[i], c=colorlist[i], marker='o')
        pl_legend.append(pl)
    ax.legend(pl_legend, ['Africa (all biomes)'] + biomes.values(), fontsize=textsize*0.8, loc=[0.01,0.01], labelspacing=0.3, handletextpad=0.3, borderpad=0.25)
    
    
    ''' Subplot 2 '''
    ax = fig.add_subplot(122)
    pcov_FC = OrderedDict()
    popt_FC = OrderedDict()
    for i, b in enumerate(['total'] + biomes.keys()):
        
        ax.scatter(axresp, [0, FC_abs005_biome[1][b], FC_abs013_biome[1][b], FC_abs025_biome[1][b]], c=colorlist[i])
        #ax.plot(axres, [0, FC_abs005_biome[1][b], FC_abs013_biome[1][b], FC_abs025_biome[1][b]], c=colorlist[i], linestyle=stylelist[i])
        
        if b in ['total', '8']:
            ax.plot(axresp, [0, FC_abs005_biome[1][b], FC_abs013_biome[1][b], FC_abs025_biome[1][b]], c=colorlist[i], linestyle=stylelist[i], alpha=0.5)
        else:
            y_FC = np.array([0, FC_abs005_biome[1][b], FC_abs013_biome[1][b], FC_abs025_biome[1][b]])
            popt_FC[b], pcov_FC[b] = scipy.optimize.curve_fit(func, axres, y_FC)
            axres_fit = np.linspace(axresp[0], axresp[-1], 50)
            #axres_fit = np.linspace(0, axresp[-1], 50)
            try:
                ax.plot(axres_fit, func(axres_fit, *popt_FC[b]), c=colorlist[i], linestyle=stylelist[i])
            except:
                pass
    
    for axr in axresp:
        ax.axvline(axr, linestyle='--', alpha=0.5, c='black', zorder=0)
    ax.axhline(0, c='black', zorder=0)
    
    FC_min_v1 = np.min(np.array(popt_FC.values()), axis=0)
    FC_max_v1 = np.max(np.array(popt_FC.values()), axis=0)
    FC_min_v2 = popt_FC['9']
    FC_max_v2 = popt_FC['2']

    if len(popt_FC.values()[0]) == 3:
        ax.text(0.25-0.015, FC_abs025_biome[1]['9'], '%.3g log( x - %.1g ) - %.3g' % (FC_min_v2[0], np.abs(FC_min_v2[2]), np.abs(FC_min_v2[1])), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
        ax.text(0.25-0.015, FC_abs025_biome[1]['2'], '%.3g log( x + %.2g ) + %.3g' % (FC_max_v2[0], FC_max_v2[2], FC_max_v2[1]), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
    elif len(popt_FC.values()[0]) == 2:
        ax.text(0.25-0.015, FC_abs025_biome[1]['9'], '%.3g log( x ) - %.3g' % (FC_min_v2[0], np.abs(FC_min_v2[1])), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
        ax.text(0.25-0.015, FC_abs025_biome[1]['2'], '%.3g log( x ) + %.3g' % (FC_max_v2[0], FC_max_v2[1]), ha='right', va='top', fontsize=textsize*0.8, bbox=boxprops)
    
    #ax.set_yscale('symlog', basey=np.e, linthreshy=0.005)
    #ax.set_xscale('log', basex=np.e)
    #ax.set_xscale('symlog', basey=2) #, linthreshy=0.5)
    ax.set_xticks(axresp)
    ax.set_xticklabels(['500m', r'$0.05\degree$', r'$0.125\degree$', r'$0.25\degree$'], fontsize=textsize*tickredux)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.set_ylim([-6, 8])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()
    
    ax.set_xlabel('Spatial resolution', fontsize=textsize)
    ax.set_ylabel('Difference in emissions (g C m$^{-2}$)', fontsize=textsize)

    fig.text(0.52, 0.99, '(b)', size=textsize, verticalalignment='top')
    
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    plt.tight_layout()
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
#res_transition(100, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure13_3_TNR_new')

print 'debug'



def plot_test_separate(fign):
    
    Biome_rel = FL_rel - FL_relb
    Biomep_rel = FL_rel - FL_relbp
    Fire_rel = FL_rel - FL_relnf
    MBF_rel = FL_rel - FL_relm
    BiomeFC_rel = FC_rel - FC_relb
    BiomepFC_rel = FC_rel - FC_relbp
    MBFFC_rel = FC_rel - FC_relm
    Biomep_rel = Biomep_rel - Biome_rel
    BiomepFC_rel = BiomepFC_rel - BiomeFC_rel
    Rest_rel = FL_rel - (Biome_rel + Biomep_rel + Fire_rel + MBF_rel)
    RestFC_rel = FC_rel - (BiomeFC_rel + BiomepFC_rel + MBFFC_rel)

    Biome_rel, _ = Model.perc_cut(Biome_rel, 0)
    Biomep_rel, _ = Model.perc_cut(Biomep_rel, 0)
    Fire_rel, _ = Model.perc_cut(Fire_rel, 0)
    MBF_rel, _ = Model.perc_cut(MBF_rel, 0)
    BiomeFC_rel, _ = Model.perc_cut(BiomeFC_rel, 0)
    BiomepFC_rel, _ = Model.perc_cut(BiomepFC_rel, 0)
    MBFFC_rel, _ = Model.perc_cut(MBFFC_rel, 0)
    Rest_rel, _ = Model.perc_cut(Rest_rel, 0)
    RestFC_rel, _ = Model.perc_cut(RestFC_rel, 0)
    FL_rel_pc, _ = Model.perc_cut(FL_rel, 0)
    FC_rel_pc, _ = Model.perc_cut(FC_rel, 0)
    
    
    FL_rel_biome = Model.biome_calc(FL_rel_pc, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    FC_rel_biome = Model.biome_calc(FC_rel_pc, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    Fire_rel_biome = Model.biome_calc(Fire_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    Biome_rel_biome = Model.biome_calc(Biome_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MBF_rel_biome = Model.biome_calc(MBF_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    BiomeFC_rel_biome = Model.biome_calc(BiomeFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MBFFC_rel_biome = Model.biome_calc(MBFFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    Biomep_rel_biome = Model.biome_calc(Biomep_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    BiomepFC_rel_biome = Model.biome_calc(BiomepFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    Rest_rel_biome = Model.biome_calc(Rest_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    RestFC_rel_biome = Model.biome_calc(RestFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    fig = plt.figure(fign, (8, 10))

    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)

    ax = fig.add_subplot(111)
    ''' Average relative difference '''  # This is correct, relative average difference is not useful.

    def stacked_bars(barlist, colorlist, offset=0):
        cumpos = np.zeros(xlen)
        cumneg = np.zeros(xlen)
        blist = []
        for i, baritem in enumerate(barlist):
            baritem_pos = np.array(baritem)
            baritem_neg = np.array(baritem)
            baritem_pos[baritem_pos < 0] = 0
            baritem_neg[baritem_neg > 0] = 0
            
            b = ax.bar(x_ax + offset, baritem_pos, width, bottom=cumpos, color=colorlist[i], alpha=0.4)
            ax.bar(x_ax + offset, baritem_neg, width, bottom=cumneg, color=colorlist[i], alpha=0.4)
            
            cumpos = cumpos + baritem_pos
            cumneg = cumneg + baritem_neg
            blist.append(b)
            
        return blist

    barlist = [Biome_rel_biome[1].values(), Biomep_rel_biome[1].values(), Fire_rel_biome[1].values(), MBF_rel_biome[1].values(), Rest_rel_biome[1].values()]
    colorlist = ['C0', 'blue', 'red', 'yellow', 'grey']
    FL_blist = stacked_bars(barlist, colorlist)

    barlist = [BiomeFC_rel_biome[1].values(), BiomepFC_rel_biome[1].values(), MBFFC_rel_biome[1].values(), RestFC_rel_biome[1].values()]
    colorlist = ['C1', 'orange', 'yellow', 'grey']
    FC_blist = stacked_bars(barlist, colorlist, offset=1.2)

    pl1 = ax.scatter(x_ax, FL_rel_biome[1].values(), color='C0', marker='s', zorder=5)
    pl2 = ax.scatter(x_ax + 1.2, FC_rel_biome[1].values(), color='C1', marker='s', zorder=5)

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45, ha='right', rotation_mode='anchor')
    ax.set_xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([-0.35, 0.85])
    ax.axhline(color='black')
    ax.legend([pl1, pl2, FL_blist[0], FL_blist[1], FL_blist[2], FC_blist[0], FC_blist[1], FC_blist[2], FC_blist[3]],
              ['FL', 'FC', 'FL - biome misclass.', 'FL - average aggr.', 'FL - fire', 'FC - biome misclass.', 'FC - average aggr.', 'Fire return (MBF)', 'Rest'])
    ax.set_ylabel('Relative difference (gC m$^{-2}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.

    plt.show()
#plot_test_separate(1)

def plot_test_cumulative(fign):
    
    Biome_rel = FL_rel - FL_relb
    Biomep_rel = FL_relb - FL_relbp
    MBF_rel = FL_relbp - FL_relbpm
    Fire_rel = FL_relbpm - FL_relbpnf
    BiomeFC_rel = FC_rel - FC_relb
    BiomepFC_rel = FC_relb - FC_relbp
    MBFFC_rel = FC_relbp - FC_relbpm
    Rest_rel = FL_relbpnf.copy()
    RestFC_rel = FC_relbpm.copy()
    
    Biome_rel, _ = Model.perc_cut(Biome_rel, 0)
    Biomep_rel, _ = Model.perc_cut(Biomep_rel, 0)
    Fire_rel, _ = Model.perc_cut(Fire_rel, 0)
    MBF_rel, _ = Model.perc_cut(MBF_rel, 0)
    BiomeFC_rel, _ = Model.perc_cut(BiomeFC_rel, 0)
    BiomepFC_rel, _ = Model.perc_cut(BiomepFC_rel, 0)
    MBFFC_rel, _ = Model.perc_cut(MBFFC_rel, 0)
    Rest_rel, _ = Model.perc_cut(Rest_rel, 0)
    RestFC_rel, _ = Model.perc_cut(RestFC_rel, 0)
    FL_rel_pc, _ = Model.perc_cut(FL_rel, 0)
    FC_rel_pc, _ = Model.perc_cut(FC_rel, 0)
    
    
    FL_rel_biome = Model.biome_calc(FL_rel_pc, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    FC_rel_biome = Model.biome_calc(FC_rel_pc, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    Fire_rel_biome = Model.biome_calc(Fire_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    Biome_rel_biome = Model.biome_calc(Biome_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MBF_rel_biome = Model.biome_calc(MBF_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    BiomeFC_rel_biome = Model.biome_calc(BiomeFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MBFFC_rel_biome = Model.biome_calc(MBFFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    Biomep_rel_biome = Model.biome_calc(Biomep_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    BiomepFC_rel_biome = Model.biome_calc(BiomepFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    Rest_rel_biome = Model.biome_calc(Rest_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    RestFC_rel_biome = Model.biome_calc(RestFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

    fig = plt.figure(fign, (8, 10))

    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)

    ax = fig.add_subplot(111)
    ''' Average relative difference '''  # This is correct, relative average difference is not useful.

    def stacked_bars(barlist, colorlist, offset=0):
        cumpos = np.zeros(xlen)
        cumneg = np.zeros(xlen)
        blist = []
        for i, baritem in enumerate(barlist):
            baritem_pos = np.array(baritem)
            baritem_neg = np.array(baritem)
            baritem_pos[baritem_pos < 0] = 0
            baritem_neg[baritem_neg > 0] = 0

            b = ax.bar(x_ax + offset, baritem_pos, width, bottom=cumpos, color=colorlist[i], alpha=0.4)
            ax.bar(x_ax + offset, baritem_neg, width, bottom=cumneg, color=colorlist[i], alpha=0.4)

            cumpos = cumpos + baritem_pos
            cumneg = cumneg + baritem_neg
            blist.append(b)

        return blist

    barlist = [Biome_rel_biome[1].values(), Biomep_rel_biome[1].values(), Fire_rel_biome[1].values(), MBF_rel_biome[1].values(), Rest_rel_biome[1].values()]
    colorlist = ['C0', 'blue', 'red', 'yellow', 'grey']
    FL_blist = stacked_bars(barlist, colorlist)

    barlist = [BiomeFC_rel_biome[1].values(), BiomepFC_rel_biome[1].values(), MBFFC_rel_biome[1].values(), RestFC_rel_biome[1].values()]
    colorlist = ['C1', 'orange', 'yellow', 'grey']
    FC_blist = stacked_bars(barlist, colorlist, offset=1.2)

    pl1 = ax.scatter(x_ax, FL_rel_biome[1].values(), color='C0', marker='s', zorder=5)
    pl2 = ax.scatter(x_ax + 1.2, FC_rel_biome[1].values(), color='C1', marker='s', zorder=5)

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45, ha='right', rotation_mode='anchor')
    ax.set_xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([-0.35, 0.85])
    ax.axhline(color='black')
    ax.legend([pl1, pl2, FL_blist[0], FL_blist[1], FL_blist[2], FC_blist[0], FC_blist[1], FC_blist[2], FC_blist[3]],
              ['FL', 'FC', 'FL - biome misclass.', 'FL - average aggr.', 'FL - fire', 'FC - biome misclass.', 'FC - average aggr.', 'Fire return (MBF)', 'Rest'])
    ax.set_ylabel('Relative difference (gC m$^{-2}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.

    plt.show()
#plot_test_cumulative(2)

def plot_factorials(fign):
    
    # A = biome misclassification
    # B = biome misclassification + average aggr.
    # C = fire off
    # D = MBF
    
    A_rel = FL_relb.copy()    # Biome_rel
    B_rel = FL_relbp.copy()   # Biomep_rel
    C_rel = FL_relnf.copy()   # Fire_rel
    D_rel = FL_relm.copy()    # MBF_rel
    AC_rel = FL_relbnf.copy()
    AD_rel = FL_relbm.copy()
    BC_rel = FL_relbpnf.copy()
    BD_rel = FL_relbpm.copy()
    
    E_rel = FC_relb.copy()
    F_rel = FC_relbp.copy()
    G_rel = FC_relm.copy()
    EG_rel = FC_relbm.copy()
    FG_rel = FC_relbpm.copy()
    
    A_rel, _ = Model.perc_cut(A_rel, 0)
    B_rel, _ = Model.perc_cut(B_rel, 0)
    C_rel, _ = Model.perc_cut(C_rel, 0)
    D_rel, _ = Model.perc_cut(D_rel, 0)
    AC_rel, _ = Model.perc_cut(AC_rel, 0)
    AD_rel, _ = Model.perc_cut(AD_rel, 0)
    BC_rel, _ = Model.perc_cut(BC_rel, 0)
    BD_rel, _ = Model.perc_cut(BD_rel, 0)
    
    E_rel, _ = Model.perc_cut(E_rel, 0)
    F_rel, _ = Model.perc_cut(F_rel, 0)
    G_rel, _ = Model.perc_cut(G_rel, 0)
    EG_rel, _ = Model.perc_cut(EG_rel, 0)
    FG_rel, _ = Model.perc_cut(FG_rel, 0)

    FL_rel_pc, _ = Model.perc_cut(FL_rel, 0)  # [0.1, 0.1])
    FC_rel_pc, _ = Model.perc_cut(FC_rel, 0)  # [0.1, 1])
    
    biomes_list = ['total'] + biomes.keys()
    FL_rel_biome = Model.biome_calc(np.abs(FL_rel_pc), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    FC_rel_biome = Model.biome_calc(np.abs(FC_rel_pc), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    A_rel_biome = Model.biome_calc(np.abs(A_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    B_rel_biome = Model.biome_calc(np.abs(B_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    C_rel_biome = Model.biome_calc(np.abs(C_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    D_rel_biome = Model.biome_calc(np.abs(D_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    AC_rel_biome = Model.biome_calc(np.abs(AC_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    AD_rel_biome = Model.biome_calc(np.abs(AD_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    BC_rel_biome = Model.biome_calc(np.abs(BC_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    BD_rel_biome = Model.biome_calc(np.abs(BD_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    
    E_rel_biome = Model.biome_calc(np.abs(E_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    F_rel_biome = Model.biome_calc(np.abs(F_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    G_rel_biome = Model.biome_calc(np.abs(G_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    EG_rel_biome = Model.biome_calc(np.abs(EG_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    FG_rel_biome = Model.biome_calc(np.abs(FG_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    
    fig = plt.figure(fign)
    
    for i, b in enumerate(biomes_list):
        
        ax = fig.add_subplot(2, 5, i+1)
        b = i
        blist = ax.bar(range(8+1), [FL_rel_biome[1].values()[b], D_rel_biome[1].values()[b], C_rel_biome[1].values()[b], A_rel_biome[1].values()[b], B_rel_biome[1].values()[b], AD_rel_biome[1].values()[b], AC_rel_biome[1].values()[b], BD_rel_biome[1].values()[b], BC_rel_biome[1].values()[b]])
        blist2 = ax.bar(range(10,16), [FC_rel_biome[1].values()[b], G_rel_biome[1].values()[b], E_rel_biome[1].values()[b], F_rel_biome[1].values()[b], EG_rel_biome[1].values()[b], FG_rel_biome[1].values()[b]])
        
        ax.axhline(color='black')
        ax.grid(axis='y', linestyle='--', zorder=0)
        ax.set_axisbelow(True)
        ax.set_ylim([0,0.7])
        ax.set_ylabel('RMS relative difference')
        ax.set_xticks(range(8+1) + range(10,16))
        ax.set_xticklabels(['FL',  'MBF', 'fire off', 'misclass.', 'aggr.', 'misclass. + MBF', 'misclass + fire off', 'aggr. + MBF', 'aggr. + fire off', 'FC', 'MBF', 'misclass.', 'aggr.', 'misclass. + MBF', 'aggr. + MBF'], rotation=45, ha='right', rotation_mode='anchor')
        ax.set_title((['Africa'] + biomes.values())[i])
    
    fig.subplots_adjust(hspace=0.5, wspace=0.3, left=0.05, right=0.95)
    
    
    
    # group open shrub, open shrub, grass and crops
    # remove decid forest and mixed forest
    biomes_list = ['total', '2', '8', '9', ['6','7','10','11']]
    FL_rel_biome = Model.biome_calc(np.abs(FL_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    FC_rel_biome = Model.biome_calc(np.abs(FC_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    A_rel_biome = Model.biome_calc(np.abs(A_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    B_rel_biome = Model.biome_calc(np.abs(B_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    C_rel_biome = Model.biome_calc(np.abs(C_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    D_rel_biome = Model.biome_calc(np.abs(D_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    AC_rel_biome = Model.biome_calc(np.abs(AC_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    AD_rel_biome = Model.biome_calc(np.abs(AD_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    BC_rel_biome = Model.biome_calc(np.abs(BC_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    BD_rel_biome = Model.biome_calc(np.abs(BD_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')

    E_rel_biome = Model.biome_calc(np.abs(E_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    F_rel_biome = Model.biome_calc(np.abs(F_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    G_rel_biome = Model.biome_calc(np.abs(G_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    EG_rel_biome = Model.biome_calc(np.abs(EG_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    FG_rel_biome = Model.biome_calc(np.abs(FG_rel), biomes_list, 0.25, years[len(years) / 2], 'Africa')
    
    fig = plt.figure(fign+1)
    
    for i, b in enumerate(biomes_list):
        
        ax = fig.add_subplot(2,3,i+1)
        b = i
        blist = ax.bar(range(8+1), [FL_rel_biome[1].values()[b], D_rel_biome[1].values()[b], C_rel_biome[1].values()[b], A_rel_biome[1].values()[b], B_rel_biome[1].values()[b], AD_rel_biome[1].values()[b], AC_rel_biome[1].values()[b], BD_rel_biome[1].values()[b], BC_rel_biome[1].values()[b]])
        blist2 = ax.bar(range(10,16), [FC_rel_biome[1].values()[b], G_rel_biome[1].values()[b], E_rel_biome[1].values()[b], F_rel_biome[1].values()[b], EG_rel_biome[1].values()[b], FG_rel_biome[1].values()[b]])
        
        ax.axhline(color='black')
        ax.grid(axis='y', linestyle='--', zorder=0)
        ax.set_axisbelow(True)
        ax.set_ylim([0,0.55])
        ax.set_ylabel('RMS relative difference')
        ax.set_xticks(range(8+1) + range(10,16))
        ax.set_xticklabels(['FL',  'MBF', 'fire off', 'misclass.', 'aggr.', 'misclass. + MBF', 'misclass + fire off', 'aggr. + MBF', 'aggr. + fire off', 'FC', 'MBF', 'misclass.', 'aggr.', 'misclass. + MBF', 'aggr. + MBF'], rotation=45, ha='right', rotation_mode='anchor')
        ax.set_title(['Africa', 'Tropical forest', 'Woody savanna', 'Open savanna', 'shrub+grass+crop'][i])

    fig.subplots_adjust(hspace=0.5, wspace=0.3, left=0.05, right=0.95)
    
    plt.show()
#plot_factorials(3)


###Fire_abs = FL_500 - FL_500nf   -> Fire abs doesnt make sense, because overall biomass difference between fire and not fire run.
Fire_rel = FL_rel - FL_relnf
Biome_rel = FL_rel - FL_relb
BiomeFC_rel = FC_rel - FC_relb
Rest_rel = FL_rel - Fire_rel - Biome_rel    # This Rest includes overlapping effects, fire biome misclassification is counted twice. Rest2 is the truth (see below).

# Version 2: further separation in 3 parts: 1. Biome misclassification, 2. Fire biome misclassification, 3. other fire effects.
Fire_rel = FL_relb - FL_relbnf          # Fire effect without biome misclassification. == (FL_rel - FL_relnf) - BiomeFire_rel
Biome_rel = FL_relnf - FL_relbnf        # biome misclassification without fire.
BiomeFire_rel = (FL_rel - FL_relb) - Biome_rel   # biome misclassification effect on fire. == (FL_rel - FL_relnf) - Fire_rel. This equality proofs both ways filter out the same fire biome misclassification.
# Fire effects isolation:
MBF_rel = FL_relb - FL_relbm        # diff due to modified burned fraction.
#BBA_rel = FL_relb - FL_relba        # diff due to BA per biome
Perc_rel = FL_relb - FL_relbp       # diff due to BA, Fpar, FTC, NTV per biome.
PercFire_rel = (FL_relbp - FL_relbpnf) - Fire_rel
Mort_rel = FL_relbp - FL_relmortbp  # diff due to mortality.
Fire_rel = Fire_rel - MBF_rel - Mort_rel #- BBA_rel    # remove explained fire effects from total fire diff.
Rest_rel = FL_rel - (Fire_rel + Biome_rel + BiomeFire_rel + MBF_rel + Mort_rel) #+ BBA_rel)
BiomeFC_rel = FC_rel - FC_relb
MBFFC_rel = FC_relb - FC_relbm
#BBAFC_rel = FC_relb - FC_relba
MortFC_rel = FC_relbp - FC_relmortbp
RestFC_rel = FC_rel - (BiomeFC_rel + MBFFC_rel + MortFC_rel) #+ BBAFC_rel)

# Version 3: using BA, Fpar, FTC, NTV per biome.
Fire_rel = FL_relbp - FL_relbpnf
Biome_rel = FL_relnf - FL_relbpnf
BiomeFire_rel = (FL_rel - FL_relbp) - Biome_rel     # Fire_rel + BiomeFire_rel == FL_rel - FL_relnf
BiomeFire_rel2 = (FL_rel - FL_relb) - (FL_relnf - FL_relbnf)
# Fire effects isolation:
MBF_rel = FL_relbp - FL_relbpm      # FL_relb - FL_relbm is identical, FL_rel - FL_relm is different, but less than 0.01 rel diff.
BiomeMBF_rel = (FL_rel - FL_relm) - MBF_rel     # = almost zero, less than 0.01 rel diff.
Mort_rel = FL_relbp - FL_relmortbp  # TREE FIRE. Adding mbf doesnt change much.
BiomeMort_rel = (FL_rel - FL_relmort) - Mort_rel    # TREE FIRE - BIOME MISCLASS.
FireRest_rel = Fire_rel - (MBF_rel + Mort_rel)  # REST FIRE.
BiomeFireRest_rel = BiomeFire_rel - (BiomeMBF_rel + BiomeMort_rel)  # REST FIRE - BIOME MISCLASS.
Rest_rel = FL_rel - (Fire_rel + Biome_rel + BiomeFire_rel)      # == FL_relbpnf.
# Fuel consumption:
BiomeFC_rel = FC_rel - FC_relbp
MBFFC_rel = FC_relbp - FC_relbpm    # FC_rel - FC_relm & FC_relb - FC_relbm are identical.
BiomeMBFFC_rel = (FC_rel - FC_relm) - MBFFC_rel     # = zero
MortFC_rel = FC_relbp - FC_relmortbp    # Adding mbf doesnt change anything significant.
BiomeMortFC_rel = (FC_rel - FC_relmort) - MortFC_rel
RestFC_rel = FC_rel - (BiomeFC_rel + MBFFC_rel + MortFC_rel + BiomeMBFFC_rel + BiomeMortFC_rel)


# Version 4: simplified.
Biome_rel = FL_relnf - FL_relbnf
Biomep_rel = FL_relbnf - FL_relbpnf
BiomeFire_rel = (FL_rel - FL_relbp) - (FL_relnf - FL_relbpnf)
Fire_rel = FL_rel - FL_relnf
MBF_rel = FL_rel - FL_relm
FireRest_rel = Fire_rel - (MBF_rel) # + BiomeFire_rel)
Rest_rel = FL_rel - (Fire_rel + Biome_rel + Biomep_rel)
BiomeFC_rel = FC_rel - FC_relb
BiomepFC_rel = FC_relb - FC_relbp
MBFFC_rel = FC_rel - FC_relm
RestFC_rel = FC_rel - (BiomeFC_rel + BiomepFC_rel + MBFFC_rel)

# Version 5: fire afterwards.
Biome_rel = FL_rel - FL_relb
Biomep_rel = FL_relb - FL_relbp
MBF_rel = FL_relbp - FL_relbpm
FireRest_rel = FL_relbp - (FL_relbpnf + MBF_rel)    # = Fire_rel - MBF_rel
Rest_rel = FL_rel - (Biome_rel + Biomep_rel + MBF_rel + FireRest_rel)
BiomeFC_rel = FC_rel - FC_relb
BiomepFC_rel = FC_relb - FC_relbp
MBFFC_rel = FC_relbp - FC_relbpm
RestFC_rel = FC_rel - (BiomeFC_rel + BiomepFC_rel + MBFFC_rel)

cutoff = 0
Fire_rel, _ = Model.perc_cut(Fire_rel, cutoff) #[0.005, 0.05])
Biome_rel, _ = Model.perc_cut(Biome_rel, cutoff) #[0.01, 0.1])
BiomeFire_rel, _ = Model.perc_cut(BiomeFire_rel, cutoff) #0.005)
MBF_rel, _ = Model.perc_cut(MBF_rel, cutoff)
Mort_rel, _ = Model.perc_cut(Mort_rel, cutoff)
FireRest_rel, _ = Model.perc_cut(FireRest_rel, cutoff)
Rest_rel, _ = Model.perc_cut(Rest_rel, cutoff) #[0, 0.1])
BiomeFC_rel, _ = Model.perc_cut(BiomeFC_rel, cutoff) #[0.01,0.1])
MBFFC_rel, _ = Model.perc_cut(MBFFC_rel, cutoff) #[0.01, 0])
MortFC_rel, _ = Model.perc_cut(MortFC_rel, cutoff)
RestFC_rel, _ = Model.perc_cut(RestFC_rel, cutoff) #[0.01,0.25])
FL_rel2 = Fire_rel + Biome_rel + Rest_rel #+ BiomeFire_rel
FC_rel2 = BiomeFC_rel + MBFFC_rel + MortFC_rel + RestFC_rel

Biomep_rel, _ = Model.perc_cut(Biomep_rel, cutoff)
BiomepFC_rel, _ = Model.perc_cut(BiomepFC_rel, cutoff)
# Version 4:
#FL_rel2 = Biome_rel + Biomep_rel + Fire_rel + Rest_rel
#FC_rel2 = BiomeFC_rel + BiomepFC_rel + MBFFC_rel + RestFC_rel

# Version 5:
FL_rel2 = Biome_rel + Biomep_rel + MBF_rel + FireRest_rel + Rest_rel
FC_rel2 = BiomeFC_rel + BiomepFC_rel + MBFFC_rel + RestFC_rel


# 
FL_rel, _ = Model.perc_cut(FL_rel, cutoff) #[0.1, 0.1])
FC_rel, _ = Model.perc_cut(FC_rel, cutoff) #[0.1, 1])
DB_rel, _ = Model.perc_cut(DB_rel, cutoff) #[0.1, 1])
FL_relnf, _ = Model.perc_cut(FL_relnf, cutoff) #[0.1, 0.5])
FL_relb, _ = Model.perc_cut(FL_relb, cutoff) #[0.1, 0.5])
FC_relb, _ = Model.perc_cut(FC_relb, cutoff) #[0.1, 1])
FL_relbnf, _ = Model.perc_cut(FL_relbnf, cutoff) #[0.1, 0.5])


mask = Model.biome_mask('9', 0.25, years[len(years)/2], 'Africa')[0]

def plot_res_comp(fign):
    
    textsize = 14
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    _,_, lat, lon = Model.load_degbox(0.25, 'Africa')
    m = Basemap(projection='cyl', llcrnrlat=lat[-1], urcrnrlat=lat[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')   # resolution = 'l' means low resolution of the coastlines.
    x, y = m(lon, lat)
    
    cmap = plt.cm.viridis
    cmap._init()
    cmap.set_bad('white', 1.)    # 'bad/masked values' are in white
    cmap_rel = plt.cm.RdBu_r
    cmap_rel._init()
    cmap_rel.set_bad('white', 1.)    # 'bad/masked values' are in white
    
    # INFO: pcolor requires vmin/vmax OR norm. It is one or the other.
    cticks_FL = [0, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 40000]
    norm_FL = BoundaryNorm(cticks_FL, cmap.N)
    
    cticks_FC = [0, 50, 100, 200, 500, 1000, 2000, 5000, 10000]
    norm_FC = BoundaryNorm(cticks_FC, cmap.N)
    
    cticks_DB = [0, 25, 50, 75, 100, 125, 150, 175, 200, 225, 250, 275, 300]
    norm_DB = BoundaryNorm(cticks_DB, cmap.N)
    
    cticks_rel = [-1, -0.75, -0.5, -0.25, 0, 0.25, 0.5, 0.75, 1]
    norm_rel = BoundaryNorm(cticks_rel, cmap_rel.N)

    FL_500_005 = data500_005['FL']      # 500-meter results aggregated to 0.05deg.
    FC_500_005 = data500_005['FCsum']
    DB_500_005 = data500_005['DBsum']
    
    cticks_BA = [0, 0.2, 0.5, 1, 2, 5, 10, 20, 50, 100]
    cticks_BA = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
    norm_BA = BoundaryNorm(cticks_BA, cmap.N)
    
    cticks_LC = range(1, 11)
    norm_LC = BoundaryNorm(cticks_LC, 9)
    cmap_LC = my_cmap = plt.cm.Paired(np.arange(plt.cm.Paired.N))
    cmap_LC_order = cmap_LC.copy()
    cmap_LC_order[0] = cmap_LC[1].copy()
    cmap_LC_order[1] = cmap_LC[0].copy()
    cmap_LC_order[2] = cmap_LC[5].copy()
    cmap_LC_order[3] = cmap_LC[7].copy()
    cmap_LC_order[4] = cmap_LC[6].copy()
    cmap_LC_order[5] = cmap_LC[3].copy()
    cmap_LC_order[6] = cmap_LC[2].copy()
    cmap_LC_order[7] = cmap_LC[9].copy()
    cmap_LC_order[8] = cmap_LC[10].copy()
    cmap_LC_order = ListedColormap(cmap_LC_order[:9])
    
    
    def plot_duo_v1(fign, arr1, arr2, resdeg, filename=None):

        textsize = 19
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        lat_cut = lat[np.where(lat < 30)]  # cut off above 30N
        m = Basemap(projection='cyl', llcrnrlat=lat_cut[-1], urcrnrlat=lat_cut[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat_cut)
        
        fig = plt.figure(fign, (14.7, 7))
        
        ax = fig.add_subplot(121)
        arr = arr1[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=(np.isnan(arr) | (arr == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm_DB)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)
        
        from mpl_toolkits.axes_grid1 import make_axes_locatable
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        fig.add_axes(cax)
        cb = fig.colorbar(da, cax=cax, orientation='horizontal')  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Carbon emissions (g C $\mathregular{m^{-2}\ yr^{-1}}$)', rotation=0, labelpad=5, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)

        ax.set_ylim([-37, 30])
        fig.text(0.06, 0.22, '(a)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        ax = fig.add_subplot(122)
        arr = arr2[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=(np.isnan(arr) | (arr == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm_FC)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)

        from mpl_toolkits.axes_grid1 import make_axes_locatable
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        fig.add_axes(cax)
        cb = fig.colorbar(da, cax=cax, orientation='horizontal')  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Fuel consumption (g C $\mathregular{m^{-2}}$ burned)', rotation=0, labelpad=5, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        cb.ax.set_xticklabels(['{:,}'.format(int(x.get_text())).replace(',', ' ') for x in cb.ax.get_xticklabels()])

        ax.set_ylim([-37, 30])
        fig.text(0.555, 0.22, '(b)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        plt.tight_layout()
        plt.subplots_adjust(left=0.045, right=0.97, bottom=0.01, top=1.05, wspace=0.14)
        #plt.subplots_adjust(left=0.035, right=0.975, bottom=0.01, top=1.05, wspace=0.12)
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
    #filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure3_TNR'
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/Referee_discussion/' + 'Figure4ab'
    #plot_duo_v1(1, DB_500_005, FC_500_005, 0.05, filename=filename)
    
    
    def plot_duo_v2(fign, arr1, arr2, resdeg, filename=None):

        textsize = 14
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        m = Basemap(projection='cyl', llcrnrlat=lat[-1], urcrnrlat=lat[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat)
        
        fig = plt.figure(fign, (14.3,5))
        
        ax = fig.add_subplot(121)
        mask_arr = np.ma.array(arr1, mask=(np.isnan(arr1) | (arr1 == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm_DB)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 0, 1], fontsize=textsize * tickredux)
        
        cb = fig.colorbar(da, shrink=0.895, pad=0.03)  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Carbon emissions (g C $\mathregular{m^{-2}\ yr^{-1}}$)', rotation=270, labelpad=20, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        
        ax.set_ylim([-37, 30])
        fig.text(0.055, 0.13, '(a)', size=textsize, verticalalignment='top')  # , weight='bold')
        
        
        ax = fig.add_subplot(122)
        mask_arr = np.ma.array(arr2, mask=(np.isnan(arr2) | (arr2 == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm_FC)
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 0, 1], fontsize=textsize * tickredux)
        cb = fig.colorbar(da, shrink=0.895, pad=0.03)  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Fuel consumption (g C $\mathregular{m^{-2}}$ burned)', rotation=270, labelpad=20, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        cb.ax.set_yticklabels(['{:,}'.format(int(x.get_text())).replace(',', ' ') for x in cb.ax.get_yticklabels()])
        
        ax.set_ylim([-37, 30])
        fig.text(0.555, 0.13, '(b)', size=textsize, verticalalignment='top')  # , weight='bold')
        
        
        plt.tight_layout()
        plt.subplots_adjust(left=0.04, right=0.98, bottom=0.01, top=1.02, wspace=0.12)
        
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
    #filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure3v2'
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/Referee_discussion/' + 'Figure4ab_v2'
    #plot_duo_v2(2, DB_500_005, FC_500_005, 0.05, filename=filename)
    
    
       
    def plot_duo_v1cd(fign, arr1, arr2, resdeg, filename=None):

        textsize = 19
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        lat_cut = lat[np.where(lat < 30)]  # cut off above 30N
        m = Basemap(projection='cyl', llcrnrlat=lat_cut[-1], urcrnrlat=lat_cut[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat_cut)
        
        fig = plt.figure(fign, (14.7, 7))
        
        ax = fig.add_subplot(121)
        arr = arr1[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=(np.isnan(arr) | (arr == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm_BA)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)
        
        from mpl_toolkits.axes_grid1 import make_axes_locatable
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        fig.add_axes(cax)
        cb = fig.colorbar(da, cax=cax, orientation='horizontal')  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Burned area (% $\mathregular{yr^{-1}}$)', rotation=0, labelpad=5, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)

        ax.set_ylim([-37, 30])
        fig.text(0.06, 0.22, '(a)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        ax = fig.add_subplot(122)
        arr = arr2[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=(np.isnan(arr) | (arr == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap_LC_order, norm=norm_LC)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)

        from mpl_toolkits.axes_grid1 import make_axes_locatable
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        fig.add_axes(cax)
        cb = fig.colorbar(da, cax=cax, orientation='horizontal', ticks=np.arange(1.5,10))  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('', rotation=0, labelpad=5, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        cb.ax.set_xticklabels(['Tropical\nforest', 'Mixed\nforest', 'Shrubland', 'Woody\nsavanna', 'Open\nsavanna', 'Grassland', 'Cropland', 'Urban', 'Desert'])
        
        ax.set_ylim([-37, 30])
        fig.text(0.555, 0.22, '(b)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        plt.tight_layout()
        plt.subplots_adjust(left=0.045, right=0.97, bottom=0.01, top=1.05, wspace=0.14)
        #plt.subplots_adjust(left=0.035, right=0.975, bottom=0.01, top=1.05, wspace=0.12)
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
        
    def plot_duo_v2cd(fign, arr1, arr2, resdeg, filename=None):

        textsize = 14
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        m = Basemap(projection='cyl', llcrnrlat=lat[-1], urcrnrlat=lat[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat)
        
        fig = plt.figure(fign, (14.3,5))
        
        ax = fig.add_subplot(121)
        mask_arr = np.ma.array(arr1, mask=(np.isnan(arr1) | (arr1 == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm_BA)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 0, 1], fontsize=textsize * tickredux)
        
        cb = fig.colorbar(da, shrink=0.895, pad=0.03)  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Burned area (% $\mathregular{yr^{-1}}$)', rotation=270, labelpad=20, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        
        ax.set_ylim([-37, 30])
        fig.text(0.055, 0.13, '(c)', size=textsize, verticalalignment='top')  # , weight='bold')
        
        
        ax = fig.add_subplot(122)
        mask_arr = np.ma.array(arr2, mask=(np.isnan(arr2) | (arr2 == 0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap_LC_order, norm=norm_LC)
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 0, 1], fontsize=textsize * tickredux)
        cb = fig.colorbar(da, shrink=0.895, pad=0.03, ticks=np.arange(1.5,10))  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('', rotation=270, labelpad=20, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        cb.ax.set_yticklabels(['Tropical\nforest', 'Mixed\nforest', 'Shrubland', 'Woody\nsavanna', 'Open\nsavanna', 'Grassland', 'Cropland', 'Urban', 'Desert'])
        
        ax.set_ylim([-37, 30])
        fig.text(0.555, 0.13, '(d)', size=textsize, verticalalignment='top')  # , weight='bold')
        
        
        plt.tight_layout()
        plt.subplots_adjust(left=0.04, right=0.98, bottom=0.01, top=1.02, wspace=0.12)
        
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
    
    LC_plot = data005['LC'].copy()
    LC_plot[LC_plot == 2] = 1
    LC_plot[LC_plot == 4] = 2
    LC_plot[LC_plot == 5] = 2
    LC_plot[LC_plot == 6] = 3
    LC_plot[LC_plot == 7] = 3
    LC_plot[LC_plot == 8] = 4
    LC_plot[LC_plot == 9] = 5
    LC_plot[LC_plot == 10] = 6
    LC_plot[LC_plot == 11] = 7
    LC_plot[LC_plot == 12] = 8
    LC_plot[LC_plot == 13] = 9
    
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/Referee_discussion/' + 'Figure4cd'
    plot_duo_v1cd(3, data005['BAsum'] * 100 / Model.load_area(0.05, 'Africa')[0], LC_plot, 0.05, filename=filename)
    
    def plot_single(fign, arr, norm, label, resdeg, filename=None):
        
        textsize = 12
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        m = Basemap(projection='cyl', llcrnrlat=lat[-1], urcrnrlat=lat[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat)
        
        fig = plt.figure(fign)
        
        ax = fig.add_subplot(111)
        mask_arr = np.ma.array(arr, mask=(np.isnan(arr) | (arr==0)))
        da = m.pcolor(x, y, mask_arr, cmap=cmap, norm=norm)
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180,180+10,10), zorder=0, linewidth=0.1, labels=[1,0,0,0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90,90+10,10), zorder=0, linewidth=0.1, labels=[0,0,0,1], fontsize=textsize * tickredux)
        cb = fig.colorbar(da, shrink=0.895, pad=0.03) #, norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label(label, rotation=270, labelpad=20, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        cb.ax.set_yticklabels(['{:,}'.format(int(x.get_text())).replace(',', ' ') for x in cb.ax.get_yticklabels()])
        
        ax.set_ylim([-37,30])
        fig.text(0, 1, 'a)', size=textsize, verticalalignment='top') #, weight='bold')
        plt.tight_layout()
        plt.subplots_adjust(left=0.08)
        
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure3a'
    #plot_single(fign+1, DB_500_005, norm_DB, 'Carbon emissions (g C $\mathregular{m^{-2}\ yr^{-1}}$)', 0.05) #, filename=filename)
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure3b'
    #plot_single(fign+2, FC_500_005, norm_FC, 'Fuel consumption (g C $\mathregular{m^{-2}}$ burned)', 0.05) #, filename=filename)

    #plot_single(1, FL_mod, norm_FL, 'Fuel load (g C $\mathregular{m^{-2}}$)', 0.25)
    
    
    def plot_duo_rel(fign, arr1, arr2, resdeg, filename=None):
        
        textsize = 19
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        lat_cut = lat[np.where(lat < 30)]  # cut off above 30N
        m = Basemap(projection='cyl', llcrnrlat=lat_cut[-1], urcrnrlat=lat_cut[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat_cut)
        
        fig = plt.figure(fign, (14.7, 7))
        
        ax = fig.add_subplot(121)
        arr = arr1[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel) # , norm=norm_rel)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)
        
        from mpl_toolkits.axes_grid1 import make_axes_locatable
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        x_pos1 = cax.get_position().get_points()[:,0]
        y_pos = cax.get_position().get_points()[:,1]
        #fig.add_axes(cax)
        #cb = fig.colorbar(da, cax=cax, orientation='horizontal')  # , norm=norm) #ticks=cticks) <- gives same result.
        #cb.set_label('Relative difference (-)', rotation=0, labelpad=8, fontsize=textsize)
        #cb.ax.tick_params(labelsize=textsize * tickredux)

        ax.set_ylim([-37, 30])
        fig.text(0.06, 0.22, '(a)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        ax = fig.add_subplot(122)
        arr = arr2[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel) # , norm=norm_rel)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)

        from mpl_toolkits.axes_grid1 import make_axes_locatable
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        #fig.add_axes(cax)

        # difine new colorbar axis. One colorbar in center of two subplots.
        x_pos2 = cax.get_position().get_points()[:,0]
        cax = fig.add_axes([np.mean(x_pos1), y_pos[0], np.mean(x_pos2) - np.mean(x_pos1), 0.04])    # unknown how y height is defined in cax. Set 0.04.
        cb = fig.colorbar(da, cax=cax, orientation='horizontal')  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Relative difference (-)', rotation=0, labelpad=5, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        
        ax.set_ylim([-37, 30])
        fig.text(0.555, 0.22, '(b)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        plt.tight_layout()
        plt.subplots_adjust(left=0.045, right=0.97, bottom=0.01, top=1.05, wspace=0.14)
        #plt.subplots_adjust(left=0.035, right=0.975, bottom=0.01, top=1.05, wspace=0.12)
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure5_rev_TNR'
    #plot_duo_rel(2, FL_rel, FC_rel, 0.25, filename=filename)
    
    
    def plot_single_rel(fign, arr, resdeg, filename=None):
        
        textsize = 12
        tickredux = 0.9  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        m = Basemap(projection='cyl', llcrnrlat=lat[-1], urcrnrlat=lat[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat)
        
        fig = plt.figure(fign)
        
        ax = fig.add_subplot(111)
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel)  # , norm=norm_rel)
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180,180+10,10), zorder=0, linewidth=0.1, labels=[1,0,0,0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90,90+10,10), zorder=0, linewidth=0.1, labels=[0,0,0,1], fontsize=textsize * tickredux)
        cb = fig.colorbar(da, shrink=0.895, pad=0.03)
        cb.set_label('Relative difference (-)', rotation=270, labelpad=20, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize * tickredux)
        
        ax.set_ylim([-37,30])
        fig.text(0, 1, 'a)', size=textsize, verticalalignment='top') #, weight='bold')
        plt.tight_layout()
        plt.subplots_adjust(left=0.08)
        
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
    
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure5b'
    #plot_single_rel(2, FL_rel, 0.25) #, filename=filename)
    
    
    def plot_quad_rel(fign, arr1, arr2, arr3, arr4, resdeg, filename=None):
        
        from mpl_toolkits.axes_grid1 import make_axes_locatable
        
        textsize = 17
        tickredux = 0.77  # ticklabel fontsize smaller.
        
        _, _, lat, lon = Model.load_degbox(resdeg, 'Africa')
        lat_cut = lat[np.where(lat < 30)]  # cut off above 30N
        m = Basemap(projection='cyl', llcrnrlat=lat_cut[-1], urcrnrlat=lat_cut[0], llcrnrlon=lon[0], urcrnrlon=lon[-1], resolution='l')  # resolution = 'l' means low resolution of the coastlines.
        x, y = m(lon, lat_cut)
        
        fig = plt.figure(fign, (10, 9))  # default ratio = 12.8, 9.6
        
        ax = fig.add_subplot(221)
        arr = arr1[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel) # , norm=norm_rel)
        
        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)
        
        ax.set_ylim([-37, 30])
        fig.text(0.07, 0.595, '(a)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        ax = fig.add_subplot(222)
        arr = arr2[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel)  # , norm=norm_rel)

        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)

        ax.set_ylim([-37, 30])
        fig.text(0.575, 0.595, '(b)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        ax = fig.add_subplot(223)
        arr = arr3[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel)  # , norm=norm_rel)

        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)
        
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        x_pos1 = cax.get_position().get_points()[:,0]
        y_pos = cax.get_position().get_points()[:,1]
        
        ax.set_ylim([-37, 30])
        fig.text(0.07, 0.145, '(c)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        
        ax = fig.add_subplot(224)
        arr = arr4[np.where(lat < 30)]
        mask_arr = np.ma.array(arr, mask=np.isnan(arr))
        da = m.pcolor(x, y, mask_arr, vmin=-1, vmax=1, cmap=cmap_rel)  # , norm=norm_rel)

        m.drawcoastlines(linewidth=0.3, zorder=1, color='grey')
        m.drawcountries(linewidth=0.3, zorder=1, color='grey')
        m.drawparallels(range(-180, 180 + 10, 10), zorder=0, linewidth=0.1, labels=[1, 0, 0, 0], fontsize=textsize * tickredux)
        m.drawmeridians(range(-90, 90 + 10, 10), zorder=0, linewidth=0.1, labels=[0, 0, 1, 0], fontsize=textsize * tickredux)
        
        divider = make_axes_locatable(ax)
        cax = divider.new_vertical(size="5%", pad=0.1, pack_start=True)
        x_pos2 = cax.get_position().get_points()[:,0]
        
        cax = fig.add_axes([np.mean(x_pos1), 0.07, np.mean(x_pos2) - np.mean(x_pos1), 0.03])    # unknown how y height is defined in cax. Set 0.04.
        cb = fig.colorbar(da, cax=cax, orientation='horizontal')  # , norm=norm) #ticks=cticks) <- gives same result.
        cb.set_label('Relative difference (-)', rotation=0, labelpad=5, fontsize=textsize)
        cb.ax.tick_params(labelsize=textsize-2)
        
        
        
        ax.set_ylim([-37, 30])
        fig.text(0.575, 0.145, '(d)', size=textsize, verticalalignment='top', zorder=10)  # , weight='bold')
        
        plt.tight_layout()
        plt.subplots_adjust(left=0.05, right=0.99, bottom=0.01, top=1.06, wspace=0.18, hspace=-0.2)
        
        if filename != None:
            fig.savefig(filename, dpi=300)
        else:
            plt.show()
        
    
    Biome_rel_plot = FL_rel - FL_relb
    Biome_rel_plot, _ = Model.perc_cut(Biome_rel_plot, 0)
    
    Biomep_rel_plot = FL_relb - FL_relbp
    Biomep_rel_plot, _ = Model.perc_cut(Biomep_rel_plot, 0)

    Fire_rel_plot = FL_rel - FL_relnf
    Fire_rel_plot, _ = Model.perc_cut(Fire_rel_plot, 0)
    
    FireRest_rel_plot = FL_relbp - FL_relbpnf
    FireRest_rel_plot, _ = Model.perc_cut(FireRest_rel_plot, 0)
    
    Rest_rel_plot = FL_rel - (Biome_rel_plot + Biomep_rel_plot + FireRest_rel_plot)
    
    #Rest_rel_plot = FL_relbpm.copy()
    #Rest_rel_plot, _ = Model.perc_cut(Rest_rel_plot, 0)
    
    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure8_rev_TNR'
    #plot_quad_rel(1, Biome_rel_plot, Biomep_rel_plot, FireRest_rel_plot, Rest_rel_plot, 0.25, filename=filename)
    
    
    BiomeFC_rel_plot = FC_rel - FC_relb
    BiomeFC_rel_plot, _ = Model.perc_cut(BiomeFC_rel_plot, 0)
    
    BiomepFC_rel_plot = FC_relb - FC_relbp
    BiomepFC_rel_plot, _ = Model.perc_cut(BiomepFC_rel_plot, 0)
    
    BiomebpFC_rel_plot = FC_rel - FC_relbp
    BiomebpFC_rel_plot, _ = Model.perc_cut(BiomebpFC_rel_plot, 0)
    
    MBF_rel_plot = FC_rel - FC_relm
    MBF_rel_plot, _ = Model.perc_cut(MBF_rel_plot, 0)
    
    RestFC_rel_plot = FC_relbpm.copy()
    RestFC_rel_plot, _ = Model.perc_cut(RestFC_rel_plot, 0)

    filename = '/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure9_rev_TNR'
    #plot_quad_rel(3, BiomeFC_rel_plot, BiomepFC_rel_plot, MBF_rel_plot, RestFC_rel_plot, 0.25, filename=filename)
    
    #plt.show()
    print 'debug'
plot_res_comp(8)


def plot_fire_interp_FC_FTC(fign):    
    
    Fire_relsc = Fire_rel.flatten()
    Fire_relsc[Fire_relsc == 0] = np.nan
    FC_relsc = FC_rel.flatten()
    FC_relsc[FC_relsc == 0] = np.nan
    
    nanindex = np.isnan(Fire_relsc) + np.isnan(FC_relsc)
    Fire_relsc = Fire_relsc[~nanindex]
    FC_relsc = FC_relsc[~nanindex]
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(211)
    ax.scatter(Fire_relsc, FC_relsc)
    
    reg = scipy.stats.linregress(Fire_relsc, FC_relsc)
    fit = np.polyfit(Fire_relsc, FC_relsc, 1);
    fit_fn = np.poly1d(fit)
    ax.plot(Fire_relsc, fit_fn(Fire_relsc), color='black', alpha=0.9)
    ax.text(1.5, 1.5, 'y = %.3f x + %.1f' % (reg[0], reg[1]))
    #ax.text(1.5, 1.4, 'R2 = %.3f' % reg[2] ** 2)
    ax.axhline(0, color='black')
    ax.axvline(0, color='black')
    ax.grid(axis='y', linestyle='--')
    ax.grid(axis='x', linestyle='--')
    ax.set_axisbelow(True)              # gridlines behind plot objects.
    ax.set_ylabel('FC_relsc')
    ax.set_xlabel('FL_fire_relsc')
    
    
    ftc = np.nanmean(Model.readdata_MODIS('FTC', 0.25, years, 'Africa'), axis=0)
    ftc = ftc.flatten()
    Fire_ftcsc = Fire_rel.flatten()
    Fire_ftcsc[np.abs(Fire_ftcsc) < 0.01] = np.nan
    Fire_ftcsc[ftc < 0.1] = np.nan
    Fire_ftcsc[ftc > 0.6] = np.nan
    nanindex = np.isnan(Fire_ftcsc)
    Fire_ftcsc = Fire_ftcsc[~nanindex]
    ftc = ftc[~nanindex]
    
    ax = fig.add_subplot(212)
    ax.scatter(ftc, Fire_ftcsc)
    
    reg = scipy.stats.linregress(ftc, Fire_ftcsc)
    fit = np.polyfit(ftc, Fire_ftcsc, 1);
    fit_fn = np.poly1d(fit)
    ax.plot(ftc, fit_fn(ftc), color='black', alpha=0.9)
    ax.text(1.5, 1.5, 'y = %.3f x + %.1f' % (reg[0], reg[1]))
    #ax.text(1.5, 1.4, 'R2 = %.3f' % reg[2] ** 2)
    ax.axhline(0, color='black')
    ax.axvline(0, color='black')
    ax.grid(axis='y', linestyle='--')
    ax.grid(axis='x', linestyle='--')
    ax.set_axisbelow(True)              # gridlines behind plot objects.
    ax.set_ylabel('FC_fire_relsc')
    ax.set_xlabel('FTC')
    
    plt.show()
#plot_fire_effect(13)


def plot_res_biome_diff(fign):
    ''' PAPER FIGURE '''
    textsize = 12
    tickredux = 0.9     # ticklabel fontsize smaller.
    
    FL_rel_biome = Model.biome_calc(FL_rel2, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    #GIVES SAME rel_avg difference: FL_rel_biome2 = Model.biome_calc(FL_mod, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa', Xref=FL_ref)
    FC_rel_biome = Model.biome_calc(FC_rel, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    FL_abs_biome = Model.biome_calc(FL_abs, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_abs_biome = Model.biome_calc(FC_abs, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    FL_relnf_biome = Model.biome_calc(FL_relnf, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    Fire_rel_biome = Model.biome_calc(Fire_rel, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    FL_relb_biome = Model.biome_calc(FL_relb, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    Biome_rel_biome = Model.biome_calc(Biome_rel, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    FC_relb_biome = Model.biome_calc(FC_relb, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    BiomeFC_rel_biome = Model.biome_calc(BiomeFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    FL_relbnf_biome = Model.biome_calc(FL_relbnf, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    Rest_rel_biome = Model.biome_calc(Rest_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    DB_rel_biome = Model.biome_calc(DB_rel, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    DB_abs_biome = Model.biome_calc(DB_abs, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    BiomeFire_rel_biome = Model.biome_calc(BiomeFire_rel, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    fig = plt.figure(fign, (8,10))
    
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    # b1 = ax.bar(x_ax, FL_relnf_biome[1].values(), width, color='C0')
    # #b1b= ax.bar(x_ax, Fire_rel_biome[1].values(), width, bottom = FL_relnf_biome[1].values(), color='red', zorder=2)
    # b2 = ax.bar(x_ax + 1.2, FC_rel_biome[1].values(), width, color='C1')
    # 
    # rcParams['hatch.linewidth'] = 3
    # rcParams['hatch.color'] = 'red'
    # for i in range(len(x_ax)):
    #     if Fire_rel_biome[1].values()[i] >= 0:
    #         b1b = ax.bar(x_ax[i] - 0.1, Fire_rel_biome[1].values()[i], width, bottom = FL_relnf_biome[1].values()[i], color='red')
    #     elif Fire_rel_biome[1].values()[i] < 0:
    #         ax.bar(x_ax[i] - 0.1, Fire_rel_biome[1].values()[i], width, bottom = FL_relnf_biome[1].values()[i], color='none', hatch='///')
    
    ax = fig.add_subplot(211)
    ''' Average relative difference ''' # This is correct, relative average difference is not useful.
    
    b1 = ax.bar(x_ax, Biome_rel_biome[1].values(), width, color='C0', zorder=0, alpha=0.4) #, bottom = FL_relbnf_biome[1].values())
    b1b = ax.bar(x_ax, Fire_rel_biome[1].values(), width/1.5, color='red', alpha=0.4, bottom = Biome_rel_biome[1].values())
    #b1c = ax.bar(x_ax, Rest_rel_biome[1].values(), width/2.5, color='green', bottom = np.array(Biome_rel_biome[1].values()) + np.array(Fire_rel_biome[1].values()))
    b1c = ax.bar(x_ax, BiomeFire_rel_biome[1].values(), width/2.5, color='green', bottom = np.array(Biome_rel_biome[1].values()) + np.array(Fire_rel_biome[1].values()))
    
    b2 = ax.bar(x_ax + 1.2, BiomeFC_rel_biome[1].values(), width, color='C1', zorder=0, alpha=0.4) #, bottom = FC_relb_biome[1].values())
    
    bp1 = ax.boxplot(FL_rel_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FC_rel_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    for bp, color in zip([bp1, bp2], ['C0', 'C1']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=5)
        plt.setp(bp['medians'], color='black')

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45, fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.axhline(color='black')
    ax.legend([b1, b1b, b2], ['FL - non fire part', 'FL - fire part', 'FC'], fontsize=textsize)
    ax.set_ylabel('Relative difference (gC m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    ax = fig.add_subplot(212)
    ''' Average absolute difference ''' # Is the same as absolute difference between averages!
    
    b1 = ax.bar(x_ax, FL_abs_biome[1].values(), width)
    b2 = ax.bar(x_ax + 1.2, FC_abs_biome[1].values(), width)
    
    bp1 = ax.boxplot(FL_abs_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FC_abs_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    ax.set_yscale('symlog', basey=2, linthreshy=100)
    ax.set_yticks([-4000,-2000,-1000,-500,-200,-100,-50,0,50,100,200,500,1000,2000,4000])
    ax.set_ylim([-6000,6000])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45, fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.axhline(color='black')
    ax.legend([b1, b2], ['FL', 'FC'], fontsize=textsize)
    ax.set_ylabel('Absolute difference (gC m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    
    
    fig = plt.figure(fign+1, (8,10))
    
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ''' Total absolute difference '''   # Is the same as absolute difference between totals!

    ax = fig.add_subplot(111)
    ax2 = ax.twinx()
    
    b1 = ax.bar(x_ax, np.array(FL_abs_biome[0].values()) / 1e15, width)
    
    # ax.set_yscale('symlog', basey=2, linthreshy=0.1)
    # ax.set_yticks([-4,-2,-1,-0.5,-0.2,-0.1,-0.05,0,0.05,0.1,0.2,0.5,1,2,4])
    # ax.set_ylim([-0.05,6])
    # from matplotlib import ticker
    # ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    # ax.minorticks_off()
    
    b2 = ax2.bar(x_ax+1.2, np.array(DB_abs_biome[0].values()) / 1e15, width, color='C1')

    # ax.set_yscale('symlog', basey=2, linthreshy=1)
    # ax.set_yticks([-40, -20, -10, -5, -2, -1, -0.5, 0, 0.5, 1, 2, 5, 10, 20, 40])
    # ax.set_ylim([-60, 60])
    # from matplotlib import ticker
    # ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    # ax.minorticks_off()
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45, fontsize=textsize * tickredux)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.axhline(color='black')
    ax.legend([b1, b2], ['AGB+LIT', 'DM'], fontsize=textsize)
    ax.set_ylabel('Absolute difference (PgC)', fontsize=textsize)
    ax2.set_ylabel('Absolute difference (PgC)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    ax.set_ylim([-2.5, 5])
    ax2.set_ylim([-0.025, 0.05])
    
    fig.subplots_adjust(bottom=0.2)
    
    plt.show()
#plot_res_biome_diff(16)


def FIGURE6(fign, filename=None):
    
    FL_abs_biome = Model.biome_calc(FL_abs, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    FC_abs_biome = Model.biome_calc(FC_abs, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    DB_abs_biome = Model.biome_calc(DB_abs, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    
    BA_025 = data025['BAsum']
    FC_abs_biomeW = weighted_pdf(FC_abs, BA_025, biomes)
    
    #FC_mod_biome = Model.biome_calc(FC_mod, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    #FC_ref_biome = Model.biome_calc(FC_ref, ['total']+biomes.keys(), 0.25, years[len(years)/2], 'Africa')
    #FC_mod_biomeW = weighted_pdf(FC_mod, BA_025, biomes)
    #FC_ref_biomeW = weighted_pdf(FC_ref, BA_025, biomes)

    # FC_ttest = scipy.stats.ttest_ind(FC_model[~np.isnan(FC_model)], FC_model500[~np.isnan(FC_model500)])
    #FC_ttest = scipy.stats.ttest_ind(FC_mod_biomeW['2'], FC_ref_biomeW['2'])
    
    textsize = 16
    tickredux = 0.9  # ticklabel fontsize smaller.
    
    fig = plt.figure(fign, (8, 8.5))
    
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(211)
    ax2 = ax.twinx()
    b1 = ax.bar(x_ax, np.array(FL_abs_biome[0].values()) / 1e15, width)
    b2 = ax2.bar(x_ax + 1.2, np.array(DB_abs_biome[0].values()) / 1e15, width, color='C1')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels([])
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.axhline(color='black')
    ax.legend([b1, b2], ['AGBL', 'Carbon emissions'], fontsize=textsize)
    ax.set_ylabel('Difference in AGBL (Pg C)', fontsize=textsize)
    ax2.set_ylabel('Difference in emissions (Pg C yr$^{-1}$)', fontsize=textsize, labelpad=10)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax2.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    ax.set_ylim([-5, 2.5])
    ax2.set_ylim([-0.05, 0.025])
    
    fig.text(0, 1, '(a)', size=textsize, verticalalignment='top') #, weight='bold')
    
    
    ax = fig.add_subplot(212)
    bp1 = ax.boxplot(FL_abs_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FC_abs_biomeW.values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    for bp, color in zip([bp1, bp2], ['C0', 'C1']):
        # for bp, color in zip([bp1, bp2, bp3], ['C2', 'C0', 'C1']):
        plt.setp(bp['boxes'], color=color)
        plt.setp(bp['means'], markerfacecolor=color, markeredgecolor=color, markersize=10)
        plt.setp(bp['medians'], color='black')
    
    l1 = ax.scatter([], [], c='C0')  # empty scatter objects to create handles with dots for legend.
    l2 = ax.scatter([], [], c='C1')
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    labels = ax.set_xticklabels(['Africa (all biomes)'] + biomes.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    #labels[0].set_y(0.04)
    #ax.set_xticklabels(labels)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.axhline(color='black')
    ax.legend([l1, l2], ['AGBL', 'Fuel consumption'], fontsize=textsize)
    ax.set_ylabel('Difference (g C m$^{-2}$)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    ax.set_yscale('symlog', basey=2, linthreshy=40)
    ax.set_yticks([-4000, -2000, -1000, -500, -200, -100, -50, -20, 0, 20, 50, 100, 200, 500, 1000, 2000, 4000])
    ax.set_ylim([-6000, 3000])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.set_yticklabels(['{:,}'.format(int(x)).replace(',',' ') for x in ax.get_yticks().tolist()])
    ax.minorticks_off()
    
    fig.text(0, 0.57, '(b)', size=textsize, verticalalignment='top') #, weight='bold')
    
    plt.tight_layout()
    plt.subplots_adjust(hspace=0.1)
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
#FIGURE6(6, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure6_rev_TNR_new')


def FIGURE10(fign, filename=None):
    
    # ''' AGBL '''
    # Biome_rel = FL_rel - FL_relb
    # Biome_rel, _ = Model.perc_cut(Biome_rel, 0)
    # 
    # Biomep_rel = FL_relb - FL_relbp
    # Biomep_rel, _ = Model.perc_cut(Biomep_rel, 0)
    # 
    # Fire_rel = FL_rel - FL_relnf
    # Fire_rel, _ = Model.perc_cut(Fire_rel, 0)
    # 
    # FireRest_rel = FL_relbp - FL_relbpnf
    # FireRest_rel, _ = Model.perc_cut(FireRest_rel, 0)
    # 
    # Rest_rel_plot = FL_rel - (Biome_rel_plot + Biomep_rel_plot + FireRest_rel_plot)
    # 
    # ''' Emissions '''
    # BiomeFC_rel_plot = FC_rel - FC_relb
    # BiomeFC_rel_plot, _ = Model.perc_cut(BiomeFC_rel_plot, 0)
    # 
    # BiomepFC_rel_plot = FC_relb - FC_relbp
    # BiomepFC_rel_plot, _ = Model.perc_cut(BiomepFC_rel_plot, 0)
    # 
    # MBF_rel_plot = FC_rel - FC_relm
    # MBF_rel_plot, _ = Model.perc_cut(MBF_rel_plot, 0)
    # 
    # RestFC_rel_plot = FC_relbpm.copy()
    # RestFC_rel_plot, _ = Model.perc_cut(RestFC_rel_plot, 0)
    
    # rmax = 5
    # FL_rel2[FL_rel2>rmax] = np.nan
    # FC_rel2[FC_rel2>rmax] = np.nan
    # Fire_rel[Fire_rel>rmax] = np.nan
    # Biome_rel[Biome_rel>rmax] = np.nan
    # BiomeFire_rel[BiomeFire_rel>rmax] = np.nan
    # MBF_rel[MBF_rel>rmax] = np.nan
    # Mort_rel[Mort_rel>rmax] = np.nan
    # FireRest_rel[FireRest_rel>rmax] = np.nan
    # Rest_rel[Rest_rel > rmax] = np.nan
    # BiomeFC_rel[BiomeFC_rel > rmax] = np.nan
    # MBFFC_rel[MBFFC_rel > rmax] = np.nan
    # MortFC_rel[MortFC_rel > rmax] = np.nan
    # RestFC_rel[RestFC_rel>rmax] = np.nan
    # Biomep_rel[Biomep_rel > rmax] = np.nan
    # BiomepFC_rel[BiomepFC_rel > rmax] = np.nan
    
    FL_rel_biome = Model.biome_calc(FL_rel2, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    FC_rel_biome = Model.biome_calc(FC_rel2, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    Fire_rel_biome = Model.biome_calc(Fire_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    Biome_rel_biome = Model.biome_calc(Biome_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    BiomeFire_rel_biome = Model.biome_calc(BiomeFire_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MBF_rel_biome = Model.biome_calc(MBF_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    Mort_rel_biome = Model.biome_calc(Mort_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    FireRest_rel_biome = Model.biome_calc(FireRest_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    Rest_rel_biome = Model.biome_calc(Rest_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    BiomeFC_rel_biome = Model.biome_calc(BiomeFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MBFFC_rel_biome = Model.biome_calc(MBFFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    MortFC_rel_biome = Model.biome_calc(MortFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    RestFC_rel_biome = Model.biome_calc(RestFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    Biomep_rel_biome = Model.biome_calc(Biomep_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    BiomepFC_rel_biome = Model.biome_calc(BiomepFC_rel, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    # BA_025 = data025['BAsum']
    # FC_rel_biomeW = weighted_pdf(FC_rel2, BA_025)
    # BiomeFC_rel_biomeW = weighted_pdf(BiomeFC_rel, BA_025)
    # MBFFC_rel_biomeW = weighted_pdf(MBFFC_rel, BA_025)
    # MortFC_rel_biomeW = weighted_pdf(MortFC_rel, BA_025)
    # RestFC_rel_biomeW = weighted_pdf(RestFC_rel, BA_025)
    # BiomepFC_rel_biomeW = weighted_pdf(BiomepFC_rel, BA_025)
    # 
    # FC_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in FC_rel_biomeW.iteritems())
    # BiomeFC_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in BiomeFC_rel_biomeW.iteritems())
    # MBFFC_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in MBFFC_rel_biomeW.iteritems())
    # MortFC_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in MortFC_rel_biomeW.iteritems())
    # RestFC_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in RestFC_rel_biomeW.iteritems())
    # BiomepFC_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in BiomepFC_rel_biomeW.iteritems())
    # 
    # FL_rel_biomeW = weighted_pdf(FL_rel2, BA_025)
    # Fire_rel_biomeW = weighted_pdf(Fire_rel, BA_025)
    # Biome_rel_biomeW = weighted_pdf(Biome_rel, BA_025)
    # BiomeFire_rel_biomeW = weighted_pdf(BiomeFire_rel, BA_025)
    # MBF_rel_biomeW = weighted_pdf(MBF_rel, BA_025)
    # Mort_rel_biomeW = weighted_pdf(Mort_rel, BA_025)
    # FireRest_rel_biomeW = weighted_pdf(FireRest_rel, BA_025)
    # Rest_rel_biomeW = weighted_pdf(Rest_rel, BA_025)
    # Biomep_rel_biomeW = weighted_pdf(Biomep_rel, BA_025)
    # 
    # FL_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in FL_rel_biomeW.iteritems())
    # Fire_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in Fire_rel_biomeW.iteritems())
    # Biome_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in Biome_rel_biomeW.iteritems())
    # BiomeFire_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in BiomeFire_rel_biomeW.iteritems())
    # MBF_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in MBF_rel_biomeW.iteritems())
    # Mort_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in Mort_rel_biomeW.iteritems())
    # FireRest_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in FireRest_rel_biomeW.iteritems())
    # Rest_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in Rest_rel_biomeW.iteritems())
    # Biomep_rel_biomeW = OrderedDict((key, np.mean(val)) for key, val in Biomep_rel_biomeW.iteritems())
    
    textsize = 17
    tickredux = 0.9  # ticklabel fontsize smaller.
    
    fig = plt.figure(fign, (10, 6.8))
    
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(111)
    ''' Average relative difference '''  # This is correct, relative average difference is not useful.
    
    def stacked_bars(barlist, colorlist, offset=0):
        cumpos = np.zeros(xlen)
        cumneg = np.zeros(xlen)
        blist = []
        for i, baritem in enumerate(barlist):
            baritem_pos = np.array(baritem)
            baritem_neg = np.array(baritem)
            baritem_pos[baritem_pos < 0] = 0
            baritem_neg[baritem_neg > 0] = 0

            b = ax.bar(x_ax + offset, baritem_pos, width, bottom=cumpos, color=colorlist[i], alpha=0.4)
            ax.bar(x_ax + offset, baritem_neg, width, bottom=cumneg, color=colorlist[i], alpha=0.4)

            cumpos = cumpos + baritem_pos
            cumneg = cumneg + baritem_neg
            blist.append(b)

        return blist
    
    # barlist = [Biome_rel_biome[1].values(), FireRest_rel_biome[1].values(), BiomeFire_rel_biome[1].values(), MBF_rel_biome[1].values(), Rest_rel_biome[1].values()] #Mort_rel_biome[1].values(), ]
    # colorlist = ['C0', 'red', 'purple', 'yellow', 'grey'] #'brown', ]
    # FL_blist = stacked_bars(barlist, colorlist)
    # 
    # barlist = [BiomeFC_rel_biome[1].values(), MBFFC_rel_biome[1].values(), RestFC_rel_biome[1].values()] #, MortFC_rel_biome[1].values()]
    # colorlist = ['C1', 'yellow', 'grey'] #  'brown']
    # FC_blist = stacked_bars(barlist, colorlist, offset=1.2)
    
    barlist = [Biome_rel_biome[1].values(), Biomep_rel_biome[1].values(), FireRest_rel_biome[1].values(), MBF_rel_biome[1].values(), Rest_rel_biome[1].values()]
    colorlist = ['C0', 'blue', 'red',  'brown', 'grey']
    FL_blist = stacked_bars(barlist, colorlist)
    
    barlist = [BiomeFC_rel_biome[1].values(), BiomepFC_rel_biome[1].values(), MBFFC_rel_biome[1].values(), RestFC_rel_biome[1].values()]
    colorlist = ['C1', 'yellow', 'brown', 'grey']
    FC_blist = stacked_bars(barlist, colorlist, offset=1.2)
    
    # for i, y in enumerate(FL_rel_biome[1].values()):
    #     ax.plot([x_ax[i]-width/2.0, x_ax[i]+width/2.0], [y, y], c='black')
    # for i, y in enumerate(FC_rel_biome[1].values()):
    #     ax.plot([x_ax[i]+1.2-width/2.0, x_ax[i]+1.2+width/2.0], [y, y], c='black')
    
    pl1 = ax.scatter(x_ax, FL_rel_biome[1].values(), color='C0', marker='s', zorder=5)
    pl2 = ax.scatter(x_ax+1.2, FC_rel_biome[1].values(), color='C1', marker='s', zorder=5)
    
    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa (all biomes)'] + biomes.values(), rotation=25, ha='right', rotation_mode='anchor', fontsize=textsize * tickredux)
    plt.xlim([-0.2, np.max(x_ax) + spacing - 0.3])
    ax.set_ylim([-0.45, 0.5])
    ax.axhline(color='black')
    #ax.legend([pl1, FL_blist[0], FL_blist[1], FL_blist[2], FL_blist[4], pl2, FC_blist[0], FC_blist[1], FC_blist[2]], ['AGBL', 'AGBL - biome misclass.', 'AGBL - pure aggr. error', 'AGBL - fire rest', 'Unexplained', 'Emissions', 'Emissions - biome misclass.', 'Emissions - pure aggr. error', 'Fire return (MBF)'], fontsize=textsize*0.9, ncol=2, loc=0)
    
    leg1 = plt.legend([pl1, FL_blist[0], FL_blist[1], FL_blist[2]], ['AGBL', 'Biome misclass.', 'Pure aggr. error', 'Fire rest'], loc=2, bbox_to_anchor=(0.483, 1), borderpad=0.63, fontsize=textsize*0.9, labelspacing=0.25, handletextpad=0.5)
    leg2 = plt.legend([pl2, FC_blist[0], FC_blist[1]], ['Emissions', 'Biome misclass.', 'Pure aggr. error'], loc=2, bbox_to_anchor=(0.495+0.239, 1), borderpad=0.63, fontsize=textsize*0.9, labelspacing=0.25, handletextpad=0.5)
    leg3 = plt.legend([FC_blist[2], FL_blist[4]], ['Fire return (MBF)', 'Unexplained'], loc=2, bbox_to_anchor=(0.483, 0.779), fontsize=textsize*0.9, labelspacing=0.25, handletextpad=0.5)
    # Legend 1 width is 0.23, height is 0.2 (without borderpadding)
    ax.add_artist(leg1)
    ax.add_artist(leg2)
    ax.add_artist(leg3)
    
    
    ax.set_ylabel('Relative difference (-)', fontsize=textsize)
    ax.yaxis.set_tick_params(labelsize=textsize * tickredux)
    ax.set_yticks([0.4,0.3,0.2,0.1,0.0,-0.1,-0.2,-0.3,-0.4])
    
    ax.grid(axis='y', linestyle='--', zorder=0)
    ax.set_axisbelow(True)  # gridlines behind plot objects.

    plt.tight_layout()
    plt.subplots_adjust(hspace=0.1)
    
    if filename != None:
        plt.savefig(filename, dpi=300)
    else:
        plt.show()
FIGURE10(10) #, filename='/Volumes/Mac_HD/Work/Vici_project/Writings/Paper1/figures_final/' + 'Figure10_rev_TNR_new')


def representation_error(fign, filename=None):
    
    sdirn = 'FL_500m_Africa_' + sdateT2 + '/'
    sdir = wdir + 'results/' + sdirn
    data500_T2 = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode), sdir + 'translate_025deg_mode%s.npz' % mode)

    sdirn = 'FL_025deg_Africa_' + sdateT2 + '/'
    sdir = wdir + 'results/' + sdirn
    data025_T2 = Model.saver(lambda: Model.load_deg(sdir, 0.25, mode), sdir + 'load_025deg_mode%s.npz' % mode)

    FL_025_T2 = data025_T2['FL']
    FL_500_T2 = data500_T2['FL']
    DB_025_T2 = data025_T2['DBsum']
    DB_500_T2 = data500_T2['DBsum']
    
    print 'debug'
#representation_error(101)


def plot_res_biome(fign):
    
    FL_ref_biome = Model.biome_calc(FL_ref, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    FC_ref_biome = Model.biome_calc(FC_ref, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    FL_mod_biome = Model.biome_calc(FL_mod, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    FC_mod_biome = Model.biome_calc(FC_mod, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    DB_ref_biome = Model.biome_calc(DB_ref, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    DB_mod_biome = Model.biome_calc(DB_mod, ['total'] + biomes.keys(), 0.25, years[len(years) / 2], 'Africa')
    
    fig = plt.figure(fign)
    
    ax = fig.add_subplot(311)
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    b1 = ax.bar(x_ax, FL_ref_biome[1].values(), width)
    b2 = ax.bar(x_ax + 1.2, FL_mod_biome[1].values(), width)
    
    bp1 = ax.boxplot(FL_ref_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FL_mod_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    ax.set_yscale('symlog', basey=2, linthreshy=200)
    ax.set_yticks([0,100,200,500,1000,2000,5000,10000,20000])
    ax.set_ylim([0,35000])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.legend([b1, b2], ['FL_ref', 'FL_mod'])
    ax.set_ylabel('Biomass (gC m$^{-2}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    
    ax = fig.add_subplot(312)
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    b1 = ax.bar(x_ax, FC_ref_biome[1].values(), width)
    b2 = ax.bar(x_ax + 1.2, FC_mod_biome[1].values(), width)
    
    bp1 = ax.boxplot(FC_ref_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(FC_mod_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    ax.set_yscale('symlog', basey=2, linthreshy=100)
    ax.set_yticks([0,50,100,200,500,1000,2000,5000])
    ax.set_ylim([0,8000])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.legend([b1, b2], ['FC_ref', 'FC_mod'])
    ax.set_ylabel('Fuel consumption (gC m$^{-2}$ burned)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    
    ax = fig.add_subplot(313)
    width = 1
    spacing = 3
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)

    b1 = ax.bar(x_ax, DB_ref_biome[1].values(), width)
    b2 = ax.bar(x_ax + 1.2, DB_mod_biome[1].values(), width)

    bp1 = ax.boxplot(DB_ref_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    bp2 = ax.boxplot(DB_mod_biome[4].values(), showmeans=True, showfliers=False, positions=x_ax + 1.2, meanprops={'marker': '.'}, whis=[5, 95], widths=width)
    
    ax.set_yscale('symlog', basey=2, linthreshy=10)
    ax.set_yticks([0, 5, 10, 20, 50, 100, 200, 500])
    ax.set_ylim([0, 500])
    from matplotlib import ticker
    ax.get_yaxis().set_major_formatter(ticker.ScalarFormatter())
    ax.minorticks_off()

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45)
    plt.xlim([0.1, np.max(x_ax) + spacing])
    ax.legend([b1, b2], ['FC_ref', 'FC_mod'])
    ax.set_ylabel('Dry matter emissions (gC m$^{-2}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    
    plt.show()
#plot_res_biome(17)


#endregion \\\

print 'debug'

#region /// Resolution comparison, variability

# Simple percentage of land cover classes misclassified.
LCperc = Model.readdata_LCperc('LC2perc', 0.25, '2010', 'Africa')
major = np.sort(np.squeeze(np.array(LCperc.values())), axis=0)
misclass = (1 - major[-1]) * 100
misclass[misclass == 100] = 0

# Index of qualitative variation (IQV)
def calc_local_IQV():
    var = 'LC'
    res = 0.25;
    ress = '025deg'
    
    X = Model.readdata_MODIS('LC2', res, years[len(years) / 2], 'Africa')[0].astype(float)
    
    def IQV(values):
        N = float(len(values))
        fractions = np.unique(values, return_counts=True)[1] / N  # category counts divided by total number of values.
        
        sqsum = 0
        for f in fractions:
            sqsum = sqsum + f ** 2
            
        return (N * (1 - sqsum)) / (N - 1)
    
    time0 = timer.time()
    iqvlocal = Model.saver(lambda: scipy.ndimage.generic_filter(X, IQV, size=3), rdir + 'varlocal_' + sdate + '_IQV_' + var + ress + '.tif')
    print 'Duration_IQV_' + var + ress + ': %s' % (timer.time() - time0)
    
    # var_biome[ress] = Model.biome_calc(var_catlocal, ['total'] + biomes.keys(), res, years[len(years) / 2], 'Africa')[1]
    
    return iqvlocal
LC_iqv_local = calc_local_IQV()
LC_iqv_local_biome = Model.biome_calc(LC_iqv_local, ['total']+biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

def calc_LC_IQV(resdeg):
    ress = '%03.0fdeg' % float(('%0.2f' % round(resdeg, 2)).lstrip('0.'))  # converts e.g. 0.25 -> '025deg'
    
    LC2perc = Model.readdata_LCperc('LC2', resdeg, years[len(years) / 2], 'Africa')
    
    N = np.load(wdir_geo + '00_Total_pixels_' + ress + '.npy')
    indexdeg = Model.load_degbox(resdeg, 'Africa')[0]
    N = N[indexdeg['lat'][0]:indexdeg['lat'][-1] + 1, indexdeg['lon'][0]:indexdeg['lon'][-1] + 1]
    
    sqsum = 0
    k = np.zeros(N.shape)
    for biome_perc in LC2perc.values():
        sqsum = sqsum + biome_perc[0] ** 2
        k[biome_perc[0] > 0] = k[biome_perc[0] > 0] + 1     # number of categories.
    IQV = (k * (1 - sqsum)) / (k-1)     # Source: https://www.youtube.com/watch?v=oQCqaS1ICwk
    IQV[np.isnan(IQV)] = 0
    
    return IQV
LC_iqv = calc_LC_IQV(0.25)
LC_iqv[np.isnan(LC_iqv)] = 0
LC_iqv_biome = Model.biome_calc(LC_iqv, ['total']+biomes.keys(), 0.25, years[len(years) / 2], 'Africa')

def calc_turnover_variability(resdeg):
    ress = '%03.0fdeg' % float(('%0.2f' % round(resdeg, 2)).lstrip('0.'))  # converts e.g. 0.25 -> '025deg'
    
    LC2perc = Model.readdata_LCperc('LC2', resdeg, years[len(years) / 2], 'Africa')
    
    N = np.load(wdir_geo + '00_Total_pixels_' + ress + '.npy')
    indexdeg = Model.load_degbox(resdeg, 'Africa')[0]
    N = N[indexdeg['lat'][0]:indexdeg['lat'][-1] + 1, indexdeg['lon'][0]:indexdeg['lon'][-1] + 1]
    
    sdir = wdir + 'results/' + 'debug_testrun/'
    n = Model(sdir, mode=2, resolution=resdeg, tile='Africa', firemode='on', act='passive')
    turnover = n.modparams['turnover_stem']
    
    LC = Model.readdata_MODIS('LC2', resdeg, years[len(years) / 2], 'Africa')[0]
    for paramkey in n.modparams.keys():
        if type(n.modparams[paramkey]) == np.ndarray:
            n.modparams[paramkey] = n.modparams[paramkey][LC]
    turnover_map1 = n.modparams['turnover_stem']
    
    turnover_map2 = 0
    for i, biome_perc in LC2perc.iteritems():
        turnover_map2 = turnover_map2 + (biome_perc[0] * turnover[i])   # this is the weighted mean!!!
    lwmask = Model.readdata_LWMASK('LWM', resdeg, 'Africa')
    turnover_map2[np.isnan(lwmask)] = turnover[0]   # set oceans to water turnover.
    
    var_turnover = 0
    for i, biome_perc in LC2perc.iteritems():
        var_turnover = var_turnover + biome_perc[0] * ((turnover[i] - turnover_map2) ** 2)
    
    return turnover_map1, turnover_map2, var_turnover
_, _, var_turnover = calc_turnover_variability(0.25)

def plot_IQV_biome(fign):
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(211)
    da = ax.imshow(LC_iqv)
    cb = fig.colorbar(da)
    cb.set_label('Index of qualitative variation (IQV)', rotation=270, labelpad=20)
    
    ax = fig.add_subplot(212)
    da = ax.imshow(var_turnover)
    cb = fig.colorbar(da)
    cb.set_label('Variance in stem turnover rate', rotation=270, labelpad=20)
    
    fig = plt.figure(fign+1)
    width = 1
    spacing = 2
    xlen = len(biomes) + 1
    x_ax = np.arange(1, xlen * spacing, spacing)
    
    ax = fig.add_subplot(111)

    b = ax.bar(x_ax, LC_iqv_biome[1].values(), width)

    ax.set_xticks(x_ax + ((spacing - 2) * 1.2) / 2.0)
    ax.set_xticklabels(['Africa'] + biomes.values(), rotation=45, ha='right', rotation_mode='anchor')
    ax.set_xlim([0.1, np.max(x_ax) + spacing])
    ax.set_ylim([0, 0.9])
    ax.axhline(color='black')
    ax.set_ylabel('Average IQV per biome (gC m$^{-2}$)')
    ax.grid(axis='y', linestyle='--')
    ax.set_axisbelow(True)  # gridlines behind plot objects.
    fig.subplots_adjust(bottom=0.25)
    
    plt.show()
#plot_IQV_biome(1)

print 'debug'




sdirn = 'FL_500m_Africa_'+sdateT2+'/'
sdir = wdir + 'results/' + sdirn

print 'START variability calc'
def calc_variability(var, varcalc):
    
    if 'sum' in var:    method = 'sum'
    else:               method = 'avg'
    
    if 'sum' in var:    varr = var[:-3]
    elif 'avg' in var:  varr = var[:-3]
    else:               varr = var[:]
    
    @cfunc(intc(CPointer(float64), intp, CPointer(float64), voidptr))
    def nb_nanstd(values_ptr, len_values, result, data):
        # checked: same functionality as np.nanmin
        values = carray(values_ptr, (len_values,), dtype=float64)
        i = 0
        sum = 0.0
        mean = 0.0
        result[0] = 0.0

        if not np.isnan(values).all():
            for v in values:
                if ~np.isnan(v):
                    i += 1
                    sum += v
            if i > 0:
                mean = sum / i
            for v in values:
                if ~np.isnan(v):
                    result[0] += pow(v - mean, 2)
            if i > 0:
                result[0] = np.sqrt(result[0] / i)
        elif np.isnan(values).all():
            result[0] = np.nan
        return 1
    
    var_biome = OrderedDict()
    if varcalc in ['image', 'local']:   reslist = ['025', '013', '005', '500', '025t', '025b', '025c']
    elif varcalc == 'compa':            reslist = ['025', '013', '005', '500']
    for ress in reslist:
        
        if '025' in ress:   res = 0.25;     sdirn = 'FL_025deg_Africa_'+sdate+'/'
        elif ress == '013': res = 0.125;    sdirn = 'FL_013deg_Africa_'+sdate+'/'
        elif ress == '005': res = 0.05;     sdirn = 'FL_005deg_Africa_'+sdate+'/'
        elif ress == '500': res = 500;      sdirn = 'FL_500m_Africa_'+sdate+'/'
        
        if ress[-1:] == 't':    res = 500;  sdirn = 'FL_500m_Africa_'+sdate+'/'
        elif ress[-1:] == 'b':  res = 0.125; sdirn = 'FL_013deg_Africa_'+sdate+'/'
        elif ress[-1:] == 'c':  res = 0.05; sdirn = 'FL_005deg_Africa_'+sdate+'/'
        
        if varcalc == 'compa':  res2 = float(res); res = 500;  sdirn = 'FL_500m_Africa_'+sdate+'/'
        
        sdir = wdir + 'results/' + sdirn
        
        #if varr == 'FC':
        #    if res == 500:
        #        X = Model.saver(lambda: Model.tile_paste(lambda tile: Model.load_2dvar(sdir, res, tile, 'DB', method), tiles), sdir + 'DB'+method+'500.tif')
        #        BA = Model.saver(lambda: Model.tile_paste(lambda tile: Model.load_2dvar(sdir, res, tile, 'BA', method), tiles), sdir + 'BA'+method+'500.tif')
        #    else:
        #        X = Model.load_2dvar(sdir, res, 'Africa', 'DB', method)
        #        BA = Model.load_2dvar(sdir, res, 'Africa', 'BA', method)
        #    X = X * Model.load_area(res, 'Africa')[0] / BA
        
        #else:
        if res == 500:
            X = Model.saver(lambda: Model.tile_paste(lambda tile: Model.load_2dvar(sdir, res, tile, varr, method), tiles), sdir + var+'500.tif')
        else:
            X = Model.load_2dvar(sdir, res, 'Africa', varr, method)
        
        if any(letter in ress for letter in ['b', 'c']):
            X = Model.translate_deg_to_coarser(X, res, 0.25)
            res = 0.25
        elif 't' in ress:
            mode = 2
            data = Model.saver(lambda: Model.translate_to_deg(sdir, 0.25, mode), sdir + 'translate_025deg_mode%s.npz' % mode)
            X = data[var]
            res = 0.25
            
        if res == 500:
            mask = Model.saver(lambda: Model.tile_paste(lambda tile: Model.readdata_LWMASK('LWM', res, tile), tiles), rdir + 'LW500.tif')
        else:
            mask = Model.readdata_LWMASK('LWM', res, 'Africa', frac='no') * Model.tile_mask(res, tiles, frac='no', extent='Africa')[0]
        
        
        if varcalc == 'image':
            var_biome[ress] = Model.biome_calc(X * mask, ['total'] + biomes.keys(), res, years[len(years)/2], 'Africa')[2]
            # of 500 direct per tile:   var_std[ress] = Model.biome_calctile(lambda tile: Model.load_2dvar(sdir, res, tile, varr, method), ['total']+biomes.keys(), res, years[len(years)/2], tiles)[2]
        
        elif varcalc == 'local':
            time0 = timer.time()
            var_local = Model.saver(lambda: scipy.ndimage.generic_filter(X * mask, LowLevelCallable(nb_nanstd.ctypes), size=3), sdir + 'varlocal_' + var + ress + '.tif')
            print 'Duration_local_' + var + ress + ': %s' % (timer.time() - time0)
            
            var_biome[ress] = Model.biome_calc(var_local, ['total'] + biomes.keys(), res, years[len(years) / 2], 'Africa')[1]
            
        elif varcalc == 'compa':
            if res2 == 500:     res2 = 0.005
            f = int(res2 / 0.005)
            time0 = timer.time()
            var_compa = Model.saver(lambda: scipy.ndimage.generic_filter(X * mask, LowLevelCallable(nb_nanstd.ctypes), size=3*f), sdir + 'varcompa_' + var + ress + '.tif')
            print 'Duration_compa_' + var + ress + ': %s' % (timer.time() - time0)
            
            var_biome[ress] = Model.biome_calc(var_compa, ['total'] + biomes.keys(), 500, years[len(years) / 2], 'Africa')[1]
        
    return var_biome

varimage_FL = Model.saver(lambda: calc_variability('FL', 'image'), rdir+'varimage_'+sdateT2+'_FL.npy')
varimage_FCsum = Model.saver(lambda: calc_variability('FCsum', 'image'), rdir+'varimage_'+sdateT2+'_FCsum.npy')
varimage_BAsum = Model.saver(lambda: calc_variability('BAsum', 'image'), rdir+'varimage_'+sdateT2+'_BAsum.npy')
varimage_FTC = Model.saver(lambda: calc_variability('FTC', 'image'), rdir+'varimage_'+sdateT2+'_FTC.npy')
varimage_DBsum = Model.saver(lambda: calc_variability('DBsum', 'image'), rdir+'varimage_'+sdateT2+'_DBsum.npy')

varlocal_FL = Model.saver(lambda: calc_variability('FL', 'local'), rdir+'varlocal_'+sdateT2+'_FL.npy')
varlocal_FCsum = Model.saver(lambda: calc_variability('FCsum', 'local'), rdir+'varlocal_'+sdateT2+'_FCsum.npy')
varlocal_BAsum = Model.saver(lambda: calc_variability('BAsum', 'local'), rdir+'varlocal_'+sdateT2+'_BAsum.npy')
varlocal_FTC = Model.saver(lambda: calc_variability('FTC', 'local'), rdir+'varlocal_'+sdateT2+'_FTC.npy')
varlocal_DBsum = Model.saver(lambda: calc_variability('DBsum', 'local'), rdir+'varlocal_'+sdateT2+'_DBsum.npy')

varcompa_FL = Model.saver(lambda: calc_variability('FL', 'compa'), rdir+'varcompa_'+sdateT2+'_FL.npy')
varcompa_FCsum = Model.saver(lambda: calc_variability('FCsum', 'compa'), rdir+'varcompa_'+sdateT2+'_FCsum.npy')
varcompa_BAsum = Model.saver(lambda: calc_variability('BAsum', 'compa'), rdir+'varcompa_'+sdateT2+'_BAsum.npy')
varcompa_FTC = Model.saver(lambda: calc_variability('FTC', 'compa'), rdir+'varcompa_'+sdateT2+'_FTC.npy')
varcompa_DBsum = Model.saver(lambda: calc_variability('DBsum', 'compa'), rdir+'varcompa_'+sdateT2+'_DBsum.npy')




print 'debug'

def plot_image_var(fign, biome):
    
    varimage_FC = varimage_FCsum.copy()
    varimage_DB = varimage_DBsum.copy()
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(131)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FL['025t'][biome], varimage_FL['025c'][biome], varimage_FL['025b'][biome], varimage_FL['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FL['500'][biome], varimage_FL['005'][biome], varimage_FL['013'][biome], varimage_FL['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Image variability - Fuel load')
    ax.legend([pl1, pl2], ['0.25 degree aggr.', 'native resolutions'])

    ax = fig.add_subplot(132)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FC['025t'][biome], varimage_FC['025c'][biome], varimage_FC['025b'][biome], varimage_FC['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FC['500'][biome], varimage_FC['005'][biome], varimage_FC['013'][biome], varimage_FC['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Image variability - Fuel consumption')
    ax.legend([pl1, pl2], ['0.25 degree aggr.', 'native resolutions'])
    
    ax = fig.add_subplot(133)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_DB['025t'][biome], varimage_DB['025c'][biome], varimage_DB['025b'][biome], varimage_DB['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_DB['500'][biome], varimage_DB['005'][biome], varimage_DB['013'][biome], varimage_DB['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Image variability - DM emissions')
    ax.legend([pl1, pl2], ['0.25 degree aggr.', 'native resolutions'])
    plt.show()

def plot_local_var(fign, biome):
    
    varlocal_FC = varlocal_FCsum.copy()
    varlocal_DB = varlocal_DBsum.copy()
    
    fig1 = plt.figure(fign)
    ax = fig1.add_subplot(131)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FL['025t'][biome], varlocal_FL['025c'][biome], varlocal_FL['025b'][biome], varlocal_FL['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FL['500'][biome], varlocal_FL['005'][biome], varlocal_FL['013'][biome], varlocal_FL['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Local variability - Fuel load')
    ax.legend([pl1, pl2], ['0.25 degree aggr.', 'native resolutions'])
    
    # spatial maps
    varlocal_map_FL = OrderedDict()
    for ress in ['025t', '025']:
        var = 'FL'
        
        if '025' in ress:   sdirn = 'FL_025deg_Africa_17-06_2/'
        elif ress == '013': sdirn = 'FL_013deg_Africa_17-06_2/'
        elif ress == '005': sdirn = 'FL_005deg_Africa_17-06_2/'
        elif ress == '500': sdirn = 'FL_500m_Africa_17-06_2/'
        
        if ress[-1:] == 't':    sdirn = 'FL_500m_Africa_17-06_2/'
        elif ress[-1:] == 'b':  sdirn = 'FL_013deg_Africa_17-06_2/'
        elif ress[-1:] == 'c':  sdirn = 'FL_005deg_Africa_17-06_2/'
        
        sdir = wdir + 'results/' + sdirn
        filename = sdir + 'varlocal_' + var + ress
        
        varlocal_map_FL[ress] = gdal.Open(filename + '.tif', gdalconst.GA_ReadOnly).ReadAsArray()

    fig2 = plt.figure(fign+1)
    ax = fig2.add_subplot(211)
    da = ax.imshow(varlocal_map_FL['025t'])
    ax.set_title('Fuel load - local variabilty 500m aggr.')
    ax = fig2.add_subplot(212)
    da = ax.imshow(varlocal_map_FL['025'])
    ax.set_title('Fuel load - local variability 0.25 degree')
    fig2.colorbar(da)

    ax = fig1.add_subplot(132)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FC['025t'][biome], varlocal_FC['025c'][biome], varlocal_FC['025b'][biome], varlocal_FC['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FC['500'][biome], varlocal_FC['005'][biome], varlocal_FC['013'][biome], varlocal_FC['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Local variability - Fuel consumption')
    ax.legend([pl1, pl2], ['0.25 degree aggr.', 'native resolutions'])

    # spatial maps
    sdir = wdir + 'results/' + 'run1_500m_Africa_v6_f32/'
    varlocal_map_FC = OrderedDict()
    for ress in ['025t', '025']:
        var = 'FCsum'
        
        if '025' in ress:   sdirn = 'FL_025deg_Africa_17-06_2/'
        elif ress == '013': sdirn = 'FL_013deg_Africa_17-06_2/'
        elif ress == '005': sdirn = 'FL_005deg_Africa_17-06_2/'
        elif ress == '500': sdirn = 'FL_500m_Africa_17-06_2/'
        
        if ress[-1:] == 't':    sdirn = 'FL_500m_Africa_17-06_2/'
        elif ress[-1:] == 'b':  sdirn = 'FL_013deg_Africa_17-06_2/'
        elif ress[-1:] == 'c':  sdirn = 'FL_005deg_Africa_17-06_2/'
        
        sdir = wdir + 'results/' + sdirn
        filename = sdir + 'varlocal_' + var + ress
        
        varlocal_map_FC[ress] = gdal.Open(filename + '.tif', gdalconst.GA_ReadOnly).ReadAsArray()

    fig3 = plt.figure(fign+2)
    ax = fig3.add_subplot(211)
    da = ax.imshow(varlocal_map_FC['025t'])
    ax.set_title('Fuel consumption - local variabilty 500m aggr.')
    ax = fig3.add_subplot(212)
    da = ax.imshow(varlocal_map_FC['025'])
    ax.set_title('Fuel consumption - local variability 0.25 degree')
    fig3.colorbar(da)
    
    ax = fig1.add_subplot(133)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_DB['025t'][biome], varlocal_DB['025c'][biome], varlocal_DB['025b'][biome], varlocal_DB['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_DB['500'][biome], varlocal_DB['005'][biome], varlocal_DB['013'][biome], varlocal_DB['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Local variability - DM emissions')
    ax.legend([pl1, pl2], ['0.25 degree aggr.', 'native resolutions'])
    
    plt.show()

def plot_compa_var(fign, biome):
    
    varcompa_FC = varcompa_FCsum.copy()
    varcompa_DB = varcompa_DBsum.copy()
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(131)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varcompa_FL['500'][biome], varcompa_FL['005'][biome], varcompa_FL['013'][biome], varcompa_FL['025'][biome]], c='C1')
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Comparative variability - Fuel load')
    ax.legend([pl1], ['native resolutions'])
    
    ax = fig.add_subplot(132)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varcompa_FC['500'][biome], varcompa_FC['005'][biome], varcompa_FC['013'][biome], varcompa_FC['025'][biome]], c='C1')
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Comparative variability - Fuel consumption')
    ax.legend([pl1], ['native resolutions'])
    
    ax = fig.add_subplot(133)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varcompa_DB['500'][biome], varcompa_DB['005'][biome], varcompa_DB['013'][biome], varcompa_DB['025'][biome]], c='C1')
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Comparative variability - DM emissions')
    ax.legend([pl1], ['native resolutions'])
    
    plt.show()

def plot_final(fign, biome):
    
    varimage_FC = varimage_FCsum.copy()
    varlocal_FC = varlocal_FCsum.copy()
    varcompa_FC = varcompa_FCsum.copy()
    
    varimage_DB = varimage_DBsum.copy()
    varlocal_DB = varlocal_DBsum.copy()
    varcompa_DB = varcompa_DBsum.copy()
    
    fig = plt.figure(fign)
    ax = fig.add_subplot(131)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FL['500'][biome], varimage_FL['005'][biome], varimage_FL['013'][biome], varimage_FL['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FL['500'][biome], varlocal_FL['005'][biome], varlocal_FL['013'][biome], varlocal_FL['025'][biome]])
    pl3, = ax.plot([0.005, 0.05, 0.125, 0.25], [varcompa_FL['500'][biome], varcompa_FL['005'][biome], varcompa_FL['013'][biome], varcompa_FL['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Fuel load')
    ax.legend([pl1, pl2, pl3], ['Image variability', 'Local variability', 'Comparative variability'])
    
    ax = fig.add_subplot(132)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FC['500'][biome], varimage_FC['005'][biome], varimage_FC['013'][biome], varimage_FC['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FC['500'][biome], varlocal_FC['005'][biome], varlocal_FC['013'][biome], varlocal_FC['025'][biome]])
    pl3, = ax.plot([0.005, 0.05, 0.125, 0.25], [varcompa_FC['500'][biome], varcompa_FC['005'][biome], varcompa_FC['013'][biome], varcompa_FC['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Fuel consumption')
    ax.legend([pl1, pl2, pl3], ['Image variability', 'Local variability', 'Comparative variability'])
    
    ax = fig.add_subplot(133)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_DB['500'][biome], varimage_DB['005'][biome], varimage_DB['013'][biome], varimage_DB['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_DB['500'][biome], varlocal_DB['005'][biome], varlocal_DB['013'][biome], varlocal_DB['025'][biome]])
    pl3, = ax.plot([0.005, 0.05, 0.125, 0.25], [varcompa_DB['500'][biome], varcompa_DB['005'][biome], varcompa_DB['013'][biome], varcompa_DB['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('DM emissions')
    ax.legend([pl1, pl2, pl3], ['Image variability', 'Local variability', 'Comparative variability'])
    
    
    fig = plt.figure(fign+1)
    ax = fig.add_subplot(131)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FL['025t'][biome], varimage_FL['025c'][biome], varimage_FL['025b'][biome], varimage_FL['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FL['025t'][biome], varlocal_FL['025c'][biome], varlocal_FL['025b'][biome], varlocal_FL['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Fuel load - 0.25 degree aggregates')
    ax.legend([pl1, pl2], ['Image variability', 'Local variability'])
    
    ax = fig.add_subplot(132)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_FC['025t'][biome], varimage_FC['025c'][biome], varimage_FC['025b'][biome], varimage_FC['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_FC['025t'][biome], varlocal_FC['025c'][biome], varlocal_FC['025b'][biome], varlocal_FC['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('Fuel consumption - 0.25 degree aggregates')
    ax.legend([pl1, pl2], ['Image variability', 'Local variability'])
    
    ax = fig.add_subplot(133)
    pl1, = ax.plot([0.005, 0.05, 0.125, 0.25], [varimage_DB['025t'][biome], varimage_DB['025c'][biome], varimage_DB['025b'][biome], varimage_DB['025'][biome]])
    pl2, = ax.plot([0.005, 0.05, 0.125, 0.25], [varlocal_DB['025t'][biome], varlocal_DB['025c'][biome], varlocal_DB['025b'][biome], varlocal_DB['025'][biome]])
    ax.set_xlabel('Resolution [decimal degrees]')
    ax.set_ylabel('Standard deviation')
    ax.set_title('DM emissions - 0.25 degree aggregates')
    ax.legend([pl1, pl2], ['Image variability', 'Local variability'])
    
    plt.show()

#plot_image_var(14, 'total')
#plot_local_var(15, '2')
#plot_compa_var(18, 'total')
#plot_final(19, 'total')

#endregion \\\


def BA_percentage_biome():
    
    X = Model.readdata_MODIS('BA', 0.25, years, 'Africa') * Model.load_area(0.25, 'Africa')[0]
    X = np.nanmean(np.nansum(np.reshape(X, (len(X) / 12, 12, X.shape[1], X.shape[2])), axis=1), axis=0)  # average annual sum
    
    biomes = Model.biomes_UMD.keys()[1:-1]
    BA_biome = Model.biome_calc(X, biomes, 0.25, years[len(years)/2], 'Africa')
    
    BA_Africa = np.sum(np.array(BA_biome[0].values()))
    
    return (np.array(BA_biome[0].values()) / BA_Africa) * 100
#BA_biomep = BA_percentage_biome()
#BA_in_savannas = BA_biomep[7] + BA_biomep[8]    # 87% BA in savannas (woody and open combined).

print 'debug'
