! mo_beleg_bgc.f90, line 178:
! =============================
! 
! In MODULE mo_beleg_bgc, the opal remineralization rate is reduced by a 
! factor of 6 for the experiments with particle ballasting; 
! otherwise, too much opal is remineralized in the euphotic zone, and 
! calcite production is suppressed by opal production.
  dremopal = 0.01_wp / 6._wp * dtb



! mo_carbch.f90:
! =============================
! 
! In MODULE mo_carbch, the variables for the particle sinking speeds and the
! second dust field need to be defined (line 76):
  REAL(wp), ALLOCATABLE :: wball(:,:,:)  ! particle sinking speed (POC and ballast)
  REAL(wp), ALLOCATABLE :: wballuncor(:,:,:) ! not corrected for wball>dzw
  REAL(wp), ALLOCATABLE :: wballc(:,:,:)   ! hypothetical POC+calcite
  REAL(wp), ALLOCATABLE :: wballo(:,:,:)   ! hypothetical POC+opal
  REAL(wp), ALLOCATABLE :: wballd(:,:,:)   ! hypothetical POC+dust
  REAL(wp), ALLOCATABLE :: wballdd(:,:,:)  ! actual speed of dust
  REAL(wp), ALLOCATABLE :: wball_poc(:,:,:)
  REAL(wp), ALLOCATABLE :: wball_cal(:,:,:)
  REAL(wp), ALLOCATABLE :: wball_opa(:,:,:)
  REAL(wp), ALLOCATABLE :: wball_dus(:,:,:)
  REAL(wp), ALLOCATABLE, TARGET :: dusty(:,:)
  REAL(wp), ALLOCATABLE, TARGET :: dusty_lgm(:,:) ! LGM dust for ballasting
  !
  ! and allocated (line 356):
    IF ( kchck > 0 ) THEN
      WRITE(io_stdo_bgc,*)'Memory allocation for variable dusty ...'
      WRITE(io_stdo_bgc,*)'First dimension    : ',kpie
      WRITE(io_stdo_bgc,*)'Second dimension   : ',kpje
    ENDIF
    ALLOCATE (dusty(kpie,kpje))
    dusty(:,:) = 0.0_wp
    ALLOCATE (dusty_lgm(kpie,kpje))
    dusty_lgm(:,:) = 0.0_wp

    IF ( kchck > 0 ) THEN
      WRITE(io_stdo_bgc,*)'Memory allocation for variable wball ...'
      WRITE(io_stdo_bgc,*)'First dimension    : ',kpie
      WRITE(io_stdo_bgc,*)'Second dimension   : ',kpje
      WRITE(io_stdo_bgc,*)'Third dimension    : ',kpke
    ENDIF
    ALLOCATE (wball(kpie,kpje,kpke))
    ALLOCATE (wballuncor(kpie,kpje,kpke))
    ALLOCATE (wballdd(kpie,kpje,kpke))
    ALLOCATE (wballc(kpie,kpje,kpke))
    ALLOCATE (wballo(kpie,kpje,kpke))
    ALLOCATE (wballd(kpie,kpje,kpke))
    ALLOCATE (wball_poc(kpie,kpje,kpke))
    ALLOCATE (wball_cal(kpie,kpje,kpke))
    ALLOCATE (wball_opa(kpie,kpje,kpke))
    ALLOCATE (wball_dus(kpie,kpje,kpke))
    wball(:,:,:) = 0._wp
    wballuncor(:,:,:) = 0._wp
    wballdd(:,:,:) = 0._wp
    wballc(:,:,:) = 0._wp
    wballo(:,:,:) = 0._wp
    wballd(:,:,:) = 0._wp
    wball_poc(:,:,:) = 0._wp
    wball_cal(:,:,:) = 0._wp
    wball_opa(:,:,:) = 0._wp
    wball_dus(:,:,:) = 0._wp



! mo_bgc_varlist.f90
!===================
!
! In MODULE mo_bgc_varlist, the sinking speeds (output) and 
! the second dust field (LGM input) are added (line 234):
    CALL varlist_add(bgc_varlist, &
         new_var('dusty', 'dust', &
         'Fixme', 34, dusty, 'p', 's', input_required=.TRUE.))
    CALL varlist_add(bgc_varlist, &
         new_var('dusty_lgm', 'dust', &
         'Fixme', 35, dusty_lgm, 'p', 's', input_required=.TRUE.))
    CALL varlist_add(bgc_varlist, &
         new_var('wball', 'particle sinking speed (Gehlen plus dust), not used everywhere', &
         'm/timestep', 288, wball, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wballuncor', 'wball uncorrected for distances higher than dzw', &
         'm/timestep', 401, wballuncor, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wballc', 'wball if only POC and calcite were present', &
         'm/timestep', 402, wballc, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wballo', 'wball if only POC and opal were present', &
         'm/timestep', 403, wballo, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wballd', 'wball if only POC and dust were present', &
         'm/timestep', 404, wballd, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wball_poc', 'sinking speed of detritus', &
         'm/timestep', 405, wball_poc, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wball_cal', 'sinking speed of calcite', &
         'm/timestep', 406, wball_cal, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wball_opa', 'sinking speed of opal', &
         'm/timestep', 407, wball_opa, 'p', 'c'))
    CALL varlist_add(bgc_varlist, &
         new_var('wball_dus', 'sinking speed of dust', &
         'm/timestep', 408, wball_dus, 'p', 'c'))


! ocprod.f90
!=====================
!
! Particle ballasting and the prognostic sinking speeds are calculated in the
! SUBROUTINE ocprod.f90.

! The additional LGM dust field is loaded (line 41):
  USE mo_carbch, ONLY         : dusty, dusty_lgm, ...

! Additional variables for the excess density calculation are declared (line 135):
  REAL(wp) :: rhosw  ! seawater density for particle ballasting [g m-3]
  REAL(wp) :: rhox,rhoxp,rhoxc,rhoxo,rhoxd ! excess density [g m-3] (and only POC, +calcite, +opal, +dust)
  REAL(wp) :: wball0 ! sinking speed for POC, without calcite, opal or dust [m/day] * timestep dtb [days] => sinking distance of POC [m]
  REAL(wp) :: pdus   ! critical POC concentration, above which dust is included in ballasting [kmolP/m3]

! The appropriate dust input fields are selected for the sensitivity experiments (line 203):
           ELSE
              dustinp = dusty(i, j) / 365._wp * dtb * pdpio(i, j, 1)
              dustinp_lgm = dusty_lgm(i, j) / 365._wp * dtb * pdpio(i, j, 1)
           ENDIF
           ! Select modern or LGM dust deposition for ballasting and / or iron here, prior to compilation:
           !
           ! modern dust:
           !ocetra(i,j,1,ifdust) = ocetra(i,j,1,ifdust) + dustinp + dustinp_volcano ! use present-day dust for ballasting
           !bgcflux(i,j,kfeatm) = dustinp*perc_diron*pddpo(i,j,1)/dtbgc  ! bio available iron kmol/(m**2 s)
           !ocetra(i,j,1,iiron)  = ocetra(i,j,1,iiron) + dustinp*perc_diron  &! perc_diron =.035*.01 /55.85 ! why *0.8 in IPCC_HAM?
           !     &                                     + dustinp_volcano*perc_diron*0.8_wp/3.5_wp  ! volcanic ash has lower iron content
           !
           ! or LGM dust:
           ocetra(i,j,1,ifdust) = ocetra(i,j,1,ifdust) + dustinp_lgm + dustinp_volcano
           bgcflux(i,j,kfeatm) = dustinp_lgm*perc_diron*pddpo(i,j,1)/dtbgc  ! bio available iron kmol/(m**2 s)
           ocetra(i,j,1,iiron)  = ocetra(i,j,1,iiron) + dustinp_lgm*perc_diron  &! perc_diron =.035*.01 /55.85 ! why *0.8 in IPCC_HAM?
                &                                     + dustinp_volcano*perc_diron*0.8_wp/3.5_wp  ! volcanic ash has lower iron content


! And, finally, the excess densities and sinking speeds are calculated (line 215):
  ! Compute sinking speed w_ballast according to Gehlen et al. 2006, but also including the effect of dust.
  ! rhox=(mass of particles/volume of water) excess density
  ! POC==det
  ! ocetra for POC and calcite [molC/m3 water], for opal [molSi/m3 water], and for ifdust [kg/m3 water]
  wball0 = sinkspeed_poc * dtb ! distance [m] POC sinks per bgc timestep (dtb in days) 
  !
  ! Assume that dust is only aggregated where POC > pdus [kmolP/m3]
  pdus=0._wp ! set to 0. -> always include dust in ballasting
  !
  DO k = 1, kpke
     DO j = 1, kpje
        DO i = 1, kpie
         IF (pddpo(i,j,k) > 0.5_wp) THEN               ! wet cell
           ! excess density rhox = sum(molarmass*concentration)/sum(molarmass/density*concentration)-rho_sw
           ! densities for POC=1.06e6g/m3, calcite=2.71e6g/m3, opal=2.10e6g/m3 
           ! molar masses for POC=32.7g/mol, calcite=100g/mol, opal=72.8g/mol
           ! stoichiometric ratios from Takahashi et al. 1985 => C:P=122; see mo_beleg_bgc.f90 
           ! DUST: assume it is mostly quartz (SiO2) with a density of 2.6e6g/m3 (like claydens; see also https://www.mineralienatlas.de)
           !       while really it is a mix with, e.g., illite (2.79e6g/m3), kaolinite (2.68e6g/m3), calcite... 
           !       compare Table 6 in Pye (1987) "Aeolian Dust and Dust Deposits"

           ! make sure POC concentrations are positive
           ! Negative POC concentrations O(1e-16 kmolP/m3) occasionally
           ! occurred in the described simulations.
           IF (ocetra(i,j,k,idet) < 0._wp) THEN
                   WRITE(0,*) "BALLAST WARNING: POC < 0; setting to 0"
                   WRITE(0,*) "i,j,k,det:",i,j,k,ocetra(i,j,k,idet)
                   ocetra(i,j,k,idet) = 0._wp
           ENDIF

           ! make sure dust concentrations are positive
           ! This was an initial precaution, but negative dust concentrations
           ! did not occur in the described simulations.
           IF (ocetra(i,j,k,ifdust) < 0._wp) THEN
                   WRITE(0,*) "BALLAST WARNING: fdust < 0; setting to 0"
                   WRITE(0,*) "i,j,k,fdust:",i,j,k,ocetra(i,j,k,ifdust)
                   ocetra(i,j,k,ifdust) = 0._wp
           ENDIF

           ! use in-situ density
           IF (rhoo(i,j,k) > 1.0599e3_wp) THEN
                   call stop_all('BALLAST: in situ density > rho_POC => negative wball; must use rhoref_water.')
           ENDIF
           rhosw=rhoo(i,j,k)*1.e3_wp ! [g m-3]
           ! OR: use seawater reference density
           ! rhosw=rhoref_water*1.e3_wp ! [g m-3]

           ! hypothetical excess density and sinking speed, assuming POC and calcite are the only particles
           rhoxc= ( 3989.4_wp*ocetra(i,j,k,idet)+100.0_wp*ocetra(i,j,k,icalc) )*1.e6_wp &
            &    /( 3763.6_wp*ocetra(i,j,k,idet)+ 36.9_wp*ocetra(i,j,k,icalc) )  &
            &    - rhosw
           wballc(i,j,k)  = wball0 * rhoxc/(1.06e6_wp-rhosw) ! sinking speed assuming POC and calcite are only particles
           ! hypothetical excess density and sinking speed, assuming POC and opal are the only particles
           rhoxo= ( 3989.4_wp*ocetra(i,j,k,idet)+72.8_wp*ocetra(i,j,k,iopal) )*1.e6_wp &
            &    /( 3763.6_wp*ocetra(i,j,k,idet)+34.7_wp*ocetra(i,j,k,iopal) )  &
            &    - rhosw
           wballo(i,j,k)  = wball0 * rhoxo/(1.06e6_wp-rhosw) ! sinking speed assuming POC and opal are only particles
           ! if POC concentration is high enough, dust is assumed to join the aggregate formation
           IF (ocetra(i,j,k,idet) > pdus) THEN
             ! hypothetical excess density and sinking speed, assuming POC and dust are the only particles
             rhoxd= ( 3989.4_wp*ocetra(i,j,k,idet)+ocetra(i,j,k,ifdust) )*1.e6_wp &
              &    /( 3763.6_wp*ocetra(i,j,k,idet)+ocetra(i,j,k,ifdust)/2.6_wp )  &
              &    - rhosw
             wballd(i,j,k)  = wball0 * rhoxd/(1.06e6_wp-rhosw) ! sinking speed assuming POC and dust are only particles
             ! actual excess density, including dust:
             rhox=  ( 3989.4_wp*ocetra(i,j,k,idet)+100.0_wp*ocetra(i,j,k,icalc)+72.8_wp*ocetra(i,j,k,iopal)+ocetra(i,j,k,ifdust) )*1.e6_wp &
              &    /( 3763.6_wp*ocetra(i,j,k,idet)+ 36.9_wp*ocetra(i,j,k,icalc)+34.7_wp*ocetra(i,j,k,iopal)+ocetra(i,j,k,ifdust)/2.6_wp )  &
              &    - rhosw
           ELSE
             rhoxd=0._wp ! if POC does not meet dust, and POC and dust are the only particles, then 
                         ! there is no hypothetical excess density or aggregate formation
             wballd(i,j,k)  = wball0
             ! actual excess density, not including dust:
             ! Assuming that POC is still affected by calcite and opal. Is that OK?
             ! Better to assume that POC meets nothing, if POC concentration is low?
             rhox= ( 3989.4_wp*ocetra(i,j,k,idet)+100.0_wp*ocetra(i,j,k,icalc)+72.8_wp*ocetra(i,j,k,iopal) )*1.e6_wp &
              &    /( 3763.6_wp*ocetra(i,j,k,idet)+ 36.9_wp*ocetra(i,j,k,icalc)+34.7_wp*ocetra(i,j,k,iopal) )  &
              &    - rhosw
           ENDIF

           ! compute the sinking speed wball according to Gehlen et al. 2006 + dust effect
           wballuncor(i,j,k) = wball0 * rhox /(1.06e6_wp-rhosw) ! sinking speed of POC, calcite, opal and, if POC high enough, dust
                                                                ! uncorrected for too high speeds (>dzw allowed)
           wball(i,j,k)  = wballuncor(i,j,k)                    ! make sure sinking distance is smaller than grid box height dzw
                                                                ! else, mass loss possible
           IF ( wball(i,j,k) > dzw(k) ) THEN
                   ! for wball0=3.5, this happens a lot, but only in upper 8
                   ! layers / rarely below euphotic zone;
                   !WRITE(0,*) "BALLAST WARNING: wball > dzw; set to dzw"
                   !WRITE(0,*)  i,j,k,wball(i,j,k),dzw(k)
                   wball(i,j,k) = dzw(k)
                   ! For the simulations described here (with wball0=0.5m/day), wball and wballuncor are identical.
           ENDIF

           ! dust sinks at wball if POC concentration is high enough
           IF (ocetra(i,j,k,idet) > pdus) THEN
                   wballdd(i,j,k) = wball(i,j,k)
           ELSE
                   ! using dust diameter / Stoke's equation, see
                   ! mo_beleg_bgc.f90
                   wballdd(i,j,k) = wdust
           ENDIF
         ENDIF !wet cell
        ENDDO
     ENDDO
  ENDDO
  DO k = 1, kpke
     DO j = 1, kpje
        DO i = 1, kpie
          wball_poc(i,j,k)=wball(i,j,k)
          wball_cal(i,j,k)=wball(i,j,k)
          wball_opa(i,j,k)=wball(i,j,k)
          wball_dus(i,j,k)=wballdd(i,j,k) ! = wball, since pdus = 0
        ENDDO
     ENDDO
  ENDDO
 


! For the computation of the export fluxes (bgcflux) and the vertical transport of tracers 
! (ocetra(i,j,k,idet/idet13/idet14/icalc/icalc13/icalc14/iopal/ifdust)) in the water column and into the sediment, the
! new 3-dimensional velocity wball is used, rather than the previously prescribed 1-D/0-D velocities (wpoc(k)/wcal/wopal/wdust)
! (line 1458):
  DO j = 1, kpje
     DO i = 1, kpie

        ! write out fluxes at 90 m (fixed settling velocity part)
        IF (kbo(i,j) > n90depth) THEN
           bgcflux(i,j,kcoex90) = ocetra(i,j,n90depth,idet )*wball_poc(i,j,n90depth)/dtbgc    !CDI tinka
           bgcflux(i,j,kopex90) = ocetra(i,j,n90depth,iopal)*wball_opa(i,j,n90depth)/dtbgc    !CDI tinka
           bgcflux(i,j,kcaex90) = ocetra(i,j,n90depth,icalc)*wball_cal(i,j,n90depth)/dtbgc    !CDI tinka
        ENDIF

        ! write out fluxes at about 1000 m
        IF (kbo(i,j) > n1000depth) THEN
           bgcflux(i,j,kcoex1000) = ocetra(i,j,n1000depth,idet )*wball_poc(i,j,n1000depth)/dtbgc !CDI tinka
           bgcflux(i,j,kopex1000) = ocetra(i,j,n1000depth,iopal)*wball_opa(i,j,n1000depth)/dtbgc !CDI tinka
           bgcflux(i,j,kcaex1000) = ocetra(i,j,n1000depth,icalc)*wball_cal(i,j,n1000depth)/dtbgc !CDI tinka
        ENDIF

        ! write out fluxes at about 1950 m
        IF (kbo(i,j) > n2000depth) THEN
           bgcflux(i,j,kcoex2000) = ocetra(i,j,n2000depth,idet )*wball_poc(i,j,n2000depth)/dtbgc !CDI tinka
           bgcflux(i,j,kopex2000) = ocetra(i,j,n2000depth,iopal)*wball_opa(i,j,n2000depth)/dtbgc !CDI tinka
           bgcflux(i,j,kcaex2000) = ocetra(i,j,n2000depth,icalc)*wball_cal(i,j,n2000depth)/dtbgc !CDI tinka
        ENDIF

     ENDDO
  ENDDO

  ! implicit method:
  ! C(k,T+dt)=C(k,T) + (w*dt/ddpo(k))*(C(k-1,T+1)-C(k,T+1))
  ! -->
  ! C(k,T+dt)=(ddpo(k)*C(k,T)+w*dt*C(k-1,T+dt))/(ddpo(k)+w*dt)
  ! sedimentation=w*dt*C(ks,T+dt)
  !

  CALL maschk(kpie,kpje,kpke,-8)


  k = 1                         ! -----------surface layer
  DO j = 1, kpje
     DO i = 1, kpie

        IF (pddpo(i,j,k) > 0.5_wp) THEN

           ocetra(i,j,k,idet)  = (ocetra(i,j,k,idet)*pddpo(i,j,k))      &
                &              / (pddpo(i,j,k)+wball_poc(i,j,k))

           !proxies
#ifdef __c_isotopes
           ocetra(i,j,k,idet13)  = (ocetra(i,j,k,idet13)*pddpo(i,j,k))  &
                &                / (pddpo(i,j,k)+wball_poc(i,j,k))

           ocetra(i,j,k,idet14)  = (ocetra(i,j,k,idet14)*pddpo(i,j,k))  &
                &                / (pddpo(i,j,k)+wball_poc(i,j,k))
#endif

           ocetra(i,j,k,icalc)   = (ocetra(i,j,k,icalc)*pddpo(i,j,k))   &
                &                / (pddpo(i,j,k)+wball_cal(i,j,k))

           !proxies
#ifdef __c_isotopes
           ocetra(i,j,k,icalc13) = (ocetra(i,j,k,icalc13)*pddpo(i,j,k)) &
                &                / (pddpo(i,j,k)+wball_cal(i,j,k))

           ocetra(i,j,k,icalc14) = (ocetra(i,j,k,icalc14)*pddpo(i,j,k))  &
                &                / (pddpo(i,j,k)+wball_cal(i,j,k))
#endif

           ocetra(i,j,k,iopal)   = (ocetra(i,j,k,iopal)*pddpo(i,j,k))    &
                &                / (pddpo(i,j,k)+wball_opa(i,j,k))

           ocetra(i,j,k,ifdust)  = (ocetra(i,j,k,ifdust)*pddpo(i,j,k))   &
                &                / (pddpo(i,j,k)+wball_dus(i,j,k))

        ENDIF

     ENDDO
  ENDDO


  DO j = 1, kpje
     DO k = 2, kpke                    ! ---------------------- water column
        DO i = 1, kpie

           IF(pddpo(i,j,k) > 0.5_wp) THEN

              ocetra(i,j,k,idet)    = (ocetra(i,j,k  ,idet)*pddpo(i,j,k)    &
                   &                +  ocetra(i,j,k-1,idet)*wball_poc(i,j,k-1))/          &
                   &                          (pddpo(i,j,k)+wball_poc(i,j,k))
#ifdef __c_isotopes
              ocetra(i,j,k,idet13)  = (ocetra(i,j,k  ,idet13)*pddpo(i,j,k)  &
                   &                +  ocetra(i,j,k-1,idet13)*wball_poc(i,j,k-1))/        &
                   &                            (pddpo(i,j,k)+wball_poc(i,j,k))

              ocetra(i,j,k,idet14)  = (ocetra(i,j,k  ,idet14)*pddpo(i,j,k)  &
                   &                +  ocetra(i,j,k-1,idet14)*wball_poc(i,j,k-1))/        &
                   &                            (pddpo(i,j,k)+wball_poc(i,j,k))
#endif
              ocetra(i,j,k,icalc)   = (ocetra(i,j,k  ,icalc)*pddpo(i,j,k)   &
                   &                +  ocetra(i,j,k-1,icalc)*wball_cal(i,j,k-1))/         &
                   &                           (pddpo(i,j,k)+wball_cal(i,j,k))
#ifdef __c_isotopes
              ocetra(i,j,k,icalc13) = (ocetra(i,j,k  ,icalc13)*pddpo(i,j,k) &
                   &                +  ocetra(i,j,k-1,icalc13)*wball_cal(i,j,k-1))/       &
                   &                             (pddpo(i,j,k)+wball_cal(i,j,k))

              ocetra(i,j,k,icalc14) = (ocetra(i,j,k  ,icalc14)*pddpo(i,j,k) &
                   &                +  ocetra(i,j,k-1,icalc14)*wball_cal(i,j,k-1))/       &
                   &                             (pddpo(i,j,k)+wball_cal(i,j,k))
#endif

              ocetra(i,j,k,iopal)   = (ocetra(i,j,k  ,iopal)*pddpo(i,j,k)   &
                   &                +  ocetra(i,j,k-1,iopal)*wball_opa(i,j,k-1))/        &
                   &                           (pddpo(i,j,k)+wball_opa(i,j,k))

              ocetra(i,j,k,ifdust)  = (ocetra(i,j,k ,ifdust)*pddpo(i,j,k)   &
                   &                +  ocetra(i,j,k-1,ifdust)*wball_dus(i,j,k-1))/       &
                   &                            (pddpo(i,j,k)+wball_dus(i,j,k))

           ENDIF

        ENDDO
     ENDDO
  ENDDO

  CALL maschk(kpie,kpje,kpke,9)

  ! ------------------------------flux to sediment
  DO j = 1, kpje
     DO i = 1, kpie

        IF (pddpo(i,j,1) > 0.5_wp) THEN

           prorca(i,j) = ocetra(i,j,kbo(i,j),idet )*wball_poc(i,j,kbo(i,j))
           prcaca(i,j) = ocetra(i,j,kbo(i,j),icalc)*wball_cal(i,j,kbo(i,j))
#ifdef __c_isotopes
           pror13(i,j) = ocetra(i,j,kbo(i,j),idet13 )*wball_poc(i,j,kbo(i,j))
           prca13(i,j) = ocetra(i,j,kbo(i,j),icalc13)*wball_cal(i,j,kbo(i,j))
           pror14(i,j) = ocetra(i,j,kbo(i,j),idet14 )*wball_poc(i,j,kbo(i,j))
           prca14(i,j) = ocetra(i,j,kbo(i,j),icalc14)*wball_cal(i,j,kbo(i,j))
#endif
           silpro(i,j) = ocetra(i,j,kbo(i,j),iopal )*wball_opa(i,j,kbo(i,j))
           produs(i,j) = ocetra(i,j,kbo(i,j),ifdust)*wball_dus(i,j,kbo(i,j))
           !
           !  write output
           !
           bgcflux(i,j,kprorca) = prorca(i,j)/dtbgc     !CDI tinka
           bgcflux(i,j,kprcaca) = prcaca(i,j)/dtbgc     !CDI tinka
           bgcflux(i,j,ksilpro) = silpro(i,j)/dtbgc     !CDI tinka
           bgcflux(i,j,kprodus) = produs(i,j)/dtbgc     !CDI tinka

        ENDIF

     END DO
  END DO

  CALL maschk(kpie,kpje,kpke,10)


